/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.hbase;

import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.hbase.HBaseIndexQPSResourceAllocator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultHBaseQPSResourceAllocator
implements HBaseIndexQPSResourceAllocator {
    private HoodieWriteConfig hoodieWriteConfig;
    private static final Logger LOG = LogManager.getLogger(DefaultHBaseQPSResourceAllocator.class);

    public DefaultHBaseQPSResourceAllocator(HoodieWriteConfig hoodieWriteConfig) {
        this.hoodieWriteConfig = hoodieWriteConfig;
    }

    @Override
    public float calculateQPSFractionForPutsTime(long numPuts, int numRegionServers) {
        return this.hoodieWriteConfig.getHbaseIndexQPSFraction();
    }

    @Override
    public float acquireQPSResources(float desiredQPSFraction, long numPuts) {
        return desiredQPSFraction;
    }

    @Override
    public void releaseQPSResources() {
        LOG.info((Object)String.format("Release QPS resources called for %s with default implementation, do nothing", this.hoodieWriteConfig.getHbaseTableName()));
    }
}

