/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RollbackUtils {
    private static final Logger LOG = LogManager.getLogger(RollbackUtils.class);

    public static HoodieRollbackPlan getRollbackPlan(HoodieTableMetaClient metaClient, HoodieInstant rollbackInstant) throws IOException {
        HoodieInstant requested = HoodieTimeline.getRollbackRequestedInstant((HoodieInstant)rollbackInstant);
        return (HoodieRollbackPlan)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])metaClient.getActiveTimeline().readRollbackInfoAsBytes(requested).get()), HoodieRollbackPlan.class);
    }

    static Map<HoodieLogBlock.HeaderMetadataType, String> generateHeader(String instantToRollback, String rollbackInstantTime) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, rollbackInstantTime);
        header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, instantToRollback);
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_PREVIOUS_BLOCK.ordinal()));
        return header;
    }

    static HoodieRollbackStat mergeRollbackStat(HoodieRollbackStat stat1, HoodieRollbackStat stat2) {
        ValidationUtils.checkArgument((boolean)stat1.getPartitionPath().equals(stat2.getPartitionPath()));
        ArrayList successDeleteFiles = new ArrayList();
        ArrayList failedDeleteFiles = new ArrayList();
        HashMap commandBlocksCount = new HashMap();
        HashMap writtenLogFileSizeMap = new HashMap();
        Option.ofNullable((Object)stat1.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getSuccessDeleteFiles()).ifPresent(successDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat2.getFailedDeleteFiles()).ifPresent(failedDeleteFiles::addAll);
        Option.ofNullable((Object)stat1.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        Option.ofNullable((Object)stat2.getCommandBlocksCount()).ifPresent(commandBlocksCount::putAll);
        return new HoodieRollbackStat(stat1.getPartitionPath(), successDeleteFiles, failedDeleteFiles, commandBlocksCount);
    }
}

