/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.exception.HoodieDeletePartitionException;
import org.apache.hudi.table.HoodieTable;

public class DeletePartitionUtils {
    public static void checkForPendingTableServiceActions(HoodieTable table, List<String> partitionsToDrop) {
        ArrayList instantsOfOffendingPendingTableServiceAction = new ArrayList();
        SyncableFileSystemView fileSystemView = (SyncableFileSystemView)table.getSliceView();
        Stream.concat(fileSystemView.getPendingCompactionOperations(), fileSystemView.getPendingLogCompactionOperations()).filter(op -> partitionsToDrop.contains(((CompactionOperation)op.getRight()).getPartitionPath())).forEach(op -> instantsOfOffendingPendingTableServiceAction.add(op.getLeft()));
        fileSystemView.getFileGroupsInPendingClustering().filter(fgIdInstantPair -> partitionsToDrop.contains(((HoodieFileGroupId)fgIdInstantPair.getLeft()).getPartitionPath())).forEach(x -> instantsOfOffendingPendingTableServiceAction.add(((HoodieInstant)x.getRight()).getTimestamp()));
        if (instantsOfOffendingPendingTableServiceAction.size() > 0) {
            throw new HoodieDeletePartitionException("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: " + partitionsToDrop + ". Instant(s) of offending pending table service action: " + instantsOfOffendingPendingTableServiceAction.stream().distinct().collect(Collectors.toList()));
        }
    }
}

