/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.hudi.common.util.ValidationUtils;

public class MergingIterator<T1, T2, R>
implements Iterator<R> {
    protected final Iterator<T1> leftIterator;
    protected final Iterator<T2> rightIterator;
    private final BiFunction<T1, T2, R> mergeFunction;

    public MergingIterator(Iterator<T1> leftIterator, Iterator<T2> rightIterator, BiFunction<T1, T2, R> mergeFunction) {
        this.leftIterator = leftIterator;
        this.rightIterator = rightIterator;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public boolean hasNext() {
        boolean rightHasNext;
        boolean leftHasNext = this.leftIterator.hasNext();
        ValidationUtils.checkArgument((leftHasNext == (rightHasNext = this.rightIterator.hasNext()) ? 1 : 0) != 0);
        return leftHasNext;
    }

    @Override
    public R next() {
        return this.mergeFunction.apply(this.leftIterator.next(), this.rightIterator.next());
    }
}

