/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config.metrics;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Metrics Configurations for Graphite", groupName=ConfigGroups.Names.METRICS, description="Enables reporting on Hudi metrics using Graphite.  Hudi publishes metrics on every commit, clean, rollback etc.")
public class HoodieMetricsGraphiteConfig
extends HoodieConfig {
    public static final String GRAPHITE_PREFIX = "hoodie.metrics.graphite";
    public static final ConfigProperty<String> GRAPHITE_SERVER_HOST_NAME = ConfigProperty.key((String)"hoodie.metrics.graphite.host").defaultValue((Object)"localhost").markAdvanced().sinceVersion("0.5.0").withDocumentation("Graphite host to connect to.");
    public static final ConfigProperty<Integer> GRAPHITE_SERVER_PORT_NUM = ConfigProperty.key((String)"hoodie.metrics.graphite.port").defaultValue((Object)4756).markAdvanced().sinceVersion("0.5.0").withDocumentation("Graphite port to connect to.");
    public static final ConfigProperty<String> GRAPHITE_METRIC_PREFIX_VALUE = ConfigProperty.key((String)"hoodie.metrics.graphite.metric.prefix").noDefaultValue().markAdvanced().sinceVersion("0.5.1").withDocumentation("Standard prefix applied to all metrics. This helps to add datacenter, environment information for e.g");
    public static final ConfigProperty<Integer> GRAPHITE_REPORT_PERIOD_IN_SECONDS = ConfigProperty.key((String)"hoodie.metrics.graphite.report.period.seconds").defaultValue((Object)30).markAdvanced().sinceVersion("0.10.0").withDocumentation("Graphite reporting period in seconds. Default to 30.");
    @Deprecated
    public static final String GRAPHITE_SERVER_HOST = GRAPHITE_SERVER_HOST_NAME.key();
    @Deprecated
    public static final String DEFAULT_GRAPHITE_SERVER_HOST = (String)GRAPHITE_SERVER_HOST_NAME.defaultValue();
    @Deprecated
    public static final String GRAPHITE_SERVER_PORT = GRAPHITE_SERVER_PORT_NUM.key();
    @Deprecated
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = (Integer)GRAPHITE_SERVER_PORT_NUM.defaultValue();
    @Deprecated
    public static final String GRAPHITE_METRIC_PREFIX = GRAPHITE_METRIC_PREFIX_VALUE.key();

    private HoodieMetricsGraphiteConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieMetricsGraphiteConfig hoodieMetricsGraphiteConfig = new HoodieMetricsGraphiteConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.hoodieMetricsGraphiteConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.hoodieMetricsGraphiteConfig.getProps().putAll((Map)props);
            return this;
        }

        public Builder toGraphiteHost(String host) {
            this.hoodieMetricsGraphiteConfig.setValue(GRAPHITE_SERVER_HOST_NAME, host);
            return this;
        }

        public Builder onGraphitePort(int port) {
            this.hoodieMetricsGraphiteConfig.setValue(GRAPHITE_SERVER_PORT_NUM, String.valueOf(port));
            return this;
        }

        public Builder usePrefix(String prefix) {
            this.hoodieMetricsGraphiteConfig.setValue(GRAPHITE_METRIC_PREFIX_VALUE, prefix);
            return this;
        }

        public Builder periodSeconds(String periodSeconds) {
            this.hoodieMetricsGraphiteConfig.setValue(GRAPHITE_REPORT_PERIOD_IN_SECONDS, periodSeconds);
            return this;
        }

        public HoodieMetricsGraphiteConfig build() {
            this.hoodieMetricsGraphiteConfig.setDefaults(HoodieMetricsGraphiteConfig.class.getName());
            return this.hoodieMetricsGraphiteConfig;
        }
    }
}

