/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.HoodieMergedReadHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.HoodieDeleteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieIndexUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIndexUtils.class);

    public static List<HoodieBaseFile> getLatestBaseFilesForPartition(String partition, HoodieTable hoodieTable) {
        Option latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
        if (latestCommitTime.isPresent()) {
            return hoodieTable.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partition, ((HoodieInstant)latestCommitTime.get()).getTimestamp()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<FileSlice> getLatestFileSlicesForPartition(String partition, HoodieTable hoodieTable) {
        Option latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
        if (latestCommitTime.isPresent()) {
            return hoodieTable.getHoodieView().getLatestFileSlicesBeforeOrOn(partition, ((HoodieInstant)latestCommitTime.get()).getTimestamp(), true).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Pair<String, HoodieBaseFile>> getLatestBaseFilesForAllPartitions(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        context.setJobStatus(HoodieIndexUtils.class.getSimpleName(), "Load latest base files from all partitions: " + hoodieTable.getConfig().getTableName());
        return context.flatMap(partitions, (SerializableFunction & Serializable)partitionPath -> {
            List filteredFiles = HoodieIndexUtils.getLatestBaseFilesForPartition(partitionPath, hoodieTable).stream().map(baseFile -> Pair.of((Object)partitionPath, (Object)baseFile)).collect(Collectors.toList());
            return filteredFiles.stream();
        }, Math.max(partitions.size(), 1));
    }

    public static <R> HoodieRecord<R> tagAsNewRecordIfNeeded(HoodieRecord<R> record, Option<HoodieRecordLocation> location) {
        if (location.isPresent()) {
            HoodieRecord newRecord = record.newInstance();
            newRecord.unseal();
            newRecord.setCurrentLocation((HoodieRecordLocation)location.get());
            newRecord.seal();
            return newRecord;
        }
        return record;
    }

    public static <R> HoodieRecord<R> tagRecord(HoodieRecord<R> record, HoodieRecordLocation location) {
        record.unseal();
        record.setCurrentLocation(location);
        record.seal();
        return record;
    }

    public static List<String> filterKeysFromFile(Path filePath, List<String> candidateRecordKeys, Configuration configuration) throws HoodieIndexException {
        ValidationUtils.checkArgument((boolean)FSUtils.isBaseFile((Path)filePath));
        ArrayList<String> foundRecordKeys = new ArrayList<String>();
        try (HoodieFileReader fileReader = HoodieFileReaderFactory.getReaderFactory((HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO).getFileReader(configuration, filePath);){
            if (!candidateRecordKeys.isEmpty()) {
                HoodieTimer timer = HoodieTimer.start();
                Set fileRowKeys = fileReader.filterRowKeys(new TreeSet<String>(candidateRecordKeys));
                foundRecordKeys.addAll(fileRowKeys);
                LOG.info(String.format("Checked keys against file %s, in %d ms. #candidates (%d) #found (%d)", filePath, timer.endTimer(), candidateRecordKeys.size(), foundRecordKeys.size()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Keys matching for file " + filePath + " => " + foundRecordKeys);
                }
            }
        }
        catch (Exception e) {
            throw new HoodieIndexException("Error checking candidate keys against file.", (Throwable)e);
        }
        return foundRecordKeys;
    }

    public static boolean checkIfValidCommit(HoodieTimeline commitTimeline, String commitTs) {
        return !commitTimeline.empty() && commitTimeline.containsOrBeforeTimelineStarts(commitTs);
    }

    public static HoodieIndex createUserDefinedIndex(HoodieWriteConfig config) {
        Object instance = ReflectionUtils.loadClass((String)config.getIndexClass(), (Object[])new Object[]{config});
        if (!(instance instanceof HoodieIndex)) {
            throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
        }
        return (HoodieIndex)instance;
    }

    private static <R> HoodieData<HoodieRecord<R>> getExistingRecords(HoodieData<HoodieRecordGlobalLocation> partitionLocations, HoodieWriteConfig config, HoodieTable hoodieTable) {
        Option instantTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::getTimestamp);
        return partitionLocations.flatMap((SerializableFunction & Serializable)p -> new HoodieMergedReadHandle(config, (Option<String>)instantTime, hoodieTable, (Pair<String, String>)Pair.of((Object)p.getPartitionPath(), (Object)p.getFileId())).getMergedRecords().iterator());
    }

    private static <R> Option<HoodieRecord<R>> mergeIncomingWithExistingRecord(HoodieRecord<R> incoming, HoodieRecord<R> existing, Schema writeSchema, HoodieWriteConfig config, HoodieRecordMerger recordMerger) throws IOException {
        Schema writeSchemaWithMetaFields;
        HoodieRecord incomingPrepended;
        HoodieRecord incomingWithMetaFields;
        Schema existingSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(config.getSchema()), (boolean)config.allowOperationMetadataField());
        Option mergeResult = recordMerger.merge(existing, existingSchema, incomingWithMetaFields = (incomingPrepended = incoming.prependMetaFields(writeSchema, writeSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields((Schema)writeSchema, (boolean)config.allowOperationMetadataField()), new MetadataValues().setRecordKey(incoming.getRecordKey()).setPartitionPath(incoming.getPartitionPath()), (Properties)config.getProps())).wrapIntoHoodieRecordPayloadWithParams(writeSchema, (Properties)config.getProps(), Option.empty(), Boolean.valueOf(config.allowOperationMetadataField()), Option.empty(), Boolean.valueOf(false), Option.empty()), writeSchemaWithMetaFields, config.getProps());
        if (mergeResult.isPresent()) {
            HoodieRecord merged = ((HoodieRecord)((Pair)mergeResult.get()).getLeft()).wrapIntoHoodieRecordPayloadWithParams(writeSchemaWithMetaFields, (Properties)config.getProps(), Option.empty(), Boolean.valueOf(config.allowOperationMetadataField()), Option.empty(), Boolean.valueOf(false), Option.of((Object)writeSchema));
            return Option.of((Object)merged);
        }
        return Option.empty();
    }

    public static <R> HoodieData<HoodieRecord<R>> mergeForPartitionUpdatesIfNeeded(HoodieData<Pair<HoodieRecord<R>, Option<HoodieRecordGlobalLocation>>> incomingRecordsAndLocations, HoodieWriteConfig config, HoodieTable hoodieTable) {
        HoodieData taggedNewRecords = incomingRecordsAndLocations.filter((SerializableFunction & Serializable)p -> !((Option)p.getRight()).isPresent()).map(Pair::getLeft);
        HoodieData untaggedUpdatingRecords = incomingRecordsAndLocations.filter((SerializableFunction & Serializable)p -> ((Option)p.getRight()).isPresent()).map(Pair::getLeft).distinctWithKey(HoodieRecord::getRecordKey, config.getGlobalIndexReconcileParallelism());
        HoodieData globalLocations = incomingRecordsAndLocations.filter((SerializableFunction & Serializable)p -> ((Option)p.getRight()).isPresent()).map((SerializableFunction & Serializable)p -> (HoodieRecordGlobalLocation)((Option)p.getRight()).get()).distinct(config.getGlobalIndexReconcileParallelism());
        HoodieData<HoodieRecord<R>> existingRecords = HoodieIndexUtils.getExistingRecords((HoodieData<HoodieRecordGlobalLocation>)globalLocations, config, hoodieTable);
        HoodieRecordMerger recordMerger = config.getRecordMerger();
        HoodieData taggedUpdatingRecords = untaggedUpdatingRecords.mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getRecordKey(), (Object)r)).leftOuterJoin(existingRecords.mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getRecordKey(), (Object)r))).values().flatMap((SerializableFunction & Serializable)entry -> {
            HoodieRecord incoming = (HoodieRecord)entry.getLeft();
            Option existingOpt = (Option)entry.getRight();
            if (!existingOpt.isPresent()) {
                return Collections.singletonList(incoming).iterator();
            }
            HoodieRecord existing = (HoodieRecord)existingOpt.get();
            Schema writeSchema = new Schema.Parser().parse(config.getWriteSchema());
            if (incoming.isDelete(writeSchema, (Properties)config.getProps())) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(incoming.newInstance(existing.getKey()), existing.getCurrentLocation())).iterator();
            }
            Option mergedOpt = HoodieIndexUtils.mergeIncomingWithExistingRecord(incoming, existing, writeSchema, config, recordMerger);
            if (!mergedOpt.isPresent()) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(incoming.newInstance(existing.getKey()), existing.getCurrentLocation())).iterator();
            }
            HoodieRecord merged = (HoodieRecord)mergedOpt.get();
            if (Objects.equals(merged.getPartitionPath(), existing.getPartitionPath())) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(merged, existing.getCurrentLocation())).iterator();
            }
            HoodieRecord deleteRecord = HoodieDeleteHelper.createDeleteRecord(config, existing.getKey());
            return Arrays.asList(HoodieIndexUtils.tagRecord(deleteRecord, existing.getCurrentLocation()), merged).iterator();
        });
        return taggedUpdatingRecords.union(taggedNewRecords);
    }

    public static <R> HoodieData<HoodieRecord<R>> tagGlobalLocationBackToRecords(HoodieData<HoodieRecord<R>> incomingRecords, HoodiePairData<String, HoodieRecordGlobalLocation> keyAndExistingLocations, boolean mayContainDuplicateLookup, boolean shouldUpdatePartitionPath, HoodieWriteConfig config, HoodieTable table) {
        HoodieRecordMerger merger = config.getRecordMerger();
        HoodiePairData keyAndIncomingRecords = incomingRecords.mapToPair((SerializablePairFunction & Serializable)record -> Pair.of((Object)record.getRecordKey(), (Object)record));
        HoodieData incomingRecordsAndLocations = keyAndIncomingRecords.leftOuterJoin(keyAndExistingLocations).values().map((SerializableFunction & Serializable)v -> {
            HoodieRecord incomingRecord = (HoodieRecord)v.getLeft();
            Option currentLocOpt = Option.ofNullable((Object)((Option)v.getRight()).orElse(null));
            if (currentLocOpt.isPresent()) {
                boolean shouldDoMergedLookUpThenTag;
                HoodieRecordGlobalLocation currentLoc = (HoodieRecordGlobalLocation)currentLocOpt.get();
                boolean bl = shouldDoMergedLookUpThenTag = mayContainDuplicateLookup || !Objects.equals(incomingRecord.getPartitionPath(), currentLoc.getPartitionPath());
                if (shouldUpdatePartitionPath && shouldDoMergedLookUpThenTag) {
                    return Pair.of((Object)incomingRecord, (Object)currentLocOpt);
                }
                return Pair.of(HoodieIndexUtils.createNewTaggedHoodieRecord(incomingRecord, currentLoc, merger.getRecordType()), (Object)Option.empty());
            }
            return Pair.of((Object)incomingRecord, (Object)Option.empty());
        });
        return shouldUpdatePartitionPath ? HoodieIndexUtils.mergeForPartitionUpdatesIfNeeded(incomingRecordsAndLocations, config, table) : incomingRecordsAndLocations.map(Pair::getLeft);
    }

    public static <R> HoodieRecord<R> createNewTaggedHoodieRecord(HoodieRecord<R> oldRecord, HoodieRecordGlobalLocation location, HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                HoodieKey recordKey = new HoodieKey(oldRecord.getRecordKey(), location.getPartitionPath());
                return HoodieIndexUtils.tagRecord(new HoodieAvroRecord(recordKey, (HoodieRecordPayload)oldRecord.getData()), (HoodieRecordLocation)location);
            }
            case SPARK: {
                return HoodieIndexUtils.tagRecord(oldRecord.newInstance(), (HoodieRecordLocation)location);
            }
        }
        throw new HoodieIndexException("Unsupported record type: " + recordType);
    }
}

