/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.io.HoodieKeyLookupResult;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieKeyLookupHandle<T, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieKeyLookupHandle.class);
    private final BloomFilter bloomFilter;
    private final List<String> candidateRecordKeys = new ArrayList<String>();
    private long totalKeysChecked = 0L;

    public HoodieKeyLookupHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, hoodieTable, partitionPathFileIDPair);
        this.bloomFilter = this.getBloomFilter();
    }

    private BloomFilter getBloomFilter() {
        HoodieTimer timer;
        BloomFilter bloomFilter;
        block15: {
            bloomFilter = null;
            timer = HoodieTimer.start();
            try {
                if (this.config.getBloomIndexUseMetadata() && this.hoodieTable.getMetaClient().getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath())) {
                    bloomFilter = (BloomFilter)this.hoodieTable.getMetadataTable().getBloomFilter((String)this.partitionPathFileIDPair.getLeft(), (String)this.partitionPathFileIDPair.getRight()).orElseThrow(() -> new HoodieIndexException("BloomFilter missing for " + (String)this.partitionPathFileIDPair.getRight()));
                    break block15;
                }
                try (HoodieFileReader reader = this.createNewFileReader();){
                    bloomFilter = reader.readBloomFilter();
                }
            }
            catch (IOException e) {
                throw new HoodieIndexException(String.format("Error reading bloom filter from %s", this.getPartitionPathFileIDPair()), (Throwable)e);
            }
        }
        LOG.info(String.format("Read bloom filter from %s in %d ms", this.partitionPathFileIDPair, timer.endTimer()));
        return bloomFilter;
    }

    public void addKey(String recordKey) {
        if (this.bloomFilter.mightContain(recordKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Record key " + recordKey + " matches bloom filter in  " + this.partitionPathFileIDPair);
            }
            this.candidateRecordKeys.add(recordKey);
        }
        ++this.totalKeysChecked;
    }

    public HoodieKeyLookupResult getLookupResult() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("#The candidate row keys for " + this.partitionPathFileIDPair + " => " + this.candidateRecordKeys);
        }
        HoodieBaseFile baseFile = this.getLatestBaseFile();
        List<String> matchingKeys = HoodieIndexUtils.filterKeysFromFile(new Path(baseFile.getPath()), this.candidateRecordKeys, this.hoodieTable.getHadoopConf());
        LOG.info(String.format("Total records (%d), bloom filter candidates (%d)/fp(%d), actual matches (%d)", this.totalKeysChecked, this.candidateRecordKeys.size(), this.candidateRecordKeys.size() - matchingKeys.size(), matchingKeys.size()));
        return new HoodieKeyLookupResult((String)this.partitionPathFileIDPair.getRight(), (String)this.partitionPathFileIDPair.getLeft(), baseFile.getCommitTime(), matchingKeys);
    }
}

