/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public final class MetricUtils {
    private static final String METRIC_NAME_AND_LABELS_SEPARATOR = ";";
    private static final String LABELS_SEPARATOR = ",";
    private static final String LABELS_KEY_AND_VALUE_SEPARATOR = ":";

    private static Pair<String, String> splitToPair(String label) {
        String[] keyValues = label.split(LABELS_KEY_AND_VALUE_SEPARATOR, 2);
        ValidationUtils.checkArgument((boolean)StringUtils.nonEmpty((String)keyValues[0]), (String)String.format("Key is empty for label %s", label));
        return Pair.of((Object)keyValues[0], (Object)(keyValues.length == 2 ? keyValues[1] : ""));
    }

    public static Pair<String, Map<String, String>> getLabelsAndMetricMap(String metric) {
        Pair<String, List<String>> labelsList = MetricUtils.getLabelsAndMetricList(metric);
        return Pair.of((Object)labelsList.getLeft(), MetricUtils.getLabelsAsMap((List)labelsList.getValue()));
    }

    public static Pair<String, String> getMetricAndLabels(String metric) {
        String[] tokens = metric.split(METRIC_NAME_AND_LABELS_SEPARATOR);
        if (tokens.length > 2) {
            throw new RuntimeException("more than one ';' detected in metric string");
        }
        if (tokens.length == 2) {
            return Pair.of((Object)tokens[0], (Object)tokens[1]);
        }
        return Pair.of((Object)tokens[0], (Object)"");
    }

    public static Map<String, String> getLabelsAsMap(String labels) {
        return MetricUtils.getLabelsAsMap(MetricUtils.getLabels(labels));
    }

    public static Map<String, String> getLabelsAsMap(List<String> labels) {
        return labels.stream().filter(StringUtils::nonEmpty).map(MetricUtils::splitToPair).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (v1, v2) -> {
            throw new IllegalStateException(String.format("Multiple values {%s, %s} for same key", v1, v2));
        }));
    }

    public static List<String> getLabels(String labels) {
        return Arrays.stream(labels.split(LABELS_SEPARATOR)).filter(StringUtils::nonEmpty).collect(Collectors.toList());
    }

    public static Pair<String, List<String>> getLabelsAndMetricList(String metric) {
        Pair<String, String> metricAndLabels = MetricUtils.getMetricAndLabels(metric);
        return Pair.of((Object)metricAndLabels.getLeft(), MetricUtils.getLabels((String)metricAndLabels.getRight()));
    }
}

