/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.DummyTaskContextSupplier;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.io.hadoop.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieAvroParquetWriter {
    @TempDir
    Path tmpDir;

    @Test
    public void testProperWriting() throws IOException {
        HoodieStorage storage = HoodieTestUtils.getStorage((String)this.tmpDir.toString());
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        List records = dataGen.generateGenericRecords(10);
        Schema schema = ((GenericRecord)records.get(0)).getSchema();
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)1000, (double)1.0E-4, (int)10000, (String)BloomFilterTypeCode.DYNAMIC_V0.name());
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(schema), schema, Option.of((Object)filter), new Properties());
        HoodieParquetConfig parquetConfig = new HoodieParquetConfig((Object)writeSupport, CompressionCodecName.GZIP, 0x8000000, 0x100000, 0x40000000L, storage.getConf(), 0.1, true);
        StoragePath filePath = new StoragePath(this.tmpDir.resolve("test.parquet").toAbsolutePath().toString());
        try (HoodieAvroParquetWriter writer = new HoodieAvroParquetWriter(filePath, parquetConfig, "001", (TaskContextSupplier)new DummyTaskContextSupplier(), true);){
            for (GenericRecord record : records) {
                writer.writeAvro((String)record.get("_row_key"), (IndexedRecord)record);
            }
        }
        ParquetUtils utils = new ParquetUtils();
        List readRecords = utils.readAvroRecords(storage, filePath);
        Assertions.assertEquals(TestHoodieAvroParquetWriter.toJson(records), TestHoodieAvroParquetWriter.toJson(readRecords));
        List<String> recordKeys = records.stream().map(r -> (String)r.get("_row_key")).collect(Collectors.toList());
        String minKey = (String)recordKeys.stream().min(Comparator.naturalOrder()).get();
        String maxKey = (String)recordKeys.stream().max(Comparator.naturalOrder()).get();
        FileMetaData parquetMetadata = ParquetUtils.readMetadata((HoodieStorage)storage, (StoragePath)filePath).getFileMetaData();
        Map extraMetadata = parquetMetadata.getKeyValueMetaData();
        Assertions.assertEquals(extraMetadata.get("hoodie_min_record_key"), (Object)minKey);
        Assertions.assertEquals(extraMetadata.get("hoodie_max_record_key"), (Object)maxKey);
        Assertions.assertEquals(extraMetadata.get("hoodie_bloom_filter_type_code"), (Object)BloomFilterTypeCode.DYNAMIC_V0.name());
        BloomFilter bloomFilter = utils.readBloomFilterFromMetadata(storage, filePath);
        recordKeys.forEach(recordKey -> Assertions.assertTrue((boolean)bloomFilter.mightContain(recordKey)));
    }

    private static List<String> toJson(List<GenericRecord> records) {
        return records.stream().map(r -> {
            try {
                return new String(HoodieAvroUtils.avroToJson((GenericRecord)r, (boolean)true));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }
}

