/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.BucketIndexConcurrentFileWritesConflictResolutionStrategy;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBucketIndexConcurrentFileWritesConflictResolutionStrategy
extends HoodieCommonTestHarness {
    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    @Test
    public void testNoConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        this.createCommit(newInstantTime);
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        BucketIndexConcurrentFileWritesConflictResolutionStrategy strategy = new BucketIndexConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertEquals((long)0L, (long)candidateInstants.count());
    }

    @Test
    public void testConcurrentWrites() throws Exception {
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        this.createCommit(newInstantTime);
        this.createInflightCommit(HoodieTestTable.makeNewCommitTime(), "2016/03/15");
        this.createInflightCommit(HoodieTestTable.makeNewCommitTime(), "2016/03/15");
        Option lastSuccessfulInstant = this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant();
        newInstantTime = HoodieTestTable.makeNewCommitTime();
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", newInstantTime));
        BucketIndexConcurrentFileWritesConflictResolutionStrategy strategy = new BucketIndexConcurrentFileWritesConflictResolutionStrategy();
        Stream candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant);
        Assertions.assertEquals((long)0L, (long)candidateInstants.count());
    }

    @Test
    public void testConcurrentWritesWithInterleavingSuccessfulCommit() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant, "2016/03/15");
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCommit(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        BucketIndexConcurrentFileWritesConflictResolutionStrategy strategy = new BucketIndexConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant, "2016/03/15");
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertTrue((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
        try {
            strategy.resolveConflict(null, thisCommitOperation, thatCommitOperation);
            Assertions.fail((String)"Cannot reach here, writer 1 and writer 2 should have thrown a conflict");
        }
        catch (HoodieWriteConflictException hoodieWriteConflictException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentWritesWithDifferentPartition() throws Exception {
        this.createCommit(HoodieActiveTimeline.createNewInstantTime());
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieActiveTimeline.createNewInstantTime();
        this.createInflightCommit(currentWriterInstant, "2015/03/16");
        String newInstantTime = HoodieActiveTimeline.createNewInstantTime();
        this.createCommit(newInstantTime);
        Option currentInstant = Option.of((Object)new HoodieInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        BucketIndexConcurrentFileWritesConflictResolutionStrategy strategy = new BucketIndexConcurrentFileWritesConflictResolutionStrategy();
        HoodieCommitMetadata currentMetadata = this.createCommitMetadata(currentWriterInstant, "2015/03/16");
        this.metaClient.reloadActiveTimeline();
        List candidateInstants = strategy.getCandidateInstants(this.metaClient, (HoodieInstant)currentInstant.get(), lastSuccessfulInstant).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)candidateInstants.size());
        ConcurrentOperation thatCommitOperation = new ConcurrentOperation((HoodieInstant)candidateInstants.get(0), this.metaClient);
        ConcurrentOperation thisCommitOperation = new ConcurrentOperation((HoodieInstant)currentInstant.get(), currentMetadata);
        Assertions.assertFalse((boolean)strategy.hasConflict(thisCommitOperation, thatCommitOperation));
    }

    private void createCommit(String instantTime) throws Exception {
        String fileId1 = "00000001-file-" + instantTime + "-1";
        String fileId2 = "00000002-file-" + instantTime + "-2";
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(fileId1);
        commitMetadata.addWriteStat("2016/03/15", writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addCommit(instantTime, Option.of((Object)commitMetadata)).withBaseFilesInPartition("2016/03/15", new String[]{fileId1, fileId2});
    }

    private HoodieCommitMetadata createCommitMetadata(String instantTime, String writeFileName, String partition) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        commitMetadata.addMetadata("test", "test");
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(writeFileName);
        commitMetadata.addWriteStat(partition, writeStat);
        commitMetadata.setOperationType(WriteOperationType.INSERT);
        return commitMetadata;
    }

    private HoodieCommitMetadata createCommitMetadata(String instantTime, String partition) {
        return this.createCommitMetadata(instantTime, "00000001-file-" + instantTime + "-1", partition);
    }

    private void createInflightCommit(String instantTime, String partition) throws Exception {
        String fileId1 = "00000001-file-" + instantTime + "-1";
        String fileId2 = "00000002-file-" + instantTime + "-2";
        HoodieTestTable.of((HoodieTableMetaClient)this.metaClient).addInflightCommit(instantTime).withBaseFilesInPartition(partition, new String[]{fileId1, fileId2});
    }
}

