/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieTestCommitGenerator;
import org.apache.hudi.client.utils.CommitMetadataUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCommitMetadataUtils
extends HoodieCommonTestHarness {
    private final HoodieWriteConfig writeConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
    private final HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private final HoodieWrapperFileSystem fileSystem = (HoodieWrapperFileSystem)Mockito.mock(HoodieWrapperFileSystem.class);
    private final HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
    private final HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);

    @BeforeEach
    public void setUp() throws Exception {
        this.initPath();
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testReconcileMetadataForMissingFiles() throws IOException {
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)this.writeConfig);
        Mockito.when((Object)this.metaClient.getTableType()).thenReturn((Object)HoodieTableType.MERGE_ON_READ);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)new HoodieHadoopStorage(this.basePath, HoodieTestUtils.getDefaultStorageConf()));
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)this.basePath);
        Mockito.when((Object)this.metaClient.getMarkerFolderPath((String)ArgumentMatchers.any())).thenReturn((Object)(this.basePath + ".hoodie/.temp"));
        Mockito.when((Object)this.table.getContext()).thenReturn((Object)this.context);
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        Mockito.when((Object)this.context.getStorageConf()).thenReturn((Object)storageConf);
        Mockito.when((Object)this.writeConfig.getViewStorageConfig()).thenReturn((Object)FileSystemViewStorageConfig.newBuilder().build());
        Mockito.when((Object)this.writeConfig.getMarkersType()).thenReturn((Object)MarkerType.DIRECT);
        Mockito.when((Object)this.writeConfig.getBasePath()).thenReturn((Object)this.basePath);
        String commitActionType = "deltacommit";
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        final String p0 = "2020/01/01";
        final String p1 = "2020/01/02";
        final String file1P0C0 = UUID.randomUUID().toString();
        final String file1P1C0 = UUID.randomUUID().toString();
        Map<String, List<String>> part1ToFileId = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
            {
                this.put(p0, CollectionUtils.createImmutableList((Object[])new String[]{file1P0C0}));
                this.put(p1, CollectionUtils.createImmutableList((Object[])new String[]{file1P1C0}));
            }
        });
        Pair<HoodieCommitMetadata, List<String>> commitMetadataWithLogFiles = TestCommitMetadataUtils.generateCommitMetadata(instantTime, part1ToFileId, this.basePath, 1, 2);
        HashSet<String> missingLogFiles = new HashSet<String>(Arrays.asList("path/to/log1", "path/to/log2"));
        WriteMarkers markers = (WriteMarkers)Mockito.mock(WriteMarkers.class);
        Mockito.when((Object)markers.getAppendedLogPaths((HoodieEngineContext)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(missingLogFiles);
        Mockito.when((Object)this.table.getFileSystemView()).thenReturn(Mockito.mock(HoodieTableFileSystemView.class));
        missingLogFiles.addAll((Collection)commitMetadataWithLogFiles.getRight());
        Mockito.when((Object)markers.getAppendedLogPaths((HoodieEngineContext)ArgumentMatchers.any(), ArgumentMatchers.anyInt())).thenReturn(missingLogFiles);
        Mockito.when((Object)this.table.getFileSystemView()).thenReturn(Mockito.mock(HoodieTableFileSystemView.class));
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.table.getStorageConf()).thenReturn((Object)storageConf);
        Mockito.when((Object)fs.exists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        HoodieCommitMetadata reconciledMetadata = CommitMetadataUtils.reconcileMetadataForMissingFiles((HoodieTable)this.table, (String)commitActionType, (String)instantTime, (HoodieCommitMetadata)((HoodieCommitMetadata)commitMetadataWithLogFiles.getLeft()), (HoodieWriteConfig)this.writeConfig, (HoodieEngineContext)this.context, (Configuration)new Configuration(), (String)((Object)((Object)this)).getClass().getSimpleName());
        Assertions.assertFalse((boolean)reconciledMetadata.getPartitionToWriteStats().isEmpty(), (String)"CommitMetadata should not be empty after reconciliation");
        Assertions.assertEquals((int)2, (int)reconciledMetadata.getPartitionToWriteStats().size());
        Assertions.assertTrue((boolean)reconciledMetadata.getPartitionToWriteStats().containsKey(p0), (String)("Partition " + p0 + " should be present in the commit metadata"));
        Assertions.assertTrue((boolean)reconciledMetadata.getPartitionToWriteStats().containsKey(p1), (String)("Partition " + p1 + " should be present in the commit metadata"));
        Assertions.assertEquals((int)1, (int)((List)reconciledMetadata.getPartitionToWriteStats().get(p0)).size(), (String)("There should be 1 write stats for partition " + p0));
        Assertions.assertEquals((int)1, (int)((List)reconciledMetadata.getPartitionToWriteStats().get(p1)).size(), (String)("There should be 1 write stats for partition " + p1));
        Assertions.assertEquals((Object)file1P0C0, (Object)((HoodieWriteStat)((List)reconciledMetadata.getPartitionToWriteStats().get(p0)).get(0)).getFileId(), (String)("FileId for partition " + p0 + " should be " + file1P0C0));
        Assertions.assertEquals((Object)file1P1C0, (Object)((HoodieWriteStat)((List)reconciledMetadata.getPartitionToWriteStats().get(p1)).get(0)).getFileId(), (String)("FileId for partition " + p1 + " should be " + file1P1C0));
    }

    private static Pair<HoodieCommitMetadata, List<String>> generateCommitMetadata(String instantTime, Map<String, List<String>> partitionToFilePaths, String basePath, int ... versions) {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.addMetadata("schema", "{\"namespace\": \"org.apache.hudi.avro.model\", \"type\": \"record\", \"name\": \"PhonyRecord\", \"fields\": []}");
        ArrayList allLogFiles = new ArrayList();
        partitionToFilePaths.forEach((partitionPath, fileList) -> fileList.forEach(f -> {
            HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
            ArrayList<String> logFiles = new ArrayList<String>();
            for (int version : versions) {
                try {
                    logFiles.add(FileCreateUtils.createLogFile((String)basePath, (String)partitionPath, (String)instantTime, (String)f, (int)version));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            allLogFiles.addAll(logFiles);
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(partitionPath + "/" + HoodieTestCommitGenerator.getBaseFilename(instantTime, f));
            writeStat.setFileId(f);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            writeStat.setTotalLogBlocks((long)logFiles.size());
            writeStat.setLogFiles(logFiles);
            metadata.addWriteStat(partitionPath, (HoodieWriteStat)writeStat);
        }));
        return Pair.of((Object)metadata, allLogFiles);
    }
}

