/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyGenUtils {
    @Test
    public void testInferKeyGeneratorType() {
        Assertions.assertEquals((Object)KeyGeneratorType.SIMPLE, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1"), (String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1"), (String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1"));
        Assertions.assertEquals((Object)KeyGeneratorType.COMPLEX, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)"partition1,partition2"));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), (String)""));
        Assertions.assertEquals((Object)KeyGeneratorType.NON_PARTITION, (Object)KeyGenUtils.inferKeyGeneratorType((Option)Option.of((Object)"col1,col2"), null));
    }

    @Test
    public void testExtractRecordKeys() {
        Object[] s1 = KeyGenUtils.extractRecordKeys((String)"id:1");
        Assertions.assertArrayEquals((Object[])new String[]{"1"}, (Object[])s1);
        Object[] s2 = KeyGenUtils.extractRecordKeys((String)"id:1,id:2");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])s2);
        Object[] s3 = KeyGenUtils.extractRecordKeys((String)"id:1,id2:__null__,id3:__empty__");
        Assertions.assertArrayEquals((Object[])new String[]{"1", null, ""}, (Object[])s3);
        Object[] s4 = KeyGenUtils.extractRecordKeys((String)"id:ab:cd,id2:ef");
        Assertions.assertArrayEquals((Object[])new String[]{"ab:cd", "ef"}, (Object[])s4);
        Object[] s5 = KeyGenUtils.extractRecordKeys((String)"1");
        Assertions.assertArrayEquals((Object[])new String[]{"1"}, (Object[])s5);
        Object[] s6 = KeyGenUtils.extractRecordKeys((String)"id:1,id2:2,2");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "2"}, (Object[])s6);
    }

    @Test
    public void testExtractRecordKeysWithFields() {
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add("id2");
        Object[] s1 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,id2:2,id3:3", fields);
        Assertions.assertArrayEquals((Object[])new String[]{"2"}, (Object[])s1);
        Object[] s2 = KeyGenUtils.extractRecordKeysByFields((String)"id1:1,id2:2,2,id3:3", fields);
        Assertions.assertArrayEquals((Object[])new String[]{"2", "2"}, (Object[])s2);
    }
}

