/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public abstract class TestWriterHelperBase<I>
extends HoodieCommonTestHarness {
    private static int runNo = 0;
    protected final BaseWriteHelper writeHelper;
    protected HoodieEngineContext context;
    protected HoodieTable table;
    protected I inputRecords;

    public TestWriterHelperBase(BaseWriteHelper writeHelper) {
        this.writeHelper = writeHelper;
    }

    public abstract I getInputRecords(List<HoodieRecord> var1, int var2);

    @BeforeEach
    public void setUp() throws Exception {
        this.initResources();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @ParameterizedTest
    @CsvSource(value={"true,0", "true,50", "false,0", "false,50"})
    public void testCombineParallelism(boolean shouldCombine, int configuredShuffleParallelism) {
        int inputParallelism = 5;
        this.inputRecords = this.getInputRecords(this.dataGen.generateInserts("20230915000000000", Integer.valueOf(10)), inputParallelism);
        HoodieData outputRecords = (HoodieData)this.writeHelper.combineOnCondition(shouldCombine, this.inputRecords, configuredShuffleParallelism, this.table);
        if (!shouldCombine || configuredShuffleParallelism == 0) {
            Assertions.assertEquals((int)inputParallelism, (int)outputRecords.getNumPartitions());
        } else {
            Assertions.assertEquals((int)configuredShuffleParallelism, (int)outputRecords.getNumPartitions());
        }
    }

    private void initResources() throws IOException {
        this.initPath("dataset" + runNo);
        ++runNo;
        this.initTestDataGenerator();
        this.initMetaClient();
    }

    private void cleanupResources() {
        this.cleanMetaClient();
        this.cleanupTestDataGenerator();
    }
}

