/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HoodieWrapperFileSystem;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestWriteMarkersFactory
extends HoodieCommonTestHarness {
    private static final String NON_HDFS_BASE_PATH = "/tmp/dir";
    private static final String HDFS_BASE_PATH = "hdfs://localhost/dir";
    private final HoodieWriteConfig writeConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
    private final HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private final HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
    private final HoodieWrapperFileSystem fileSystem = (HoodieWrapperFileSystem)Mockito.mock(HoodieWrapperFileSystem.class);
    private final HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
    private final HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);

    @BeforeEach
    public void init() throws IOException {
        this.initMetaClient();
    }

    public static Stream<Arguments> configParams() {
        Object[][] data = new Object[][]{{NON_HDFS_BASE_PATH, true}, {HDFS_BASE_PATH, false}, {NON_HDFS_BASE_PATH, true}, {HDFS_BASE_PATH, false}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"configParams"})
    public void testDirectMarkers(String basePath, boolean isTimelineServerEnabled) {
        this.testWriteMarkersFactory(MarkerType.DIRECT, basePath, isTimelineServerEnabled, DirectWriteMarkers.class);
    }

    @Test
    public void testTimelineServerBasedMarkersWithTimelineServerEnabled() {
        this.testWriteMarkersFactory(MarkerType.TIMELINE_SERVER_BASED, NON_HDFS_BASE_PATH, true, TimelineServerBasedWriteMarkers.class);
    }

    @Test
    public void testTimelineServerBasedMarkersWithTimelineServerDisabled() {
        this.testWriteMarkersFactory(MarkerType.TIMELINE_SERVER_BASED, NON_HDFS_BASE_PATH, false, DirectWriteMarkers.class);
    }

    @Test
    public void testTimelineServerBasedMarkersWithHDFS() {
        this.testWriteMarkersFactory(MarkerType.TIMELINE_SERVER_BASED, HDFS_BASE_PATH, true, DirectWriteMarkers.class);
    }

    private void testWriteMarkersFactory(MarkerType markerTypeConfig, String basePath, boolean isTimelineServerEnabled, Class<?> expectedWriteMarkersClass) {
        String instantTime = "001";
        Mockito.when((Object)this.table.getConfig()).thenReturn((Object)this.writeConfig);
        Mockito.when((Object)this.writeConfig.isEmbeddedTimelineServerEnabled()).thenReturn((Object)isTimelineServerEnabled);
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.storage.getFileSystem()).thenReturn((Object)this.fileSystem);
        Mockito.when((Object)this.metaClient.getBasePath()).thenReturn((Object)basePath);
        Mockito.when((Object)this.metaClient.getMarkerFolderPath((String)ArgumentMatchers.any())).thenReturn((Object)(basePath + ".hoodie/.temp"));
        Mockito.when((Object)this.table.getContext()).thenReturn((Object)this.context);
        StorageConfiguration storageConfToReturn = HoodieTestUtils.getDefaultStorageConf();
        Mockito.when((Object)this.context.getStorageConf()).thenReturn((Object)storageConfToReturn);
        Mockito.when((Object)this.writeConfig.getViewStorageConfig()).thenReturn((Object)FileSystemViewStorageConfig.newBuilder().build());
        Assertions.assertEquals(expectedWriteMarkersClass, WriteMarkersFactory.get((MarkerType)markerTypeConfig, (HoodieTable)this.table, (String)instantTime).getClass());
    }
}

