/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.testutils.HoodieMergeOnReadTestUtils;
import org.junit.jupiter.api.Assertions;

public class GenericRecordValidationTestUtils {
    public static void assertGenericRecords(GenericRecord record1, GenericRecord record2, Schema schema, List<String> excludeFields) {
        for (Schema.Field f : schema.getFields()) {
            String fieldName = f.name();
            if (excludeFields.contains(fieldName)) continue;
            Object value1 = record1.get(fieldName);
            Object value2 = record2.get(fieldName);
            if (value1 != null && value2 != null) {
                if (value1 instanceof ArrayWritable) {
                    Assertions.assertEquals((Object)HoodieRealtimeRecordReaderUtils.arrayWritableToString((ArrayWritable)((ArrayWritable)value1)), (Object)HoodieRealtimeRecordReaderUtils.arrayWritableToString((ArrayWritable)((ArrayWritable)value2)));
                    continue;
                }
                if (value1 instanceof Text && value2 instanceof BytesWritable) {
                    Assertions.assertArrayEquals((byte[])((Text)value1).getBytes(), (byte[])((BytesWritable)value2).getBytes());
                    continue;
                }
                Assertions.assertEquals((Object)value1, (Object)value2, (String)("Field name " + fieldName + " is not same. Val1: " + value1 + ", Val2:" + value2));
                continue;
            }
            if (value1 == null && value2 == null) continue;
            throw new HoodieValidationException("Field name " + fieldName + " is not same. Val1: " + value1 + ", Val2:" + value2);
        }
    }

    public static void assertDataInMORTable(HoodieWriteConfig config, String instant1, String instant2, StorageConfiguration<Configuration> storageConf, List<String> partitionPaths) {
        List excludeFields = CollectionUtils.createImmutableList((Object[])new String[]{HoodieRecord.COMMIT_TIME_METADATA_FIELD, HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, HoodieRecord.FILENAME_METADATA_FIELD, HoodieRecord.OPERATION_METADATA_FIELD});
        GenericRecordValidationTestUtils.assertDataInMORTable(config, instant1, instant2, storageConf, partitionPaths, excludeFields);
    }

    public static void assertDataInMORTable(HoodieWriteConfig config, String instant1, String instant2, StorageConfiguration<Configuration> storageConf, List<String> partitionPaths, List<String> excludeFields) {
        JobConf jobConf = new JobConf((Configuration)storageConf.unwrap());
        List<String> fullPartitionPaths = partitionPaths.stream().map(partitionPath -> Paths.get(config.getBasePath(), partitionPath).toString()).collect(Collectors.toList());
        jobConf.set(String.format("hoodie.%s.consume.commit", config.getTableName()), instant1);
        jobConf.set("hoodie.optimized.log.blocks.scan.enable", "true");
        List<GenericRecord> records = HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(storageConf, fullPartitionPaths, config.getBasePath(), jobConf, true);
        Map prevRecordsMap = records.stream().collect(Collectors.toMap(rec -> rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString(), Function.identity()));
        jobConf.set(String.format("hoodie.%s.consume.commit", config.getTableName()), instant2);
        List<GenericRecord> records1 = HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(storageConf, fullPartitionPaths, config.getBasePath(), jobConf, true);
        Map newRecordsMap = records1.stream().collect(Collectors.toMap(rec -> rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString(), Function.identity()));
        Assertions.assertEquals((int)prevRecordsMap.size(), (int)newRecordsMap.size());
        Schema readerSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(config.getSchema()), (boolean)config.allowOperationMetadataField());
        prevRecordsMap.forEach((key, value) -> {
            Assertions.assertTrue((boolean)newRecordsMap.containsKey(key));
            GenericRecordValidationTestUtils.assertGenericRecords(value, (GenericRecord)newRecordsMap.get(key), readerSchema, excludeFields);
        });
    }

    public static Map<String, GenericRecord> getRecordsMap(HoodieWriteConfig config, StorageConfiguration<Configuration> storageConf, HoodieTestDataGenerator dataGen) {
        JobConf jobConf = new JobConf((Configuration)storageConf.unwrap());
        List<String> fullPartitionPaths = Arrays.stream(dataGen.getPartitionPaths()).map(partitionPath -> Paths.get(config.getBasePath(), partitionPath).toString()).collect(Collectors.toList());
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(storageConf, fullPartitionPaths, config.getBasePath(), jobConf, true).stream().collect(Collectors.toMap(rec -> rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString(), Function.identity()));
    }

    public static Stream<GenericRecord> readHFile(Configuration conf, String[] paths) {
        LinkedList valuesAsList = new LinkedList();
        for (String path : paths) {
            HoodieHadoopStorage storage = new HoodieHadoopStorage(path, conf);
            try (HoodieAvroHFileReaderImplBase reader = (HoodieAvroHFileReaderImplBase)HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, new StoragePath(path), HoodieFileFormat.HFILE);){
                valuesAsList.addAll(HoodieAvroHFileReaderImplBase.readAllRecords((HoodieAvroFileReader)reader).stream().map(e -> (GenericRecord)e).collect(Collectors.toList()));
            }
            catch (IOException e2) {
                throw new HoodieException("Error reading HFile " + path, (Throwable)e2);
            }
        }
        return valuesAsList.stream();
    }
}

