/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils.providers;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePathInfo;

public interface HoodieMetaClientProvider {
    public HoodieTableMetaClient getHoodieMetaClient(StorageConfiguration<?> var1, String var2, Properties var3) throws IOException;

    default public HoodieTableFileSystemView getHoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, List<StoragePathInfo> pathInfoList) {
        return new HoodieTableFileSystemView(metaClient, visibleActiveTimeline, pathInfoList);
    }

    default public SyncableFileSystemView getFileSystemViewWithUnCommittedSlices(HoodieTableMetaClient metaClient) {
        try {
            return new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), HoodieTestTable.of((HoodieTableMetaClient)metaClient).listAllBaseAndLogFiles());
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error getting file system view", ioe);
        }
    }
}

