/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;

public class EmbeddedTimelineServerHelper {
    public static Option<EmbeddedTimelineService> createEmbeddedTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        if (config.isEmbeddedTimelineServerEnabled()) {
            Option hostAddr = context.getProperty(EngineProperty.EMBEDDED_SERVER_HOST);
            EmbeddedTimelineService timelineService = EmbeddedTimelineService.getOrStartEmbeddedTimelineService(context, (String)hostAddr.orElse(null), config);
            EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer(timelineService, config);
            return Option.of((Object)timelineService);
        }
        return Option.empty();
    }

    public static void updateWriteConfigWithTimelineServer(EmbeddedTimelineService timelineServer, HoodieWriteConfig config) {
        if (config.isEmbeddedTimelineServerEnabled()) {
            config.setViewStorageConfig(timelineServer.getRemoteFileSystemViewConfig());
        }
    }
}

