/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.client.utils.MetadataConversionUtils;
import org.apache.hudi.common.model.HoodieMetadataWrapper;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public class ConcurrentOperation {
    private WriteOperationType operationType;
    private final HoodieMetadataWrapper metadataWrapper;
    private final Option<org.apache.hudi.common.model.HoodieCommitMetadata> commitMetadataOption;
    private final String actionState;
    private final String actionType;
    private final String instantTime;
    private Set<Pair<String, String>> mutatedPartitionAndFileIds = Collections.emptySet();

    public ConcurrentOperation(HoodieInstant instant, HoodieTableMetaClient metaClient) throws IOException {
        if (instant.getAction().equals("compaction") && instant.getState().equals((Object)HoodieInstant.State.INFLIGHT)) {
            instant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instant.getTimestamp());
        }
        this.metadataWrapper = new HoodieMetadataWrapper(MetadataConversionUtils.createMetaWrapper(instant, metaClient));
        this.commitMetadataOption = Option.empty();
        this.actionState = instant.getState().name();
        this.actionType = instant.getAction();
        this.instantTime = instant.getTimestamp();
        this.init(instant);
    }

    public ConcurrentOperation(HoodieInstant instant, org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata) {
        this.commitMetadataOption = Option.of((Object)commitMetadata);
        this.metadataWrapper = new HoodieMetadataWrapper(commitMetadata);
        this.actionState = instant.getState().name();
        this.actionType = instant.getAction();
        this.instantTime = instant.getTimestamp();
        this.init(instant);
    }

    public String getInstantActionState() {
        return this.actionState;
    }

    public String getInstantActionType() {
        return this.actionType;
    }

    public String getInstantTimestamp() {
        return this.instantTime;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public Set<Pair<String, String>> getMutatedPartitionAndFileIds() {
        return this.mutatedPartitionAndFileIds;
    }

    public Option<org.apache.hudi.common.model.HoodieCommitMetadata> getCommitMetadataOption() {
        return this.commitMetadataOption;
    }

    private void init(HoodieInstant instant) {
        block28: {
            block27: {
                if (!this.metadataWrapper.isAvroMetadata()) break block27;
                switch (this.getInstantActionType()) {
                    case "compaction": {
                        this.operationType = WriteOperationType.COMPACT;
                        this.mutatedPartitionAndFileIds = this.metadataWrapper.getMetadataFromTimeline().getHoodieCompactionPlan().getOperations().stream().map(operation -> Pair.of((Object)operation.getPartitionPath(), (Object)operation.getFileId())).collect(Collectors.toSet());
                        break;
                    }
                    case "commit": 
                    case "deltacommit": {
                        this.mutatedPartitionAndFileIds = CommitUtils.getPartitionAndFileIdWithoutSuffixFromSpecificRecord((Map)this.metadataWrapper.getMetadataFromTimeline().getHoodieCommitMetadata().getPartitionToWriteStats());
                        this.operationType = WriteOperationType.fromValue((String)this.metadataWrapper.getMetadataFromTimeline().getHoodieCommitMetadata().getOperationType());
                        break;
                    }
                    case "replacecommit": {
                        if (instant.isCompleted()) {
                            this.mutatedPartitionAndFileIds = CommitUtils.getPartitionAndFileIdWithoutSuffixFromSpecificRecord((Map)this.metadataWrapper.getMetadataFromTimeline().getHoodieReplaceCommitMetadata().getPartitionToWriteStats());
                            Map partitionToReplaceFileIds = this.metadataWrapper.getMetadataFromTimeline().getHoodieReplaceCommitMetadata().getPartitionToReplaceFileIds();
                            this.mutatedPartitionAndFileIds.addAll(CommitUtils.flattenPartitionToReplaceFileIds((Map)partitionToReplaceFileIds));
                            this.operationType = WriteOperationType.fromValue((String)this.metadataWrapper.getMetadataFromTimeline().getHoodieReplaceCommitMetadata().getOperationType());
                            break;
                        }
                        HoodieRequestedReplaceMetadata requestedReplaceMetadata = this.metadataWrapper.getMetadataFromTimeline().getHoodieRequestedReplaceMetadata();
                        HoodieCommitMetadata inflightCommitMetadata = this.metadataWrapper.getMetadataFromTimeline().getHoodieInflightReplaceMetadata();
                        if (instant.isRequested()) {
                            if (requestedReplaceMetadata != null && requestedReplaceMetadata.getClusteringPlan() != null) {
                                this.mutatedPartitionAndFileIds = ConcurrentOperation.getPartitionAndFileIdsFromRequestedReplaceMetadata(requestedReplaceMetadata);
                                this.operationType = WriteOperationType.CLUSTER;
                                break;
                            }
                        } else {
                            if (inflightCommitMetadata != null) {
                                this.mutatedPartitionAndFileIds = CommitUtils.getPartitionAndFileIdWithoutSuffixFromSpecificRecord((Map)inflightCommitMetadata.getPartitionToWriteStats());
                                this.operationType = WriteOperationType.fromValue((String)this.metadataWrapper.getMetadataFromTimeline().getHoodieInflightReplaceMetadata().getOperationType());
                                break;
                            }
                            if (requestedReplaceMetadata != null) {
                                this.mutatedPartitionAndFileIds = ConcurrentOperation.getPartitionAndFileIdsFromRequestedReplaceMetadata(requestedReplaceMetadata);
                                this.operationType = WriteOperationType.CLUSTER;
                                break;
                            }
                        }
                        break block28;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported Action Type " + this.getInstantActionType());
                    }
                }
                break block28;
            }
            switch (this.getInstantActionType()) {
                case "compaction": 
                case "commit": 
                case "deltacommit": 
                case "replacecommit": 
                case "logcompaction": {
                    this.mutatedPartitionAndFileIds = CommitUtils.getPartitionAndFileIdWithoutSuffix((Map)this.metadataWrapper.getCommitMetadata().getPartitionToWriteStats());
                    this.operationType = this.metadataWrapper.getCommitMetadata().getOperationType();
                    if (!this.operationType.equals((Object)WriteOperationType.CLUSTER) && !WriteOperationType.isOverwrite((WriteOperationType)this.operationType)) break;
                    HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)this.metadataWrapper.getCommitMetadata();
                    this.mutatedPartitionAndFileIds.addAll(CommitUtils.flattenPartitionToReplaceFileIds((Map)replaceCommitMetadata.getPartitionToReplaceFileIds()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Action Type " + this.getInstantActionType());
                }
            }
        }
    }

    private static Set<Pair<String, String>> getPartitionAndFileIdsFromRequestedReplaceMetadata(HoodieRequestedReplaceMetadata requestedReplaceMetadata) {
        return requestedReplaceMetadata.getClusteringPlan().getInputGroups().stream().flatMap(ig -> ig.getSlices().stream()).map(fileSlice -> Pair.of((Object)fileSlice.getPartitionPath(), (Object)fileSlice.getFileId())).collect(Collectors.toSet());
    }

    public String toString() {
        return "{actionType=" + this.getInstantActionType() + ", instantTime=" + this.getInstantTimestamp() + ", actionState=" + this.getInstantActionState() + '\'' + '}';
    }
}

