/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.BaseStream;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedGlobalIndexFileFilter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalBloomIndex
extends HoodieBloomIndex {
    public HoodieGlobalBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config, bloomIndexHelper);
    }

    @Override
    List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List allPartitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)context, (HoodieStorage)metaClient.getStorage(), (HoodieMetadataConfig)this.config.getMetadataConfig(), (String)metaClient.getBasePath());
        return super.loadColumnRangesFromFiles(allPartitionPaths, context, hoodieTable);
    }

    @Override
    HoodiePairData<HoodieFileGroupId, String> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedGlobalIndexFileFilter(partitionToFileIndexInfo) : new ListBasedGlobalIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map((SerializableFunction & Serializable)partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair((Object)new HoodieFileGroupId((String)partitionFileIdPair.getLeft(), (String)partitionFileIdPair.getRight()), (Object)recordKey));
        }).flatMapToPair(BaseStream::iterator);
    }

    @Override
    protected <R> HoodieData<HoodieRecord<R>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyLocationPairs, HoodieData<HoodieRecord<R>> records, HoodieTable hoodieTable) {
        HoodiePairData keyAndExistingLocations = keyLocationPairs.mapToPair((SerializablePairFunction & Serializable)p -> Pair.of((Object)((HoodieKey)p.getLeft()).getRecordKey(), (Object)HoodieRecordGlobalLocation.fromLocal((String)((HoodieKey)p.getLeft()).getPartitionPath(), (HoodieRecordLocation)((HoodieRecordLocation)p.getRight()))));
        boolean mayContainDuplicateLookup = hoodieTable.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ;
        boolean shouldUpdatePartitionPath = this.config.getGlobalBloomIndexUpdatePartitionPath() && hoodieTable.isPartitioned();
        return HoodieIndexUtils.tagGlobalLocationBackToRecords(records, (HoodiePairData<String, HoodieRecordGlobalLocation>)keyAndExistingLocations, mayContainDuplicateLookup, shouldUpdatePartitionPath, this.config, hoodieTable);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

