/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.keygen.AutoRecordKeyGeneratorWrapper;
import org.apache.hudi.keygen.BaseKeyGenerator;

public class AutoRecordGenWrapperAvroKeyGenerator
extends BaseKeyGenerator
implements AutoRecordKeyGeneratorWrapper {
    private final BaseKeyGenerator keyGenerator;
    private Integer partitionId;
    private String instantTime;
    private int rowId;

    public AutoRecordGenWrapperAvroKeyGenerator(TypedProperties config, BaseKeyGenerator keyGenerator) {
        super(config);
        this.keyGenerator = keyGenerator;
        this.rowId = 0;
        this.partitionId = null;
        this.instantTime = null;
    }

    public String getRecordKey(GenericRecord record) {
        return this.generateSequenceId(this.rowId++);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.keyGenerator.getPartitionPath(record);
    }

    public List<String> getRecordKeyFieldNames() {
        return this.keyGenerator.getRecordKeyFieldNames();
    }

    public List<String> getPartitionPathFields() {
        return this.keyGenerator.getPartitionPathFields();
    }

    public boolean isConsistentLogicalTimestampEnabled() {
        return this.keyGenerator.isConsistentLogicalTimestampEnabled();
    }

    @Override
    public BaseKeyGenerator getPartitionKeyGenerator() {
        return this.keyGenerator;
    }

    private String generateSequenceId(long recordIndex) {
        if (this.partitionId == null) {
            this.partitionId = this.config.getInteger("_hoodie.record.key.gen.partition.id");
        }
        if (this.instantTime == null) {
            this.instantTime = this.config.getString("_hoodie.record.key.gen.instant.time");
        }
        return HoodieRecord.generateSequenceId((String)this.instantTime, (int)this.partitionId, (long)recordIndex);
    }
}

