/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.action.index.AbstractIndexingCatchupTask;

public class WriteStatBasedIndexingCatchupTask
extends AbstractIndexingCatchupTask {
    public WriteStatBasedIndexingCatchupTask(HoodieTableMetadataWriter metadataWriter, List<HoodieInstant> instantsToIndex, Set<String> metadataCompletedInstants, HoodieTableMetaClient metaClient, HoodieTableMetaClient metadataMetaClient, String currentCaughtupInstant, TransactionManager txnManager, HoodieEngineContext engineContext) {
        super(metadataWriter, instantsToIndex, metadataCompletedInstants, metaClient, metadataMetaClient, txnManager, currentCaughtupInstant, engineContext);
    }

    @Override
    public void updateIndexForWriteAction(HoodieInstant instant) throws IOException {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])this.metaClient.getActiveTimeline().getInstantDetails(instant).get()), HoodieCommitMetadata.class);
        this.metadataWriter.updateFromWriteStatuses(commitMetadata, (HoodieData<WriteStatus>)this.engineContext.emptyHoodieData(), instant.getTimestamp());
    }
}

