/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.upgrade.FiveToFourDowngradeHandler;
import org.apache.hudi.table.upgrade.FiveToSixUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToFiveUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToThreeDowngradeHandler;
import org.apache.hudi.table.upgrade.OneToTwoUpgradeHandler;
import org.apache.hudi.table.upgrade.OneToZeroDowngradeHandler;
import org.apache.hudi.table.upgrade.SixToFiveDowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.ThreeToFourUpgradeHandler;
import org.apache.hudi.table.upgrade.ThreeToTwoDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToOneDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToThreeUpgradeHandler;
import org.apache.hudi.table.upgrade.ZeroToOneUpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDowngrade {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeDowngrade.class);
    public static final String HOODIE_UPDATED_PROPERTY_FILE = "hoodie.properties.updated";
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private HoodieTableMetaClient metaClient;
    protected HoodieWriteConfig config;
    protected HoodieEngineContext context;
    private Path updatedPropsFilePath;
    private Path propsFilePath;

    public UpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this.metaClient = metaClient;
        this.config = config;
        this.context = context;
        this.updatedPropsFilePath = new Path(metaClient.getMetaPath().toString(), HOODIE_UPDATED_PROPERTY_FILE);
        this.propsFilePath = new Path(metaClient.getMetaPath().toString(), "hoodie.properties");
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    public boolean needsUpgradeOrDowngrade(HoodieTableVersion toVersion) {
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        return toVersion.versionCode() != fromVersion.versionCode();
    }

    public void run(HoodieTableVersion toVersion, String instantTime) {
        if (toVersion.versionCode() >= HoodieTableVersion.FOUR.versionCode()) {
            String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath((String)this.metaClient.getBasePathV2().toString());
            try {
                if (this.metaClient.getStorage().exists(new StoragePath(metadataTablePath))) {
                    HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(metadataTablePath).build();
                    HoodieWriteConfig mdtWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig(this.config, HoodieFailedWritesCleaningPolicy.EAGER);
                    new UpgradeDowngrade(mdtMetaClient, mdtWriteConfig, this.context, this.upgradeDowngradeHelper).run(toVersion, instantTime);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to upgrade or downgrade the metadata table to version " + toVersion + ", ignoring the error and continue.", (Throwable)e);
            }
        }
        HoodieTableVersion fromVersion = this.metaClient.getTableConfig().getTableVersion();
        if (!this.needsUpgradeOrDowngrade(toVersion)) {
            return;
        }
        LOG.info("Attempting to move table from version " + fromVersion + " to " + toVersion);
        Hashtable<ConfigProperty, String> tableProps = new Hashtable<ConfigProperty, String>();
        if (fromVersion.versionCode() < toVersion.versionCode()) {
            while (fromVersion.versionCode() < toVersion.versionCode()) {
                HoodieTableVersion nextVersion = HoodieTableVersion.versionFromCode((int)(fromVersion.versionCode() + 1));
                tableProps.putAll(this.upgrade(fromVersion, nextVersion, instantTime));
                fromVersion = nextVersion;
            }
        } else {
            while (fromVersion.versionCode() > toVersion.versionCode()) {
                HoodieTableVersion prevVersion = HoodieTableVersion.versionFromCode((int)(fromVersion.versionCode() - 1));
                tableProps.putAll(this.downgrade(fromVersion, prevVersion, instantTime));
                fromVersion = prevVersion;
            }
        }
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        for (Map.Entry entry : tableProps.entrySet()) {
            this.metaClient.getTableConfig().setValue((ConfigProperty)entry.getKey(), (String)entry.getValue());
        }
        this.metaClient.getTableConfig().setTableVersion(toVersion);
        HoodieTableConfig.update((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps());
    }

    protected Map<ConfigProperty, String> upgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ZERO && toVersion == HoodieTableVersion.ONE) {
            return new ZeroToOneUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.TWO) {
            return new OneToTwoUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.THREE) {
            return new TwoToThreeUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.FOUR) {
            return new ThreeToFourUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.FIVE) {
            return new FourToFiveUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.SIX) {
            return new FiveToSixUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), true);
    }

    protected Map<ConfigProperty, String> downgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.ZERO) {
            return new OneToZeroDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.ONE) {
            return new TwoToOneDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.TWO) {
            return new ThreeToTwoDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.THREE) {
            return new FourToThreeDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.FOUR) {
            return new FiveToFourDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SIX && toVersion == HoodieTableVersion.FIVE) {
            return new SixToFiveDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), false);
    }
}

