/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedTimelineServerHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedTimelineService.class);
    private static Option<EmbeddedTimelineService> TIMELINE_SERVER = Option.empty();

    public static synchronized Option<EmbeddedTimelineService> createEmbeddedTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        if (config.isEmbeddedTimelineServerReuseEnabled()) {
            if (!TIMELINE_SERVER.isPresent() || !((EmbeddedTimelineService)TIMELINE_SERVER.get()).canReuseFor(config.getBasePath())) {
                TIMELINE_SERVER = Option.of((Object)EmbeddedTimelineServerHelper.startTimelineService(context, config));
            } else {
                EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer((EmbeddedTimelineService)TIMELINE_SERVER.get(), config);
            }
            return TIMELINE_SERVER;
        }
        if (config.isEmbeddedTimelineServerEnabled()) {
            return Option.of((Object)EmbeddedTimelineServerHelper.startTimelineService(context, config));
        }
        return Option.empty();
    }

    private static EmbeddedTimelineService startTimelineService(HoodieEngineContext context, HoodieWriteConfig config) throws IOException {
        LOG.info("Starting Timeline service !!");
        Option hostAddr = context.getProperty(EngineProperty.EMBEDDED_SERVER_HOST);
        EmbeddedTimelineService timelineService = new EmbeddedTimelineService(context, (String)hostAddr.orElse(null), config);
        timelineService.startServer();
        EmbeddedTimelineServerHelper.updateWriteConfigWithTimelineServer(timelineService, config);
        return timelineService;
    }

    public static void updateWriteConfigWithTimelineServer(EmbeddedTimelineService timelineServer, HoodieWriteConfig config) {
        if (config.isEmbeddedTimelineServerEnabled()) {
            config.setViewStorageConfig(timelineServer.getRemoteFileSystemViewConfig());
        }
    }
}

