/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.timeline;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class ActiveActionWithDetails
extends ActiveAction {
    private final Option<byte[]> requestedDetails;
    private final Option<byte[]> inflightDetails;
    private final Option<byte[]> completedDetails;

    protected ActiveActionWithDetails(@Nullable HoodieInstant requested, Option<byte[]> requestedDetails, @Nullable HoodieInstant inflight, Option<byte[]> inflightDetails, HoodieInstant completed, Option<byte[]> completedDetails) {
        super(requested, inflight, completed);
        this.requestedDetails = requestedDetails;
        this.inflightDetails = inflightDetails;
        this.completedDetails = completedDetails;
    }

    public static ActiveActionWithDetails fromInstantAndDetails(List<Pair<HoodieInstant, Option<byte[]>>> instantAndDetails) {
        ValidationUtils.checkArgument((instantAndDetails.size() <= 3 ? 1 : 0) != 0);
        HoodieInstant requested = null;
        HoodieInstant inflight = null;
        HoodieInstant completed = null;
        Option requestedDetails = Option.empty();
        Option inflightDetails = Option.empty();
        Option completedDetails = Option.empty();
        for (Pair<HoodieInstant, Option<byte[]>> instantAndDetail : instantAndDetails) {
            HoodieInstant instant = (HoodieInstant)instantAndDetail.getKey();
            Option details = (Option)instantAndDetail.getRight();
            if (instant.isRequested()) {
                requested = instant;
                requestedDetails = details;
                continue;
            }
            if (instant.isInflight()) {
                inflight = instant;
                inflightDetails = details;
                continue;
            }
            completed = instant;
            completedDetails = details;
        }
        return new ActiveActionWithDetails(requested, (Option<byte[]>)requestedDetails, inflight, (Option<byte[]>)inflightDetails, Objects.requireNonNull(completed), (Option<byte[]>)completedDetails);
    }

    public Option<byte[]> getCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.completedDetails;
    }

    public Option<byte[]> getRequestedCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.requestedDetails;
    }

    public Option<byte[]> getInflightCommitMetadata(HoodieTableMetaClient metaClient) {
        return this.inflightDetails;
    }

    public byte[] getCleanPlan(HoodieTableMetaClient metaClient) {
        ValidationUtils.checkState((boolean)this.requestedDetails.isPresent(), (String)"clean plan does not exist");
        return (byte[])this.requestedDetails.get();
    }

    public byte[] getCompactionPlan(HoodieTableMetaClient metaClient) {
        ValidationUtils.checkState((boolean)this.requestedDetails.isPresent(), (String)"compaction plan does not exist");
        return (byte[])this.requestedDetails.get();
    }

    public byte[] getLogCompactionPlan(HoodieTableMetaClient metaClient) {
        ValidationUtils.checkState((boolean)this.requestedDetails.isPresent(), (String)"log compaction plan does not exist");
        return (byte[])this.requestedDetails.get();
    }
}

