/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.client.timeline.ActiveActionWithDetails;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyArchivedMetaEntryReader {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyArchivedMetaEntryReader.class);
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^\\.commits_\\.archive\\.([0-9]+).*");
    public static final String MERGE_ARCHIVE_PLAN_NAME = "mergeArchivePlan";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final String ACTION_STATE = "actionState";
    private static final String STATE_TRANSITION_TIME = "stateTransitionTime";
    private final HoodieTableMetaClient metaClient;

    public LegacyArchivedMetaEntryReader(HoodieTableMetaClient metaClient) {
        this.metaClient = metaClient;
    }

    public ClosableIterator<ActiveAction> getActiveActionsIterator() {
        return this.loadInstants(null);
    }

    private Pair<HoodieInstant, Option<byte[]>> readInstant(GenericRecord record) {
        String instantTime = record.get("commitTime").toString();
        String action = record.get(ACTION_TYPE_KEY).toString();
        String stateTransitionTime = (String)record.get(STATE_TRANSITION_TIME);
        Option details = this.getMetadataKey(action).map(key -> {
            Object actionData = record.get(key);
            if (actionData != null) {
                if (action.equals("compaction")) {
                    return HoodieAvroUtils.indexedRecordToBytes((IndexedRecord)((IndexedRecord)actionData));
                }
                return StringUtils.getUTF8Bytes((String)actionData.toString());
            }
            return null;
        });
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.valueOf((String)record.get(ACTION_STATE).toString()), action, instantTime, stateTransitionTime);
        return Pair.of((Object)instant, (Object)details);
    }

    @Nonnull
    private Option<String> getMetadataKey(String action) {
        switch (action) {
            case "clean": {
                return Option.of((Object)"hoodieCleanMetadata");
            }
            case "commit": 
            case "deltacommit": {
                return Option.of((Object)"hoodieCommitMetadata");
            }
            case "rollback": {
                return Option.of((Object)"hoodieRollbackMetadata");
            }
            case "savepoint": {
                return Option.of((Object)"hoodieSavePointMetadata");
            }
            case "compaction": 
            case "logcompaction": {
                return Option.of((Object)"hoodieCompactionPlan");
            }
            case "replacecommit": {
                return Option.of((Object)"hoodieReplaceCommitMetadata");
            }
            case "indexing": {
                return Option.of((Object)"hoodieIndexCommitMetadata");
            }
        }
        LOG.error(String.format("Unknown action in metadata (%s)", action));
        return Option.empty();
    }

    private ClosableIterator<ActiveAction> loadInstants(final HoodieArchivedTimeline.TimeRangeFilter filter) {
        try {
            FileStatus[] fsStatuses = this.metaClient.getFs().globStatus(new Path(this.metaClient.getArchivePath() + "/.commits_.archive*"));
            Arrays.sort(fsStatuses, new ArchiveLogVersionComparator());
            final ClosableIterator<HoodieRecord<IndexedRecord>> itr = this.getRecordIterator(fsStatuses);
            return new ClosableIterator<ActiveAction>(){
                private ActiveAction activeAction;
                private Pair<HoodieInstant, Option<byte[]>> nextInstantAndDetail;

                public void close() {
                    itr.close();
                }

                public boolean hasNext() {
                    ArrayList<Pair<HoodieInstant, Option<byte[]>>> instantAndDetails = new ArrayList<Pair<HoodieInstant, Option<byte[]>>>();
                    String lastInstantTime = null;
                    if (this.nextInstantAndDetail != null) {
                        instantAndDetails.add(this.nextInstantAndDetail);
                        lastInstantTime = ((HoodieInstant)this.nextInstantAndDetail.getKey()).getTimestamp();
                        this.nextInstantAndDetail = null;
                    }
                    while (itr.hasNext()) {
                        HoodieRecord record = (HoodieRecord)itr.next();
                        Pair instantAndDetail = LegacyArchivedMetaEntryReader.this.readInstant((GenericRecord)record.getData());
                        String instantTime = ((HoodieInstant)instantAndDetail.getKey()).getTimestamp();
                        if (filter != null && !filter.isInRange(instantTime)) continue;
                        if (lastInstantTime == null) {
                            instantAndDetails.add((Pair<HoodieInstant, Option<byte[]>>)instantAndDetail);
                            lastInstantTime = instantTime;
                            continue;
                        }
                        if (lastInstantTime.equals(instantTime)) {
                            instantAndDetails.add((Pair<HoodieInstant, Option<byte[]>>)instantAndDetail);
                            continue;
                        }
                        this.nextInstantAndDetail = instantAndDetail;
                        break;
                    }
                    if (!instantAndDetails.isEmpty()) {
                        this.activeAction = ActiveActionWithDetails.fromInstantAndDetails(instantAndDetails);
                        return true;
                    }
                    return false;
                }

                public ActiveAction next() {
                    return this.activeAction;
                }
            };
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + this.metaClient.getArchivePath(), e);
        }
    }

    private ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(final FileStatus[] fsStatuses) throws IOException {
        return new ClosableIterator<HoodieRecord<IndexedRecord>>(){
            final Iterator<FileStatus> fsItr;
            HoodieLogFormat.Reader reader;
            ClosableIterator<HoodieRecord<IndexedRecord>> recordItr;
            {
                this.fsItr = Arrays.asList(fsStatuses).iterator();
            }

            public void close() {
                if (this.reader != null) {
                    LegacyArchivedMetaEntryReader.this.closeLogFormatReader(this.reader);
                }
            }

            public boolean hasNext() {
                if (this.recordItr != null && this.recordItr.hasNext()) {
                    return true;
                }
                if (this.reader != null) {
                    while (this.reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)this.reader.next();
                        if (!(block instanceof HoodieAvroDataBlock)) continue;
                        HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                        this.recordItr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        if (!this.recordItr.hasNext()) continue;
                        return true;
                    }
                    LegacyArchivedMetaEntryReader.this.closeLogFormatReader(this.reader);
                    this.reader = null;
                }
                while (this.fsItr.hasNext()) {
                    FileStatus fs = this.fsItr.next();
                    try {
                        this.reader = HoodieLogFormat.newReader((FileSystem)LegacyArchivedMetaEntryReader.this.metaClient.getFs(), (HoodieLogFile)new HoodieLogFile(fs.getPath()), (Schema)HoodieArchivedMetaEntry.getClassSchema());
                    }
                    catch (IOException ioe) {
                        throw new HoodieIOException("Error initializing the reader for archived log: " + fs.getPath(), ioe);
                    }
                    while (this.reader.hasNext()) {
                        HoodieLogBlock block = (HoodieLogBlock)this.reader.next();
                        if (!(block instanceof HoodieAvroDataBlock)) continue;
                        HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                        this.recordItr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                        if (!this.recordItr.hasNext()) continue;
                        return true;
                    }
                }
                return false;
            }

            public HoodieRecord<IndexedRecord> next() {
                return (HoodieRecord)this.recordItr.next();
            }
        };
    }

    private void closeLogFormatReader(HoodieLogFormat.Reader reader) {
        try {
            reader.close();
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error closing log format reader", ioe);
        }
    }

    private static int getArchivedFileSuffix(FileStatus f) {
        try {
            Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(f.getPath().getName());
            if (fileMatcher.matches()) {
                return Integer.parseInt(fileMatcher.group(1));
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("error getting suffix for archived file: " + f.getPath());
        }
        return 0;
    }

    public static class ArchiveLogVersionComparator
    implements Comparator<FileStatus>,
    Serializable {
        @Override
        public int compare(FileStatus f1, FileStatus f2) {
            return Integer.compare(LegacyArchivedMetaEntryReader.getArchivedFileSuffix(f2), LegacyArchivedMetaEntryReader.getArchivedFileSuffix(f1));
        }
    }
}

