/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionUtils.class);

    public static Option<HoodieCommitMetadata> resolveWriteConflictIfAny(HoodieTable table, Option<HoodieInstant> currentTxnOwnerInstant, Option<HoodieCommitMetadata> thisCommitMetadata, HoodieWriteConfig config, Option<HoodieInstant> lastCompletedTxnOwnerInstant, boolean reloadActiveTimeline, Set<String> pendingInstants) throws HoodieWriteConflictException {
        WriteOperationType operationType = (WriteOperationType)thisCommitMetadata.map(HoodieCommitMetadata::getOperationType).orElse(null);
        if (config.needResolveWriteConflict(operationType)) {
            Stream<HoodieInstant> completedInstantsDuringCurrentWriteOperation = TransactionUtils.getCompletedInstantsDuringCurrentWriteOperation(table.getMetaClient(), pendingInstants);
            ConflictResolutionStrategy resolutionStrategy = config.getWriteConflictResolutionStrategy();
            if (reloadActiveTimeline) {
                table.getMetaClient().reloadActiveTimeline();
            }
            Stream<HoodieInstant> instantStream = Stream.concat(resolutionStrategy.getCandidateInstants(table.getMetaClient(), (HoodieInstant)currentTxnOwnerInstant.get(), lastCompletedTxnOwnerInstant), completedInstantsDuringCurrentWriteOperation);
            ConcurrentOperation thisOperation = new ConcurrentOperation((HoodieInstant)currentTxnOwnerInstant.get(), (HoodieCommitMetadata)thisCommitMetadata.orElse((Object)new HoodieCommitMetadata()));
            instantStream.forEach(instant -> {
                try {
                    ConcurrentOperation otherOperation = new ConcurrentOperation((HoodieInstant)instant, table.getMetaClient());
                    if (resolutionStrategy.hasConflict(thisOperation, otherOperation)) {
                        LOG.info("Conflict encountered between current instant = " + thisOperation + " and instant = " + otherOperation + ", attempting to resolve it...");
                        resolutionStrategy.resolveConflict(table, thisOperation, otherOperation);
                    }
                }
                catch (IOException io) {
                    throw new HoodieWriteConflictException("Unable to resolve conflict, if present", (Throwable)io);
                }
            });
            LOG.info("Successfully resolved conflicts, if any");
            return thisOperation.getCommitMetadataOption();
        }
        return thisCommitMetadata;
    }

    public static Option<Pair<HoodieInstant, Map<String, String>>> getLastCompletedTxnInstantAndMetadata(HoodieTableMetaClient metaClient) {
        Option hoodieInstantOption = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
        return TransactionUtils.getHoodieInstantAndMetaDataPair(metaClient, (Option<HoodieInstant>)hoodieInstantOption);
    }

    private static Option<Pair<HoodieInstant, Map<String, String>>> getHoodieInstantAndMetaDataPair(HoodieTableMetaClient metaClient, Option<HoodieInstant> hoodieInstantOption) {
        try {
            if (hoodieInstantOption.isPresent()) {
                HoodieCommitMetadata commitMetadata = TimelineUtils.getCommitMetadata((HoodieInstant)((HoodieInstant)hoodieInstantOption.get()), (HoodieTimeline)metaClient.getActiveTimeline());
                return Option.of((Object)Pair.of((Object)hoodieInstantOption.get(), (Object)commitMetadata.getExtraMetadata()));
            }
            return Option.empty();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read metadata for instant " + hoodieInstantOption.get(), io);
        }
    }

    public static Set<String> getInflightAndRequestedInstants(HoodieTableMetaClient metaClient) {
        Set timelineActions = CollectionUtils.createImmutableSet((Object[])new String[]{"replacecommit", "compaction", "deltacommit", "commit"});
        return metaClient.getActiveTimeline().getTimelineOfActions(timelineActions).filterInflightsAndRequested().getInstantsAsStream().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
    }

    public static Stream<HoodieInstant> getCompletedInstantsDuringCurrentWriteOperation(HoodieTableMetaClient metaClient, Set<String> pendingInstants) {
        return metaClient.reloadActiveTimeline().getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().filter(f -> pendingInstants.contains(f.getTimestamp()));
    }
}

