/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieReadHandle<T, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    protected final Pair<String, String> partitionPathFileIDPair;

    public HoodieReadHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, (Option<String>)Option.empty(), hoodieTable);
        this.partitionPathFileIDPair = partitionPathFileIDPair;
    }

    public HoodieReadHandle(HoodieWriteConfig config, Option<String> instantTime, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, instantTime, hoodieTable);
        this.partitionPathFileIDPair = partitionPathFileIDPair;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    public Pair<String, String> getPartitionPathFileIDPair() {
        return this.partitionPathFileIDPair;
    }

    public String getFileId() {
        return (String)this.partitionPathFileIDPair.getRight();
    }

    protected HoodieBaseFile getLatestBaseFile() {
        return (HoodieBaseFile)this.hoodieTable.getBaseFileOnlyView().getLatestBaseFile((String)this.partitionPathFileIDPair.getLeft(), (String)this.partitionPathFileIDPair.getRight()).get();
    }

    protected HoodieFileReader createNewFileReader() throws IOException {
        return HoodieFileReaderFactory.getReaderFactory((HoodieRecord.HoodieRecordType)this.config.getRecordMerger().getRecordType()).getFileReader(this.hoodieTable.getHadoopConf(), new Path(this.getLatestBaseFile().getPath()));
    }

    protected HoodieFileReader createNewFileReader(HoodieBaseFile hoodieBaseFile) throws IOException {
        return HoodieFileReaderFactory.getReaderFactory((HoodieRecord.HoodieRecordType)this.config.getRecordMerger().getRecordType()).getFileReader(this.hoodieTable.getHadoopConf(), new Path(hoodieBaseFile.getPath()));
    }
}

