/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.parser.BaseHoodieDateTimeParser;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class HoodieDateTimeParser
extends BaseHoodieDateTimeParser {
    private String configInputDateFormatList;
    private final DateTimeZone inputDateTimeZone;

    public HoodieDateTimeParser(TypedProperties config) {
        super(config);
        ConfigUtils.checkRequiredConfigProperties((TypedProperties)config, Arrays.asList(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD, TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT));
        this.inputDateTimeZone = this.getInputDateTimeZone();
    }

    private DateTimeFormatter getInputDateFormatter() {
        if (this.configInputDateFormatList.isEmpty()) {
            throw new IllegalArgumentException(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key() + " configuration is required");
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().append(null, (DateTimeParser[])Arrays.stream(this.configInputDateFormatList.split(this.configInputDateFormatDelimiter)).map(String::trim).map(DateTimeFormat::forPattern).map(DateTimeFormatter::getParser).toArray(DateTimeParser[]::new)).toFormatter();
        formatter = this.inputDateTimeZone != null ? formatter.withZone(this.inputDateTimeZone) : formatter.withOffsetParsed();
        return formatter;
    }

    @Override
    public Option<DateTimeFormatter> getInputFormatter() {
        TimestampBasedAvroKeyGenerator.TimestampType timestampType = TimestampBasedAvroKeyGenerator.TimestampType.valueOf(ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD));
        if (timestampType == TimestampBasedAvroKeyGenerator.TimestampType.DATE_STRING || timestampType == TimestampBasedAvroKeyGenerator.TimestampType.MIXED) {
            ConfigUtils.checkRequiredConfigProperties((TypedProperties)this.config, Collections.singletonList(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT));
            this.configInputDateFormatList = ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT, (boolean)true);
            return Option.of((Object)this.getInputDateFormatter());
        }
        return Option.empty();
    }

    @Override
    public DateTimeZone getInputDateTimeZone() {
        String inputTimeZone = ConfigUtils.containsConfigProperty((TypedProperties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT) ? ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT, (String)"GMT") : ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_TIMEZONE_FORMAT, (String)"");
        return !inputTimeZone.trim().isEmpty() ? DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(inputTimeZone)) : null;
    }

    @Override
    public DateTimeZone getOutputDateTimeZone() {
        String outputTimeZone = ConfigUtils.containsConfigProperty((TypedProperties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT) ? ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT, (String)"GMT") : ConfigUtils.getStringWithAltKeys((Properties)this.config, (ConfigProperty)TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_TIMEZONE_FORMAT, (String)"");
        return !outputTimeZone.trim().isEmpty() ? DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(outputTimeZone)) : null;
    }
}

