/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.index;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleIndexActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieIndexPlan>> {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleIndexActionExecutor.class);
    private static final Integer INDEX_PLAN_VERSION_1;
    private static final Integer LATEST_INDEX_PLAN_VERSION;
    private final List<MetadataPartitionType> partitionIndexTypes;
    private final TransactionManager txnManager;

    public ScheduleIndexActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, List<MetadataPartitionType> partitionIndexTypes) {
        super(context, config, table, instantTime);
        this.partitionIndexTypes = partitionIndexTypes;
        this.txnManager = new TransactionManager(config, (FileSystem)table.getMetaClient().getFs());
    }

    @Override
    public Option<HoodieIndexPlan> execute() {
        this.validateBeforeScheduling();
        Set indexesInflightOrCompleted = HoodieTableMetadataUtil.getInflightAndCompletedMetadataPartitions((HoodieTableConfig)this.table.getMetaClient().getTableConfig());
        Set requestedPartitions = this.partitionIndexTypes.stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
        requestedPartitions.removeAll(indexesInflightOrCompleted);
        if (requestedPartitions.isEmpty()) {
            LOG.error("All requested index types are inflight or completed: " + this.partitionIndexTypes);
            return Option.empty();
        }
        LOG.warn(String.format("Following partitions already exist or inflight: %s. Going to schedule indexing of only these partitions: %s", indexesInflightOrCompleted, requestedPartitions));
        List finalPartitionsToIndex = this.partitionIndexTypes.stream().filter(p -> requestedPartitions.contains(p.getPartitionPath())).collect(Collectors.toList());
        HoodieInstant indexInstant = HoodieTimeline.getIndexRequestedInstant((String)this.instantTime);
        try {
            this.txnManager.beginTransaction((Option<HoodieInstant>)Option.of((Object)indexInstant), (Option<HoodieInstant>)Option.empty());
            Option indexUptoInstant = this.table.getActiveTimeline().getContiguousCompletedWriteTimeline().lastInstant();
            if (indexUptoInstant.isPresent()) {
                List indexPartitionInfos = finalPartitionsToIndex.stream().map(p -> this.buildIndexPartitionInfo((MetadataPartitionType)p, (HoodieInstant)indexUptoInstant.get())).collect(Collectors.toList());
                HoodieIndexPlan indexPlan = new HoodieIndexPlan(LATEST_INDEX_PLAN_VERSION, indexPartitionInfos);
                this.table.getActiveTimeline().saveToPendingIndexAction(indexInstant, TimelineMetadataUtils.serializeIndexPlan((HoodieIndexPlan)indexPlan));
                Option option = Option.of((Object)indexPlan);
                return option;
            }
        }
        catch (IOException e) {
            LOG.error("Could not initialize file groups", (Throwable)e);
            this.abort(indexInstant);
            throw new HoodieIOException(e.getMessage(), e);
        }
        finally {
            this.txnManager.endTransaction((Option<HoodieInstant>)Option.of((Object)indexInstant));
        }
        return Option.empty();
    }

    private HoodieIndexPartitionInfo buildIndexPartitionInfo(MetadataPartitionType partitionType, HoodieInstant indexUptoInstant) {
        String partitionName = MetadataPartitionType.FUNCTIONAL_INDEX.equals((Object)partitionType) ? this.config.getFunctionalIndexConfig().getIndexName() : partitionType.getPartitionPath();
        return new HoodieIndexPartitionInfo(LATEST_INDEX_PLAN_VERSION, partitionName, indexUptoInstant.getTimestamp(), Collections.emptyMap());
    }

    private void validateBeforeScheduling() {
        if (!EnumSet.allOf(MetadataPartitionType.class).containsAll(this.partitionIndexTypes)) {
            throw new HoodieIndexException("Not all index types are valid: " + this.partitionIndexTypes);
        }
        if (!this.config.getWriteConcurrencyMode().supportsMultiWriter() || StringUtils.isNullOrEmpty((String)this.config.getLockProviderClass())) {
            throw new HoodieIndexException(String.format("Need to set %s as %s or %s and configure lock provider class", HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name(), WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL.name()));
        }
    }

    private void abort(HoodieInstant indexInstant) {
        this.partitionIndexTypes.forEach(partitionType -> {
            if (HoodieTableMetadataUtil.metadataPartitionExists((String)this.table.getMetaClient().getBasePath(), (HoodieEngineContext)this.context, (MetadataPartitionType)partitionType)) {
                HoodieTableMetadataUtil.deleteMetadataPartition((String)this.table.getMetaClient().getBasePath(), (HoodieEngineContext)this.context, (MetadataPartitionType)partitionType);
            }
        });
        this.table.getMetaClient().reloadActiveTimeline().deleteInstantFileIfExists(indexInstant);
    }

    static {
        LATEST_INDEX_PLAN_VERSION = INDEX_PLAN_VERSION_1 = Integer.valueOf(1);
    }
}

