/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.BaseRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.CopyOnWriteRollbackActionExecutor;

public class CopyOnWriteRestoreActionExecutor<T, I, K, O>
extends BaseRestoreActionExecutor<T, I, K, O> {
    public CopyOnWriteRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime, savepointToRestoreTimestamp);
    }

    @Override
    protected HoodieRollbackMetadata rollbackInstant(HoodieInstant instantToRollback) {
        if (!instantToRollback.getAction().equals("commit") && !instantToRollback.getAction().equals("replacecommit")) {
            throw new HoodieRollbackException("Unsupported action in rollback instant:" + instantToRollback);
        }
        this.table.getMetaClient().reloadActiveTimeline();
        String newInstantTime = this.table.getMetaClient().createNewInstantTime();
        this.table.scheduleRollback(this.context, newInstantTime, instantToRollback, false, false, true);
        this.table.getMetaClient().reloadActiveTimeline();
        CopyOnWriteRollbackActionExecutor rollbackActionExecutor = new CopyOnWriteRollbackActionExecutor(this.context, this.config, this.table, newInstantTime, instantToRollback, true, true, false);
        return rollbackActionExecutor.execute();
    }
}

