/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointHelpers.class);

    public static void deleteSavepoint(HoodieTable table, String savepointTime) {
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", savepointTime);
        boolean isSavepointPresent = table.getCompletedSavepointTimeline().containsInstant(savePoint);
        if (!isSavepointPresent) {
            LOG.warn("No savepoint present " + savepointTime);
            return;
        }
        table.getActiveTimeline().revertToInflight(savePoint);
        table.getActiveTimeline().deleteInflight(new HoodieInstant(true, "savepoint", savepointTime));
        LOG.info("Savepoint " + savepointTime + " deleted");
    }

    public static void validateSavepointRestore(HoodieTable table, String savepointTime) {
        table.getMetaClient().reloadActiveTimeline();
        Option lastInstant = table.getActiveTimeline().getWriteTimeline().filterCompletedAndCompactionInstants().lastInstant();
        ValidationUtils.checkArgument((boolean)lastInstant.isPresent());
        ValidationUtils.checkArgument((boolean)((HoodieInstant)lastInstant.get()).getTimestamp().equals(savepointTime), (String)(savepointTime + " is not the last commit after restoring to savepoint, last commit was " + ((HoodieInstant)lastInstant.get()).getTimestamp()));
    }

    public static void validateSavepointPresence(HoodieTable table, String savepointTime) {
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", savepointTime);
        boolean isSavepointPresent = table.getCompletedSavepointTimeline().containsInstant(savePoint);
        if (!isSavepointPresent) {
            throw new HoodieRollbackException("No savepoint for instantTime " + savepointTime);
        }
    }
}

