/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.bootstrap.BootstrapMode;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieIndexingConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.HoodieTableServiceManagerConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.queue.DisruptorWaitStrategyType;
import org.apache.hudi.common.util.queue.ExecutorType;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsM3Config;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.RandomFileIdPrefixProvider;
import org.apache.hudi.table.action.clean.CleaningTriggerStrategy;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.CompositeCompactionStrategy;
import org.apache.hudi.table.marker.ConflictDetectionUtils;
import org.apache.hudi.table.storage.HoodieStorageLayout;
import org.apache.orc.CompressionKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigClassProperty(name="Write Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations that control write behavior on Hudi tables. These can be directly passed down from even higher level frameworks (e.g Spark datasources, Flink sink) and utilities (e.g Hudi Streamer).")
@Immutable
public class HoodieWriteConfig
extends HoodieConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteConfig.class);
    private static final long serialVersionUID = 0L;
    public static final String STREAMER_CHECKPOINT_KEY = "deltastreamer.checkpoint.key";
    @Deprecated
    public static final String DELTASTREAMER_CHECKPOINT_KEY = "deltastreamer.checkpoint.key";
    public static final String CONCURRENCY_PREFIX = "hoodie.write.concurrency.";
    public static final ConfigProperty<String> TBL_NAME = ConfigProperty.key((String)"hoodie.table.name").noDefaultValue().withDocumentation("Table name that will be used for registering with metastores like HMS. Needs to be same across runs.");
    public static final ConfigProperty<Integer> WRITE_TABLE_VERSION = ConfigProperty.key((String)"hoodie.write.table.version").defaultValue((Object)HoodieTableVersion.current().versionCode()).withValidValues(new String[]{String.valueOf(HoodieTableVersion.SIX.versionCode()), String.valueOf(HoodieTableVersion.current().versionCode())}).sinceVersion("1.0.0").withDocumentation("The table version this writer is storing the table in. This should match the current table version.");
    public static final ConfigProperty<Boolean> AUTO_UPGRADE_VERSION = ConfigProperty.key((String)"hoodie.write.auto.upgrade").defaultValue((Object)true).sinceVersion("1.0.0").withDocumentation("If enabled, writers automatically migrate the table to the specified write table version if the current table version is lower.");
    public static final ConfigProperty<String> TAGGED_RECORD_STORAGE_LEVEL_VALUE = ConfigProperty.key((String)"hoodie.write.tagged.record.storage.level").defaultValue((Object)"MEMORY_AND_DISK_SER").markAdvanced().withDocumentation("Determine what level of persistence is used to cache write RDDs. Refer to org.apache.spark.storage.StorageLevel for different values");
    public static final ConfigProperty<String> PRECOMBINE_FIELD_NAME = ConfigProperty.key((String)"hoodie.datasource.write.precombine.field").defaultValue((Object)"ts").withDocumentation("Field used in preCombining before actual write. When two records have the same key value, we will pick the one with the largest value for the precombine field, determined by Object.compareTo(..)");
    public static final ConfigProperty<String> WRITE_PAYLOAD_CLASS_NAME = ConfigProperty.key((String)"hoodie.datasource.write.payload.class").noDefaultValue().markAdvanced().deprecatedAfter("1.0.0").withDocumentation("Payload class used. Override this, if you like to roll your own merge logic, when upserting/inserting. This will render any value set for PRECOMBINE_FIELD_OPT_VAL in-effective");
    public static final ConfigProperty<String> RECORD_MERGE_MODE = ConfigProperty.key((String)"hoodie.write.record.merge.mode").defaultValue((Object)RecordMergeMode.EVENT_TIME_ORDERING.name()).sinceVersion("1.0.0").withDocumentation(RecordMergeMode.class);
    public static final ConfigProperty<String> RECORD_MERGE_STRATEGY_ID = ConfigProperty.key((String)"hoodie.write.record.merge.strategy.id").noDefaultValue().markAdvanced().withAlternatives(new String[]{"hoodie.datasource.write.record.merger.strategy"}).sinceVersion("0.13.0").withDocumentation("ID of record merge strategy. Hudi will pick HoodieRecordMerger implementations in `hoodie.write.record.merge.custom.implementation.classes` which has the same merge strategy id");
    public static final ConfigProperty<String> RECORD_MERGE_IMPL_CLASSES = ConfigProperty.key((String)"hoodie.write.record.merge.custom.implementation.classes").noDefaultValue().markAdvanced().withAlternatives(new String[]{"hoodie.datasource.write.record.merger.impls"}).sinceVersion("0.13.0").withDocumentation("List of HoodieMerger implementations constituting Hudi's merging strategy -- based on the engine used. These record merge impls will filter by " + RECORD_MERGE_STRATEGY_ID.key() + "Hudi will pick most efficient implementation to perform merging/combining of the records (during update, reading MOR table, etc)");
    public static final ConfigProperty<String> KEYGENERATOR_CLASS_NAME = ConfigProperty.key((String)"hoodie.datasource.write.keygenerator.class").noDefaultValue().markAdvanced().withDocumentation("Key generator class, that implements `org.apache.hudi.keygen.KeyGenerator` extract a key out of incoming records.");
    public static final ConfigProperty<String> WRITE_EXECUTOR_TYPE = ConfigProperty.key((String)"hoodie.write.executor.type").defaultValue((Object)ExecutorType.SIMPLE.name()).withValidValues((String[])Arrays.stream(ExecutorType.values()).map(Enum::name).toArray(String[]::new)).markAdvanced().sinceVersion("0.13.0").withDocumentation(ExecutorType.class);
    public static final ConfigProperty<String> KEYGENERATOR_TYPE = ConfigProperty.key((String)"hoodie.datasource.write.keygenerator.type").defaultValue((Object)KeyGeneratorType.SIMPLE.name()).markAdvanced().withDocumentation(KeyGeneratorType.class, "**Note** This is being actively worked on. Please use `hoodie.datasource.write.keygenerator.class` instead.");
    public static final ConfigProperty<String> ROLLBACK_USING_MARKERS_ENABLE = ConfigProperty.key((String)"hoodie.rollback.using.markers").defaultValue((Object)"true").markAdvanced().withDocumentation("Enables a more efficient mechanism for rollbacks based on the marker files generated during the writes. Turned on by default.");
    public static final ConfigProperty<String> TIMELINE_LAYOUT_VERSION_NUM = ConfigProperty.key((String)"hoodie.timeline.layout.version").defaultValue((Object)Integer.toString(TimelineLayoutVersion.CURR_VERSION)).withValidValues(new String[]{Integer.toString(TimelineLayoutVersion.VERSION_0), Integer.toString(TimelineLayoutVersion.VERSION_1), Integer.toString(TimelineLayoutVersion.VERSION_2)}).markAdvanced().sinceVersion("0.5.1").withDocumentation("Controls the layout of the timeline. Version 0 relied on renames, Version 1 (default) models the timeline as an immutable log relying only on atomic writes for object storage.");
    public static final ConfigProperty<HoodieFileFormat> BASE_FILE_FORMAT = ConfigProperty.key((String)"hoodie.base.file.format").defaultValue((Object)HoodieFileFormat.PARQUET).withValidValues(new String[]{HoodieFileFormat.PARQUET.name(), HoodieFileFormat.ORC.name(), HoodieFileFormat.HFILE.name()}).withAlternatives(new String[]{"hoodie.table.ro.file.format"}).markAdvanced().withDocumentation(HoodieFileFormat.class, "File format to store all the base file data.");
    public static final ConfigProperty<String> BASE_PATH = HoodieCommonConfig.BASE_PATH;
    public static final ConfigProperty<String> AVRO_SCHEMA_STRING = ConfigProperty.key((String)"hoodie.avro.schema").noDefaultValue().markAdvanced().withDocumentation("Schema string representing the current write schema of the table. Hudi passes this to implementations of HoodieRecordPayload to convert incoming records to avro. This is also used as the write schema evolving records during an update.");
    public static final ConfigProperty<String> INTERNAL_SCHEMA_STRING = ConfigProperty.key((String)"hoodie.internal.schema").noDefaultValue().markAdvanced().withDocumentation("Schema string representing the latest schema of the table. Hudi passes this to implementations of evolution of schema");
    public static final ConfigProperty<String> AVRO_SCHEMA_VALIDATE_ENABLE = ConfigProperty.key((String)"hoodie.avro.schema.validate").defaultValue((Object)"false").markAdvanced().withDocumentation("Validate the schema used for the write against the latest schema, for backwards compatibility.");
    public static final ConfigProperty<String> SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP = ConfigProperty.key((String)"hoodie.datasource.write.schema.allow.auto.evolution.column.drop").defaultValue((Object)"false").markAdvanced().sinceVersion("0.13.0").withDocumentation("Controls whether table's schema is allowed to automatically evolve when incoming batch's schema can have any of the columns dropped. By default, Hudi will not allow this kind of (auto) schema evolution. Set this config to true to allow table's schema to be updated automatically when columns are dropped from the new incoming batch.");
    public static final ConfigProperty<String> INSERT_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.insert.shuffle.parallelism").defaultValue((Object)"0").markAdvanced().withDocumentation("Parallelism for inserting records into the table. Inserts can shuffle data before writing to tune file sizes and optimize the storage layout. Before 0.13.0 release, if users do not configure it, Hudi would use 200 as the default shuffle parallelism. From 0.13.0 onwards Hudi by default automatically uses the parallelism deduced by Spark based on the source data. If the shuffle parallelism is explicitly configured by the user, the user-configured parallelism is used in defining the actual parallelism. If you observe small files from the insert operation, we suggest configuring this shuffle parallelism explicitly, so that the parallelism is around total_input_data_size/120MB.");
    public static final ConfigProperty<String> BULKINSERT_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.bulkinsert.shuffle.parallelism").defaultValue((Object)"0").markAdvanced().withDocumentation("For large initial imports using bulk_insert operation, controls the parallelism to use for sort modes or custom partitioning done before writing records to the table. Before 0.13.0 release, if users do not configure it, Hudi would use 200 as the default shuffle parallelism. From 0.13.0 onwards Hudi by default automatically uses the parallelism deduced by Spark based on the source data or the parallelism based on the logical plan for row writer. If the shuffle parallelism is explicitly configured by the user, the user-configured parallelism is used in defining the actual parallelism. If you observe small files from the bulk insert operation, we suggest configuring this shuffle parallelism explicitly, so that the parallelism is around total_input_data_size/120MB.");
    public static final ConfigProperty<String> BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS = ConfigProperty.key((String)"hoodie.bulkinsert.user.defined.partitioner.sort.columns").noDefaultValue().markAdvanced().withDocumentation("Columns to sort the data by when use org.apache.hudi.execution.bulkinsert.RDDCustomColumnsSortPartitioner as user defined partitioner during bulk_insert. For example 'column1,column2'");
    public static final ConfigProperty<Boolean> BULKINSERT_SUFFIX_RECORD_KEY_SORT_COLUMNS = ConfigProperty.key((String)"hoodie.bulkinsert.sort.suffix.record_key").defaultValue((Object)false).markAdvanced().sinceVersion("1.0.0").withDocumentation("When using user defined sort columns there can be possibility of skew because spark's RangePartitioner used in sort can reduce the number of outputSparkPartitionsif the sampled dataset has a low cardinality on the provided sort columns. This can cause an increase in commit durations as we are not leveraging the original parallelism.Enabling this config suffixes the record key at the end to avoid skew.This config is used by RowCustomColumnsSortPartitioner, RDDCustomColumnsSortPartitioner and JavaCustomColumnsSortPartitioner");
    public static final ConfigProperty<String> BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME = ConfigProperty.key((String)"hoodie.bulkinsert.user.defined.partitioner.class").noDefaultValue().markAdvanced().withDocumentation("If specified, this class will be used to re-partition records before they are bulk inserted. This can be used to sort, pack, cluster data optimally for common query patterns. For now we support a build-in user defined bulkinsert partitioner org.apache.hudi.execution.bulkinsert.RDDCustomColumnsSortPartitioner which can does sorting based on specified column values set by " + BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS.key());
    public static final ConfigProperty<String> UPSERT_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.upsert.shuffle.parallelism").defaultValue((Object)"0").markAdvanced().withDocumentation("Parallelism to use for upsert operation on the table. Upserts can shuffle data to perform index lookups, file sizing, bin packing records optimally into file groups. Before 0.13.0 release, if users do not configure it, Hudi would use 200 as the default shuffle parallelism. From 0.13.0 onwards Hudi by default automatically uses the parallelism deduced by Spark based on the source data. If the shuffle parallelism is explicitly configured by the user, the user-configured parallelism is used in defining the actual parallelism. If you observe small files from the upsert operation, we suggest configuring this shuffle parallelism explicitly, so that the parallelism is around total_input_data_size/120MB.");
    public static final ConfigProperty<String> DELETE_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.delete.shuffle.parallelism").defaultValue((Object)"0").markAdvanced().withDocumentation("Parallelism used for delete operation. Delete operations also performs shuffles, similar to upsert operation. Before 0.13.0 release, if users do not configure it, Hudi would use 200 as the default shuffle parallelism. From 0.13.0 onwards Hudi by default automatically uses the parallelism deduced by Spark based on the source data. If the shuffle parallelism is explicitly configured by the user, the user-configured parallelism is used in defining the actual parallelism.");
    public static final ConfigProperty<String> ROLLBACK_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.rollback.parallelism").defaultValue((Object)"100").markAdvanced().withDocumentation("This config controls the parallelism for rollback of commits. Rollbacks perform deletion of files or logging delete blocks to file groups on storage in parallel. The configure value limits the parallelism so that the number of Spark tasks do not exceed the value. If rollback is slow due to the limited parallelism, you can increase this to tune the performance.");
    public static final ConfigProperty<String> WRITE_BUFFER_LIMIT_BYTES_VALUE = ConfigProperty.key((String)"hoodie.write.buffer.limit.bytes").defaultValue((Object)String.valueOf(0x400000)).markAdvanced().withDocumentation("Size of in-memory buffer used for parallelizing network reads and lake storage writes.");
    public static final ConfigProperty<String> WRITE_BUFFER_RECORD_SAMPLING_RATE = ConfigProperty.key((String)"hoodie.write.buffer.record.sampling.rate").defaultValue((Object)String.valueOf(64)).markAdvanced().sinceVersion("0.15.0").withDocumentation("Sampling rate of in-memory buffer used to estimate object size. Higher value lead to lower CPU usage.");
    public static final ConfigProperty<String> WRITE_BUFFER_RECORD_CACHE_LIMIT = ConfigProperty.key((String)"hoodie.write.buffer.record.cache.limit").defaultValue((Object)String.valueOf(131072)).markAdvanced().sinceVersion("0.15.0").withDocumentation("Maximum queue size of in-memory buffer for parallelizing network reads and lake storage writes.");
    public static final ConfigProperty<String> WRITE_EXECUTOR_DISRUPTOR_BUFFER_LIMIT_BYTES = ConfigProperty.key((String)"hoodie.write.executor.disruptor.buffer.limit.bytes").defaultValue((Object)String.valueOf(1024)).markAdvanced().sinceVersion("0.13.0").withDocumentation("The size of the Disruptor Executor ring buffer, must be power of 2");
    public static final ConfigProperty<String> WRITE_EXECUTOR_DISRUPTOR_WAIT_STRATEGY = ConfigProperty.key((String)"hoodie.write.executor.disruptor.wait.strategy").defaultValue((Object)DisruptorWaitStrategyType.BLOCKING_WAIT.name()).markAdvanced().sinceVersion("0.13.0").withDocumentation(DisruptorWaitStrategyType.class);
    public static final ConfigProperty<String> COMBINE_BEFORE_INSERT = ConfigProperty.key((String)"hoodie.combine.before.insert").defaultValue((Object)"false").markAdvanced().withDocumentation("When inserted records share same key, controls whether they should be first combined (i.e de-duplicated) before writing to storage.");
    public static final ConfigProperty<String> COMBINE_BEFORE_UPSERT = ConfigProperty.key((String)"hoodie.combine.before.upsert").defaultValue((Object)"true").markAdvanced().withDocumentation("When upserted records share same key, controls whether they should be first combined (i.e de-duplicated) before writing to storage. This should be turned off only if you are absolutely certain that there are no duplicates incoming,  otherwise it can lead to duplicate keys and violate the uniqueness guarantees.");
    public static final ConfigProperty<String> COMBINE_BEFORE_DELETE = ConfigProperty.key((String)"hoodie.combine.before.delete").defaultValue((Object)"true").markAdvanced().withDocumentation("During delete operations, controls whether we should combine deletes (and potentially also upserts) before  writing to storage.");
    public static final ConfigProperty<String> WRITE_STATUS_STORAGE_LEVEL_VALUE = ConfigProperty.key((String)"hoodie.write.status.storage.level").defaultValue((Object)"MEMORY_AND_DISK_SER").markAdvanced().withDocumentation("Write status objects hold metadata about a write (stats, errors), that is not yet committed to storage. This controls the how that information is cached for inspection by clients. We rarely expect this to be changed.");
    public static final ConfigProperty<String> AUTO_COMMIT_ENABLE = ConfigProperty.key((String)"hoodie.auto.commit").defaultValue((Object)"true").markAdvanced().withDocumentation("Controls whether a write operation should auto commit. This can be turned off to perform inspection of the uncommitted write before deciding to commit.");
    public static final ConfigProperty<String> WRITE_STATUS_CLASS_NAME = ConfigProperty.key((String)"hoodie.writestatus.class").defaultValue((Object)WriteStatus.class.getName()).markAdvanced().withDocumentation("Subclass of " + WriteStatus.class.getName() + " to be used to collect information about a write. Can be overridden to collection additional metrics/statistics about the data if needed.");
    public static final ConfigProperty<String> FINALIZE_WRITE_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.finalize.write.parallelism").defaultValue((Object)"200").markAdvanced().withDocumentation("Parallelism for the write finalization internal operation, which involves removing any partially written files from lake storage, before committing the write. Reduce this value, if the high number of tasks incur delays for smaller tables or low latency writes.");
    public static final ConfigProperty<String> MARKERS_TYPE = ConfigProperty.key((String)"hoodie.write.markers.type").defaultValue((Object)MarkerType.TIMELINE_SERVER_BASED.name()).markAdvanced().sinceVersion("0.9.0").withDocumentation(MarkerType.class);
    public static final ConfigProperty<Boolean> INSTANT_STATE_TIMELINE_SERVER_BASED = ConfigProperty.key((String)"hoodie.instant_state.timeline_server_based.enabled").defaultValue((Object)false).sinceVersion("1.0.0").withDocumentation("If enabled, writers get instant state from timeline server rather than requesting DFS directly");
    public static final ConfigProperty<Integer> INSTANT_STATE_TIMELINE_SERVER_BASED_FORCE_REFRESH_REQUEST_NUMBER = ConfigProperty.key((String)"hoodie.instant_state.timeline_server_based.force_refresh.request.number").defaultValue((Object)100).sinceVersion("1.0.0").withDocumentation("Number of requests to trigger instant state cache refreshing");
    public static final ConfigProperty<Integer> MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS = ConfigProperty.key((String)"hoodie.markers.timeline_server_based.batch.num_threads").defaultValue((Object)20).markAdvanced().sinceVersion("0.9.0").withDocumentation("Number of threads to use for batch processing marker creation requests at the timeline server");
    public static final ConfigProperty<Long> MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS = ConfigProperty.key((String)"hoodie.markers.timeline_server_based.batch.interval_ms").defaultValue((Object)50L).markAdvanced().sinceVersion("0.9.0").withDocumentation("The batch interval in milliseconds for marker creation batch processing");
    public static final ConfigProperty<String> MARKERS_DELETE_PARALLELISM_VALUE = ConfigProperty.key((String)"hoodie.markers.delete.parallelism").defaultValue((Object)"100").markAdvanced().withDocumentation("Determines the parallelism for deleting marker files, which are used to track all files (valid or invalid/partial) written during a write operation. Increase this value if delays are observed, with large batch writes.");
    public static final ConfigProperty<String> BULK_INSERT_SORT_MODE = ConfigProperty.key((String)"hoodie.bulkinsert.sort.mode").defaultValue((Object)BulkInsertSortMode.NONE.name()).markAdvanced().withDocumentation(BulkInsertSortMode.class);
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_ENABLE = ConfigProperty.key((String)"hoodie.embed.timeline.server").defaultValue((Object)"true").markAdvanced().withDocumentation("When true, spins up an instance of the timeline server (meta server that serves cached file listings, statistics),running on each writer's driver process, accepting requests during the write from executors.");
    public static final ConfigProperty<Boolean> EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED = ConfigProperty.key((String)"hoodie.embed.timeline.server.reuse.enabled").defaultValue((Object)false).markAdvanced().withDocumentation("Controls whether the timeline server instance should be cached and reused across the tablesto avoid startup costs and server overhead. This should only be used if you are running multiple writers in the same JVM.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_PORT_NUM = ConfigProperty.key((String)"hoodie.embed.timeline.server.port").defaultValue((Object)"0").markAdvanced().withDocumentation("Port at which the timeline server listens for requests. When running embedded in each writer, it picks a free port and communicates to all the executors. This should rarely be changed.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_NUM_SERVER_THREADS = ConfigProperty.key((String)"hoodie.embed.timeline.server.threads").defaultValue((Object)"-1").markAdvanced().withDocumentation("Number of threads to serve requests in the timeline server. By default, auto configured based on the number of underlying cores.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE = ConfigProperty.key((String)"hoodie.embed.timeline.server.gzip").defaultValue((Object)"true").markAdvanced().withDocumentation("Controls whether gzip compression is used, for large responses from the timeline server, to improve latency.");
    public static final ConfigProperty<String> EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE = ConfigProperty.key((String)"hoodie.embed.timeline.server.async").defaultValue((Object)"false").markAdvanced().withDocumentation("Controls whether or not, the requests to the timeline server are processed in asynchronous fashion, potentially improving throughput.");
    public static final ConfigProperty<String> FAIL_ON_TIMELINE_ARCHIVING_ENABLE = ConfigProperty.key((String)"hoodie.fail.on.timeline.archiving").defaultValue((Object)"true").markAdvanced().withDocumentation("Timeline archiving removes older instants from the timeline, after each write operation, to minimize metadata overhead. Controls whether or not, the write should be failed as well, if such archiving fails.");
    public static final ConfigProperty<String> FAIL_ON_INLINE_TABLE_SERVICE_EXCEPTION = ConfigProperty.key((String)"hoodie.fail.writes.on.inline.table.service.exception").defaultValue((Object)"true").markAdvanced().sinceVersion("0.13.0").withDocumentation("Table services such as compaction and clustering can fail and prevent syncing to the metaclient. Set this to true to fail writes when table services fail");
    public static final ConfigProperty<Long> INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = ConfigProperty.key((String)"hoodie.consistency.check.initial_interval_ms").defaultValue((Object)2000L).markAdvanced().withDocumentation("Initial time between successive attempts to ensure written data's metadata is consistent on storage. Grows with exponential backoff after the initial value.");
    public static final ConfigProperty<Long> MAX_CONSISTENCY_CHECK_INTERVAL_MS = ConfigProperty.key((String)"hoodie.consistency.check.max_interval_ms").defaultValue((Object)300000L).markAdvanced().withDocumentation("Max time to wait between successive attempts at performing consistency checks");
    public static final ConfigProperty<Integer> MAX_CONSISTENCY_CHECKS = ConfigProperty.key((String)"hoodie.consistency.check.max_checks").defaultValue((Object)7).markAdvanced().withDocumentation("Maximum number of checks, for consistency of written data.");
    public static final ConfigProperty<String> MERGE_DATA_VALIDATION_CHECK_ENABLE = ConfigProperty.key((String)"hoodie.merge.data.validation.enabled").defaultValue((Object)"false").markAdvanced().withDocumentation("When enabled, data validation checks are performed during merges to ensure expected number of records after merge operation.");
    public static final ConfigProperty<String> MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE = ConfigProperty.key((String)"hoodie.merge.allow.duplicate.on.inserts").defaultValue((Object)"true").markAdvanced().withDocumentation("When enabled, we allow duplicate keys even if inserts are routed to merge with an existing file (for ensuring file sizing). This is only relevant for insert operation, since upsert, delete operations will ensure unique key constraints are maintained.");
    public static final ConfigProperty<Integer> MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT = ConfigProperty.key((String)"hoodie.merge.small.file.group.candidates.limit").defaultValue((Object)1).markAdvanced().withDocumentation("Limits number of file groups, whose base file satisfies small-file limit, to consider for appending records during upsert operation. Only applicable to MOR tables");
    public static final ConfigProperty<Integer> CLIENT_HEARTBEAT_INTERVAL_IN_MS = ConfigProperty.key((String)"hoodie.client.heartbeat.interval_in_ms").defaultValue((Object)60000).markAdvanced().withDocumentation("Writers perform heartbeats to indicate liveness. Controls how often (in ms), such heartbeats are registered to lake storage.");
    public static final ConfigProperty<Integer> CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES = ConfigProperty.key((String)"hoodie.client.heartbeat.tolerable.misses").defaultValue((Object)2).markAdvanced().withDocumentation("Number of heartbeat misses, before a writer is deemed not alive and all pending writes are aborted.");
    public static final ConfigProperty<String> WRITE_CONCURRENCY_MODE = ConfigProperty.key((String)"hoodie.write.concurrency.mode").defaultValue((Object)WriteConcurrencyMode.SINGLE_WRITER.name()).withDocumentation(WriteConcurrencyMode.class);
    public static final ConfigProperty<Integer> NUM_RETRIES_ON_CONFLICT_FAILURES = ConfigProperty.key((String)"hoodie.write.num.retries.on.conflict.failures").defaultValue((Object)0).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum number of times to retry a batch on conflict failure.");
    public static final ConfigProperty<String> WRITE_SCHEMA_OVERRIDE = ConfigProperty.key((String)"hoodie.write.schema").noDefaultValue().markAdvanced().withDocumentation("Config allowing to override writer's schema. This might be necessary in cases when writer's schema derived from the incoming dataset might actually be different from the schema we actually want to use when writing. This, for ex, could be the case for'partial-update' use-cases (like `MERGE INTO` Spark SQL statement for ex) where only a projection of the incoming dataset might be used to update the records in the existing table, prompting us to override the writer's schema");
    public static final ConfigProperty<String> ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE = ConfigProperty.key((String)"_.hoodie.allow.multi.write.on.same.instant").defaultValue((Object)"false").markAdvanced().withDocumentation("");
    public static final ConfigProperty<String> AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE = ConfigProperty.key((String)(AVRO_SCHEMA_STRING.key() + ".external.transformation")).defaultValue((Object)"false").withAlternatives(new String[]{AVRO_SCHEMA_STRING.key() + ".externalTransformation"}).markAdvanced().withDocumentation("When enabled, records in older schema are rewritten into newer schema during upsert,delete and background compaction,clustering operations.");
    public static final ConfigProperty<Boolean> ALLOW_EMPTY_COMMIT = ConfigProperty.key((String)"hoodie.allow.empty.commit").defaultValue((Object)true).markAdvanced().withDocumentation("Whether to allow generation of empty commits, even if no data was written in the commit. It's useful in cases where extra metadata needs to be published regardless e.g tracking source offsets when ingesting data");
    public static final ConfigProperty<Boolean> ALLOW_OPERATION_METADATA_FIELD = ConfigProperty.key((String)"hoodie.allow.operation.metadata.field").defaultValue((Object)false).markAdvanced().sinceVersion("0.9.0").withDocumentation("Whether to include '_hoodie_operation' in the metadata fields. Once enabled, all the changes of a record are persisted to the delta log directly without merge");
    public static final ConfigProperty<String> FILEID_PREFIX_PROVIDER_CLASS = ConfigProperty.key((String)"hoodie.fileid.prefix.provider.class").defaultValue((Object)RandomFileIdPrefixProvider.class.getName()).markAdvanced().sinceVersion("0.10.0").withDocumentation("File Id Prefix provider class, that implements `org.apache.hudi.fileid.FileIdPrefixProvider`");
    public static final ConfigProperty<Boolean> TABLE_SERVICES_ENABLED = ConfigProperty.key((String)"hoodie.table.services.enabled").defaultValue((Object)true).markAdvanced().sinceVersion("0.11.0").withDocumentation("Master control to disable all table services including archive, clean, compact, cluster, etc.");
    public static final ConfigProperty<Boolean> RELEASE_RESOURCE_ENABLE = ConfigProperty.key((String)"hoodie.release.resource.on.completion.enable").defaultValue((Object)true).markAdvanced().sinceVersion("0.11.0").withDocumentation("Control to enable release all persist rdds when the spark job finish.");
    public static final ConfigProperty<Boolean> AUTO_ADJUST_LOCK_CONFIGS = ConfigProperty.key((String)"hoodie.auto.adjust.lock.configs").defaultValue((Object)false).markAdvanced().sinceVersion("0.11.0").withDocumentation("Auto adjust lock configurations when metadata table is enabled and for async table services.");
    public static final ConfigProperty<Boolean> SKIP_DEFAULT_PARTITION_VALIDATION = ConfigProperty.key((String)"hoodie.skip.default.partition.validation").defaultValue((Object)false).markAdvanced().sinceVersion("0.12.0").withDocumentation("When table is upgraded from pre 0.12 to 0.12, we check for \"default\" partition and fail if found one. Users are expected to rewrite the data in those partitions. Enabling this config will bypass this validation");
    public static final ConfigProperty<String> EARLY_CONFLICT_DETECTION_STRATEGY_CLASS_NAME = ConfigProperty.key((String)"hoodie.write.concurrency.early.conflict.detection.strategy").noDefaultValue().markAdvanced().sinceVersion("0.13.0").withInferFunction(cfg -> {
        MarkerType markerType = MarkerType.valueOf((String)cfg.getStringOrDefault(MARKERS_TYPE).toUpperCase());
        return Option.of((Object)ConflictDetectionUtils.getDefaultEarlyConflictDetectionStrategy(markerType));
    }).withDocumentation("The class name of the early conflict detection strategy to use. This should be a subclass of `org.apache.hudi.common.conflict.detection.EarlyConflictDetectionStrategy`.");
    public static final ConfigProperty<Boolean> EARLY_CONFLICT_DETECTION_ENABLE = ConfigProperty.key((String)"hoodie.write.concurrency.early.conflict.detection.enable").defaultValue((Object)false).markAdvanced().sinceVersion("0.13.0").withDocumentation("Whether to enable early conflict detection based on markers. It eagerly detects writing conflict before create markers and fails fast if a conflict is detected, to release cluster compute resources as soon as possible.");
    public static final ConfigProperty<Long> ASYNC_CONFLICT_DETECTOR_INITIAL_DELAY_MS = ConfigProperty.key((String)"hoodie.write.concurrency.async.conflict.detector.initial_delay_ms").defaultValue((Object)0L).markAdvanced().sinceVersion("0.13.0").withDocumentation("Used for timeline-server-based markers with `AsyncTimelineServerBasedDetectionStrategy`. The time in milliseconds to delay the first execution of async marker-based conflict detection.");
    public static final ConfigProperty<Long> ASYNC_CONFLICT_DETECTOR_PERIOD_MS = ConfigProperty.key((String)"hoodie.write.concurrency.async.conflict.detector.period_ms").defaultValue((Object)30000L).markAdvanced().sinceVersion("0.13.0").withDocumentation("Used for timeline-server-based markers with `AsyncTimelineServerBasedDetectionStrategy`. The period in milliseconds between successive executions of async marker-based conflict detection.");
    public static final ConfigProperty<Boolean> EARLY_CONFLICT_DETECTION_CHECK_COMMIT_CONFLICT = ConfigProperty.key((String)"hoodie.write.concurrency.early.conflict.check.commit.conflict").defaultValue((Object)false).markAdvanced().sinceVersion("0.13.0").withDocumentation("Whether to enable commit conflict checking or not during early conflict detection.");
    public static final ConfigProperty<String> SENSITIVE_CONFIG_KEYS_FILTER = ConfigProperty.key((String)"hoodie.sensitive.config.keys").defaultValue((Object)"ssl,tls,sasl,auth,credentials").markAdvanced().sinceVersion("0.14.0").withDocumentation("Comma separated list of filters for sensitive config keys. Hudi Streamer will not print any configuration which contains the configured filter. For example with a configured filter `ssl`, value for config `ssl.trustore.location` would be masked.");
    public static final ConfigProperty<Boolean> ROLLBACK_INSTANT_BACKUP_ENABLED = ConfigProperty.key((String)"hoodie.rollback.instant.backup.enabled").defaultValue((Object)false).markAdvanced().withDocumentation("Backup instants removed during rollback and restore (useful for debugging)");
    public static final ConfigProperty<String> ROLLBACK_INSTANT_BACKUP_DIRECTORY = ConfigProperty.key((String)"hoodie.rollback.instant.backup.dir").defaultValue((Object)".rollback_backup").markAdvanced().withDocumentation("Path where instants being rolled back are copied. If not absolute path then a directory relative to .hoodie folder is created.");
    public static final ConfigProperty<String> CLIENT_INIT_CALLBACK_CLASS_NAMES = ConfigProperty.key((String)"hoodie.client.init.callback.classes").defaultValue((Object)"").markAdvanced().sinceVersion("0.14.0").withDocumentation("Fully-qualified class names of the Hudi client init callbacks to run at the initialization of the Hudi client.  The class names are separated by `,`. The class must be a subclass of `org.apache.hudi.callback.HoodieClientInitCallback`.By default, no Hudi client init callback is executed.");
    public static final ConfigProperty<Boolean> WRITE_RECORD_POSITIONS = ConfigProperty.key((String)"hoodie.write.record.positions").defaultValue((Object)true).markAdvanced().sinceVersion("1.0.0").withDocumentation("Whether to write record positions to the block header for data blocks containing updates and delete blocks. The record positions can be used to improve the performance of merging records from base and log files.");
    public static final ConfigProperty<String> WRITE_PARTIAL_UPDATE_SCHEMA = ConfigProperty.key((String)"hoodie.write.partial.update.schema").defaultValue((Object)"").markAdvanced().sinceVersion("1.0.0").withDocumentation("Avro schema of the partial updates. This is automatically set by the Hudi write client and user is not expected to manually change the value.");
    public static final String SPARK_SQL_MERGE_INTO_PREPPED_KEY = "_hoodie.spark.sql.merge.into.prepped";
    public static final String WRITES_FILEID_ENCODING = "_hoodie.writes.fileid.encoding";
    private ConsistencyGuardConfig consistencyGuardConfig;
    private FileSystemRetryConfig fileSystemRetryConfig;
    private final FileSystemViewStorageConfig clientSpecifiedViewStorageConfig;
    private FileSystemViewStorageConfig viewStorageConfig;
    private HoodiePayloadConfig hoodiePayloadConfig;
    private HoodieMetadataConfig metadataConfig;
    private HoodieMetricsConfig metricsConfig;
    private HoodieMetaserverConfig metaserverConfig;
    private HoodieTableServiceManagerConfig tableServiceManagerConfig;
    private HoodieCommonConfig commonConfig;
    private HoodieStorageConfig storageConfig;
    private HoodieTimeGeneratorConfig timeGeneratorConfig;
    private HoodieIndexingConfig indexingConfig;
    private EngineType engineType;
    @Deprecated
    public static final String TABLE_NAME = TBL_NAME.key();
    @Deprecated
    public static final String PRECOMBINE_FIELD_PROP = PRECOMBINE_FIELD_NAME.key();
    @Deprecated
    public static final String WRITE_PAYLOAD_CLASS = WRITE_PAYLOAD_CLASS_NAME.key();
    @Deprecated
    public static final String KEYGENERATOR_CLASS_PROP = KEYGENERATOR_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_KEYGENERATOR_CLASS = SimpleAvroKeyGenerator.class.getName();
    @Deprecated
    public static final String DEFAULT_ROLLBACK_USING_MARKERS = (String)ROLLBACK_USING_MARKERS_ENABLE.defaultValue();
    @Deprecated
    public static final String ROLLBACK_USING_MARKERS = ROLLBACK_USING_MARKERS_ENABLE.key();
    @Deprecated
    public static final String TIMELINE_LAYOUT_VERSION = TIMELINE_LAYOUT_VERSION_NUM.key();
    @Deprecated
    public static final String BASE_PATH_PROP = BASE_PATH.key();
    @Deprecated
    public static final String AVRO_SCHEMA = AVRO_SCHEMA_STRING.key();
    @Deprecated
    public static final String AVRO_SCHEMA_VALIDATE = AVRO_SCHEMA_VALIDATE_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_AVRO_SCHEMA_VALIDATE = (String)AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue();
    @Deprecated
    public static final String DEFAULT_PARALLELISM = (String)INSERT_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String INSERT_PARALLELISM = INSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String BULKINSERT_PARALLELISM = BULKINSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String BULKINSERT_USER_DEFINED_PARTITIONER_CLASS = BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME.key();
    @Deprecated
    public static final String BULKINSERT_INPUT_DATA_SCHEMA_DDL = "hoodie.bulkinsert.schema.ddl";
    @Deprecated
    public static final String UPSERT_PARALLELISM = UPSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DELETE_PARALLELISM = DELETE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_ROLLBACK_PARALLELISM = (String)ROLLBACK_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String ROLLBACK_PARALLELISM = ROLLBACK_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String WRITE_BUFFER_LIMIT_BYTES = WRITE_BUFFER_LIMIT_BYTES_VALUE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_BUFFER_LIMIT_BYTES = (String)WRITE_BUFFER_LIMIT_BYTES_VALUE.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_INSERT_PROP = COMBINE_BEFORE_INSERT.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_INSERT = (String)COMBINE_BEFORE_INSERT.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_UPSERT_PROP = COMBINE_BEFORE_UPSERT.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_UPSERT = (String)COMBINE_BEFORE_UPSERT.defaultValue();
    @Deprecated
    public static final String COMBINE_BEFORE_DELETE_PROP = COMBINE_BEFORE_DELETE.key();
    @Deprecated
    public static final String DEFAULT_COMBINE_BEFORE_DELETE = (String)COMBINE_BEFORE_DELETE.defaultValue();
    @Deprecated
    public static final String WRITE_STATUS_STORAGE_LEVEL = WRITE_STATUS_STORAGE_LEVEL_VALUE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_STATUS_STORAGE_LEVEL = (String)WRITE_STATUS_STORAGE_LEVEL_VALUE.defaultValue();
    @Deprecated
    public static final String HOODIE_AUTO_COMMIT_PROP = AUTO_COMMIT_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_HOODIE_AUTO_COMMIT = (String)AUTO_COMMIT_ENABLE.defaultValue();
    @Deprecated
    public static final String HOODIE_WRITE_STATUS_CLASS_PROP = WRITE_STATUS_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_HOODIE_WRITE_STATUS_CLASS = (String)WRITE_STATUS_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String FINALIZE_WRITE_PARALLELISM = FINALIZE_WRITE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_FINALIZE_WRITE_PARALLELISM = (String)FINALIZE_WRITE_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String MARKERS_DELETE_PARALLELISM = MARKERS_DELETE_PARALLELISM_VALUE.key();
    @Deprecated
    public static final String DEFAULT_MARKERS_DELETE_PARALLELISM = (String)MARKERS_DELETE_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String BULKINSERT_SORT_MODE = BULK_INSERT_SORT_MODE.key();
    @Deprecated
    public static final String DEFAULT_BULKINSERT_SORT_MODE = (String)BULK_INSERT_SORT_MODE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_ENABLED = EMBEDDED_TIMELINE_SERVER_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ENABLED = (String)EMBEDDED_TIMELINE_SERVER_ENABLE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_PORT = EMBEDDED_TIMELINE_SERVER_PORT_NUM.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_PORT = (String)EMBEDDED_TIMELINE_SERVER_PORT_NUM.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_THREADS = EMBEDDED_TIMELINE_NUM_SERVER_THREADS.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_THREADS = (String)EMBEDDED_TIMELINE_NUM_SERVER_THREADS.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_COMPRESS_OUTPUT = EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_COMPRESS_OUTPUT = (String)EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE.defaultValue();
    @Deprecated
    public static final String EMBEDDED_TIMELINE_SERVER_USE_ASYNC = EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ASYNC = (String)EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE.defaultValue();
    @Deprecated
    public static final String FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP = FAIL_ON_TIMELINE_ARCHIVING_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_FAIL_ON_TIMELINE_ARCHIVING_ENABLED = (String)FAIL_ON_TIMELINE_ARCHIVING_ENABLE.defaultValue();
    @Deprecated
    public static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = INITIAL_CONSISTENCY_CHECK_INTERVAL_MS.key();
    @Deprecated
    public static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = (Long)INITIAL_CONSISTENCY_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    public static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = MAX_CONSISTENCY_CHECK_INTERVAL_MS.key();
    @Deprecated
    public static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = (Long)MAX_CONSISTENCY_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    public static final String MAX_CONSISTENCY_CHECKS_PROP = MAX_CONSISTENCY_CHECKS.key();
    @Deprecated
    public static int DEFAULT_MAX_CONSISTENCY_CHECKS = (Integer)MAX_CONSISTENCY_CHECKS.defaultValue();
    @Deprecated
    private static final String MERGE_DATA_VALIDATION_CHECK_ENABLED = MERGE_DATA_VALIDATION_CHECK_ENABLE.key();
    @Deprecated
    private static final String DEFAULT_MERGE_DATA_VALIDATION_CHECK_ENABLED = (String)MERGE_DATA_VALIDATION_CHECK_ENABLE.defaultValue();
    @Deprecated
    private static final String MERGE_ALLOW_DUPLICATE_ON_INSERTS = MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.key();
    @Deprecated
    private static final String DEFAULT_MERGE_ALLOW_DUPLICATE_ON_INSERTS = (String)MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE.defaultValue();
    @Deprecated
    public static final String CLIENT_HEARTBEAT_INTERVAL_IN_MS_PROP = CLIENT_HEARTBEAT_INTERVAL_IN_MS.key();
    @Deprecated
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_INTERVAL_IN_MS = (Integer)CLIENT_HEARTBEAT_INTERVAL_IN_MS.defaultValue();
    @Deprecated
    public static final String CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES_PROP = CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES.key();
    @Deprecated
    public static final Integer DEFAULT_CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES = (Integer)CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES.defaultValue();
    @Deprecated
    public static final String WRITE_CONCURRENCY_MODE_PROP = WRITE_CONCURRENCY_MODE.key();
    @Deprecated
    public static final String DEFAULT_WRITE_CONCURRENCY_MODE = (String)WRITE_CONCURRENCY_MODE.defaultValue();
    @Deprecated
    public static final String ALLOW_MULTI_WRITE_ON_SAME_INSTANT = ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_ALLOW_MULTI_WRITE_ON_SAME_INSTANT = (String)ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE.defaultValue();
    @Deprecated
    public static final String EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE.key();
    @Deprecated
    public static final String DEFAULT_EXTERNAL_RECORD_AND_SCHEMA_TRANSFORMATION = (String)AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE.defaultValue();

    protected HoodieWriteConfig() {
        this.engineType = EngineType.SPARK;
        this.clientSpecifiedViewStorageConfig = null;
    }

    protected HoodieWriteConfig(EngineType engineType, Properties props) {
        super(props);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        this.engineType = engineType;
        this.consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().fromProperties(newProps).build();
        this.fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().fromProperties(newProps).build();
        this.viewStorageConfig = this.clientSpecifiedViewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties(newProps).build();
        this.hoodiePayloadConfig = HoodiePayloadConfig.newBuilder().fromProperties(newProps).build();
        this.metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(props).build();
        this.metricsConfig = HoodieMetricsConfig.newBuilder().fromProperties(props).build();
        this.metaserverConfig = HoodieMetaserverConfig.newBuilder().fromProperties(props).build();
        this.tableServiceManagerConfig = HoodieTableServiceManagerConfig.newBuilder().fromProperties(props).build();
        this.commonConfig = HoodieCommonConfig.newBuilder().fromProperties(props).build();
        this.storageConfig = HoodieStorageConfig.newBuilder().fromProperties(props).build();
        this.timeGeneratorConfig = HoodieTimeGeneratorConfig.newBuilder().fromProperties(props).withDefaultLockProvider(!this.isLockRequired()).build();
        this.indexingConfig = HoodieIndexingConfig.newBuilder().fromProperties(props).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBasePath() {
        return this.getString(BASE_PATH);
    }

    public HoodieFileFormat getBaseFileFormat() {
        return HoodieFileFormat.getValue((String)this.getStringOrDefault(BASE_FILE_FORMAT));
    }

    public String getRecordMergeStrategyId() {
        return this.getString(RECORD_MERGE_STRATEGY_ID);
    }

    public RecordMergeMode getRecordMergeMode() {
        return RecordMergeMode.getValue((String)this.getString(RECORD_MERGE_MODE));
    }

    public HoodieRecordMerger getRecordMerger() {
        return HoodieRecordUtils.createRecordMerger((String)this.getString(BASE_PATH), (EngineType)this.engineType, (List)this.getSplitStrings(RECORD_MERGE_IMPL_CLASSES), (String)this.getString(RECORD_MERGE_STRATEGY_ID));
    }

    public String getSchema() {
        return this.getString(AVRO_SCHEMA_STRING);
    }

    public void setSchema(String schemaStr) {
        this.setValue(AVRO_SCHEMA_STRING, schemaStr);
    }

    public void setRecordMergerClass(String recordMergerStrategy) {
        this.setValue(RECORD_MERGE_STRATEGY_ID, recordMergerStrategy);
    }

    public String getWriteSchema() {
        if (this.props.containsKey((Object)WRITE_SCHEMA_OVERRIDE.key())) {
            return this.getString(WRITE_SCHEMA_OVERRIDE);
        }
        return this.getSchema();
    }

    public HoodieTableVersion getWriteVersion() {
        Integer versionCode = this.getInt(WRITE_TABLE_VERSION);
        if (versionCode != null) {
            WRITE_TABLE_VERSION.checkValues(versionCode.toString());
        }
        return HoodieTableVersion.fromVersionCode((int)this.getIntOrDefault(WRITE_TABLE_VERSION));
    }

    public boolean autoUpgrade() {
        return this.getBoolean(AUTO_UPGRADE_VERSION);
    }

    public String getTaggedRecordStorageLevel() {
        return this.getString(TAGGED_RECORD_STORAGE_LEVEL_VALUE);
    }

    public String getInternalSchema() {
        return this.getString(INTERNAL_SCHEMA_STRING);
    }

    public void setInternalSchemaString(String internalSchemaString) {
        this.setValue(INTERNAL_SCHEMA_STRING, internalSchemaString);
    }

    public boolean getSchemaEvolutionEnable() {
        return this.getBoolean(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE);
    }

    public void setSchemaEvolutionEnable(boolean enable) {
        this.setValue(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE, String.valueOf(enable));
    }

    public boolean shouldValidateAvroSchema() {
        return this.getBoolean(AVRO_SCHEMA_VALIDATE_ENABLE);
    }

    public boolean shouldAllowAutoEvolutionColumnDrop() {
        return this.getBooleanOrDefault(SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP);
    }

    public String getTableName() {
        return this.getString(TBL_NAME);
    }

    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf((String)this.getStringOrDefault(HoodieTableConfig.TYPE, ((HoodieTableType)HoodieTableConfig.TYPE.defaultValue()).name()).toUpperCase());
    }

    public String getPreCombineField() {
        return this.getString(PRECOMBINE_FIELD_NAME);
    }

    public String getKeyGeneratorClass() {
        return this.getString(KEYGENERATOR_CLASS_NAME);
    }

    public ExecutorType getExecutorType() {
        return ExecutorType.valueOf((String)this.getStringOrDefault(WRITE_EXECUTOR_TYPE).toUpperCase(Locale.ROOT));
    }

    public boolean isConsistentHashingEnabled() {
        return this.getIndexType() == HoodieIndex.IndexType.BUCKET && this.getBucketIndexEngineType() == HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING;
    }

    public boolean isSimpleBucketIndex() {
        return HoodieIndex.IndexType.BUCKET.equals((Object)this.getIndexType()) && HoodieIndex.BucketIndexEngineType.SIMPLE.equals((Object)this.getBucketIndexEngineType());
    }

    public boolean isYieldingPureLogForMor() {
        switch (this.getIndexType()) {
            case BUCKET: 
            case FLINK_STATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isConsistentLogicalTimestampEnabled() {
        return this.getBooleanOrDefault(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED);
    }

    public Boolean shouldAutoCommit() {
        return this.getBoolean(AUTO_COMMIT_ENABLE);
    }

    public boolean shouldUseExternalSchemaTransformation() {
        return this.getBoolean(AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE);
    }

    public Integer getTimelineLayoutVersion() {
        return this.getInt(TIMELINE_LAYOUT_VERSION_NUM);
    }

    public int getBulkInsertShuffleParallelism() {
        return this.getInt(BULKINSERT_PARALLELISM_VALUE);
    }

    public String getUserDefinedBulkInsertPartitionerClass() {
        return this.getString(BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME);
    }

    public String getUserDefinedBulkInsertPartitionerSortColumns() {
        return this.getString(BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS);
    }

    public int getInsertShuffleParallelism() {
        return this.getInt(INSERT_PARALLELISM_VALUE);
    }

    public int getUpsertShuffleParallelism() {
        return this.getInt(UPSERT_PARALLELISM_VALUE);
    }

    public int getDeleteShuffleParallelism() {
        return this.getInt(DELETE_PARALLELISM_VALUE);
    }

    public int getRollbackParallelism() {
        return this.getInt(ROLLBACK_PARALLELISM_VALUE);
    }

    public int getFileListingParallelism() {
        return this.metadataConfig.getFileListingParallelism();
    }

    public boolean shouldRollbackUsingMarkers() {
        return this.getBoolean(ROLLBACK_USING_MARKERS_ENABLE);
    }

    public int getWriteBufferLimitBytes() {
        return Integer.parseInt(this.getStringOrDefault(WRITE_BUFFER_LIMIT_BYTES_VALUE));
    }

    public int getWriteBufferRecordSamplingRate() {
        return Integer.parseInt(this.getStringOrDefault(WRITE_BUFFER_RECORD_SAMPLING_RATE));
    }

    public int getWriteBufferRecordCacheLimit() {
        return Integer.parseInt(this.getStringOrDefault(WRITE_BUFFER_RECORD_CACHE_LIMIT));
    }

    public String getWriteExecutorDisruptorWaitStrategy() {
        return this.getStringOrDefault(WRITE_EXECUTOR_DISRUPTOR_WAIT_STRATEGY);
    }

    public Integer getWriteExecutorDisruptorWriteBufferLimitBytes() {
        return Integer.parseInt(this.getStringOrDefault(WRITE_EXECUTOR_DISRUPTOR_BUFFER_LIMIT_BYTES));
    }

    public boolean shouldCombineBeforeInsert() {
        return this.getBoolean(COMBINE_BEFORE_INSERT);
    }

    public boolean shouldCombineBeforeUpsert() {
        return this.getBoolean(COMBINE_BEFORE_UPSERT);
    }

    public boolean shouldCombineBeforeDelete() {
        return this.getBoolean(COMBINE_BEFORE_DELETE);
    }

    public boolean shouldAllowMultiWriteOnSameInstant() {
        return this.getBoolean(ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE);
    }

    public boolean shouldDropPartitionColumns() {
        return this.getBoolean(HoodieTableConfig.DROP_PARTITION_COLUMNS);
    }

    public String getWriteStatusClassName() {
        return this.getString(WRITE_STATUS_CLASS_NAME);
    }

    public int getFinalizeWriteParallelism() {
        return this.getInt(FINALIZE_WRITE_PARALLELISM_VALUE);
    }

    public boolean isTimelineServerBasedInstantStateEnabled() {
        return this.getBoolean(INSTANT_STATE_TIMELINE_SERVER_BASED);
    }

    public int getTimelineServerBasedInstantStateForceRefreshRequestNumber() {
        return this.getInt(INSTANT_STATE_TIMELINE_SERVER_BASED_FORCE_REFRESH_REQUEST_NUMBER);
    }

    public MarkerType getMarkersType() {
        String markerType = this.getString(MARKERS_TYPE);
        return MarkerType.valueOf((String)markerType.toUpperCase());
    }

    public boolean isHiveStylePartitioningEnabled() {
        return this.getBooleanOrDefault(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE);
    }

    public int getMarkersTimelineServerBasedBatchNumThreads() {
        return this.getInt(MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS);
    }

    public long getMarkersTimelineServerBasedBatchIntervalMs() {
        return this.getLong(MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS);
    }

    public int getMarkersDeleteParallelism() {
        return this.getInt(MARKERS_DELETE_PARALLELISM_VALUE);
    }

    public boolean isEmbeddedTimelineServerEnabled() {
        return this.getBoolean(EMBEDDED_TIMELINE_SERVER_ENABLE);
    }

    public boolean isEmbeddedTimelineServerReuseEnabled() {
        return this.getBoolean(EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED);
    }

    public int getEmbeddedTimelineServerPort() {
        return Integer.parseInt(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_PORT_NUM));
    }

    public int getEmbeddedTimelineServerThreads() {
        return Integer.parseInt(this.getStringOrDefault(EMBEDDED_TIMELINE_NUM_SERVER_THREADS));
    }

    public boolean getEmbeddedTimelineServerCompressOutput() {
        return Boolean.parseBoolean(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_COMPRESS_ENABLE));
    }

    public boolean getEmbeddedTimelineServerUseAsync() {
        return Boolean.parseBoolean(this.getStringOrDefault(EMBEDDED_TIMELINE_SERVER_USE_ASYNC_ENABLE));
    }

    public boolean isFailOnTimelineArchivingEnabled() {
        return this.getBoolean(FAIL_ON_TIMELINE_ARCHIVING_ENABLE);
    }

    public boolean isFailOnInlineTableServiceExceptionEnabled() {
        return this.getBoolean(FAIL_ON_INLINE_TABLE_SERVICE_EXCEPTION);
    }

    public int getMaxConsistencyChecks() {
        return this.getInt(MAX_CONSISTENCY_CHECKS);
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return this.getInt(INITIAL_CONSISTENCY_CHECK_INTERVAL_MS);
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return this.getInt(MAX_CONSISTENCY_CHECK_INTERVAL_MS);
    }

    public BulkInsertSortMode getBulkInsertSortMode() {
        String sortMode = this.getStringOrDefault(BULK_INSERT_SORT_MODE);
        return BulkInsertSortMode.valueOf(sortMode.toUpperCase());
    }

    public boolean isMergeDataValidationCheckEnabled() {
        return this.getBoolean(MERGE_DATA_VALIDATION_CHECK_ENABLE);
    }

    public boolean allowDuplicateInserts() {
        return this.getBoolean(MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE);
    }

    public int getSmallFileGroupCandidatesLimit() {
        return this.getInt(MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT);
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    public boolean populateMetaFields() {
        return this.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
    }

    public boolean isLogCompactionEnabled() {
        return this.getBoolean(HoodieCompactionConfig.ENABLE_LOG_COMPACTION);
    }

    public int getLogCompactionBlocksThreshold() {
        return this.getInt(HoodieCompactionConfig.LOG_COMPACTION_BLOCKS_THRESHOLD);
    }

    public boolean enableOptimizedLogBlocksScan() {
        return this.getBoolean(HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN);
    }

    public HoodieCleaningPolicy getCleanerPolicy() {
        return HoodieCleaningPolicy.valueOf((String)this.getString(HoodieCleanConfig.CLEANER_POLICY));
    }

    public int getCleanerFileVersionsRetained() {
        return this.getInt(HoodieCleanConfig.CLEANER_FILE_VERSIONS_RETAINED);
    }

    public int getCleanerCommitsRetained() {
        return this.getInt(HoodieCleanConfig.CLEANER_COMMITS_RETAINED);
    }

    public int getCleanerHoursRetained() {
        return this.getInt(HoodieCleanConfig.CLEANER_HOURS_RETAINED);
    }

    public int getMaxCommitsToKeep() {
        return this.getInt(HoodieArchivalConfig.MAX_COMMITS_TO_KEEP);
    }

    public int getMinCommitsToKeep() {
        return this.getInt(HoodieArchivalConfig.MIN_COMMITS_TO_KEEP);
    }

    public int getTimelineCompactionBatchSize() {
        return this.getInt(HoodieArchivalConfig.TIMELINE_COMPACTION_BATCH_SIZE);
    }

    public int getParquetSmallFileLimit() {
        return this.getInt(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT);
    }

    public double getRecordSizeEstimationThreshold() {
        return this.getDouble(HoodieCompactionConfig.RECORD_SIZE_ESTIMATION_THRESHOLD);
    }

    public int getCopyOnWriteInsertSplitSize() {
        return this.getInt(HoodieCompactionConfig.COPY_ON_WRITE_INSERT_SPLIT_SIZE);
    }

    public int getCopyOnWriteRecordSizeEstimate() {
        return this.getInt(HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE);
    }

    public boolean allowMultipleCleans() {
        return this.getBoolean(HoodieCleanConfig.ALLOW_MULTIPLE_CLEANS);
    }

    public boolean shouldAutoTuneInsertSplits() {
        return this.getBoolean(HoodieCompactionConfig.COPY_ON_WRITE_AUTO_SPLIT_INSERTS);
    }

    public int getCleanerParallelism() {
        return this.getInt(HoodieCleanConfig.CLEANER_PARALLELISM_VALUE);
    }

    public int getCleaningMaxCommits() {
        return this.getInt(HoodieCleanConfig.CLEAN_MAX_COMMITS);
    }

    public CleaningTriggerStrategy getCleaningTriggerStrategy() {
        return CleaningTriggerStrategy.valueOf(this.getString(HoodieCleanConfig.CLEAN_TRIGGER_STRATEGY));
    }

    public boolean isAutoClean() {
        return this.getBoolean(HoodieCleanConfig.AUTO_CLEAN);
    }

    public boolean shouldArchiveBeyondSavepoint() {
        return this.getBooleanOrDefault(HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT);
    }

    public boolean isAutoArchive() {
        return this.getBoolean(HoodieArchivalConfig.AUTO_ARCHIVE);
    }

    public boolean isAsyncArchive() {
        return this.getBoolean(HoodieArchivalConfig.ASYNC_ARCHIVE);
    }

    public boolean isAsyncClean() {
        return this.getBoolean(HoodieCleanConfig.ASYNC_CLEAN);
    }

    public boolean incrementalCleanerModeEnabled() {
        return this.getBoolean(HoodieCleanConfig.CLEANER_INCREMENTAL_MODE_ENABLE);
    }

    public boolean inlineCompactionEnabled() {
        return this.getBoolean(HoodieCompactionConfig.INLINE_COMPACT);
    }

    public boolean scheduleInlineCompaction() {
        return this.getBoolean(HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT);
    }

    public boolean inlineLogCompactionEnabled() {
        return this.getBoolean(HoodieCompactionConfig.INLINE_LOG_COMPACT);
    }

    public CompactionTriggerStrategy getInlineCompactTriggerStrategy() {
        return CompactionTriggerStrategy.valueOf(this.getString(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY));
    }

    public int getInlineCompactDeltaCommitMax() {
        return this.getInt(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS);
    }

    public int getInlineCompactDeltaSecondsMax() {
        return this.getInt(HoodieCompactionConfig.INLINE_COMPACT_TIME_DELTA_SECONDS);
    }

    public CompactionStrategy getCompactionStrategy() {
        String compactionStrategiesStr = this.getString(HoodieCompactionConfig.COMPACTION_STRATEGY);
        String[] compactionStrategyArr = compactionStrategiesStr.split(",");
        List<CompactionStrategy> compactionStrategies = Arrays.stream(compactionStrategyArr).map(className -> (CompactionStrategy)ReflectionUtils.loadClass((String)className)).collect(Collectors.toList());
        return compactionStrategies.size() == 1 ? (CompactionStrategy)compactionStrategies.get(0) : new CompositeCompactionStrategy(compactionStrategies);
    }

    public Long getTargetIOPerCompactionInMB() {
        return this.getLong(HoodieCompactionConfig.TARGET_IO_PER_COMPACTION_IN_MB);
    }

    public Long getCompactionLogFileSizeThreshold() {
        return this.getLong(HoodieCompactionConfig.COMPACTION_LOG_FILE_SIZE_THRESHOLD);
    }

    public Long getCompactionLogFileNumThreshold() {
        return this.getLong(HoodieCompactionConfig.COMPACTION_LOG_FILE_NUM_THRESHOLD);
    }

    public Boolean getCompactionLazyBlockReadEnabled() {
        return this.getBoolean(HoodieReaderConfig.COMPACTION_LAZY_BLOCK_READ_ENABLE);
    }

    public Boolean getCompactionReverseLogReadEnabled() {
        return this.getBoolean(HoodieReaderConfig.COMPACTION_REVERSE_LOG_READ_ENABLE);
    }

    public int getArchiveDeleteParallelism() {
        return this.getInt(HoodieArchivalConfig.DELETE_ARCHIVED_INSTANT_PARALLELISM_VALUE);
    }

    public boolean inlineClusteringEnabled() {
        return this.getBoolean(HoodieClusteringConfig.INLINE_CLUSTERING);
    }

    public boolean scheduleInlineClustering() {
        return this.getBoolean(HoodieClusteringConfig.SCHEDULE_INLINE_CLUSTERING);
    }

    public boolean isAsyncClusteringEnabled() {
        return this.getBoolean(HoodieClusteringConfig.ASYNC_CLUSTERING_ENABLE);
    }

    public boolean isClusteringEnabled() {
        return this.inlineClusteringEnabled() || this.isAsyncClusteringEnabled();
    }

    public boolean isRollbackPendingClustering() {
        return this.getBoolean(HoodieClusteringConfig.ROLLBACK_PENDING_CLUSTERING_ON_CONFLICT);
    }

    public int getInlineClusterMaxCommits() {
        return this.getInt(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS);
    }

    public int getAsyncClusterMaxCommits() {
        return this.getInt(HoodieClusteringConfig.ASYNC_CLUSTERING_MAX_COMMITS);
    }

    public String getPayloadClass() {
        return HoodieRecordPayload.getPayloadClassName((HoodieConfig)this);
    }

    public int getTargetPartitionsPerDayBasedCompaction() {
        return this.getInt(HoodieCompactionConfig.TARGET_PARTITIONS_PER_DAYBASED_COMPACTION);
    }

    public int getCommitArchivalBatchSize() {
        return this.getInt(HoodieArchivalConfig.COMMITS_ARCHIVAL_BATCH_SIZE);
    }

    public Boolean shouldCleanBootstrapBaseFile() {
        return this.getBoolean(HoodieCleanConfig.CLEANER_BOOTSTRAP_BASE_FILE_ENABLE);
    }

    public String getClusteringUpdatesStrategyClass() {
        return this.getString(HoodieClusteringConfig.UPDATES_STRATEGY);
    }

    public HoodieFailedWritesCleaningPolicy getFailedWritesCleanPolicy() {
        return HoodieFailedWritesCleaningPolicy.valueOf((String)this.getString(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY));
    }

    public String getCompactionSpecifyPartitionPathRegex() {
        return this.getString(HoodieCompactionConfig.COMPACTION_SPECIFY_PARTITION_PATH_REGEX);
    }

    public String getClusteringPlanStrategyClass() {
        return this.getString(HoodieClusteringConfig.PLAN_STRATEGY_CLASS_NAME);
    }

    public int getClusteringMaxParallelism() {
        return this.getInt(HoodieClusteringConfig.CLUSTERING_MAX_PARALLELISM);
    }

    public ClusteringPlanPartitionFilterMode getClusteringPlanPartitionFilterMode() {
        String mode = this.getString(HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME);
        return ClusteringPlanPartitionFilterMode.valueOf(mode);
    }

    public String getBeginPartitionForClustering() {
        return this.getString(HoodieClusteringConfig.PARTITION_FILTER_BEGIN_PARTITION);
    }

    public String getEndPartitionForClustering() {
        return this.getString(HoodieClusteringConfig.PARTITION_FILTER_END_PARTITION);
    }

    public String getClusteringExecutionStrategyClass() {
        return this.getString(HoodieClusteringConfig.EXECUTION_STRATEGY_CLASS_NAME);
    }

    public long getClusteringMaxBytesInGroup() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_MAX_BYTES_PER_OUTPUT_FILEGROUP);
    }

    public long getClusteringSmallFileLimit() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_SMALL_FILE_LIMIT);
    }

    public String getClusteringPartitionSelected() {
        return this.getString(HoodieClusteringConfig.PARTITION_SELECTED);
    }

    public String getClusteringPartitionFilterRegexPattern() {
        return this.getString(HoodieClusteringConfig.PARTITION_REGEX_PATTERN);
    }

    public int getClusteringMaxNumGroups() {
        return this.getInt(HoodieClusteringConfig.PLAN_STRATEGY_MAX_GROUPS);
    }

    public long getClusteringTargetFileMaxBytes() {
        return this.getLong(HoodieClusteringConfig.PLAN_STRATEGY_TARGET_FILE_MAX_BYTES);
    }

    public int getTargetPartitionsForClustering() {
        return this.getInt(HoodieClusteringConfig.DAYBASED_LOOKBACK_PARTITIONS);
    }

    public int getSkipPartitionsFromLatestForClustering() {
        return this.getInt(HoodieClusteringConfig.PLAN_STRATEGY_SKIP_PARTITIONS_FROM_LATEST);
    }

    public boolean isSingleGroupClusteringEnabled() {
        return this.getBoolean(HoodieClusteringConfig.PLAN_STRATEGY_SINGLE_GROUP_CLUSTERING_ENABLED);
    }

    public boolean shouldClusteringSingleGroup() {
        return this.isClusteringSortEnabled() || this.isSingleGroupClusteringEnabled();
    }

    public String getClusteringSortColumns() {
        return this.getString(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS);
    }

    public boolean isClusteringSortEnabled() {
        return !StringUtils.isNullOrEmpty((String)this.getString(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS));
    }

    public HoodieClusteringConfig.LayoutOptimizationStrategy getLayoutOptimizationStrategy() {
        return HoodieClusteringConfig.resolveLayoutOptimizationStrategy(this.getStringOrDefault(HoodieClusteringConfig.LAYOUT_OPTIMIZE_STRATEGY));
    }

    public HoodieClusteringConfig.SpatialCurveCompositionStrategyType getLayoutOptimizationCurveBuildMethod() {
        return (HoodieClusteringConfig.SpatialCurveCompositionStrategyType)ConfigUtils.resolveEnum(HoodieClusteringConfig.SpatialCurveCompositionStrategyType.class, (String)this.getString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_SPATIAL_CURVE_BUILD_METHOD));
    }

    public int getLayoutOptimizationSampleSize() {
        return this.getInt(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE);
    }

    public int getClusteringGroupReadParallelism() {
        return this.getInt(HoodieClusteringConfig.CLUSTERING_GROUP_READ_PARALLELISM);
    }

    public HoodieIndex.IndexType getIndexType() {
        return HoodieIndex.IndexType.valueOf(this.getString(HoodieIndexConfig.INDEX_TYPE));
    }

    public String getIndexClass() {
        return this.getString(HoodieIndexConfig.INDEX_CLASS_NAME);
    }

    public HoodieIndex.BucketIndexEngineType getBucketIndexEngineType() {
        return HoodieIndex.BucketIndexEngineType.valueOf(this.getString(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE));
    }

    public int getBloomFilterNumEntries() {
        return this.getInt(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE);
    }

    public double getBloomFilterFPP() {
        return this.getDouble(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE);
    }

    public String getHbaseZkQuorum() {
        return this.getString(HoodieHBaseIndexConfig.ZKQUORUM);
    }

    public int getHbaseZkPort() {
        return this.getInt(HoodieHBaseIndexConfig.ZKPORT);
    }

    public String getHBaseZkZnodeParent() {
        return this.getString(HoodieHBaseIndexConfig.ZK_NODE_PATH);
    }

    public String getHbaseTableName() {
        return this.getString(HoodieHBaseIndexConfig.TABLENAME);
    }

    public int getHbaseIndexGetBatchSize() {
        return this.getInt(HoodieHBaseIndexConfig.GET_BATCH_SIZE);
    }

    public Boolean getHBaseIndexRollbackSync() {
        return this.getBoolean(HoodieHBaseIndexConfig.ROLLBACK_SYNC_ENABLE);
    }

    public int getHbaseIndexPutBatchSize() {
        return this.getInt(HoodieHBaseIndexConfig.PUT_BATCH_SIZE);
    }

    public boolean getHbaseIndexPutBatchSizeAutoCompute() {
        return this.getBooleanOrDefault(HoodieHBaseIndexConfig.PUT_BATCH_SIZE_AUTO_COMPUTE);
    }

    public String getHBaseQPSResourceAllocatorClass() {
        return this.getString(HoodieHBaseIndexConfig.QPS_ALLOCATOR_CLASS_NAME);
    }

    public String getHBaseQPSZKnodePath() {
        return this.getString(HoodieHBaseIndexConfig.ZKPATH_QPS_ROOT);
    }

    public String getHBaseZkZnodeSessionTimeout() {
        return this.getString(HoodieHBaseIndexConfig.ZK_SESSION_TIMEOUT_MS);
    }

    public String getHBaseZkZnodeConnectionTimeout() {
        return this.getString(HoodieHBaseIndexConfig.ZK_CONNECTION_TIMEOUT_MS);
    }

    public boolean getHBaseIndexShouldComputeQPSDynamically() {
        return this.getBoolean(HoodieHBaseIndexConfig.COMPUTE_QPS_DYNAMICALLY);
    }

    public String getHBaseIndexSecurityAuthentication() {
        return this.getString(HoodieHBaseIndexConfig.SECURITY_AUTHENTICATION);
    }

    public String getHBaseIndexKerberosUserKeytab() {
        return this.getString(HoodieHBaseIndexConfig.KERBEROS_USER_KEYTAB);
    }

    public String getHBaseIndexKerberosUserPrincipal() {
        return this.getString(HoodieHBaseIndexConfig.KERBEROS_USER_PRINCIPAL);
    }

    public String getHBaseIndexRegionserverPrincipal() {
        return this.getString(HoodieHBaseIndexConfig.REGIONSERVER_PRINCIPAL);
    }

    public String getHBaseIndexMasterPrincipal() {
        return this.getString(HoodieHBaseIndexConfig.MASTER_PRINCIPAL);
    }

    public int getHBaseIndexDesiredPutsTime() {
        return this.getInt(HoodieHBaseIndexConfig.DESIRED_PUTS_TIME_IN_SECONDS);
    }

    public String getBloomFilterType() {
        return this.getString(HoodieStorageConfig.BLOOM_FILTER_TYPE);
    }

    public int getDynamicBloomFilterMaxNumEntries() {
        return this.getInt(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES);
    }

    public float getHbaseIndexQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.QPS_FRACTION).floatValue();
    }

    public float getHBaseIndexMinQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.MIN_QPS_FRACTION).floatValue();
    }

    public float getHBaseIndexMaxQPSFraction() {
        return this.getFloat(HoodieHBaseIndexConfig.MAX_QPS_FRACTION).floatValue();
    }

    public int getHbaseIndexMaxQPSPerRegionServer() {
        return this.getInt(HoodieHBaseIndexConfig.MAX_QPS_PER_REGION_SERVER);
    }

    public boolean getHbaseIndexUpdatePartitionPath() {
        return this.getBooleanOrDefault(HoodieHBaseIndexConfig.UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getHBaseIndexRegionCount() {
        return this.getInt(HoodieHBaseIndexConfig.BUCKET_NUMBER);
    }

    public int getBloomIndexParallelism() {
        return this.getInt(HoodieIndexConfig.BLOOM_INDEX_PARALLELISM);
    }

    public boolean getBloomIndexPruneByRanges() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_PRUNE_BY_RANGES);
    }

    public boolean getBloomIndexUseCaching() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_USE_CACHING);
    }

    public boolean getBloomIndexUseMetadata() {
        return this.getBooleanOrDefault(HoodieIndexConfig.BLOOM_INDEX_USE_METADATA);
    }

    public boolean useBloomIndexTreebasedFilter() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_TREE_BASED_FILTER);
    }

    public boolean useBloomIndexBucketizedChecking() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_BUCKETIZED_CHECKING);
    }

    public boolean isMetadataBloomFilterIndexEnabled() {
        return this.isMetadataTableEnabled() && this.getMetadataConfig().isBloomFilterIndexEnabled();
    }

    public boolean isMetadataColumnStatsIndexEnabled() {
        return this.isMetadataTableEnabled() && this.getMetadataConfig().isColumnStatsIndexEnabled();
    }

    public boolean isPartitionStatsIndexEnabled() {
        return this.isMetadataTableEnabled() && this.getMetadataConfig().isPartitionStatsIndexEnabled();
    }

    public int getPartitionStatsIndexParallelism() {
        return this.metadataConfig.getPartitionStatsIndexParallelism();
    }

    public List<String> getColumnsEnabledForBloomFilterIndex() {
        return this.getMetadataConfig().getColumnsEnabledForBloomFilterIndex();
    }

    public int getIndexingCheckTimeoutSeconds() {
        return this.getMetadataConfig().getIndexingCheckTimeoutSeconds();
    }

    public int getMetadataBloomFilterIndexParallelism() {
        return this.metadataConfig.getBloomFilterIndexParallelism();
    }

    public int getColumnStatsIndexParallelism() {
        return this.metadataConfig.getColumnStatsIndexParallelism();
    }

    public int getBloomIndexKeysPerBucket() {
        return this.getInt(HoodieIndexConfig.BLOOM_INDEX_KEYS_PER_BUCKET);
    }

    public boolean getGlobalBloomIndexUpdatePartitionPath() {
        return this.getBoolean(HoodieIndexConfig.BLOOM_INDEX_UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getSimpleIndexParallelism() {
        return this.getInt(HoodieIndexConfig.SIMPLE_INDEX_PARALLELISM);
    }

    public boolean getSimpleIndexUseCaching() {
        return this.getBoolean(HoodieIndexConfig.SIMPLE_INDEX_USE_CACHING);
    }

    public int getGlobalSimpleIndexParallelism() {
        return this.getInt(HoodieIndexConfig.GLOBAL_SIMPLE_INDEX_PARALLELISM);
    }

    public boolean getGlobalSimpleIndexUpdatePartitionPath() {
        return this.getBoolean(HoodieIndexConfig.SIMPLE_INDEX_UPDATE_PARTITION_PATH_ENABLE);
    }

    public int getGlobalIndexReconcileParallelism() {
        return this.getInt(HoodieIndexConfig.GLOBAL_INDEX_RECONCILE_PARALLELISM);
    }

    public int getBucketIndexNumBuckets() {
        return this.getIntOrDefault(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS);
    }

    public int getBucketIndexMaxNumBuckets() {
        return this.getInt(HoodieIndexConfig.BUCKET_INDEX_MAX_NUM_BUCKETS);
    }

    public int getBucketIndexMinNumBuckets() {
        return this.getInt(HoodieIndexConfig.BUCKET_INDEX_MIN_NUM_BUCKETS);
    }

    public double getBucketSplitThreshold() {
        return this.getDouble(HoodieIndexConfig.BUCKET_SPLIT_THRESHOLD);
    }

    public double getBucketMergeThreshold() {
        return this.getDouble(HoodieIndexConfig.BUCKET_MERGE_THRESHOLD);
    }

    public String getBucketIndexHashField() {
        return this.getString(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD);
    }

    public String getBucketIndexHashFieldWithDefault() {
        return this.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD, this.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME));
    }

    public boolean getRecordIndexUseCaching() {
        return this.getBoolean(HoodieIndexConfig.RECORD_INDEX_USE_CACHING);
    }

    public boolean getRecordIndexUpdatePartitionPath() {
        return this.getBoolean(HoodieIndexConfig.RECORD_INDEX_UPDATE_PARTITION_PATH_ENABLE);
    }

    public long getMaxFileSize(HoodieFileFormat format) {
        switch (format) {
            case PARQUET: {
                return this.getParquetMaxFileSize();
            }
            case HFILE: {
                return this.getHFileMaxFileSize();
            }
            case ORC: {
                return this.getOrcMaxFileSize();
            }
        }
        throw new HoodieNotSupportedException("Unknown file format: " + format);
    }

    public long getParquetMaxFileSize() {
        return this.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE);
    }

    public int getParquetBlockSize() {
        return this.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE);
    }

    public int getParquetPageSize() {
        return this.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE);
    }

    public long getLogFileDataBlockMaxSize() {
        return this.getLong(HoodieStorageConfig.LOGFILE_DATA_BLOCK_MAX_SIZE);
    }

    public boolean shouldWriteRecordPositions() {
        return this.getBoolean(WRITE_RECORD_POSITIONS);
    }

    public boolean shouldWritePartialUpdates() {
        return !StringUtils.isNullOrEmpty((String)this.getString(WRITE_PARTIAL_UPDATE_SCHEMA));
    }

    public String getPartialUpdateSchema() {
        return this.getString(WRITE_PARTIAL_UPDATE_SCHEMA);
    }

    public double getParquetCompressionRatio() {
        return this.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION);
    }

    public String getParquetCompressionCodec() {
        return this.getString(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
    }

    public boolean parquetDictionaryEnabled() {
        return this.getBoolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED);
    }

    public String parquetOutputTimestampType() {
        return this.getString(HoodieStorageConfig.PARQUET_OUTPUT_TIMESTAMP_TYPE);
    }

    public String parquetFieldIdWriteEnabled() {
        return this.getString(HoodieStorageConfig.PARQUET_FIELD_ID_WRITE_ENABLED);
    }

    public boolean parquetBloomFilterEnabled() {
        return this.getBooleanOrDefault(HoodieStorageConfig.PARQUET_WITH_BLOOM_FILTER_ENABLED);
    }

    public Option<HoodieLogBlock.HoodieLogBlockType> getLogDataBlockFormat() {
        return Option.ofNullable((Object)this.getString(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT)).map(HoodieLogBlock.HoodieLogBlockType::fromId);
    }

    public long getLogFileMaxSize() {
        return this.getLong(HoodieStorageConfig.LOGFILE_MAX_SIZE);
    }

    public double getLogFileToParquetCompressionRatio() {
        return this.getDouble(HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION);
    }

    public long getHFileMaxFileSize() {
        return this.getLong(HoodieStorageConfig.HFILE_MAX_FILE_SIZE);
    }

    public int getHFileBlockSize() {
        return this.getInt(HoodieStorageConfig.HFILE_BLOCK_SIZE);
    }

    public String getHFileCompressionAlgorithm() {
        return this.getString(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME);
    }

    public long getOrcMaxFileSize() {
        return this.getLong(HoodieStorageConfig.ORC_FILE_MAX_SIZE);
    }

    public int getOrcStripeSize() {
        return this.getInt(HoodieStorageConfig.ORC_STRIPE_SIZE);
    }

    public int getOrcBlockSize() {
        return this.getInt(HoodieStorageConfig.ORC_BLOCK_SIZE);
    }

    public CompressionKind getOrcCompressionCodec() {
        return CompressionKind.valueOf((String)this.getString(HoodieStorageConfig.ORC_COMPRESSION_CODEC_NAME));
    }

    public boolean isMetricsOn() {
        return this.metricsConfig.isMetricsOn();
    }

    public boolean isCompactionLogBlockMetricsOn() {
        return this.metricsConfig.isCompactionLogBlockMetricsOn();
    }

    public boolean isExecutorMetricsEnabled() {
        return this.metricsConfig.isExecutorMetricsEnabled();
    }

    public boolean isLockingMetricsEnabled() {
        return this.metricsConfig.isLockingMetricsEnabled();
    }

    public MetricsReporterType getMetricsReporterType() {
        return this.metricsConfig.getMetricsReporterType();
    }

    public String getGraphiteServerHost() {
        return this.metricsConfig.getGraphiteServerHost();
    }

    public int getGraphiteServerPort() {
        return this.metricsConfig.getGraphiteServerPort();
    }

    public String getGraphiteMetricPrefix() {
        return this.metricsConfig.getGraphiteMetricPrefix();
    }

    public int getGraphiteReportPeriodSeconds() {
        return this.metricsConfig.getGraphiteReportPeriodSeconds();
    }

    public String getM3ServerHost() {
        return this.metricsConfig.getM3ServerHost();
    }

    public int getM3ServerPort() {
        return this.metricsConfig.getM3ServerPort();
    }

    public String getM3Tags() {
        return this.metricsConfig.getM3Tags();
    }

    public String getM3Env() {
        return this.metricsConfig.getM3Env();
    }

    public String getM3Service() {
        return this.metricsConfig.getM3Service();
    }

    public String getJmxHost() {
        return this.metricsConfig.getJmxHost();
    }

    public String getJmxPort() {
        return this.metricsConfig.getJmxPort();
    }

    public int getDatadogReportPeriodSeconds() {
        return this.metricsConfig.getDatadogReportPeriodSeconds();
    }

    public DatadogHttpClient.ApiSite getDatadogApiSite() {
        return this.metricsConfig.getDatadogApiSite();
    }

    public String getDatadogApiKey() {
        return this.metricsConfig.getDatadogApiKey();
    }

    public boolean getDatadogApiKeySkipValidation() {
        return this.metricsConfig.getDatadogApiKeySkipValidation();
    }

    public int getDatadogApiTimeoutSeconds() {
        return this.metricsConfig.getDatadogApiTimeoutSeconds();
    }

    public String getDatadogMetricPrefix() {
        return this.metricsConfig.getDatadogMetricPrefix();
    }

    public String getDatadogMetricHost() {
        return this.metricsConfig.getDatadogMetricHost();
    }

    public List<String> getDatadogMetricTags() {
        return this.metricsConfig.getDatadogMetricTags();
    }

    public int getCloudWatchReportPeriodSeconds() {
        return this.metricsConfig.getCloudWatchReportPeriodSeconds();
    }

    public String getCloudWatchMetricPrefix() {
        return this.metricsConfig.getCloudWatchMetricPrefix();
    }

    public String getCloudWatchMetricNamespace() {
        return this.metricsConfig.getCloudWatchMetricNamespace();
    }

    public int getCloudWatchMaxDatumsPerRequest() {
        return this.metricsConfig.getCloudWatchMaxDatumsPerRequest();
    }

    public String getMetricReporterClassName() {
        return this.metricsConfig.getMetricReporterClassName();
    }

    public int getPrometheusPort() {
        return this.metricsConfig.getPrometheusPort();
    }

    public String getPushGatewayHost() {
        return this.metricsConfig.getPushGatewayHost();
    }

    public int getPushGatewayPort() {
        return this.metricsConfig.getPushGatewayPort();
    }

    public int getPushGatewayReportPeriodSeconds() {
        return this.metricsConfig.getPushGatewayReportPeriodSeconds();
    }

    public boolean getPushGatewayDeleteOnShutdown() {
        return this.metricsConfig.getPushGatewayDeleteOnShutdown();
    }

    public String getPushGatewayJobName() {
        return this.metricsConfig.getPushGatewayJobName();
    }

    public String getPushGatewayLabels() {
        return this.metricsConfig.getPushGatewayLabels();
    }

    public boolean getPushGatewayRandomJobNameSuffix() {
        return this.metricsConfig.getPushGatewayRandomJobNameSuffix();
    }

    public String getMetricReporterMetricsNamePrefix() {
        return this.metricsConfig.getMetricReporterMetricsNamePrefix();
    }

    public String getMetricReporterFileBasedConfigs() {
        return this.metricsConfig.getMetricReporterFileBasedConfigs();
    }

    public int getMaxDFSStreamBufferSize() {
        return this.getInt(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE);
    }

    public String getSpillableMapBasePath() {
        return (String)Option.ofNullable((Object)this.getString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH)).orElseGet(FileIOUtils::getDefaultSpillableMapBasePath);
    }

    public double getWriteStatusFailureFraction() {
        return this.getDouble(HoodieMemoryConfig.WRITESTATUS_FAILURE_FRACTION);
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public FileSystemRetryConfig getFileSystemRetryConfig() {
        return this.fileSystemRetryConfig;
    }

    public void setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
        this.consistencyGuardConfig = consistencyGuardConfig;
    }

    public FileSystemViewStorageConfig getViewStorageConfig() {
        return this.viewStorageConfig;
    }

    public void setViewStorageConfig(FileSystemViewStorageConfig viewStorageConfig) {
        this.viewStorageConfig = viewStorageConfig;
    }

    public void resetViewStorageConfig() {
        this.setViewStorageConfig(this.getClientSpecifiedViewStorageConfig());
    }

    public FileSystemViewStorageConfig getClientSpecifiedViewStorageConfig() {
        return this.clientSpecifiedViewStorageConfig;
    }

    public HoodiePayloadConfig getPayloadConfig() {
        return this.hoodiePayloadConfig;
    }

    public HoodieMetadataConfig getMetadataConfig() {
        return this.metadataConfig;
    }

    public HoodieMetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    public HoodieTableServiceManagerConfig getTableServiceManagerConfig() {
        return this.tableServiceManagerConfig;
    }

    public HoodieCommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public HoodieStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public HoodieTimeGeneratorConfig getTimeGeneratorConfig() {
        return this.timeGeneratorConfig;
    }

    public HoodieIndexingConfig getIndexingConfig() {
        return this.indexingConfig;
    }

    public boolean writeCommitCallbackOn() {
        return this.getBoolean(HoodieWriteCommitCallbackConfig.TURN_CALLBACK_ON);
    }

    public String getCallbackClass() {
        return this.getString(HoodieWriteCommitCallbackConfig.CALLBACK_CLASS_NAME);
    }

    public String getBootstrapSourceBasePath() {
        return this.getString(HoodieBootstrapConfig.BASE_PATH);
    }

    public String getBootstrapModeSelectorClass() {
        return this.getString(HoodieBootstrapConfig.MODE_SELECTOR_CLASS_NAME);
    }

    public String getFullBootstrapInputProvider() {
        return this.getString(HoodieBootstrapConfig.FULL_BOOTSTRAP_INPUT_PROVIDER_CLASS_NAME);
    }

    public String getBootstrapModeSelectorRegex() {
        return this.getString(HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_PATTERN);
    }

    public BootstrapMode getBootstrapModeForRegexMatch() {
        return BootstrapMode.valueOf(this.getString(HoodieBootstrapConfig.PARTITION_SELECTOR_REGEX_MODE));
    }

    public String getBootstrapPartitionPathTranslatorClass() {
        return this.getString(HoodieBootstrapConfig.PARTITION_PATH_TRANSLATOR_CLASS_NAME);
    }

    public int getBootstrapParallelism() {
        return this.getInt(HoodieBootstrapConfig.PARALLELISM_VALUE);
    }

    public Long getMaxMemoryPerPartitionMerge() {
        return this.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE);
    }

    public Long getHoodieClientHeartbeatIntervalInMs() {
        return this.getLong(CLIENT_HEARTBEAT_INTERVAL_IN_MS);
    }

    public Integer getHoodieClientHeartbeatTolerableMisses() {
        return this.getInt(CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES);
    }

    public boolean isMetadataTableEnabled() {
        return this.getBooleanOrDefault(HoodieMetadataConfig.ENABLE);
    }

    public int getMetadataCompactDeltaCommitMax() {
        return this.getInt(HoodieMetadataConfig.COMPACT_NUM_DELTA_COMMITS);
    }

    public boolean isMetadataAsyncIndex() {
        return this.getBooleanOrDefault(HoodieMetadataConfig.ASYNC_INDEX_ENABLE);
    }

    public int getMetadataLogCompactBlocksThreshold() {
        return this.getInt(HoodieMetadataConfig.LOG_COMPACT_BLOCKS_THRESHOLD);
    }

    public boolean isLogCompactionEnabledOnMetadata() {
        return this.getBoolean(HoodieMetadataConfig.ENABLE_LOG_COMPACTION_ON_METADATA_TABLE);
    }

    public boolean isRecordIndexEnabled() {
        return this.metadataConfig.isRecordIndexEnabled();
    }

    public int getRecordIndexMinFileGroupCount() {
        return this.metadataConfig.getRecordIndexMinFileGroupCount();
    }

    public int getRecordIndexMaxFileGroupCount() {
        return this.metadataConfig.getRecordIndexMaxFileGroupCount();
    }

    public float getRecordIndexGrowthFactor() {
        return this.metadataConfig.getRecordIndexGrowthFactor();
    }

    public int getRecordIndexMaxFileGroupSizeBytes() {
        return this.metadataConfig.getRecordIndexMaxFileGroupSizeBytes();
    }

    public boolean isAutoAdjustLockConfigs() {
        return this.getBooleanOrDefault(AUTO_ADJUST_LOCK_CONFIGS);
    }

    public String getLockProviderClass() {
        return this.getString(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME);
    }

    public String getLockHiveDatabaseName() {
        return this.getString(HoodieLockConfig.HIVE_DATABASE_NAME);
    }

    public String getLockHiveTableName() {
        return this.getString(HoodieLockConfig.HIVE_TABLE_NAME);
    }

    public ConflictResolutionStrategy getWriteConflictResolutionStrategy() {
        return (ConflictResolutionStrategy)ReflectionUtils.loadClass((String)this.getString(HoodieLockConfig.WRITE_CONFLICT_RESOLUTION_STRATEGY_CLASS_NAME));
    }

    public Long getAsyncConflictDetectorInitialDelayMs() {
        return this.getLong(ASYNC_CONFLICT_DETECTOR_INITIAL_DELAY_MS);
    }

    public Long getAsyncConflictDetectorPeriodMs() {
        return this.getLong(ASYNC_CONFLICT_DETECTOR_PERIOD_MS);
    }

    public Long getLockAcquireWaitTimeoutInMs() {
        return this.getLong(HoodieLockConfig.LOCK_ACQUIRE_WAIT_TIMEOUT_MS);
    }

    public WriteConcurrencyMode getWriteConcurrencyMode() {
        return WriteConcurrencyMode.valueOf((String)this.getStringOrDefault(WRITE_CONCURRENCY_MODE).toUpperCase());
    }

    public boolean isEarlyConflictDetectionEnable() {
        return this.getBoolean(EARLY_CONFLICT_DETECTION_ENABLE);
    }

    public String getEarlyConflictDetectionStrategyClassName() {
        return this.getString(EARLY_CONFLICT_DETECTION_STRATEGY_CLASS_NAME);
    }

    public boolean earlyConflictDetectionCheckCommitConflict() {
        return this.getBoolean(EARLY_CONFLICT_DETECTION_CHECK_COMMIT_CONFLICT);
    }

    public Boolean doSkipDefaultPartitionValidation() {
        return this.getBoolean(SKIP_DEFAULT_PARTITION_VALIDATION);
    }

    public Boolean areAnyTableServicesExecutedInline() {
        return this.areTableServicesEnabled() && (this.inlineClusteringEnabled() || this.inlineCompactionEnabled() || this.inlineLogCompactionEnabled() || this.isAutoClean() && !this.isAsyncClean() || this.isAutoArchive() && !this.isAsyncArchive());
    }

    public Boolean areAnyTableServicesAsync() {
        return this.areTableServicesEnabled() && (this.isAsyncClusteringEnabled() || this.getTableType() == HoodieTableType.MERGE_ON_READ && !this.inlineCompactionEnabled() || this.isAutoClean() && this.isAsyncClean() || this.isAutoArchive() && this.isAsyncArchive());
    }

    public Boolean areAnyTableServicesScheduledInline() {
        return this.scheduleInlineCompaction() || this.scheduleInlineClustering();
    }

    public String getPreCommitValidators() {
        return this.getString(HoodiePreCommitValidatorConfig.VALIDATOR_CLASS_NAMES);
    }

    public String getPreCommitValidatorEqualitySqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.EQUALITY_SQL_QUERIES);
    }

    public String getPreCommitValidatorSingleResultSqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.SINGLE_VALUE_SQL_QUERIES);
    }

    public String getPreCommitValidatorInequalitySqlQueries() {
        return this.getString(HoodiePreCommitValidatorConfig.INEQUALITY_SQL_QUERIES);
    }

    public boolean allowEmptyCommit() {
        return this.getBooleanOrDefault(ALLOW_EMPTY_COMMIT);
    }

    public boolean allowOperationMetadataField() {
        return this.getBooleanOrDefault(ALLOW_OPERATION_METADATA_FIELD);
    }

    public String getFileIdPrefixProviderClassName() {
        return this.getString(FILEID_PREFIX_PROVIDER_CLASS);
    }

    public boolean areTableServicesEnabled() {
        return this.getBooleanOrDefault(TABLE_SERVICES_ENABLED);
    }

    public boolean areReleaseResourceEnabled() {
        return this.getBooleanOrDefault(RELEASE_RESOURCE_ENABLE);
    }

    public boolean isLockRequired() {
        return !this.isDefaultLockProvider() || this.getWriteConcurrencyMode().supportsMultiWriter();
    }

    private boolean isDefaultLockProvider() {
        return ((String)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.defaultValue()).equals(this.getLockProviderClass());
    }

    public HoodieStorageLayout.LayoutType getLayoutType() {
        return HoodieStorageLayout.LayoutType.valueOf(this.getString(HoodieLayoutConfig.LAYOUT_TYPE));
    }

    public boolean isMetaserverEnabled() {
        return this.metaserverConfig.isMetaserverEnabled();
    }

    public boolean shouldBackupRollbacks() {
        return this.getBoolean(ROLLBACK_INSTANT_BACKUP_ENABLED);
    }

    public String getRollbackBackupDirectory() {
        return this.getString(ROLLBACK_INSTANT_BACKUP_DIRECTORY);
    }

    public String getClientInitCallbackClassNames() {
        return this.getString(CLIENT_INIT_CALLBACK_CLASS_NAMES);
    }

    public Integer getWritesFileIdEncoding() {
        return this.props.getInteger(WRITES_FILEID_ENCODING, 0);
    }

    public boolean needResolveWriteConflict(WriteOperationType operationType) {
        WriteConcurrencyMode mode = this.getWriteConcurrencyMode();
        switch (mode) {
            case SINGLE_WRITER: {
                return false;
            }
            case OPTIMISTIC_CONCURRENCY_CONTROL: {
                return true;
            }
            case NON_BLOCKING_CONCURRENCY_CONTROL: {
                return WriteOperationType.BULK_INSERT == operationType;
            }
        }
        throw new IllegalArgumentException("Invalid WriteConcurrencyMode " + mode);
    }

    public boolean isNonBlockingConcurrencyControl() {
        return this.getWriteConcurrencyMode().isNonBlockingConcurrencyControl();
    }

    public boolean isInlinePartitionTTLEnable() {
        return this.getBoolean(HoodieTTLConfig.INLINE_PARTITION_TTL);
    }

    public String getPartitionTTLStrategyClassName() {
        return this.getString(HoodieTTLConfig.PARTITION_TTL_STRATEGY_CLASS_NAME);
    }

    public Integer getPartitionTTLStrategyDaysRetain() {
        return this.getInt(HoodieTTLConfig.DAYS_RETAIN);
    }

    public String getPartitionTTLPartitionSelected() {
        return this.getString(HoodieTTLConfig.PARTITION_SELECTED);
    }

    public Integer getPartitionTTLMaxPartitionsToDelete() {
        return this.getInt(HoodieTTLConfig.MAX_PARTITION_TO_DELETE);
    }

    public boolean isSecondaryIndexEnabled() {
        return this.metadataConfig.isSecondaryIndexEnabled();
    }

    public int getSecondaryIndexParallelism() {
        return this.metadataConfig.getSecondaryIndexParallelism();
    }

    public static class Builder {
        protected final HoodieWriteConfig writeConfig = new HoodieWriteConfig();
        protected EngineType engineType = EngineType.SPARK;
        private boolean isIndexConfigSet = false;
        private boolean isStorageConfigSet = false;
        private boolean isCompactionConfigSet = false;
        private boolean isCleanConfigSet = false;
        private boolean isArchivalConfigSet = false;
        private boolean isClusteringConfigSet = false;
        private boolean isOptimizeConfigSet = false;
        private boolean isMetricsConfigSet = false;
        private boolean isBootstrapConfigSet = false;
        private boolean isMemoryConfigSet = false;
        private boolean isViewConfigSet = false;
        private boolean isConsistencyGuardSet = false;
        private boolean isCallbackConfigSet = false;
        private boolean isPayloadConfigSet = false;
        private boolean isMetadataConfigSet = false;
        private boolean isTTLConfigSet = false;
        private boolean isLockConfigSet = false;
        private boolean isPreCommitValidationConfigSet = false;
        private boolean isMetricsJmxConfigSet = false;
        private boolean isMetricsGraphiteConfigSet = false;
        private boolean isMetricsM3ConfigSet = false;
        private boolean isLayoutConfigSet = false;

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.writeConfig.getProps().load((Reader)reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromInputStream(InputStream inputStream) throws IOException {
            try {
                this.writeConfig.getProps().load(inputStream);
                Builder builder = this;
                return builder;
            }
            finally {
                inputStream.close();
            }
        }

        public Builder withProps(Map kvprops) {
            this.writeConfig.getProps().putAll(kvprops);
            return this;
        }

        public Builder withPath(String basePath) {
            this.writeConfig.setValue(BASE_PATH, basePath);
            return this;
        }

        public Builder withPath(StoragePath basePath) {
            this.writeConfig.setValue(BASE_PATH, basePath.toString());
            return this;
        }

        public Builder withBaseFileFormat(String baseFileFormat) {
            this.writeConfig.setValue(BASE_FILE_FORMAT, HoodieFileFormat.valueOf((String)baseFileFormat).name());
            return this;
        }

        public Builder withSchema(String schemaStr) {
            this.writeConfig.setValue(AVRO_SCHEMA_STRING, schemaStr);
            return this;
        }

        public Builder withSchemaEvolutionEnable(boolean enable) {
            this.writeConfig.setValue(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withWriteTableVersion(int writeVersion) {
            HoodieTableVersion tableVersion = HoodieTableVersion.fromVersionCode((int)writeVersion);
            this.writeConfig.setValue(WRITE_TABLE_VERSION, String.valueOf(tableVersion.versionCode()));
            return this.withTimelineLayoutVersion(tableVersion.getTimelineLayoutVersion().getVersion());
        }

        public Builder withAutoUpgradeVersion(boolean enable) {
            this.writeConfig.setValue(AUTO_UPGRADE_VERSION, String.valueOf(enable));
            return this;
        }

        public Builder withAvroSchemaValidate(boolean enable) {
            this.writeConfig.setValue(AVRO_SCHEMA_VALIDATE_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withAllowAutoEvolutionColumnDrop(boolean shouldAllowDroppedColumns) {
            this.writeConfig.setValue(SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP, String.valueOf(shouldAllowDroppedColumns));
            return this;
        }

        public Builder forTable(String tableName) {
            this.writeConfig.setValue(TBL_NAME, tableName);
            return this;
        }

        public Builder withPreCombineField(String preCombineField) {
            this.writeConfig.setValue(PRECOMBINE_FIELD_NAME, preCombineField);
            return this;
        }

        public Builder withWritePayLoad(String payload) {
            this.writeConfig.setValue(WRITE_PAYLOAD_CLASS_NAME, payload);
            return this;
        }

        public Builder withRecordMergeImplClasses(String recordMergeImplClasses) {
            if (!StringUtils.isNullOrEmpty((String)recordMergeImplClasses)) {
                this.writeConfig.setValue(RECORD_MERGE_IMPL_CLASSES, recordMergeImplClasses);
            }
            return this;
        }

        public Builder withRecordMergeStrategyId(String recordMergeStrategyId) {
            this.writeConfig.setValue(RECORD_MERGE_STRATEGY_ID, recordMergeStrategyId);
            return this;
        }

        public Builder withKeyGenerator(String keyGeneratorClass) {
            this.writeConfig.setValue(KEYGENERATOR_CLASS_NAME, keyGeneratorClass);
            return this;
        }

        public Builder withExecutorType(String executorClass) {
            this.writeConfig.setValue(WRITE_EXECUTOR_TYPE, executorClass);
            return this;
        }

        public Builder withTimelineLayoutVersion(int version) {
            this.writeConfig.setValue(TIMELINE_LAYOUT_VERSION_NUM, String.valueOf(version));
            return this;
        }

        public Builder withBulkInsertParallelism(int bulkInsertParallelism) {
            this.writeConfig.setValue(BULKINSERT_PARALLELISM_VALUE, String.valueOf(bulkInsertParallelism));
            return this;
        }

        public Builder withUserDefinedBulkInsertPartitionerClass(String className) {
            this.writeConfig.setValue(BULKINSERT_USER_DEFINED_PARTITIONER_CLASS_NAME, className);
            return this;
        }

        public Builder withUserDefinedBulkInsertPartitionerSortColumns(String columns) {
            this.writeConfig.setValue(BULKINSERT_USER_DEFINED_PARTITIONER_SORT_COLUMNS, columns);
            return this;
        }

        public Builder withDeleteParallelism(int parallelism) {
            this.writeConfig.setValue(DELETE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withFailureOnInlineTableServiceException(boolean fail) {
            this.writeConfig.setValue(FAIL_ON_INLINE_TABLE_SERVICE_EXCEPTION, String.valueOf(fail));
            return this;
        }

        public Builder withParallelism(int insertShuffleParallelism, int upsertShuffleParallelism) {
            this.writeConfig.setValue(INSERT_PARALLELISM_VALUE, String.valueOf(insertShuffleParallelism));
            this.writeConfig.setValue(UPSERT_PARALLELISM_VALUE, String.valueOf(upsertShuffleParallelism));
            return this;
        }

        public Builder withRollbackParallelism(int rollbackParallelism) {
            this.writeConfig.setValue(ROLLBACK_PARALLELISM_VALUE, String.valueOf(rollbackParallelism));
            return this;
        }

        public Builder withRollbackUsingMarkers(boolean rollbackUsingMarkers) {
            this.writeConfig.setValue(ROLLBACK_USING_MARKERS_ENABLE, String.valueOf(rollbackUsingMarkers));
            return this;
        }

        public Builder withWriteBufferLimitBytes(int writeBufferLimit) {
            this.writeConfig.setValue(WRITE_BUFFER_LIMIT_BYTES_VALUE, String.valueOf(writeBufferLimit));
            return this;
        }

        public Builder withWriteBufferRecordSamplingRate(int recordSamplingRate) {
            this.writeConfig.setValue(WRITE_BUFFER_RECORD_SAMPLING_RATE, String.valueOf(recordSamplingRate));
            return this;
        }

        public Builder withWriteBufferRecordCacheLimit(int recordCacheLimit) {
            this.writeConfig.setValue(WRITE_BUFFER_RECORD_CACHE_LIMIT, String.valueOf(recordCacheLimit));
            return this;
        }

        public Builder withWriteExecutorDisruptorWaitStrategy(String waitStrategy) {
            this.writeConfig.setValue(WRITE_EXECUTOR_DISRUPTOR_WAIT_STRATEGY, String.valueOf(waitStrategy));
            return this;
        }

        public Builder withWriteExecutorDisruptorWriteBufferLimitBytes(long size) {
            this.writeConfig.setValue(WRITE_EXECUTOR_DISRUPTOR_BUFFER_LIMIT_BYTES, String.valueOf(size));
            return this;
        }

        public Builder combineInput(boolean onInsert, boolean onUpsert) {
            this.writeConfig.setValue(COMBINE_BEFORE_INSERT, String.valueOf(onInsert));
            this.writeConfig.setValue(COMBINE_BEFORE_UPSERT, String.valueOf(onUpsert));
            return this;
        }

        public Builder combineDeleteInput(boolean onDelete) {
            this.writeConfig.setValue(COMBINE_BEFORE_DELETE, String.valueOf(onDelete));
            return this;
        }

        public Builder withWriteStatusStorageLevel(String level) {
            this.writeConfig.setValue(WRITE_STATUS_STORAGE_LEVEL_VALUE, level);
            return this;
        }

        public Builder withIndexConfig(HoodieIndexConfig indexConfig) {
            this.writeConfig.getProps().putAll((Map)indexConfig.getProps());
            this.isIndexConfigSet = true;
            return this;
        }

        public Builder withStorageConfig(HoodieStorageConfig storageConfig) {
            this.writeConfig.getProps().putAll((Map)storageConfig.getProps());
            this.isStorageConfigSet = true;
            return this;
        }

        public Builder withCompactionConfig(HoodieCompactionConfig compactionConfig) {
            this.writeConfig.getProps().putAll((Map)compactionConfig.getProps());
            this.isCompactionConfigSet = true;
            return this;
        }

        public Builder withCleanConfig(HoodieCleanConfig cleanConfig) {
            this.writeConfig.getProps().putAll((Map)cleanConfig.getProps());
            this.isCleanConfigSet = true;
            return this;
        }

        public Builder withArchivalConfig(HoodieArchivalConfig cleanConfig) {
            this.writeConfig.getProps().putAll((Map)cleanConfig.getProps());
            this.isArchivalConfigSet = true;
            return this;
        }

        public Builder withClusteringConfig(HoodieClusteringConfig clusteringConfig) {
            this.writeConfig.getProps().putAll((Map)clusteringConfig.getProps());
            this.isClusteringConfigSet = true;
            return this;
        }

        public Builder withLockConfig(HoodieLockConfig lockConfig) {
            this.writeConfig.getProps().putAll((Map)lockConfig.getProps());
            this.isLockConfigSet = true;
            return this;
        }

        public Builder withMetricsJmxConfig(HoodieMetricsJmxConfig metricsJmxConfig) {
            this.writeConfig.getProps().putAll((Map)metricsJmxConfig.getProps());
            this.isMetricsJmxConfigSet = true;
            return this;
        }

        public Builder withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig mericsGraphiteConfig) {
            this.writeConfig.getProps().putAll((Map)mericsGraphiteConfig.getProps());
            this.isMetricsGraphiteConfigSet = true;
            return this;
        }

        public Builder withMetricsM3Config(HoodieMetricsM3Config metricsM3Config) {
            this.writeConfig.getProps().putAll((Map)metricsM3Config.getProps());
            this.isMetricsM3ConfigSet = true;
            return this;
        }

        public Builder withPreCommitValidatorConfig(HoodiePreCommitValidatorConfig validatorConfig) {
            this.writeConfig.getProps().putAll((Map)validatorConfig.getProps());
            this.isPreCommitValidationConfigSet = true;
            return this;
        }

        public Builder withMetricsConfig(HoodieMetricsConfig metricsConfig) {
            this.writeConfig.getProps().putAll((Map)metricsConfig.getProps());
            this.isMetricsConfigSet = true;
            return this;
        }

        public Builder withMemoryConfig(HoodieMemoryConfig memoryConfig) {
            this.writeConfig.getProps().putAll((Map)memoryConfig.getProps());
            this.isMemoryConfigSet = true;
            return this;
        }

        public Builder withBootstrapConfig(HoodieBootstrapConfig bootstrapConfig) {
            this.writeConfig.getProps().putAll((Map)bootstrapConfig.getProps());
            this.isBootstrapConfigSet = true;
            return this;
        }

        public Builder withPayloadConfig(HoodiePayloadConfig payloadConfig) {
            this.writeConfig.getProps().putAll((Map)payloadConfig.getProps());
            this.isPayloadConfigSet = true;
            return this;
        }

        public Builder withRecordMergeMode(RecordMergeMode recordMergeMode) {
            this.writeConfig.setValue(RECORD_MERGE_MODE, recordMergeMode.name());
            return this;
        }

        public Builder withMetadataConfig(HoodieMetadataConfig metadataConfig) {
            this.writeConfig.getProps().putAll((Map)metadataConfig.getProps());
            this.isMetadataConfigSet = true;
            return this;
        }

        public Builder withTTLConfig(HoodieTTLConfig ttlConfig) {
            this.writeConfig.getProps().putAll((Map)ttlConfig.getProps());
            this.isTTLConfigSet = true;
            return this;
        }

        public Builder withAutoCommit(boolean autoCommit) {
            this.writeConfig.setValue(AUTO_COMMIT_ENABLE, String.valueOf(autoCommit));
            return this;
        }

        public Builder withWriteStatusClass(Class<? extends WriteStatus> writeStatusClass) {
            this.writeConfig.setValue(WRITE_STATUS_CLASS_NAME, writeStatusClass.getName());
            return this;
        }

        public Builder withFileSystemViewConfig(FileSystemViewStorageConfig viewStorageConfig) {
            this.writeConfig.getProps().putAll((Map)viewStorageConfig.getProps());
            this.isViewConfigSet = true;
            return this;
        }

        public Builder withConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.writeConfig.getProps().putAll((Map)consistencyGuardConfig.getProps());
            this.isConsistencyGuardSet = true;
            return this;
        }

        public Builder withCallbackConfig(HoodieWriteCommitCallbackConfig callbackConfig) {
            this.writeConfig.getProps().putAll((Map)callbackConfig.getProps());
            this.isCallbackConfigSet = true;
            return this;
        }

        public Builder withLayoutConfig(HoodieLayoutConfig layoutConfig) {
            this.writeConfig.getProps().putAll((Map)layoutConfig.getProps());
            this.isLayoutConfigSet = true;
            return this;
        }

        public Builder withFinalizeWriteParallelism(int parallelism) {
            this.writeConfig.setValue(FINALIZE_WRITE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withMarkersType(String markerType) {
            this.writeConfig.setValue(MARKERS_TYPE, markerType);
            return this;
        }

        public Builder withMarkersTimelineServerBasedBatchNumThreads(int numThreads) {
            this.writeConfig.setValue(MARKERS_TIMELINE_SERVER_BASED_BATCH_NUM_THREADS, String.valueOf(numThreads));
            return this;
        }

        public Builder withMarkersTimelineServerBasedBatchIntervalMs(long intervalMs) {
            this.writeConfig.setValue(MARKERS_TIMELINE_SERVER_BASED_BATCH_INTERVAL_MS, String.valueOf(intervalMs));
            return this;
        }

        public Builder withMarkersDeleteParallelism(int parallelism) {
            this.writeConfig.setValue(MARKERS_DELETE_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withEmbeddedTimelineServerEnabled(boolean enabled) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withEmbeddedTimelineServerReuseEnabled(boolean enabled) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_REUSE_ENABLED, String.valueOf(enabled));
            return this;
        }

        public Builder withEmbeddedTimelineServerPort(int port) {
            this.writeConfig.setValue(EMBEDDED_TIMELINE_SERVER_PORT_NUM, String.valueOf(port));
            return this;
        }

        public Builder withTimelineServerBasedInstantStateEnable(boolean enable) {
            this.writeConfig.setValue(INSTANT_STATE_TIMELINE_SERVER_BASED, String.valueOf(enable));
            return this;
        }

        public Builder withBulkInsertSortMode(String mode) {
            this.writeConfig.setValue(BULK_INSERT_SORT_MODE, mode);
            return this;
        }

        public Builder withAllowMultiWriteOnSameInstant(boolean allow) {
            this.writeConfig.setValue(ALLOW_MULTI_WRITE_ON_SAME_INSTANT_ENABLE, String.valueOf(allow));
            return this;
        }

        public Builder withHiveStylePartitioningEnabled(boolean enabled) {
            this.writeConfig.setValue(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withExternalSchemaTrasformation(boolean enabled) {
            this.writeConfig.setValue(AVRO_EXTERNAL_SCHEMA_TRANSFORMATION_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeDataValidationCheckEnabled(boolean enabled) {
            this.writeConfig.setValue(MERGE_DATA_VALIDATION_CHECK_ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withMergeAllowDuplicateOnInserts(boolean routeInsertsToNewFiles) {
            this.writeConfig.setValue(MERGE_ALLOW_DUPLICATE_ON_INSERTS_ENABLE, String.valueOf(routeInsertsToNewFiles));
            return this;
        }

        public Builder withMergeSmallFileGroupCandidatesLimit(int limit) {
            this.writeConfig.setValue(MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT, String.valueOf(limit));
            return this;
        }

        public Builder withHeartbeatIntervalInMs(Integer heartbeatIntervalInMs) {
            this.writeConfig.setValue(CLIENT_HEARTBEAT_INTERVAL_IN_MS, String.valueOf(heartbeatIntervalInMs));
            return this;
        }

        public Builder withHeartbeatTolerableMisses(Integer heartbeatTolerableMisses) {
            this.writeConfig.setValue(CLIENT_HEARTBEAT_NUM_TOLERABLE_MISSES, String.valueOf(heartbeatTolerableMisses));
            return this;
        }

        public Builder withWriteConcurrencyMode(WriteConcurrencyMode concurrencyMode) {
            this.writeConfig.setValue(WRITE_CONCURRENCY_MODE, concurrencyMode.name());
            return this;
        }

        public Builder withPopulateMetaFields(boolean populateMetaFields) {
            this.writeConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS, Boolean.toString(populateMetaFields));
            return this;
        }

        public Builder withAllowOperationMetadataField(boolean allowOperationMetadataField) {
            this.writeConfig.setValue(ALLOW_OPERATION_METADATA_FIELD, Boolean.toString(allowOperationMetadataField));
            return this;
        }

        public Builder withFileIdPrefixProviderClassName(String fileIdPrefixProviderClassName) {
            this.writeConfig.setValue(FILEID_PREFIX_PROVIDER_CLASS, fileIdPrefixProviderClassName);
            return this;
        }

        public Builder withTableServicesEnabled(boolean enabled) {
            this.writeConfig.setValue(TABLE_SERVICES_ENABLED, Boolean.toString(enabled));
            return this;
        }

        public Builder withReleaseResourceEnabled(boolean enabled) {
            this.writeConfig.setValue(RELEASE_RESOURCE_ENABLE, Boolean.toString(enabled));
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.writeConfig.getProps().putAll((Map)properties);
            return this;
        }

        public Builder withAutoAdjustLockConfigs(boolean autoAdjustLockConfigs) {
            this.writeConfig.setValue(AUTO_ADJUST_LOCK_CONFIGS, String.valueOf(autoAdjustLockConfigs));
            return this;
        }

        public Builder doSkipDefaultPartitionValidation(boolean skipDefaultPartitionValidation) {
            this.writeConfig.setValue(SKIP_DEFAULT_PARTITION_VALIDATION, String.valueOf(skipDefaultPartitionValidation));
            return this;
        }

        public Builder withEarlyConflictDetectionEnable(boolean enable) {
            this.writeConfig.setValue(EARLY_CONFLICT_DETECTION_ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withAsyncConflictDetectorInitialDelayMs(long intervalMs) {
            this.writeConfig.setValue(ASYNC_CONFLICT_DETECTOR_INITIAL_DELAY_MS, String.valueOf(intervalMs));
            return this;
        }

        public Builder withAsyncConflictDetectorPeriodMs(long periodMs) {
            this.writeConfig.setValue(ASYNC_CONFLICT_DETECTOR_PERIOD_MS, String.valueOf(periodMs));
            return this;
        }

        public Builder withEarlyConflictDetectionCheckCommitConflict(boolean enable) {
            this.writeConfig.setValue(EARLY_CONFLICT_DETECTION_CHECK_COMMIT_CONFLICT, String.valueOf(enable));
            return this;
        }

        public Builder withEarlyConflictDetectionStrategy(String className) {
            this.writeConfig.setValue(EARLY_CONFLICT_DETECTION_STRATEGY_CLASS_NAME, className);
            return this;
        }

        public Builder withRollbackBackupEnabled(boolean rollbackBackupEnabled) {
            this.writeConfig.setValue(ROLLBACK_INSTANT_BACKUP_ENABLED, String.valueOf(rollbackBackupEnabled));
            return this;
        }

        public Builder withRollbackBackupDirectory(String backupDir) {
            this.writeConfig.setValue(ROLLBACK_INSTANT_BACKUP_DIRECTORY, backupDir);
            return this;
        }

        public Builder withClientInitCallbackClassNames(String classNames) {
            this.writeConfig.setValue(CLIENT_INIT_CALLBACK_CLASS_NAMES, classNames);
            return this;
        }

        public Builder withWritesFileIdEncoding(Integer fileIdEncoding) {
            this.writeConfig.setValue(HoodieWriteConfig.WRITES_FILEID_ENCODING, Integer.toString(fileIdEncoding));
            return this;
        }

        public Builder withWriteRecordPositionsEnabled(boolean shouldWriteRecordPositions) {
            this.writeConfig.setValue(WRITE_RECORD_POSITIONS, String.valueOf(shouldWriteRecordPositions));
            return this;
        }

        protected void setDefaults() {
            this.writeConfig.setDefaultValue(MARKERS_TYPE, this.getDefaultMarkersType(this.engineType));
            this.writeConfig.setDefaults(HoodieWriteConfig.class.getName());
            this.writeConfig.setDefaults(HoodieHBaseIndexConfig.class.getName());
            this.writeConfig.setDefaultOnCondition(!this.isIndexConfigSet, HoodieIndexConfig.newBuilder().withEngineType(this.engineType).fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isStorageConfigSet, (HoodieConfig)HoodieStorageConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isCompactionConfigSet, HoodieCompactionConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isCleanConfigSet, HoodieCleanConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isArchivalConfigSet, HoodieArchivalConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isClusteringConfigSet, HoodieClusteringConfig.newBuilder().withEngineType(this.engineType).fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMetricsConfigSet, (HoodieConfig)HoodieMetricsConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isBootstrapConfigSet, HoodieBootstrapConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMemoryConfigSet, (HoodieConfig)HoodieMemoryConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isViewConfigSet, (HoodieConfig)FileSystemViewStorageConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isConsistencyGuardSet, (HoodieConfig)ConsistencyGuardConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isCallbackConfigSet, HoodieWriteCommitCallbackConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isPayloadConfigSet, HoodiePayloadConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isMetadataConfigSet, (HoodieConfig)HoodieMetadataConfig.newBuilder().withEngineType(this.engineType).fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isPreCommitValidationConfigSet, HoodiePreCommitValidatorConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isLayoutConfigSet, HoodieLayoutConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultValue(TIMELINE_LAYOUT_VERSION_NUM, String.valueOf(TimelineLayoutVersion.CURR_VERSION));
            TypedProperties writeConfigProperties = this.writeConfig.getProps();
            boolean isLockProviderPropertySet = writeConfigProperties.containsKey((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key());
            this.writeConfig.setDefaultOnCondition(!this.isLockConfigSet, HoodieLockConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.writeConfig.setDefaultOnCondition(!this.isTTLConfigSet, HoodieTTLConfig.newBuilder().fromProperties((Properties)this.writeConfig.getProps()).build());
            this.autoAdjustConfigsForConcurrencyMode(isLockProviderPropertySet);
        }

        private boolean isLockRequiredForSingleWriter() {
            return this.writeConfig.isMetadataTableEnabled() && this.writeConfig.areAnyTableServicesAsync() != false && !this.writeConfig.getWriteConcurrencyMode().supportsMultiWriter();
        }

        private void autoAdjustConfigsForConcurrencyMode(boolean isLockProviderPropertySet) {
            WriteConcurrencyMode writeConcurrencyMode;
            if (this.writeConfig.getWriteConcurrencyMode() == WriteConcurrencyMode.SINGLE_WRITER && !this.writeConfig.areAnyTableServicesAsync().booleanValue() && this.writeConfig.getLockProviderClass() != null && !this.writeConfig.getLockProviderClass().equals(InProcessLockProvider.class.getCanonicalName())) {
                LOG.warn(String.format("For a single writer mode, overriding lock provider class (%s) to %s. So, user configured lock provider %s may not take effect", HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName(), this.writeConfig.getLockProviderClass()));
                this.writeConfig.setValue(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName());
            }
            if (!isLockProviderPropertySet && this.writeConfig.isAutoAdjustLockConfigs() && this.isLockRequiredForSingleWriter()) {
                this.writeConfig.setValue(HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName());
                LOG.info(String.format("Automatically set %s=%s since user has not set the lock provider for single writer with async table services", HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), InProcessLockProvider.class.getName()));
            }
            if ((writeConcurrencyMode = this.writeConfig.getWriteConcurrencyMode()).supportsMultiWriter()) {
                this.writeConfig.setValue(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.LAZY.name());
                LOG.info(String.format("Automatically set %s=%s since %s is used", HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.LAZY.name(), writeConcurrencyMode.name()));
            }
        }

        private void validate() {
            HoodieCleaningPolicy cleaningPolicy;
            if (HoodieTableVersion.SIX.equals((Object)this.writeConfig.getWriteVersion())) {
                LOG.warn("HoodieTableVersion.SIX is not yet fully supported by the writer. Please expect some unexpected behavior, until its fully implemented.");
            }
            String layoutVersion = this.writeConfig.getString(TIMELINE_LAYOUT_VERSION_NUM);
            new TimelineLayoutVersion(Integer.valueOf(Integer.parseInt(layoutVersion)));
            Objects.requireNonNull(this.writeConfig.getString(BASE_PATH));
            WriteConcurrencyMode writeConcurrencyMode = this.writeConfig.getWriteConcurrencyMode();
            if (this.writeConfig.isEarlyConflictDetectionEnable()) {
                ValidationUtils.checkArgument((boolean)writeConcurrencyMode.isOptimisticConcurrencyControl(), (String)"To use early conflict detection, set hoodie.write.concurrency.mode=OPTIMISTIC_CONCURRENCY_CONTROL");
            }
            if (writeConcurrencyMode.supportsMultiWriter()) {
                ValidationUtils.checkArgument((!this.writeConfig.getString(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY).equals(HoodieFailedWritesCleaningPolicy.EAGER.name()) ? 1 : 0) != 0, (String)String.format("To enable %s, set hoodie.clean.failed.writes.policy=LAZY", writeConcurrencyMode.name()));
            }
            if (writeConcurrencyMode == WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL) {
                ValidationUtils.checkArgument((this.writeConfig.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ) && this.writeConfig.isSimpleBucketIndex() ? 1 : 0) != 0, (String)"Non-blocking concurrency control requires the MOR table with simple bucket index");
            }
            if ((cleaningPolicy = HoodieCleaningPolicy.valueOf((String)this.writeConfig.getString(HoodieCleanConfig.CLEANER_POLICY))) == HoodieCleaningPolicy.KEEP_LATEST_COMMITS) {
                int minInstantsToKeep = Integer.parseInt(this.writeConfig.getStringOrDefault(HoodieArchivalConfig.MIN_COMMITS_TO_KEEP));
                int maxInstantsToKeep = Integer.parseInt(this.writeConfig.getStringOrDefault(HoodieArchivalConfig.MAX_COMMITS_TO_KEEP));
                int cleanerCommitsRetained = Integer.parseInt(this.writeConfig.getStringOrDefault(HoodieCleanConfig.CLEANER_COMMITS_RETAINED));
                ValidationUtils.checkArgument((maxInstantsToKeep > minInstantsToKeep ? 1 : 0) != 0, (String)String.format("Increase %s=%d to be greater than %s=%d.", HoodieArchivalConfig.MAX_COMMITS_TO_KEEP.key(), maxInstantsToKeep, HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), minInstantsToKeep));
                if (minInstantsToKeep <= cleanerCommitsRetained) {
                    LOG.warn("Increase {}={} to be greater than {}={} (there is risk of incremental pull missing data from few instants based on the current configuration). The Hudi archiver will automatically adjust the configuration regardless.", new Object[]{HoodieArchivalConfig.MIN_COMMITS_TO_KEEP.key(), minInstantsToKeep, HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key(), cleanerCommitsRetained});
                }
            }
            boolean inlineCompact = this.writeConfig.getBoolean(HoodieCompactionConfig.INLINE_COMPACT);
            boolean inlineCompactSchedule = this.writeConfig.getBoolean(HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT);
            ValidationUtils.checkArgument((!inlineCompact || !inlineCompactSchedule ? 1 : 0) != 0, (String)String.format("Either of inline compaction (%s) or schedule inline compaction (%s) can be enabled. Both can't be set to true at the same time. %s, %s", HoodieCompactionConfig.INLINE_COMPACT.key(), HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT.key(), inlineCompact, inlineCompactSchedule));
        }

        public HoodieWriteConfig build() {
            return this.build(true);
        }

        @VisibleForTesting
        public HoodieWriteConfig build(boolean shouldValidate) {
            this.setDefaults();
            if (shouldValidate) {
                this.validate();
            }
            return new HoodieWriteConfig(this.engineType, (Properties)this.writeConfig.getProps());
        }

        private String getDefaultMarkersType(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    if (this.writeConfig.isEmbeddedTimelineServerEnabled()) {
                        return MarkerType.TIMELINE_SERVER_BASED.toString();
                    }
                    if (!HoodieTableMetadata.isMetadataTable((String)this.writeConfig.getBasePath())) {
                        LOG.warn("Embedded timeline server is disabled, fallback to use direct marker type for spark");
                    }
                    return MarkerType.DIRECT.toString();
                }
                case FLINK: 
                case JAVA: {
                    return MarkerType.DIRECT.toString();
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + engineType);
        }
    }
}

