/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.HoodieMergedReadHandle;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieBackedTableMetadataWriter<I>
implements HoodieTableMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBackedTableMetadataWriter.class);
    private static final String RECORD_KEY_FIELD_NAME = "key";
    private static final int RECORD_INDEX_AVERAGE_RECORD_SIZE = 48;
    private transient BaseHoodieWriteClient<?, I, ?, ?> writeClient;
    protected HoodieWriteConfig metadataWriteConfig;
    protected HoodieWriteConfig dataWriteConfig;
    protected HoodieBackedTableMetadata metadata;
    protected HoodieTableMetaClient metadataMetaClient;
    protected HoodieTableMetaClient dataMetaClient;
    protected Option<HoodieMetadataMetrics> metrics;
    protected StorageConfiguration<?> storageConf;
    protected final transient HoodieEngineContext engineContext;
    protected final List<MetadataPartitionType> enabledPartitionTypes;
    private boolean initialized = false;
    private HoodieMetadataFileSystemView metadataView;

    protected HoodieBackedTableMetadataWriter(StorageConfiguration<?> storageConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        this.dataWriteConfig = writeConfig;
        this.engineContext = engineContext;
        this.storageConf = storageConf;
        this.metrics = Option.empty();
        this.dataMetaClient = HoodieTableMetaClient.builder().setConf(storageConf.newInstance()).setBasePath(this.dataWriteConfig.getBasePath()).setTimeGeneratorConfig(this.dataWriteConfig.getTimeGeneratorConfig()).build();
        this.enabledPartitionTypes = MetadataPartitionType.getEnabledPartitions((TypedProperties)this.dataWriteConfig.getProps(), (HoodieTableMetaClient)this.dataMetaClient);
        if (writeConfig.isMetadataTableEnabled()) {
            this.metadataWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig(writeConfig, failedWritesCleaningPolicy);
            try {
                this.initRegistry();
                this.initialized = this.initializeIfNeeded(this.dataMetaClient, inflightInstantTimestamp);
            }
            catch (IOException e) {
                LOG.error("Failed to initialize metadata table", (Throwable)e);
            }
        }
        ValidationUtils.checkArgument((!this.initialized || this.metadata != null ? 1 : 0) != 0, (String)"MDT Reader should have been opened post initialization");
    }

    abstract HoodieTable getTable(HoodieWriteConfig var1, HoodieTableMetaClient var2);

    private void initMetadataReader() {
        if (this.metadata != null) {
            this.metadata.close();
        }
        try {
            this.metadata = new HoodieBackedTableMetadata(this.engineContext, this.dataMetaClient.getStorage(), this.dataWriteConfig.getMetadataConfig(), this.dataWriteConfig.getBasePath(), true);
            this.metadataMetaClient = this.metadata.getMetadataMetaClient();
        }
        catch (Exception e) {
            throw new HoodieException("Could not open MDT for reads", (Throwable)e);
        }
    }

    private HoodieMetadataFileSystemView getMetadataView() {
        if (this.metadataView == null || !this.metadataView.equals(this.metadata.getMetadataFileSystemView())) {
            ValidationUtils.checkState((this.metadata != null ? 1 : 0) != 0, (String)"Metadata table not initialized");
            ValidationUtils.checkState((this.dataMetaClient != null ? 1 : 0) != 0, (String)"Data table meta client not initialized");
            this.metadataView = new HoodieMetadataFileSystemView(this.dataMetaClient, (HoodieTimeline)this.dataMetaClient.getActiveTimeline(), (HoodieTableMetadata)this.metadata);
        }
        return this.metadataView;
    }

    protected abstract void initRegistry();

    public HoodieWriteConfig getWriteConfig() {
        return this.metadataWriteConfig;
    }

    public HoodieBackedTableMetadata getTableMetadata() {
        return this.metadata;
    }

    public List<MetadataPartitionType> getEnabledPartitionTypes() {
        return this.enabledPartitionTypes;
    }

    protected boolean initializeIfNeeded(HoodieTableMetaClient dataMetaClient, Option<String> inflightInstantTimestamp) throws IOException {
        HoodieTimer timer = HoodieTimer.start();
        ArrayList<MetadataPartitionType> metadataPartitionsToInit = new ArrayList<MetadataPartitionType>(MetadataPartitionType.getValidValues().length);
        try {
            boolean exists = this.metadataTableExists(dataMetaClient);
            if (!exists) {
                metadataPartitionsToInit.add(MetadataPartitionType.FILES);
            }
            if (!this.dataWriteConfig.isMetadataAsyncIndex()) {
                Set completedPartitions = dataMetaClient.getTableConfig().getMetadataPartitions();
                LOG.info("Async metadata indexing disabled and following partitions already initialized: {}", (Object)completedPartitions);
                this.enabledPartitionTypes.stream().filter(p -> !completedPartitions.contains(p.getPartitionPath()) && !MetadataPartitionType.FILES.equals(p)).forEach(metadataPartitionsToInit::add);
            }
            if (metadataPartitionsToInit.isEmpty()) {
                this.initMetadataReader();
                return true;
            }
            String initializationTime = (String)dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime).orElse((Object)"00000000000000");
            this.initializeFromFilesystem(initializationTime, metadataPartitionsToInit, inflightInstantTimestamp);
            this.metrics.ifPresent(m -> m.updateMetrics("initialize", timer.endTimer()));
            return true;
        }
        catch (IOException e) {
            LOG.error("Failed to initialize metadata table. Disabling the writer.", (Throwable)e);
            return false;
        }
    }

    private boolean metadataTableExists(HoodieTableMetaClient dataMetaClient) throws IOException {
        boolean exists = dataMetaClient.getTableConfig().isMetadataTableAvailable();
        boolean reInitialize = false;
        if (exists) {
            try {
                this.metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf.newInstance()).setBasePath(this.metadataWriteConfig.getBasePath()).setTimeGeneratorConfig(this.dataWriteConfig.getTimeGeneratorConfig()).build();
                if (this.metadataMetaClient.getTableConfig().populateMetaFields()) {
                    LOG.info("Re-initiating metadata table properties since populate meta fields have changed");
                    this.metadataMetaClient = this.initializeMetaClient();
                }
            }
            catch (TableNotFoundException e) {
                return false;
            }
            Option latestMetadataInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant();
            reInitialize = this.isBootstrapNeeded((Option<HoodieInstant>)latestMetadataInstant);
        }
        if (reInitialize) {
            this.metrics.ifPresent(m -> m.incrementMetric("rebootstrap_count", 1L));
            LOG.info("Deleting Metadata Table directory so that it can be re-initialized");
            HoodieTableMetadataUtil.deleteMetadataTable((HoodieTableMetaClient)dataMetaClient, (HoodieEngineContext)this.engineContext, (boolean)false);
            exists = false;
        }
        return exists;
    }

    private boolean isBootstrapNeeded(Option<HoodieInstant> latestMetadataInstant) {
        if (!latestMetadataInstant.isPresent()) {
            LOG.warn("Metadata Table will need to be re-initialized as no instants were found");
            return true;
        }
        return false;
    }

    private void initializeFromFilesystem(String initializationTime, List<MetadataPartitionType> partitionsToInit, Option<String> inflightInstantTimestamp) throws IOException {
        Set<String> pendingDataInstants = this.getPendingDataInstants(this.dataMetaClient);
        boolean filesPartitionAvailable = this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.FILES);
        if (!filesPartitionAvailable) {
            partitionsToInit.remove(MetadataPartitionType.FILES);
            partitionsToInit.add(0, MetadataPartitionType.FILES);
            this.metadataMetaClient = this.initializeMetaClient();
        } else {
            this.initMetadataReader();
            if (this.metadataMetaClient == null) {
                this.metadataMetaClient = HoodieTableMetaClient.builder().setConf(this.storageConf.newInstance()).setBasePath(this.metadataWriteConfig.getBasePath()).setTimeGeneratorConfig(this.dataWriteConfig.getTimeGeneratorConfig()).build();
            }
        }
        partitionsToInit.removeIf(metadataPartition -> this.dataMetaClient.getTableConfig().isMetadataPartitionAvailable(metadataPartition));
        List<Object> partitionInfoList = filesPartitionAvailable ? this.listAllPartitionsFromMDT(initializationTime, pendingDataInstants) : (this.dataWriteConfig.getMetadataConfig().shouldAutoInitialize() ? this.listAllPartitionsFromFilesystem(initializationTime, pendingDataInstants) : Collections.emptyList());
        Map<String, Map<String, Long>> partitionToFilesMap = partitionInfoList.stream().map(p -> {
            String partitionName = HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition((String)p.getRelativePath());
            return Pair.of((Object)partitionName, (Object)p.getFileNameToSizeMap());
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        Iterator<MetadataPartitionType> iterator = partitionsToInit.iterator();
        while (iterator.hasNext()) {
            MetadataPartitionType partitionType = iterator.next();
            if (partitionType != MetadataPartitionType.PARTITION_STATS || this.dataMetaClient.getTableConfig().isTablePartitioned()) continue;
            LOG.warn("Partition stats index cannot be enabled for a non-partitioned table. Removing from initialization list. Please disable {}", (Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_PARTITION_STATS.key());
            iterator.remove();
            this.enabledPartitionTypes.remove(partitionType);
        }
        block12: for (MetadataPartitionType partitionType : partitionsToInit) {
            String partitionName;
            Pair<Integer, HoodieData<HoodieRecord>> fileGroupCountAndRecordsPair;
            String instantTimeForPartition = this.generateUniqueInstantTime(initializationTime);
            String partitionTypeName = partitionType.name();
            LOG.info("Initializing MDT partition {} at instant {}", (Object)partitionTypeName, (Object)instantTimeForPartition);
            try {
                switch (partitionType) {
                    case FILES: {
                        fileGroupCountAndRecordsPair = this.initializeFilesPartition(partitionInfoList);
                        partitionName = MetadataPartitionType.FILES.getPartitionPath();
                        break;
                    }
                    case BLOOM_FILTERS: {
                        fileGroupCountAndRecordsPair = this.initializeBloomFiltersPartition(initializationTime, partitionToFilesMap);
                        partitionName = MetadataPartitionType.BLOOM_FILTERS.getPartitionPath();
                        break;
                    }
                    case COLUMN_STATS: {
                        fileGroupCountAndRecordsPair = this.initializeColumnStatsPartition(partitionToFilesMap);
                        partitionName = MetadataPartitionType.COLUMN_STATS.getPartitionPath();
                        break;
                    }
                    case RECORD_INDEX: {
                        fileGroupCountAndRecordsPair = this.initializeRecordIndexPartition();
                        partitionName = MetadataPartitionType.RECORD_INDEX.getPartitionPath();
                        break;
                    }
                    case EXPRESSION_INDEX: {
                        Set<String> expressionIndexPartitionsToInit = this.getIndexPartitionsToInit(partitionType);
                        if (expressionIndexPartitionsToInit.isEmpty()) continue block12;
                        ValidationUtils.checkState((expressionIndexPartitionsToInit.size() == 1 ? 1 : 0) != 0, (String)"Only one expression index at a time is supported for now");
                        partitionName = expressionIndexPartitionsToInit.iterator().next();
                        fileGroupCountAndRecordsPair = this.initializeExpressionIndexPartition(partitionName, instantTimeForPartition);
                        break;
                    }
                    case PARTITION_STATS: {
                        if (!this.dataWriteConfig.isMetadataColumnStatsIndexEnabled()) {
                            LOG.warn("Skipping partition stats initialization as column stats index is not enabled. Please enable {}", (Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key());
                            continue block12;
                        }
                        fileGroupCountAndRecordsPair = this.initializePartitionStatsIndex(partitionInfoList);
                        partitionName = MetadataPartitionType.PARTITION_STATS.getPartitionPath();
                        break;
                    }
                    case SECONDARY_INDEX: {
                        Set<String> secondaryIndexPartitionsToInit = this.getIndexPartitionsToInit(partitionType);
                        if (secondaryIndexPartitionsToInit.size() != 1) {
                            if (secondaryIndexPartitionsToInit.size() <= 1) continue block12;
                            LOG.warn("Skipping secondary index initialization as only one secondary index bootstrap at a time is supported for now. Provided: {}", secondaryIndexPartitionsToInit);
                            continue block12;
                        }
                        partitionName = secondaryIndexPartitionsToInit.iterator().next();
                        fileGroupCountAndRecordsPair = this.initializeSecondaryIndexPartition(partitionName);
                        break;
                    }
                    default: {
                        throw new HoodieMetadataException(String.format("Unsupported MDT partition type: %s", partitionType));
                    }
                }
            }
            catch (Exception e) {
                String metricKey = partitionType.getPartitionPath() + "_" + "bootstrap_error";
                this.metrics.ifPresent(m -> m.setMetric(metricKey, 1L));
                String errMsg = String.format("Bootstrap on %s partition failed for %s", partitionType.getPartitionPath(), this.metadataMetaClient.getBasePath());
                LOG.error(errMsg, (Throwable)e);
                throw new HoodieMetadataException(errMsg, e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Initializing {} index with {} mappings", (Object)partitionTypeName, fileGroupCountAndRecordsPair.getKey());
            }
            HoodieTimer partitionInitTimer = HoodieTimer.start();
            int fileGroupCount = (Integer)fileGroupCountAndRecordsPair.getKey();
            ValidationUtils.checkArgument((fileGroupCount > 0 ? 1 : 0) != 0, (String)("FileGroup count for MDT partition " + partitionTypeName + " should be > 0"));
            this.initializeFileGroups(this.dataMetaClient, partitionType, instantTimeForPartition, fileGroupCount, partitionName);
            HoodieData records = (HoodieData)fileGroupCountAndRecordsPair.getValue();
            this.bulkCommit(instantTimeForPartition, partitionName, (HoodieData<HoodieRecord>)records, fileGroupCount);
            this.metadataMetaClient.reloadActiveTimeline();
            this.dataMetaClient.getTableConfig().setMetadataPartitionState(this.dataMetaClient, partitionName, true);
            this.initMetadataReader();
            long totalInitTime = partitionInitTimer.endTimer();
            LOG.info("Initializing {} index in metadata table took {} in ms", (Object)partitionTypeName, (Object)totalInitTime);
        }
    }

    private String generateUniqueInstantTime(String initializationTime) {
        HoodieTimeline dataIndexTimeline = this.dataMetaClient.getActiveTimeline().filter(instant -> instant.getAction().equals("indexing"));
        if (HoodieTableMetadataUtil.isIndexingCommit((HoodieTimeline)dataIndexTimeline, (String)initializationTime)) {
            return initializationTime;
        }
        int offset = 0;
        while (true) {
            String commitInstantTime = HoodieInstantTimeGenerator.instantTimePlusMillis((String)"00000000000000", (long)offset);
            if (!this.metadataMetaClient.getCommitsTimeline().containsInstant(commitInstantTime)) {
                return commitInstantTime;
            }
            ++offset;
        }
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializePartitionStatsIndex(List<HoodieTableMetadataUtil.DirectoryInfo> partitionInfoList) throws IOException {
        HoodieData records = HoodieTableMetadataUtil.convertFilesToPartitionStatsRecords((HoodieEngineContext)this.engineContext, this.getPartitionFileSlicePairs(), (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), (HoodieTableMetaClient)this.dataMetaClient, (Option)Option.of((Object)new Schema.Parser().parse(this.dataWriteConfig.getWriteSchema())));
        int fileGroupCount = this.dataWriteConfig.getMetadataConfig().getPartitionStatsIndexFileGroupCount();
        return Pair.of((Object)fileGroupCount, (Object)records);
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializeColumnStatsPartition(Map<String, Map<String, Long>> partitionToFilesMap) {
        HoodieData records = HoodieTableMetadataUtil.convertFilesToColumnStatsRecords((HoodieEngineContext)this.engineContext, Collections.emptyMap(), partitionToFilesMap, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), (int)this.dataWriteConfig.getColumnStatsIndexParallelism(), (int)this.dataWriteConfig.getMetadataConfig().getMaxReaderBufferSize());
        int fileGroupCount = this.dataWriteConfig.getMetadataConfig().getColumnStatsIndexFileGroupCount();
        return Pair.of((Object)fileGroupCount, (Object)records);
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializeBloomFiltersPartition(String createInstantTime, Map<String, Map<String, Long>> partitionToFilesMap) {
        HoodieData records = HoodieTableMetadataUtil.convertFilesToBloomFilterRecords((HoodieEngineContext)this.engineContext, Collections.emptyMap(), partitionToFilesMap, (String)createInstantTime, (HoodieTableMetaClient)this.dataMetaClient, (int)this.dataWriteConfig.getBloomIndexParallelism(), (String)this.dataWriteConfig.getBloomFilterType());
        int fileGroupCount = this.dataWriteConfig.getMetadataConfig().getBloomFilterIndexFileGroupCount();
        return Pair.of((Object)fileGroupCount, (Object)records);
    }

    protected abstract HoodieData<HoodieRecord> getExpressionIndexRecords(List<Pair<String, Pair<String, Long>>> var1, HoodieIndexDefinition var2, HoodieTableMetaClient var3, int var4, Schema var5, StorageConfiguration<?> var6, String var7);

    protected abstract EngineType getEngineType();

    public abstract HoodieData<HoodieRecord> getDeletedSecondaryRecordMapping(HoodieEngineContext var1, Map<String, String> var2, HoodieIndexDefinition var3);

    private Pair<Integer, HoodieData<HoodieRecord>> initializeExpressionIndexPartition(String indexName, String instantTime) throws Exception {
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexName);
        ValidationUtils.checkState((indexDefinition != null ? 1 : 0) != 0, (String)("Expression Index definition is not present for index " + indexName));
        List<Pair<String, FileSlice>> partitionFileSlicePairs = this.getPartitionFileSlicePairs();
        ArrayList<Pair<String, Pair<String, Long>>> partitionFilePathSizeTriplet = new ArrayList<Pair<String, Pair<String, Long>>>();
        partitionFileSlicePairs.forEach(entry -> {
            if (((FileSlice)entry.getValue()).getBaseFile().isPresent()) {
                partitionFilePathSizeTriplet.add(Pair.of((Object)entry.getKey(), (Object)Pair.of((Object)((HoodieBaseFile)((FileSlice)entry.getValue()).getBaseFile().get()).getPath(), (Object)((HoodieBaseFile)((FileSlice)entry.getValue()).getBaseFile().get()).getFileLen())));
            }
            ((FileSlice)entry.getValue()).getLogFiles().forEach(hoodieLogFile -> {
                if (((FileSlice)entry.getValue()).getLogFiles().count() > 0L) {
                    ((FileSlice)entry.getValue()).getLogFiles().forEach(logfile -> partitionFilePathSizeTriplet.add(Pair.of((Object)entry.getKey(), (Object)Pair.of((Object)logfile.getPath().toString(), (Object)logfile.getFileSize()))));
                }
            });
        });
        int fileGroupCount = this.dataWriteConfig.getMetadataConfig().getExpressionIndexFileGroupCount();
        int parallelism = Math.min(partitionFilePathSizeTriplet.size(), this.dataWriteConfig.getMetadataConfig().getExpressionIndexParallelism());
        Schema readerSchema = HoodieTableMetadataUtil.getProjectedSchemaForExpressionIndex((HoodieIndexDefinition)indexDefinition, (HoodieTableMetaClient)this.dataMetaClient);
        return Pair.of((Object)fileGroupCount, this.getExpressionIndexRecords(partitionFilePathSizeTriplet, indexDefinition, this.dataMetaClient, parallelism, readerSchema, this.storageConf, instantTime));
    }

    private HoodieIndexDefinition getIndexDefinition(String indexName) {
        Option expressionIndexMetadata = this.dataMetaClient.getIndexMetadata();
        if (expressionIndexMetadata.isPresent()) {
            return (HoodieIndexDefinition)((HoodieIndexMetadata)expressionIndexMetadata.get()).getIndexDefinitions().get(indexName);
        }
        throw new HoodieIndexException("Expression Index definition is not present");
    }

    private Set<String> getIndexPartitionsToInit(MetadataPartitionType partitionType) {
        if (this.dataMetaClient.getIndexMetadata().isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> indexPartitions = ((HoodieIndexMetadata)this.dataMetaClient.getIndexMetadata().get()).getIndexDefinitions().values().stream().map(HoodieIndexDefinition::getIndexName).filter(indexName -> indexName.startsWith(partitionType.getPartitionPath())).collect(Collectors.toSet());
        Set completedMetadataPartitions = this.dataMetaClient.getTableConfig().getMetadataPartitions();
        indexPartitions.removeAll(completedMetadataPartitions);
        return indexPartitions;
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializeSecondaryIndexPartition(String indexName) throws IOException {
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexName);
        ValidationUtils.checkState((indexDefinition != null ? 1 : 0) != 0, (String)("Secondary Index definition is not present for index " + indexName));
        List<Pair<String, FileSlice>> partitionFileSlicePairs = this.getPartitionFileSlicePairs();
        int parallelism = Math.min(partitionFileSlicePairs.size(), this.dataWriteConfig.getMetadataConfig().getSecondaryIndexParallelism());
        HoodieData records = HoodieTableMetadataUtil.readSecondaryKeysFromFileSlices((HoodieEngineContext)this.engineContext, partitionFileSlicePairs, (int)parallelism, (String)this.getClass().getSimpleName(), (HoodieTableMetaClient)this.dataMetaClient, (EngineType)this.getEngineType(), (HoodieIndexDefinition)indexDefinition);
        int fileGroupCount = HoodieTableMetadataUtil.estimateFileGroupCount((MetadataPartitionType)MetadataPartitionType.RECORD_INDEX, (long)records.count(), (int)48, (int)this.dataWriteConfig.getRecordIndexMinFileGroupCount(), (int)this.dataWriteConfig.getRecordIndexMaxFileGroupCount(), (float)this.dataWriteConfig.getRecordIndexGrowthFactor(), (int)this.dataWriteConfig.getRecordIndexMaxFileGroupSizeBytes());
        return Pair.of((Object)fileGroupCount, (Object)records);
    }

    private List<Pair<String, FileSlice>> getPartitionFileSlicePairs() throws IOException {
        String latestInstant = (String)this.dataMetaClient.getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant().map(HoodieInstant::requestedTime).orElse((Object)"00000000000000");
        try (HoodieMetadataFileSystemView fsView = this.getMetadataView();){
            List partitions = this.metadata.getAllPartitionPaths();
            fsView.loadAllPartitions();
            ArrayList<Pair<String, FileSlice>> partitionFileSlicePairs = new ArrayList<Pair<String, FileSlice>>();
            partitions.forEach(partition -> fsView.getLatestMergedFileSlicesBeforeOrOn(partition, latestInstant).forEach(fs -> partitionFileSlicePairs.add(Pair.of((Object)partition, (Object)fs))));
            ArrayList<Pair<String, FileSlice>> arrayList = partitionFileSlicePairs;
            return arrayList;
        }
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializeRecordIndexPartition() throws IOException {
        HoodieMetadataFileSystemView fsView = this.getMetadataView();
        HoodieTable hoodieTable = this.getTable(this.dataWriteConfig, this.dataMetaClient);
        List partitions = this.metadata.getAllPartitionPaths();
        fsView.loadAllPartitions();
        HoodieData<HoodieRecord> records = null;
        if (this.dataMetaClient.getTableConfig().getTableType() == HoodieTableType.COPY_ON_WRITE) {
            ArrayList partitionBaseFilePairs = new ArrayList();
            for (Object partition : partitions) {
                partitionBaseFilePairs.addAll(fsView.getLatestBaseFiles((String)partition).map(arg_0 -> HoodieBackedTableMetadataWriter.lambda$initializeRecordIndexPartition$13((String)partition, arg_0)).collect(Collectors.toList()));
            }
            LOG.info("Initializing record index from " + partitionBaseFilePairs.size() + " base files in " + partitions.size() + " partitions");
            records = HoodieTableMetadataUtil.readRecordKeysFromBaseFiles((HoodieEngineContext)this.engineContext, (HoodieConfig)this.dataWriteConfig, partitionBaseFilePairs, (boolean)false, (int)this.dataWriteConfig.getMetadataConfig().getRecordIndexMaxParallelism(), (StoragePath)this.dataMetaClient.getBasePath(), this.storageConf, (String)this.getClass().getSimpleName());
        } else {
            ArrayList<Pair<String, FileSlice>> partitionFileSlicePairs = new ArrayList<Pair<String, FileSlice>>();
            String latestCommit = (String)this.dataMetaClient.getActiveTimeline().filterCompletedAndCompactionInstants().lastInstant().map(instant -> instant.requestedTime()).orElse((Object)"00000000000000");
            for (String partition : partitions) {
                fsView.getLatestMergedFileSlicesBeforeOrOn(partition, latestCommit).forEach(fs -> partitionFileSlicePairs.add(Pair.of((Object)partition, (Object)fs)));
            }
            LOG.info("Initializing record index from " + partitionFileSlicePairs.size() + " file slices in " + partitions.size() + " partitions");
            records = HoodieBackedTableMetadataWriter.readRecordKeysFromFileSliceSnapshot(this.engineContext, partitionFileSlicePairs, this.dataWriteConfig.getMetadataConfig().getRecordIndexMaxParallelism(), this.getClass().getSimpleName(), this.dataMetaClient, this.dataWriteConfig, hoodieTable);
        }
        records.persist("MEMORY_AND_DISK_SER");
        long recordCount = records.count();
        int fileGroupCount = HoodieTableMetadataUtil.estimateFileGroupCount((MetadataPartitionType)MetadataPartitionType.RECORD_INDEX, (long)recordCount, (int)48, (int)this.dataWriteConfig.getRecordIndexMinFileGroupCount(), (int)this.dataWriteConfig.getRecordIndexMaxFileGroupCount(), (float)this.dataWriteConfig.getRecordIndexGrowthFactor(), (int)this.dataWriteConfig.getRecordIndexMaxFileGroupSizeBytes());
        LOG.info("Initializing record index with {} mappings and {} file groups.", (Object)recordCount, (Object)fileGroupCount);
        return Pair.of((Object)fileGroupCount, records);
    }

    private static HoodieData<HoodieRecord> readRecordKeysFromFileSliceSnapshot(HoodieEngineContext engineContext, List<Pair<String, FileSlice>> partitionFileSlicePairs, int recordIndexMaxParallelism, String activeModule, HoodieTableMetaClient metaClient, HoodieWriteConfig dataWriteConfig, HoodieTable hoodieTable) {
        if (partitionFileSlicePairs.isEmpty()) {
            return engineContext.emptyHoodieData();
        }
        Option instantTime = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime);
        engineContext.setJobStatus(activeModule, "Record Index: reading record keys from " + partitionFileSlicePairs.size() + " file slices");
        int parallelism = Math.min(partitionFileSlicePairs.size(), recordIndexMaxParallelism);
        return engineContext.parallelize(partitionFileSlicePairs, parallelism).flatMap((SerializableFunction & Serializable)partitionAndFileSlice -> {
            String partition = (String)partitionAndFileSlice.getKey();
            FileSlice fileSlice = (FileSlice)partitionAndFileSlice.getValue();
            String fileId = fileSlice.getFileId();
            return new HoodieMergedReadHandle(dataWriteConfig, (Option<String>)instantTime, hoodieTable, (Pair<String, String>)Pair.of((Object)partition, (Object)fileSlice.getFileId()), (Option<FileSlice>)Option.of((Object)fileSlice)).getMergedRecords().stream().map(record -> {
                HoodieRecord record1 = (HoodieRecord)record;
                return HoodieMetadataPayload.createRecordIndexUpdate((String)record1.getRecordKey(), (String)partition, (String)fileId, (String)record1.getCurrentLocation().getInstantTime(), (int)0);
            }).iterator();
        });
    }

    private Pair<Integer, HoodieData<HoodieRecord>> initializeFilesPartition(List<HoodieTableMetadataUtil.DirectoryInfo> partitionInfoList) {
        boolean fileGroupCount = true;
        List partitions = partitionInfoList.stream().map(p -> HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition((String)p.getRelativePath())).collect(Collectors.toList());
        int totalDataFilesCount = partitionInfoList.stream().mapToInt(HoodieTableMetadataUtil.DirectoryInfo::getTotalFiles).sum();
        LOG.info("Committing total {} partitions and {} files to metadata", (Object)partitions.size(), (Object)totalDataFilesCount);
        HoodieRecord record = HoodieMetadataPayload.createPartitionListRecord(partitions);
        HoodieData allPartitionsRecord = this.engineContext.parallelize(Collections.singletonList(record), 1);
        if (partitionInfoList.isEmpty()) {
            return Pair.of((Object)1, (Object)allPartitionsRecord);
        }
        this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Creating records for metadata FILES partition");
        HoodieData fileListRecords = this.engineContext.parallelize(partitionInfoList, partitionInfoList.size()).map((SerializableFunction & Serializable)partitionInfo -> {
            Map fileNameToSizeMap = partitionInfo.getFileNameToSizeMap();
            return HoodieMetadataPayload.createPartitionFilesRecord((String)partitionInfo.getRelativePath(), (Map)fileNameToSizeMap, Collections.emptyList());
        });
        ValidationUtils.checkState((fileListRecords.count() == (long)partitions.size() ? 1 : 0) != 0);
        return Pair.of((Object)1, (Object)allPartitionsRecord.union(fileListRecords));
    }

    private Set<String> getPendingDataInstants(HoodieTableMetaClient dataMetaClient) {
        return dataMetaClient.getActiveTimeline().getInstantsAsStream().filter(i -> !i.isCompleted()).filter(i -> !"indexing".equals(i.getAction())).map(HoodieInstant::requestedTime).collect(Collectors.toSet());
    }

    private HoodieTableMetaClient initializeMetaClient() throws IOException {
        HoodieTableMetaClient.newTableBuilder().setTableType(HoodieTableType.MERGE_ON_READ).setTableName(this.dataWriteConfig.getTableName() + "_metadata").setTableVersion(this.dataWriteConfig.getWriteVersion()).setArchiveLogFolder((String)HoodieTableConfig.TIMELINE_HISTORY_PATH.defaultValue()).setPayloadClassName(HoodieMetadataPayload.class.getName()).setBaseFileFormat(HoodieFileFormat.HFILE.toString()).setRecordKeyFields(RECORD_KEY_FIELD_NAME).setPopulateMetaFields(false).setKeyGeneratorClassProp(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).initTable(this.storageConf.newInstance(), this.metadataWriteConfig.getBasePath());
        return HoodieTableMetaClient.builder().setBasePath(this.metadataWriteConfig.getBasePath()).setConf(this.storageConf.newInstance()).setTimeGeneratorConfig(this.dataWriteConfig.getTimeGeneratorConfig()).build();
    }

    private List<HoodieTableMetadataUtil.DirectoryInfo> listAllPartitionsFromFilesystem(String initializationTime, Set<String> pendingDataInstants) {
        if (this.dataMetaClient.getActiveTimeline().countInstants() == 0) {
            return Collections.emptyList();
        }
        ArrayDeque<StoragePath> pathsToList = new ArrayDeque<StoragePath>();
        pathsToList.add(new StoragePath(this.dataWriteConfig.getBasePath()));
        LinkedList<HoodieTableMetadataUtil.DirectoryInfo> partitionsToBootstrap = new LinkedList<HoodieTableMetadataUtil.DirectoryInfo>();
        int fileListingParallelism = this.metadataWriteConfig.getFileListingParallelism();
        StorageConfiguration storageConf = this.dataMetaClient.getStorageConf();
        String dirFilterRegex = this.dataWriteConfig.getMetadataConfig().getDirectoryFilterRegex();
        StoragePath storageBasePath = this.dataMetaClient.getBasePath();
        while (!pathsToList.isEmpty()) {
            int numDirsToList = Math.min(fileListingParallelism, pathsToList.size());
            ArrayList pathsToProcess = new ArrayList(numDirsToList);
            for (int i = 0; i < numDirsToList; ++i) {
                pathsToProcess.add(pathsToList.poll());
            }
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Listing " + numDirsToList + " partitions from filesystem");
            List processedDirectories = this.engineContext.map(pathsToProcess, (SerializableFunction & Serializable)path -> {
                HoodieHadoopStorage storage = new HoodieHadoopStorage(path, storageConf);
                String relativeDirPath = FSUtils.getRelativePartitionPath((StoragePath)storageBasePath, (StoragePath)path);
                return new HoodieTableMetadataUtil.DirectoryInfo(relativeDirPath, storage.listDirectEntries(path), initializationTime, pendingDataInstants);
            }, numDirsToList);
            for (HoodieTableMetadataUtil.DirectoryInfo dirInfo : processedDirectories) {
                String relativePath;
                if (!dirFilterRegex.isEmpty() && !(relativePath = dirInfo.getRelativePath()).isEmpty() && relativePath.matches(dirFilterRegex)) {
                    LOG.info("Ignoring directory {} which matches the filter regex {}", (Object)relativePath, (Object)dirFilterRegex);
                    continue;
                }
                if (dirInfo.isHoodiePartition()) {
                    partitionsToBootstrap.add(dirInfo);
                    continue;
                }
                pathsToList.addAll(dirInfo.getSubDirectories());
            }
        }
        return partitionsToBootstrap;
    }

    private List<HoodieTableMetadataUtil.DirectoryInfo> listAllPartitionsFromMDT(String initializationTime, Set<String> pendingDataInstants) throws IOException {
        List allAbsolutePartitionPaths = this.metadata.getAllPartitionPaths().stream().map(partitionPath -> this.dataWriteConfig.getBasePath() + '/' + partitionPath).collect(Collectors.toList());
        Map partitionFileMap = this.metadata.getAllFilesInPartitions(allAbsolutePartitionPaths);
        ArrayList<HoodieTableMetadataUtil.DirectoryInfo> dirinfoList = new ArrayList<HoodieTableMetadataUtil.DirectoryInfo>(partitionFileMap.size());
        for (Map.Entry entry : partitionFileMap.entrySet()) {
            String relativeDirPath = FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(this.dataWriteConfig.getBasePath()), (StoragePath)new StoragePath((String)entry.getKey()));
            dirinfoList.add(new HoodieTableMetadataUtil.DirectoryInfo(relativeDirPath, (List)entry.getValue(), initializationTime, pendingDataInstants, false));
        }
        return dirinfoList;
    }

    private void initializeFileGroups(HoodieTableMetaClient dataMetaClient, MetadataPartitionType metadataPartition, String instantTime, int fileGroupCount, String partitionName) throws IOException {
        StoragePath partitionPath = new StoragePath(this.metadataWriteConfig.getBasePath(), partitionName);
        HoodieStorage storage = this.metadataMetaClient.getStorage();
        try {
            List existingFiles = storage.listDirectEntries(partitionPath);
            if (existingFiles.size() > 0) {
                LOG.warn("Deleting all existing files found in MDT partition {}", (Object)partitionName);
                storage.deleteDirectory(partitionPath);
                ValidationUtils.checkState((!storage.exists(partitionPath) ? 1 : 0) != 0, (String)("Failed to delete MDT partition " + partitionName));
            }
        }
        catch (FileNotFoundException existingFiles) {
            // empty catch block
        }
        String msg = String.format("Creating %d file groups for partition %s with base fileId %s at instant time %s", fileGroupCount, partitionName, metadataPartition.getFileIdPrefix(), instantTime);
        LOG.info(msg);
        List fileGroupFileIds = IntStream.range(0, fileGroupCount).mapToObj(i -> HoodieTableMetadataUtil.getFileIDForFileGroup((MetadataPartitionType)metadataPartition, (int)i, (String)partitionName)).collect(Collectors.toList());
        ValidationUtils.checkArgument((fileGroupFileIds.size() == fileGroupCount ? 1 : 0) != 0);
        this.engineContext.setJobStatus(this.getClass().getSimpleName(), msg);
        this.engineContext.foreach(fileGroupFileIds, (SerializableConsumer & Serializable)fileGroupFileId -> {
            try {
                Map<HoodieLogBlock.HeaderMetadataType, String> blockHeader = Collections.singletonMap(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, instantTime);
                HoodieDeleteBlock block = new HoodieDeleteBlock(Collections.emptyList(), false, blockHeader);
                try (HoodieLogFormat.Writer writer = HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.constructAbsolutePath((String)this.metadataWriteConfig.getBasePath(), (String)partitionName)).withFileId(fileGroupFileId).withInstantTime(instantTime).withLogVersion(HoodieLogFile.LOGFILE_BASE_VERSION.intValue()).withFileSize(0L).withSizeThreshold(this.metadataWriteConfig.getLogFileMaxSize()).withStorage(dataMetaClient.getStorage()).withLogWriteToken("0-0-0").withTableVersion(this.metadataWriteConfig.getWriteVersion()).withFileExtension(".log").build();){
                    writer.appendBlock((HoodieLogBlock)block);
                }
            }
            catch (InterruptedException e) {
                throw new HoodieException(String.format("Failed to created fileGroup %s for partition %s", fileGroupFileId, partitionName), (Throwable)e);
            }
        }, fileGroupFileIds.size());
    }

    @Override
    public void dropMetadataPartitions(List<String> metadataPartitions) throws IOException {
        for (String partitionPath : metadataPartitions) {
            LOG.warn("Deleting Metadata Table partition: {}", (Object)partitionPath);
            this.dataMetaClient.getStorage().deleteDirectory(new StoragePath(this.metadataWriteConfig.getBasePath(), partitionPath));
            LOG.warn("Deleting pending indexing instant from the timeline for partition: {}", (Object)partitionPath);
            HoodieBackedTableMetadataWriter.deletePendingIndexingInstant(this.dataMetaClient, partitionPath);
        }
        this.closeInternal();
    }

    private static void deletePendingIndexingInstant(HoodieTableMetaClient metaClient, String partitionPath) {
        InstantGenerator instantGenerator = metaClient.getInstantGenerator();
        metaClient.reloadActiveTimeline().filterPendingIndexTimeline().getInstantsAsStream().filter(instant -> HoodieInstant.State.REQUESTED.equals((Object)instant.getState())).forEach(instant -> {
            try {
                HoodieIndexPlan indexPlan = TimelineMetadataUtils.deserializeIndexPlan((byte[])((byte[])metaClient.getActiveTimeline().readIndexPlanAsBytes(instant).get()));
                if (indexPlan.getIndexPartitionInfos().stream().anyMatch(indexPartitionInfo -> indexPartitionInfo.getMetadataPartitionPath().equals(partitionPath))) {
                    metaClient.getActiveTimeline().deleteInstantFileIfExists(instant);
                    metaClient.getActiveTimeline().deleteInstantFileIfExists(instantGenerator.getIndexInflightInstant(instant.requestedTime()));
                }
            }
            catch (IOException e) {
                LOG.error("Failed to delete the instant file corresponding to {}", instant);
            }
        });
    }

    private void processAndCommit(String instantTime, ConvertMetadataFunction convertMetadataFunction) {
        Set<String> partitionsToUpdate = this.getMetadataPartitionsToUpdate();
        if (this.initialized && this.metadata != null) {
            Map<String, HoodieData<HoodieRecord>> partitionRecordsMap = convertMetadataFunction.convertMetadata().entrySet().stream().filter(entry -> partitionsToUpdate.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.commit(instantTime, partitionRecordsMap);
        }
    }

    private Set<String> getMetadataPartitionsToUpdate() {
        Set partitionsToUpdate = this.dataMetaClient.getTableConfig().getMetadataPartitions();
        partitionsToUpdate.addAll(HoodieTableMetadataUtil.getInflightMetadataPartitions((HoodieTableConfig)this.dataMetaClient.getTableConfig()));
        if (!partitionsToUpdate.isEmpty()) {
            return partitionsToUpdate;
        }
        LOG.debug("There are no partitions to update according to table config. Falling back to enabled partition types in the write config.");
        return this.getEnabledPartitionTypes().stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toSet());
    }

    @Override
    public void buildMetadataPartitions(HoodieEngineContext engineContext, List<HoodieIndexPartitionInfo> indexPartitionInfos, String instantTime) throws IOException {
        if (indexPartitionInfos.isEmpty()) {
            LOG.warn("No partition to index in the plan");
            return;
        }
        String indexUptoInstantTime = indexPartitionInfos.get(0).getIndexUptoInstant();
        ArrayList partitionPaths = new ArrayList();
        ArrayList<MetadataPartitionType> partitionTypes = new ArrayList<MetadataPartitionType>();
        indexPartitionInfos.forEach(indexPartitionInfo -> {
            String relativePartitionPath = indexPartitionInfo.getMetadataPartitionPath();
            LOG.info("Creating a new metadata index for partition '{}' under path {} upto instant {}", new Object[]{relativePartitionPath, this.metadataWriteConfig.getBasePath(), indexUptoInstantTime});
            MetadataPartitionType partitionType = MetadataPartitionType.fromPartitionPath((String)relativePartitionPath);
            if (!this.enabledPartitionTypes.contains(partitionType)) {
                throw new HoodieIndexException(String.format("Indexing for metadata partition: %s is not enabled", partitionType));
            }
            partitionTypes.add(partitionType);
            partitionPaths.add(relativePartitionPath);
        });
        this.dataMetaClient.getTableConfig().setMetadataPartitionsInflight(this.dataMetaClient, partitionPaths);
        this.initializeFromFilesystem(instantTime, partitionTypes, (Option<String>)Option.empty());
    }

    @Override
    public void update(HoodieCommitMetadata commitMetadata, String instantTime) {
        this.processAndCommit(instantTime, () -> {
            Map partitionToRecordMap = HoodieTableMetadataUtil.convertMetadataToRecords((HoodieEngineContext)this.engineContext, (HoodieConfig)this.dataWriteConfig, (HoodieCommitMetadata)commitMetadata, (String)instantTime, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), this.enabledPartitionTypes, (String)this.dataWriteConfig.getBloomFilterType(), (int)this.dataWriteConfig.getBloomIndexParallelism(), (Integer)this.dataWriteConfig.getWritesFileIdEncoding());
            if (this.dataWriteConfig.isRecordIndexEnabled()) {
                HoodieData<HoodieRecord> additionalUpdates = this.getRecordIndexAdditionalUpserts((HoodieData<HoodieRecord>)((HoodieData)partitionToRecordMap.get(MetadataPartitionType.RECORD_INDEX.getPartitionPath())), commitMetadata);
                partitionToRecordMap.put(MetadataPartitionType.RECORD_INDEX.getPartitionPath(), ((HoodieData)partitionToRecordMap.get(MetadataPartitionType.RECORD_INDEX.getPartitionPath())).union(additionalUpdates));
            }
            this.updateExpressionIndexIfPresent(commitMetadata, instantTime, partitionToRecordMap);
            this.updateSecondaryIndexIfPresent(commitMetadata, partitionToRecordMap, instantTime);
            return partitionToRecordMap;
        });
        this.closeInternal();
    }

    @Override
    public void update(HoodieCommitMetadata commitMetadata, HoodieData<HoodieRecord> records, String instantTime) {
        this.processAndCommit(instantTime, () -> {
            Map partitionToRecordMap = HoodieTableMetadataUtil.convertMetadataToRecords((HoodieEngineContext)this.engineContext, (HoodieConfig)this.dataWriteConfig, (HoodieCommitMetadata)commitMetadata, (String)instantTime, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), this.enabledPartitionTypes, (String)this.dataWriteConfig.getBloomFilterType(), (int)this.dataWriteConfig.getBloomIndexParallelism(), (Integer)this.dataWriteConfig.getWritesFileIdEncoding());
            HoodieData<HoodieRecord> additionalUpdates = this.getRecordIndexAdditionalUpserts(records, commitMetadata);
            partitionToRecordMap.put(MetadataPartitionType.RECORD_INDEX.getPartitionPath(), records.union(additionalUpdates));
            this.updateExpressionIndexIfPresent(commitMetadata, instantTime, partitionToRecordMap);
            return partitionToRecordMap;
        });
        this.closeInternal();
    }

    private void updateExpressionIndexIfPresent(HoodieCommitMetadata commitMetadata, String instantTime, Map<String, HoodieData<HoodieRecord>> partitionToRecordMap) {
        if (!MetadataPartitionType.EXPRESSION_INDEX.isMetadataPartitionAvailable(this.dataMetaClient)) {
            return;
        }
        this.dataMetaClient.getTableConfig().getMetadataPartitions().stream().filter(partition -> partition.startsWith("expr_index_")).forEach(partition -> {
            HoodieData<HoodieRecord> expressionIndexRecords;
            try {
                expressionIndexRecords = this.getExpressionIndexUpdates(commitMetadata, (String)partition, instantTime);
            }
            catch (Exception e) {
                throw new HoodieMetadataException(String.format("Failed to get expression index updates for partition %s", partition), e);
            }
            partitionToRecordMap.put((String)partition, expressionIndexRecords);
        });
    }

    private HoodieData<HoodieRecord> getExpressionIndexUpdates(HoodieCommitMetadata commitMetadata, String indexPartition, String instantTime) throws Exception {
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexPartition);
        ArrayList<Pair<String, Pair<String, Long>>> partitionFilePathPairs = new ArrayList<Pair<String, Pair<String, Long>>>();
        commitMetadata.getPartitionToWriteStats().forEach((dataPartition, writeStats) -> writeStats.forEach(writeStat -> partitionFilePathPairs.add(Pair.of((Object)writeStat.getPartitionPath(), (Object)Pair.of((Object)new StoragePath(this.dataMetaClient.getBasePath(), writeStat.getPath()).toString(), (Object)writeStat.getFileSizeInBytes())))));
        int parallelism = Math.min(partitionFilePathPairs.size(), this.dataWriteConfig.getMetadataConfig().getExpressionIndexParallelism());
        Schema readerSchema = HoodieTableMetadataUtil.getProjectedSchemaForExpressionIndex((HoodieIndexDefinition)indexDefinition, (HoodieTableMetaClient)this.dataMetaClient);
        return this.getExpressionIndexRecords(partitionFilePathPairs, indexDefinition, this.dataMetaClient, parallelism, readerSchema, this.storageConf, instantTime);
    }

    private void updateSecondaryIndexIfPresent(HoodieCommitMetadata commitMetadata, Map<String, HoodieData<HoodieRecord>> partitionToRecordMap, String instantTime) {
        if (!this.dataWriteConfig.isSecondaryIndexEnabled()) {
            return;
        }
        WriteOperationType operationType = commitMetadata.getOperationType();
        if (operationType.isInsertOverwriteOrDeletePartition() && MetadataPartitionType.SECONDARY_INDEX.isMetadataPartitionAvailable(this.dataMetaClient)) {
            throw new HoodieIndexException(String.format("Can not perform operation %s on secondary index", operationType));
        }
        if (operationType == WriteOperationType.COMPACT || operationType == WriteOperationType.CLUSTER) {
            return;
        }
        this.dataMetaClient.getTableConfig().getMetadataPartitions().stream().filter(partition -> partition.startsWith("secondary_index_")).forEach(partition -> {
            HoodieData<HoodieRecord> secondaryIndexRecords;
            try {
                secondaryIndexRecords = this.getSecondaryIndexUpdates(commitMetadata, (String)partition, instantTime);
            }
            catch (Exception e) {
                throw new HoodieMetadataException("Failed to get secondary index updates for partition " + partition, e);
            }
            partitionToRecordMap.put((String)partition, secondaryIndexRecords);
        });
    }

    private HoodieData<HoodieRecord> getSecondaryIndexUpdates(HoodieCommitMetadata commitMetadata, String indexPartition, String instantTime) throws Exception {
        List<Pair<String, Pair<String, List<String>>>> partitionFilePairs = HoodieBackedTableMetadataWriter.getPartitionFilePairs(commitMetadata);
        List keysToRemove = HoodieTableMetadataUtil.getRecordKeysDeletedOrUpdated((HoodieEngineContext)this.engineContext, (HoodieCommitMetadata)commitMetadata, (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), (HoodieTableMetaClient)this.dataMetaClient, (String)instantTime);
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexPartition);
        Map recordKeySecondaryKeyMap = this.metadata.getSecondaryKeys(keysToRemove, indexDefinition.getIndexName());
        HoodieData<HoodieRecord> deletedRecords = this.getDeletedSecondaryRecordMapping(this.engineContext, recordKeySecondaryKeyMap, indexDefinition);
        long totalWriteBytesForSecondaryIndex = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).mapToLong(HoodieWriteStat::getTotalWriteBytes).sum();
        long targetPartitionSize = 0x6400000L;
        int parallelism = (int)Math.max(1L, (totalWriteBytesForSecondaryIndex + targetPartitionSize - 1L) / targetPartitionSize);
        return HoodieTableMetadataUtil.readSecondaryKeysFromBaseFiles((HoodieEngineContext)this.engineContext, partitionFilePairs, (int)parallelism, (String)this.getClass().getSimpleName(), (HoodieTableMetaClient)this.dataMetaClient, (EngineType)this.getEngineType(), (HoodieIndexDefinition)indexDefinition).union(deletedRecords).distinctWithKey(HoodieRecord::getKey, parallelism);
    }

    private static List<Pair<String, Pair<String, List<String>>>> getPartitionFilePairs(HoodieCommitMetadata commitMetadata) {
        ArrayList<Pair<String, Pair<String, List<String>>>> partitionFilePairs = new ArrayList<Pair<String, Pair<String, List<String>>>>();
        commitMetadata.getPartitionToWriteStats().forEach((dataPartition, writeStats) -> writeStats.forEach(writeStat -> {
            if (writeStat instanceof HoodieDeltaWriteStat) {
                partitionFilePairs.add(Pair.of((Object)dataPartition, (Object)Pair.of((Object)((HoodieDeltaWriteStat)writeStat).getBaseFile(), (Object)((HoodieDeltaWriteStat)writeStat).getLogFiles())));
            } else {
                partitionFilePairs.add(Pair.of((Object)dataPartition, (Object)Pair.of((Object)writeStat.getPath(), Collections.emptyList())));
            }
        }));
        return partitionFilePairs;
    }

    @Override
    public void update(HoodieCleanMetadata cleanMetadata, String instantTime) {
        this.processAndCommit(instantTime, () -> HoodieTableMetadataUtil.convertMetadataToRecords((HoodieEngineContext)this.engineContext, (HoodieCleanMetadata)cleanMetadata, (String)instantTime, (HoodieTableMetaClient)this.dataMetaClient, (HoodieMetadataConfig)this.dataWriteConfig.getMetadataConfig(), this.enabledPartitionTypes, (int)this.dataWriteConfig.getBloomIndexParallelism()));
        this.closeInternal();
    }

    @Override
    public void update(HoodieRestoreMetadata restoreMetadata, String instantTime) {
        this.dataMetaClient.reloadActiveTimeline();
        InstantGenerator datainstantGenerator = this.dataMetaClient.getInstantGenerator();
        HoodieInstant restoreInstant = datainstantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "restore", instantTime);
        HoodieInstant requested = datainstantGenerator.getRestoreRequestedInstant(restoreInstant);
        HoodieRestorePlan restorePlan = null;
        try {
            restorePlan = (HoodieRestorePlan)TimelineMetadataUtils.deserializeAvroMetadata((byte[])((byte[])this.dataMetaClient.getActiveTimeline().readRestoreInfoAsBytes(requested).get()), HoodieRestorePlan.class);
        }
        catch (IOException e) {
            throw new HoodieIOException(String.format("Deserialization of restore plan failed whose restore instant time is %s in data table", instantTime), e);
        }
        String restoreToInstantTime = restorePlan.getSavepointToRestoreTimestamp();
        LOG.info("Triggering restore to {} in metadata table", (Object)restoreToInstantTime);
        List filesGroups = this.metadata.getMetadataFileSystemView().getAllFileGroups(MetadataPartitionType.FILES.getPartitionPath()).collect(Collectors.toList());
        boolean cannotRestore = filesGroups.stream().map(fileGroup -> fileGroup.getAllFileSlices().map(FileSlice::getBaseInstantTime).anyMatch(instantTime1 -> InstantComparison.compareTimestamps((String)instantTime1, (BiPredicate)InstantComparison.LESSER_THAN_OR_EQUALS, (String)restoreToInstantTime))).anyMatch(canRestore -> canRestore == false);
        if (cannotRestore) {
            throw new HoodieMetadataException(String.format("Can't restore to %s since there is no base file in MDT lesser than the commit to restore to. Please delete metadata table and retry", restoreToInstantTime));
        }
        List<HoodieTableMetadataUtil.DirectoryInfo> dirInfoList = this.listAllPartitionsFromFilesystem(instantTime, Collections.emptySet());
        Map<String, HoodieTableMetadataUtil.DirectoryInfo> dirInfoMap = dirInfoList.stream().collect(Collectors.toMap(HoodieTableMetadataUtil.DirectoryInfo::getRelativePath, Function.identity()));
        dirInfoList.clear();
        BaseHoodieWriteClient<?, I, ?, ?> writeClient = this.getWriteClient();
        writeClient.restoreToInstant(restoreToInstantTime, false);
        try {
            this.initMetadataReader();
            HashMap<String, Map<String, Long>> partitionFilesToAdd = new HashMap<String, Map<String, Long>>();
            HashMap<String, List<String>> partitionFilesToDelete = new HashMap<String, List<String>>();
            ArrayList<String> partitionsToDelete = new ArrayList<String>();
            this.fetchOutofSyncFilesRecordsFromMetadataTable(dirInfoMap, partitionFilesToAdd, partitionFilesToDelete, partitionsToDelete);
            String syncCommitTime = writeClient.createNewInstantTime(false);
            this.processAndCommit(syncCommitTime, () -> HoodieTableMetadataUtil.convertMissingPartitionRecords((HoodieEngineContext)this.engineContext, (List)partitionsToDelete, (Map)partitionFilesToAdd, (Map)partitionFilesToDelete, (String)syncCommitTime));
            this.closeInternal();
        }
        catch (IOException e) {
            throw new HoodieMetadataException("IOException during MDT restore sync", (Exception)e);
        }
    }

    @Override
    public void update(HoodieRollbackMetadata rollbackMetadata, String instantTime) {
        if (this.initialized && this.metadata != null) {
            String commitToRollbackInstantTime = (String)rollbackMetadata.getCommitsRollback().get(0);
            HoodieInstant deltaCommitInstant = this.metadataMetaClient.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", commitToRollbackInstantTime);
            if (this.metadataMetaClient.getActiveTimeline().getDeltaCommitTimeline().containsInstant(deltaCommitInstant)) {
                this.validateRollback(commitToRollbackInstantTime);
                LOG.info("Rolling back MDT deltacommit {}", (Object)commitToRollbackInstantTime);
                if (!this.getWriteClient().rollback(commitToRollbackInstantTime, instantTime)) {
                    throw new HoodieMetadataException(String.format("Failed to rollback deltacommit at %s", commitToRollbackInstantTime));
                }
            } else {
                LOG.info("Ignoring rollback of instant {} at {}. The commit to rollback is not found in MDT", (Object)commitToRollbackInstantTime, (Object)instantTime);
            }
            this.closeInternal();
        }
    }

    private void validateRollback(String commitToRollbackInstantTime) {
        Option deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompaction((HoodieActiveTimeline)this.metadataMetaClient.getActiveTimeline());
        HoodieInstant compactionInstant = (HoodieInstant)((Pair)deltaCommitsInfo.get()).getValue();
        HoodieTimeline deltacommitsSinceCompaction = (HoodieTimeline)((Pair)deltaCommitsInfo.get()).getKey();
        if (compactionInstant.getAction().equals("commit")) {
            String compactionInstantTime = compactionInstant.requestedTime();
            if (commitToRollbackInstantTime.length() == compactionInstantTime.length() && InstantComparison.LESSER_THAN_OR_EQUALS.test(commitToRollbackInstantTime, compactionInstantTime)) {
                throw new HoodieMetadataException(String.format("Commit being rolled back %s is earlier than the latest compaction %s. There are %d deltacommits after this compaction: %s", commitToRollbackInstantTime, compactionInstantTime, deltacommitsSinceCompaction.countInstants(), deltacommitsSinceCompaction.getInstants()));
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.metadata != null) {
            this.metadata.close();
        }
        if (this.writeClient != null) {
            this.writeClient.close();
            this.writeClient = null;
        }
        if (this.metadataView != null) {
            this.metadataView = null;
        }
    }

    protected abstract void commit(String var1, Map<String, HoodieData<HoodieRecord>> var2);

    protected abstract I convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> var1);

    protected void commitInternal(String instantTime, Map<String, HoodieData<HoodieRecord>> partitionRecordsMap, boolean isInitializing, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        ValidationUtils.checkState((this.metadataMetaClient != null ? 1 : 0) != 0, (String)"Metadata table is not fully initialized yet.");
        HoodieData<HoodieRecord> preppedRecords = this.prepRecords(partitionRecordsMap);
        I preppedRecordInputs = this.convertHoodieDataToEngineSpecificData(preppedRecords);
        BaseHoodieWriteClient<?, I, ?, ?> writeClient = this.getWriteClient();
        if (this.dataWriteConfig.getFailedWritesCleanPolicy().isEager() && writeClient.rollbackFailedWrites()) {
            this.metadataMetaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metadataMetaClient);
        }
        if (!this.metadataMetaClient.getActiveTimeline().getCommitsTimeline().containsInstant(instantTime)) {
            LOG.info("New commit at {} being applied to MDT.", (Object)instantTime);
        } else {
            Option alreadyCompletedInstant = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().filter(entry -> entry.requestedTime().equals(instantTime)).lastInstant();
            LOG.info("{} completed commit at {} being applied to MDT.", (Object)(alreadyCompletedInstant.isPresent() ? "Already" : "Partially"), (Object)instantTime);
            if (!writeClient.rollback(instantTime)) {
                throw new HoodieMetadataException(String.format("Failed to rollback deltacommit at %s from MDT", instantTime));
            }
            this.metadataMetaClient.reloadActiveTimeline();
        }
        writeClient.startCommitWithTime(instantTime);
        this.preWrite(instantTime);
        if (isInitializing) {
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), String.format("Bulk inserting at %s into metadata table %s", instantTime, this.metadataWriteConfig.getTableName()));
            writeClient.bulkInsertPreppedRecords(preppedRecordInputs, instantTime, bulkInsertPartitioner);
        } else {
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), String.format("Upserting at %s into metadata table %s", instantTime, this.metadataWriteConfig.getTableName()));
            writeClient.upsertPreppedRecords(preppedRecordInputs, instantTime);
        }
        this.metadataMetaClient.reloadActiveTimeline();
        this.metrics.ifPresent(m -> m.updateSizeMetrics(this.metadataMetaClient, this.metadata, this.dataMetaClient.getTableConfig().getMetadataPartitions()));
    }

    protected void preWrite(String instantTime) {
    }

    protected abstract void bulkCommit(String var1, String var2, HoodieData<HoodieRecord> var3, int var4);

    protected HoodieData<HoodieRecord> prepRecords(Map<String, HoodieData<HoodieRecord>> partitionRecordsMap) {
        HoodieData allPartitionRecords = this.engineContext.emptyHoodieData();
        try (HoodieTableFileSystemView fsView = HoodieTableMetadataUtil.getFileSystemView((HoodieTableMetaClient)this.metadataMetaClient);){
            for (Map.Entry<String, HoodieData<HoodieRecord>> entry : partitionRecordsMap.entrySet()) {
                int fileGroupCount;
                String partitionName = entry.getKey();
                HoodieData<HoodieRecord> records = entry.getValue();
                List fileSlices = HoodieTableMetadataUtil.getPartitionLatestFileSlices((HoodieTableMetaClient)this.metadataMetaClient, (Option)Option.ofNullable((Object)fsView), (String)partitionName);
                if (fileSlices.isEmpty()) {
                    fileSlices = HoodieTableMetadataUtil.getPartitionLatestFileSlicesIncludingInflight((HoodieTableMetaClient)this.metadataMetaClient, (Option)Option.ofNullable((Object)fsView), (String)partitionName);
                }
                ValidationUtils.checkArgument(((fileGroupCount = fileSlices.size()) > 0 ? 1 : 0) != 0, (String)String.format("FileGroup count for MDT partition %s should be > 0", partitionName));
                List finalFileSlices = fileSlices;
                HoodieData rddSinglePartitionRecords = records.map((SerializableFunction & Serializable)r -> {
                    FileSlice slice = (FileSlice)finalFileSlices.get(HoodieTableMetadataUtil.mapRecordKeyToFileGroupIndex((String)r.getRecordKey(), (int)fileGroupCount));
                    r.unseal();
                    r.setCurrentLocation(new HoodieRecordLocation(slice.getBaseInstantTime(), slice.getFileId()));
                    r.seal();
                    return r;
                });
                allPartitionRecords = allPartitionRecords.union(rddSinglePartitionRecords);
            }
            HoodieData hoodieData = allPartitionRecords;
            return hoodieData;
        }
    }

    @Override
    public void performTableServices(Option<String> inFlightInstantTimestamp) {
        HoodieTimer metadataTableServicesTimer = HoodieTimer.start();
        boolean allTableServicesExecutedSuccessfullyOrSkipped = true;
        BaseHoodieWriteClient<?, I, ?, ?> writeClient = this.getWriteClient();
        try {
            this.runPendingTableServicesOperations(writeClient);
            Option lastInstant = this.metadataMetaClient.reloadActiveTimeline().getDeltaCommitTimeline().filterCompletedInstants().lastInstant();
            if (!lastInstant.isPresent()) {
                return;
            }
            this.cleanIfNecessary(writeClient);
            if (this.validateCompactionScheduling()) {
                String latestDeltacommitTime = ((HoodieInstant)lastInstant.get()).requestedTime();
                LOG.info("Latest deltacommit time found is {}, running compaction operations.", (Object)latestDeltacommitTime);
                this.compactIfNecessary(writeClient);
            }
            writeClient.archive();
            LOG.info("All the table services operations on MDT completed successfully");
        }
        catch (Exception e) {
            LOG.error("Exception in running table services on metadata table", (Throwable)e);
            allTableServicesExecutedSuccessfullyOrSkipped = false;
            throw e;
        }
        finally {
            long timeSpent = metadataTableServicesTimer.endTimer();
            this.metrics.ifPresent(m -> m.setMetric("table_service_execution_duration", timeSpent));
            if (allTableServicesExecutedSuccessfullyOrSkipped) {
                this.metrics.ifPresent(m -> m.setMetric("table_service_execution_status", 1L));
            } else {
                this.metrics.ifPresent(m -> m.setMetric("table_service_execution_status", -1L));
            }
        }
    }

    private void runPendingTableServicesOperations(BaseHoodieWriteClient writeClient) {
        writeClient.runAnyPendingCompactions();
        writeClient.runAnyPendingLogCompactions();
    }

    protected void compactIfNecessary(BaseHoodieWriteClient writeClient) {
        HoodieTimeline metadataCompletedTimeline = this.metadataMetaClient.getActiveTimeline().filterCompletedInstants();
        String compactionInstantTime = (String)this.dataMetaClient.reloadActiveTimeline().filterInflightsAndRequested().filter(instant -> metadataCompletedTimeline.containsInstant(instant.requestedTime())).firstInstant().map(instant -> HoodieInstantTimeGenerator.instantTimeMinusMillis((String)instant.requestedTime(), (long)1L)).orElse((Object)writeClient.createNewInstantTime(false));
        if (this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().containsInstant(compactionInstantTime)) {
            LOG.info("Compaction with same {} time is already present in the timeline.", (Object)compactionInstantTime);
        } else if (writeClient.scheduleCompactionAtInstant(compactionInstantTime, (Option<Map<String, String>>)Option.empty())) {
            LOG.info("Compaction is scheduled for timestamp {}", (Object)compactionInstantTime);
            writeClient.compact(compactionInstantTime);
        } else if (this.metadataWriteConfig.isLogCompactionEnabled()) {
            String logCompactionInstantTime = this.metadataMetaClient.createNewInstantTime(false);
            if (this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().containsInstant(logCompactionInstantTime)) {
                LOG.info("Log compaction with same {} time is already present in the timeline.", (Object)logCompactionInstantTime);
            } else if (writeClient.scheduleLogCompactionAtInstant(logCompactionInstantTime, (Option<Map<String, String>>)Option.empty())) {
                LOG.info("Log compaction is scheduled for timestamp {}", (Object)logCompactionInstantTime);
                writeClient.logCompact(logCompactionInstantTime);
            }
        }
    }

    protected void cleanIfNecessary(BaseHoodieWriteClient writeClient) {
        Option lastCompletedCompactionInstant = this.metadataMetaClient.reloadActiveTimeline().getCommitAndReplaceTimeline().filterCompletedInstants().lastInstant();
        if (lastCompletedCompactionInstant.isPresent() && this.metadataMetaClient.getActiveTimeline().filterCompletedInstants().findInstantsAfter(((HoodieInstant)lastCompletedCompactionInstant.get()).requestedTime()).countInstants() < 3) {
            return;
        }
        writeClient.clean(this.metadataMetaClient.createNewInstantTime(false));
        writeClient.lazyRollbackFailedIndexing();
    }

    protected boolean validateCompactionScheduling() {
        if (this.metadataWriteConfig.isLogCompactionEnabled()) {
            Option pendingLogCompactionInstant = this.metadataMetaClient.getActiveTimeline().filterPendingLogCompactionTimeline().firstInstant();
            Option pendingCompactionInstant = this.metadataMetaClient.getActiveTimeline().filterPendingCompactionTimeline().firstInstant();
            if (pendingLogCompactionInstant.isPresent() || pendingCompactionInstant.isPresent()) {
                LOG.warn("Not scheduling compaction or logCompaction, since a pending compaction instant {} or logCompaction {} instant is present", (Object)pendingCompactionInstant, (Object)pendingLogCompactionInstant);
                return false;
            }
        }
        return true;
    }

    private void fetchOutofSyncFilesRecordsFromMetadataTable(Map<String, HoodieTableMetadataUtil.DirectoryInfo> dirInfoMap, Map<String, Map<String, Long>> partitionFilesToAdd, Map<String, List<String>> partitionFilesToDelete, List<String> partitionsToDelete) throws IOException {
        for (String partition : this.metadata.fetchAllPartitionPaths()) {
            StoragePath partitionPath = null;
            partitionPath = StringUtils.isNullOrEmpty((String)partition) && !this.dataMetaClient.getTableConfig().isTablePartitioned() ? new StoragePath(this.dataWriteConfig.getBasePath()) : new StoragePath(this.dataWriteConfig.getBasePath(), partition);
            String partitionId = HoodieTableMetadataUtil.getPartitionIdentifierForFilesPartition((String)partition);
            List metadataFiles = this.metadata.getAllFilesInPartition(partitionPath);
            if (!dirInfoMap.containsKey(partition)) {
                partitionsToDelete.add(partitionId);
                if (metadataFiles == null || metadataFiles.size() <= 0) continue;
                partitionFilesToDelete.put(partitionId, metadataFiles.stream().map(f -> f.getPath().getName()).collect(Collectors.toList()));
                continue;
            }
            Map fsFiles = dirInfoMap.get(partition).getFileNameToSizeMap();
            List mdtFiles = metadataFiles.stream().map(mdtFile -> mdtFile.getPath().getName()).collect(Collectors.toList());
            List filesDeleted = metadataFiles.stream().map(f -> f.getPath().getName()).filter(n -> !fsFiles.containsKey(n)).collect(Collectors.toList());
            HashMap filesToAdd = new HashMap();
            dirInfoMap.get(partition).getFileNameToSizeMap().forEach((k, v) -> {
                if (!mdtFiles.contains(k)) {
                    filesToAdd.put(k, v);
                }
            });
            if (!filesToAdd.isEmpty()) {
                partitionFilesToAdd.put(partitionId, filesToAdd);
            }
            if (filesDeleted.isEmpty()) continue;
            partitionFilesToDelete.put(partitionId, filesDeleted);
        }
    }

    private HoodieData<HoodieRecord> getRecordIndexReplacedRecords(HoodieReplaceCommitMetadata replaceCommitMetadata) {
        try (HoodieMetadataFileSystemView fsView = this.getMetadataView();){
            List partitionBaseFilePairs = replaceCommitMetadata.getPartitionToReplaceFileIds().keySet().stream().flatMap(partition -> fsView.getLatestBaseFiles(partition).map(f -> Pair.of((Object)partition, (Object)f))).collect(Collectors.toList());
            HoodieData hoodieData = HoodieTableMetadataUtil.readRecordKeysFromBaseFiles((HoodieEngineContext)this.engineContext, (HoodieConfig)this.dataWriteConfig, partitionBaseFilePairs, (boolean)true, (int)this.dataWriteConfig.getMetadataConfig().getRecordIndexMaxParallelism(), (StoragePath)this.dataMetaClient.getBasePath(), this.storageConf, (String)this.getClass().getSimpleName());
            return hoodieData;
        }
    }

    private HoodieData<HoodieRecord> getRecordIndexAdditionalUpserts(HoodieData<HoodieRecord> updatesFromWriteStatuses, HoodieCommitMetadata commitMetadata) {
        WriteOperationType operationType = commitMetadata.getOperationType();
        if (operationType == WriteOperationType.INSERT_OVERWRITE) {
            return this.getRecordIndexReplacedRecords((HoodieReplaceCommitMetadata)commitMetadata).mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getKey(), (Object)r)).leftOuterJoin(updatesFromWriteStatuses.mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getKey(), (Object)r))).values().filter((SerializableFunction & Serializable)p -> !((Option)p.getRight()).isPresent()).map(Pair::getLeft);
        }
        if (operationType == WriteOperationType.INSERT_OVERWRITE_TABLE) {
            return this.getRecordIndexReplacedRecords((HoodieReplaceCommitMetadata)commitMetadata).mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getRecordKey(), (Object)r)).leftOuterJoin(updatesFromWriteStatuses.mapToPair((SerializablePairFunction & Serializable)r -> Pair.of((Object)r.getRecordKey(), (Object)r))).values().filter((SerializableFunction & Serializable)p -> !((Option)p.getRight()).isPresent()).map(Pair::getLeft);
        }
        if (operationType == WriteOperationType.DELETE_PARTITION) {
            return this.getRecordIndexReplacedRecords((HoodieReplaceCommitMetadata)commitMetadata);
        }
        return this.engineContext.emptyHoodieData();
    }

    protected void closeInternal() {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new HoodieException("Failed to close HoodieMetadata writer ", (Throwable)e);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected BaseHoodieWriteClient<?, I, ?, ?> getWriteClient() {
        if (this.writeClient == null) {
            this.writeClient = this.initializeWriteClient();
        }
        return this.writeClient;
    }

    protected abstract BaseHoodieWriteClient<?, I, ?, ?> initializeWriteClient();

    private static /* synthetic */ Pair lambda$initializeRecordIndexPartition$13(String partition, HoodieBaseFile basefile) {
        return Pair.of((Object)partition, (Object)basefile);
    }

    private static interface ConvertMetadataFunction {
        public Map<String, HoodieData<HoodieRecord>> convertMetadata();
    }
}

