/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;

public class BootstrapUtils {
    public static List<Pair<String, List<HoodieFileStatus>>> getAllLeafFoldersWithFiles(HoodieFileFormat baseFileFormat, HoodieStorage storage, String basePathStr, HoodieEngineContext context) throws IOException {
        StoragePath basePath = new StoragePath(basePathStr);
        String baseFileExtension = baseFileFormat.getFileExtension();
        HashMap levelToPartitions = new HashMap();
        HashMap partitionToFiles = new HashMap();
        StoragePathFilter filePathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
        StoragePathFilter metaPathFilter = BootstrapUtils.getExcludeMetaPathFilter();
        List topLevelPathInfos = storage.listDirectEntries(basePath);
        ArrayList<String> subDirectories = new ArrayList<String>();
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (StoragePathInfo topLevelPathInfo : topLevelPathInfos) {
            if (topLevelPathInfo.isFile() && filePathFilter.accept(topLevelPathInfo.getPath())) {
                String relativePath = FSUtils.getRelativePartitionPath((StoragePath)basePath, (StoragePath)topLevelPathInfo.getPath().getParent());
                Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                HoodieFileStatus hoodieFileStatus = FSUtils.fromPathInfo((StoragePathInfo)topLevelPathInfo);
                result.add(Pair.of((Object)hoodieFileStatus, (Object)Pair.of((Object)level, (Object)relativePath)));
                continue;
            }
            if (!topLevelPathInfo.isDirectory() || !metaPathFilter.accept(topLevelPathInfo.getPath())) continue;
            subDirectories.add(topLevelPathInfo.getPath().toString());
        }
        if (!subDirectories.isEmpty()) {
            result.addAll(context.flatMap(subDirectories, (SerializableFunction & Serializable)directory -> {
                StoragePathFilter pathFilter = BootstrapUtils.getFilePathFilter(baseFileExtension);
                StoragePath path = new StoragePath(directory);
                HoodieStorage tmpStorage = HoodieStorageUtils.getStorage((StoragePath)path, (StorageConfiguration)HadoopFSUtils.getStorageConf());
                return tmpStorage.listFiles(path).stream().filter(pathInfo -> pathFilter.accept(pathInfo.getPath())).map(pathInfo -> {
                    String relativePath = FSUtils.getRelativePartitionPath((StoragePath)basePath, (StoragePath)pathInfo.getPath().getParent());
                    Integer level = (int)relativePath.chars().filter(ch -> ch == 47).count();
                    HoodieFileStatus hoodieFileStatus = FSUtils.fromPathInfo((StoragePathInfo)pathInfo);
                    return Pair.of((Object)hoodieFileStatus, (Object)Pair.of((Object)level, (Object)relativePath));
                });
            }, subDirectories.size()));
        }
        result.forEach(val -> {
            String relativePath = (String)((Pair)val.getRight()).getRight();
            ArrayList<Object> statusList = (ArrayList<Object>)partitionToFiles.get(relativePath);
            if (null == statusList) {
                Integer level = (Integer)((Pair)val.getRight()).getLeft();
                ArrayList<String> dirs = (ArrayList<String>)levelToPartitions.get(level);
                if (null == dirs) {
                    dirs = new ArrayList<String>();
                    levelToPartitions.put(level, dirs);
                }
                dirs.add(relativePath);
                statusList = new ArrayList<Object>();
                partitionToFiles.put(relativePath, statusList);
            }
            statusList.add(val.getLeft());
        });
        OptionalInt maxLevelOpt = levelToPartitions.keySet().stream().mapToInt(x -> x).max();
        int maxLevel = maxLevelOpt.orElse(-1);
        return maxLevel >= 0 ? ((List)levelToPartitions.get(maxLevel)).stream().map(d -> Pair.of((Object)d, partitionToFiles.get(d))).collect(Collectors.toList()) : new ArrayList<Pair<String, List<HoodieFileStatus>>>();
    }

    private static StoragePathFilter getFilePathFilter(String baseFileExtension) {
        return (StoragePathFilter & Serializable)path -> path.getName().endsWith(baseFileExtension);
    }

    private static StoragePathFilter getExcludeMetaPathFilter() {
        return (StoragePathFilter & Serializable)path -> !path.toString().contains(".hoodie");
    }
}

