/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.action.rollback.SerializableHoodieRollbackRequest;
import org.apache.hudi.util.CommonClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRollbackHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseRollbackHelper.class);
    protected static final String EMPTY_STRING = "";
    protected final HoodieTableMetaClient metaClient;
    protected final HoodieWriteConfig config;

    public BaseRollbackHelper(HoodieTableMetaClient metaClient, HoodieWriteConfig config) {
        this.metaClient = metaClient;
        this.config = config;
    }

    public List<HoodieRollbackStat> performRollback(HoodieEngineContext context, HoodieInstant instantToRollback, List<HoodieRollbackRequest> rollbackRequests) {
        int parallelism = Math.max(Math.min(rollbackRequests.size(), this.config.getRollbackParallelism()), 1);
        context.setJobStatus(this.getClass().getSimpleName(), "Perform rollback actions: " + this.config.getTableName());
        List<SerializableHoodieRollbackRequest> serializableRequests = rollbackRequests.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList());
        return context.reduceByKey(this.maybeDeleteAndCollectStats(context, instantToRollback, serializableRequests, true, parallelism), RollbackUtils::mergeRollbackStat, parallelism);
    }

    public List<HoodieRollbackStat> collectRollbackStats(HoodieEngineContext context, HoodieInstant instantToRollback, List<HoodieRollbackRequest> rollbackRequests) {
        int parallelism = Math.max(Math.min(rollbackRequests.size(), this.config.getRollbackParallelism()), 1);
        context.setJobStatus(this.getClass().getSimpleName(), "Collect rollback stats for upgrade/downgrade: " + this.config.getTableName());
        List<SerializableHoodieRollbackRequest> serializableRequests = rollbackRequests.stream().map(SerializableHoodieRollbackRequest::new).collect(Collectors.toList());
        return context.reduceByKey(this.maybeDeleteAndCollectStats(context, instantToRollback, serializableRequests, false, parallelism), RollbackUtils::mergeRollbackStat, parallelism);
    }

    List<Pair<String, HoodieRollbackStat>> maybeDeleteAndCollectStats(HoodieEngineContext context, HoodieInstant instantToRollback, List<SerializableHoodieRollbackRequest> rollbackRequests, boolean doDelete, int numPartitions) {
        TaskContextSupplier taskContextSupplier = context.getTaskContextSupplier();
        return context.flatMap(rollbackRequests, (SerializableFunction & Serializable)rollbackRequest -> {
            List<String> filesToBeDeleted = rollbackRequest.getFilesToBeDeleted();
            if (!filesToBeDeleted.isEmpty()) {
                List<HoodieRollbackStat> rollbackStats = this.deleteFiles(this.metaClient, filesToBeDeleted, doDelete);
                ArrayList partitionToRollbackStats = new ArrayList();
                rollbackStats.forEach(entry -> partitionToRollbackStats.add(Pair.of((Object)entry.getPartitionPath(), (Object)entry)));
                return partitionToRollbackStats.stream();
            }
            if (!rollbackRequest.getLogBlocksToBeDeleted().isEmpty()) {
                StoragePath filePath;
                HoodieLogFormat.Writer writer = null;
                try {
                    String fileId = rollbackRequest.getFileId();
                    HoodieTableVersion tableVersion = this.metaClient.getTableConfig().getTableVersion();
                    writer = HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.constructAbsolutePath((StoragePath)this.metaClient.getBasePath(), (String)rollbackRequest.getPartitionPath())).withFileId(fileId).withLogWriteToken(CommonClientUtils.generateWriteToken(taskContextSupplier)).withInstantTime(tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT) ? instantToRollback.requestedTime() : rollbackRequest.getLatestBaseInstant()).withStorage(this.metaClient.getStorage()).withTableVersion(tableVersion).withFileExtension(".log").build();
                    if (doDelete) {
                        Map<HoodieLogBlock.HeaderMetadataType, String> header = this.generateHeader(instantToRollback.requestedTime());
                        filePath = writer.appendBlock((HoodieLogBlock)new HoodieCommandBlock(header)).logFile().getPath();
                    } else {
                        filePath = writer.getLogFile().getPath();
                    }
                }
                catch (IOException | InterruptedException io) {
                    throw new HoodieRollbackException("Failed to rollback for instant " + instantToRollback, io);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException io) {
                        throw new HoodieIOException("Error appending rollback block", io);
                    }
                }
                Map<StoragePathInfo, Long> filesToNumBlocksRollback = Collections.singletonMap(this.metaClient.getStorage().getPathInfo(Objects.requireNonNull(filePath)), 1L);
                return Stream.of(Pair.of((Object)rollbackRequest.getPartitionPath(), (Object)HoodieRollbackStat.newBuilder().withPartitionPath(rollbackRequest.getPartitionPath()).withRollbackBlockAppendResults(filesToNumBlocksRollback).build()));
            }
            return Stream.of(Pair.of((Object)rollbackRequest.getPartitionPath(), (Object)HoodieRollbackStat.newBuilder().withPartitionPath(rollbackRequest.getPartitionPath()).build()));
        }, numPartitions);
    }

    protected List<HoodieRollbackStat> deleteFiles(HoodieTableMetaClient metaClient, List<String> filesToBeDeleted, boolean doDelete) throws IOException {
        return filesToBeDeleted.stream().map(fileToDelete -> {
            String basePath = metaClient.getBasePath().toString();
            try {
                StoragePath fullDeletePath = new StoragePath(fileToDelete);
                String partitionPath = FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(basePath), (StoragePath)fullDeletePath.getParent());
                boolean isDeleted = true;
                if (doDelete) {
                    try {
                        isDeleted = metaClient.getStorage().deleteFile(fullDeletePath);
                    }
                    catch (FileNotFoundException e) {
                        isDeleted = true;
                    }
                }
                return HoodieRollbackStat.newBuilder().withPartitionPath(partitionPath).withDeletedFileResult(fullDeletePath.toString(), isDeleted).build();
            }
            catch (IOException e) {
                LOG.error("Fetching file status for ");
                throw new HoodieIOException("Fetching file status for " + fileToDelete + " failed ", e);
            }
        }).collect(Collectors.toList());
    }

    protected Map<HoodieLogBlock.HeaderMetadataType, String> generateHeader(String commit) {
        HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>(3);
        header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, ((HoodieInstant)this.metaClient.getActiveTimeline().lastInstant().get()).requestedTime());
        header.put(HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME, commit);
        header.put(HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE, String.valueOf(HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK.ordinal()));
        return header;
    }
}

