/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonClientUtils.class);

    public static void validateTableVersion(HoodieTableConfig tableConfig, HoodieWriteConfig writeConfig) {
        if (!tableConfig.getTableVersion().equals((Object)writeConfig.getWriteVersion())) {
            if (tableConfig.getTableVersion().greaterThan(HoodieTableVersion.SIX) && writeConfig.getWriteVersion().equals((Object)HoodieTableVersion.SIX)) {
                LOG.warn("Table version is greater than 6, while writer version is 6. Allowing it for upgrade.");
            } else {
                throw new HoodieNotSupportedException(String.format("Table version (%s) and Writer version (%s) do not match for table at: %s.", tableConfig.getTableVersion(), writeConfig.getWriteVersion(), writeConfig.getBasePath()));
            }
        }
        if (tableConfig.getTableVersion().lesserThan(HoodieTableVersion.EIGHT) && writeConfig.shouldWritePartialUpdates()) {
            throw new HoodieNotSupportedException("Partial updates are not supported for table versions < 8. Please unset " + HoodieWriteConfig.WRITE_PARTIAL_UPDATE_SCHEMA.key());
        }
        if (tableConfig.getTableVersion().lesserThan(HoodieTableVersion.EIGHT) && writeConfig.isNonBlockingConcurrencyControl()) {
            throw new HoodieNotSupportedException("Non-blocking concurrency control is not supported for table versions < 8.");
        }
    }

    public static String generateWriteToken(TaskContextSupplier taskContextSupplier) {
        try {
            return FSUtils.makeWriteToken((int)((Integer)taskContextSupplier.getPartitionIdSupplier().get()), (int)((Integer)taskContextSupplier.getStageIdSupplier().get()), (long)((Long)taskContextSupplier.getAttemptIdSupplier().get()));
        }
        catch (Throwable t) {
            LOG.warn("Error generating write token, using default.", t);
            return "0-0-0";
        }
    }
}

