/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hudi.async.HoodieAsyncTableService;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestHoodieAsyncTableService {
    TestHoodieAsyncTableService() {
    }

    @Test
    void tableServiceShouldNotStartIfDisabled(@Mock HoodieWriteConfig config) {
        Mockito.when((Object)config.areTableServicesEnabled()).thenReturn((Object)false);
        DummyAsyncTableService service = new DummyAsyncTableService(config);
        service.start(null);
        Assertions.assertFalse((boolean)service.isStarted());
    }

    private static class DummyAsyncTableService
    extends HoodieAsyncTableService {
        protected DummyAsyncTableService(HoodieWriteConfig writeConfig) {
            super(writeConfig);
        }

        protected Pair<CompletableFuture, ExecutorService> startService() {
            return null;
        }
    }
}

