/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.timeline.service.TimelineService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestEmbeddedTimelineService
extends HoodieCommonTestHarness {
    @Test
    public void embeddedTimelineServiceReused() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf());
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table1").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService);
        Mockito.when((Object)mockService.startService()).thenReturn((Object)123);
        EmbeddedTimelineService service1 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig1, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator);
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table2").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteTimelineClientRetry(true).build()).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator2 = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        EmbeddedTimelineService service2 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig2, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator2);
        Assertions.assertSame((Object)service1, (Object)service2);
        Assertions.assertFalse((boolean)service1.getRemoteFileSystemViewConfig(writeConfig1).isRemoteTimelineClientRetryEnabled());
        Assertions.assertTrue((boolean)service1.getRemoteFileSystemViewConfig(writeConfig2).isRemoteTimelineClientRetryEnabled());
        service1.stopForBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.never())).close();
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig2.getBasePath());
        service2.stopForBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void embeddedTimelineServiceCreatedForDifferentMetadataConfig() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf());
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table1").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService);
        Mockito.when((Object)mockService.startService()).thenReturn((Object)321);
        EmbeddedTimelineService service1 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig1, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator);
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table2").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator2 = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService2 = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator2.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService2);
        Mockito.when((Object)mockService2.startService()).thenReturn((Object)456);
        EmbeddedTimelineService service2 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig2, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator2);
        Assertions.assertNotSame((Object)service1, (Object)service2);
        service1.stopForBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).close();
        service2.stopForBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService2, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void embeddedTimelineServerNotReusedIfReuseDisabled() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf());
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table1").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService);
        Mockito.when((Object)mockService.startService()).thenReturn((Object)789);
        EmbeddedTimelineService service1 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig1, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator);
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table2").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(false).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator2 = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService2 = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator2.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService2);
        Mockito.when((Object)mockService2.startService()).thenReturn((Object)987);
        EmbeddedTimelineService service2 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig2, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator2);
        Assertions.assertNotSame((Object)service1, (Object)service2);
        service1.stopForBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).close();
        service2.stopForBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService2, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService2, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void embeddedTimelineServerIsNotReusedAfterStopped() throws Exception {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf());
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table1").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService);
        Mockito.when((Object)mockService.startService()).thenReturn((Object)555);
        EmbeddedTimelineService service1 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig1, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator);
        service1.stopForBasePath(writeConfig1.getBasePath());
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath(this.tempDir.resolve("table2").toString()).withEmbeddedTimelineServerEnabled(true).withEmbeddedTimelineServerReuseEnabled(true).build();
        EmbeddedTimelineService.TimelineServiceCreator mockCreator2 = (EmbeddedTimelineService.TimelineServiceCreator)Mockito.mock(EmbeddedTimelineService.TimelineServiceCreator.class);
        TimelineService mockService2 = (TimelineService)Mockito.mock(TimelineService.class);
        Mockito.when((Object)mockCreator2.create((HoodieEngineContext)ArgumentMatchers.any(), (StorageConfiguration)ArgumentMatchers.any(), (TimelineService.Config)ArgumentMatchers.any(), (HoodieStorage)ArgumentMatchers.any(), (FileSystemViewManager)ArgumentMatchers.any())).thenReturn((Object)mockService2);
        Mockito.when((Object)mockService2.startService()).thenReturn((Object)111);
        EmbeddedTimelineService service2 = EmbeddedTimelineService.getOrStartEmbeddedTimelineService((HoodieEngineContext)engineContext, null, (HoodieWriteConfig)writeConfig2, (EmbeddedTimelineService.TimelineServiceCreator)mockCreator2);
        Assertions.assertNotSame((Object)service1, (Object)service2);
        service1.stopForBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig1.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService, (VerificationMode)Mockito.times((int)1))).close();
        service2.stopForBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService2, (VerificationMode)Mockito.times((int)1))).unregisterBasePath(writeConfig2.getBasePath());
        ((TimelineService)Mockito.verify((Object)mockService2, (VerificationMode)Mockito.times((int)1))).close();
    }
}

