/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;

public class FileSystemBasedLockProviderTestClass
implements LockProvider<String>,
Serializable {
    private static final String LOCK = "lock";
    private final int retryMaxCount;
    private final int retryWaitTimeMs;
    private transient HoodieStorage storage;
    private transient StoragePath lockFile;
    protected LockConfiguration lockConfiguration;

    public FileSystemBasedLockProviderTestClass(LockConfiguration lockConfiguration, StorageConfiguration<?> configuration) {
        this.lockConfiguration = lockConfiguration;
        String lockDirectory = lockConfiguration.getConfig().getString("hoodie.write.lock.filesystem.path");
        this.retryWaitTimeMs = lockConfiguration.getConfig().getInteger("hoodie.write.lock.wait_time_ms_between_retry");
        this.retryMaxCount = lockConfiguration.getConfig().getInteger("hoodie.write.lock.num_retries");
        this.lockFile = new StoragePath(lockDirectory + "/" + LOCK);
        this.storage = HoodieStorageUtils.getStorage((String)this.lockFile.toString(), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        String string = LOCK;
        synchronized (LOCK) {
            try {
                this.storage.deleteDirectory(this.lockFile);
            }
            catch (IOException e) {
                throw new HoodieLockException("Unable to release lock: " + this.getLock(), (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long time, TimeUnit unit) {
        try {
            int numRetries = 0;
            String string = LOCK;
            synchronized (LOCK) {
                while (this.storage.exists(this.lockFile)) {
                    LOCK.wait(this.retryWaitTimeMs);
                    if (++numRetries <= this.retryMaxCount) continue;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return false;
                }
                this.acquireLock();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this.storage.exists(this.lockFile);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new HoodieLockException("Failed to acquire lock: " + this.getLock(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        String string = LOCK;
        synchronized (LOCK) {
            try {
                if (this.storage.exists(this.lockFile)) {
                    this.storage.deleteDirectory(this.lockFile);
                }
            }
            catch (IOException io) {
                throw new HoodieIOException("Unable to delete lock " + this.getLock() + "on disk", io);
            }
            return;
        }
    }

    public String getLock() {
        return this.lockFile.toString();
    }

    private void acquireLock() {
        try {
            this.storage.create(this.lockFile, false).close();
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to acquire lock: " + this.getLock(), e);
        }
    }
}

