/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hudi.DummyActiveAction;
import org.apache.hudi.client.timeline.versioning.v2.LSMTimelineWriter;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHoodieArchivedTimeline
extends HoodieCommonTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    @Test
    public void testLoadingInstantsIncrementally() throws Exception {
        this.writeArchivedTimeline(10, 10000000L);
        HoodieArchivedTimeline archivedTimeline = this.metaClient.getArchivedTimeline("10000043");
        MatcherAssert.assertThat((Object)archivedTimeline.firstInstant().map(HoodieInstant::requestedTime).orElse((Object)""), (Matcher)CoreMatchers.is((Object)"10000043"));
        MatcherAssert.assertThat((Object)archivedTimeline.lastInstant().map(HoodieInstant::requestedTime).orElse((Object)""), (Matcher)CoreMatchers.is((Object)"10000050"));
        archivedTimeline.reload("10000034");
        MatcherAssert.assertThat((Object)archivedTimeline.firstInstant().map(HoodieInstant::requestedTime).orElse((Object)""), (Matcher)CoreMatchers.is((Object)"10000034"));
        archivedTimeline.reload("10000011");
        MatcherAssert.assertThat((Object)archivedTimeline.firstInstant().map(HoodieInstant::requestedTime).orElse((Object)""), (Matcher)CoreMatchers.is((Object)"10000011"));
    }

    private void writeArchivedTimeline(int batchSize, long startTs) throws Exception {
        HoodieTestTable testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withMarkersType("DIRECT").build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf());
        LSMTimelineWriter writer = LSMTimelineWriter.getInstance((HoodieWriteConfig)writeConfig, (TaskContextSupplier)new LocalTaskContextSupplier(), (HoodieTableMetaClient)this.metaClient);
        ArrayList<DummyActiveAction> instantBuffer = new ArrayList<DummyActiveAction>();
        for (int i = 1; i <= 50; ++i) {
            long instantTimeTs = startTs + (long)i;
            String instantTime = String.valueOf(instantTimeTs);
            String completionTime = String.valueOf(instantTimeTs + 10L);
            HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime, completionTime);
            HoodieCommitMetadata metadata = testTable.createCommitMetadata(instantTime, WriteOperationType.INSERT, Arrays.asList("par1", "par2"), 10, false);
            byte[] serializedMetadata = (byte[])TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)this.metaClient.getCommitMetadataSerDe(), (HoodieCommitMetadata)metadata).get();
            instantBuffer.add(new DummyActiveAction(instant, serializedMetadata));
            if (i % batchSize != 0) continue;
            writer.write(instantBuffer, Option.empty(), Option.empty());
            writer.compactAndClean((HoodieEngineContext)engineContext);
            instantBuffer.clear();
        }
    }
}

