/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieMetrics {
    @Mock
    HoodieWriteConfig writeConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.INMEMORY);
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
        this.metrics = this.hoodieMetrics.getMetrics();
    }

    @AfterEach
    void shutdownMetrics() {
        this.metrics.shutdown();
    }

    @Test
    public void testRegisterGauge() {
        this.metrics.registerGauge("metric1", 123L);
        Assertions.assertEquals((Object)"123", (Object)((Gauge)this.metrics.getRegistry().getGauges().get("metric1")).getValue().toString());
    }

    @Test
    public void testTimerCtxandGauges() throws InterruptedException {
        Boolean[] boolValues;
        Random rand = new Random();
        Timer.Context timer = this.hoodieMetrics.getIndexCtx();
        Thread.sleep(5L);
        this.hoodieMetrics.updateIndexMetrics("some_action", this.hoodieMetrics.getDurationInMs(timer.stop()));
        String metricName = this.hoodieMetrics.getMetricsName("index", "some_action.duration");
        long msec = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        timer = this.hoodieMetrics.getSourceReadAndIndexTimerCtx();
        Thread.sleep(5L);
        this.hoodieMetrics.updateSourceReadAndIndexMetrics("some_action", this.hoodieMetrics.getDurationInMs(timer.stop()));
        metricName = this.hoodieMetrics.getMetricsName("source_read_and_index", "some_action.duration");
        msec = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.hoodieMetrics.getMetricsName("index", "type");
        for (HoodieIndex.IndexType indexType : HoodieIndex.IndexType.values()) {
            this.hoodieMetrics.emitIndexTypeMetrics(indexType.ordinal());
            long indexTypeOrdinal = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
            Assertions.assertEquals((long)indexTypeOrdinal, (long)indexType.ordinal());
        }
        metricName = this.hoodieMetrics.getMetricsName("metadata", "isEnabled");
        String colStatsMetricName = this.hoodieMetrics.getMetricsName("metadata", "isColSatsEnabled");
        String bloomFilterMetricName = this.hoodieMetrics.getMetricsName("metadata", "isBloomFilterEnabled");
        String rliMetricName = this.hoodieMetrics.getMetricsName("metadata", "isRliEnabled");
        for (Boolean mdt : boolValues = new Boolean[]{true, false}) {
            for (Boolean colStats : boolValues) {
                for (Boolean bloomFilter : boolValues) {
                    for (Boolean rli : boolValues) {
                        this.hoodieMetrics.emitMetadataEnablementMetrics(mdt.booleanValue(), colStats.booleanValue(), bloomFilter.booleanValue(), rli.booleanValue());
                        Assertions.assertEquals((Object)(mdt != false ? 1L : 0L), (Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue());
                        Assertions.assertEquals((Object)(colStats != false ? 1L : 0L), (Object)((Gauge)this.metrics.getRegistry().getGauges().get(colStatsMetricName)).getValue());
                        Assertions.assertEquals((Object)(bloomFilter != false ? 1L : 0L), (Object)((Gauge)this.metrics.getRegistry().getGauges().get(bloomFilterMetricName)).getValue());
                        Assertions.assertEquals((Object)(rli != false ? 1L : 0L), (Object)((Gauge)this.metrics.getRegistry().getGauges().get(rliMetricName)).getValue());
                    }
                }
            }
        }
        timer = this.hoodieMetrics.getRollbackCtx();
        Thread.sleep(5L);
        long numFilesDeleted = 1 + rand.nextInt();
        this.hoodieMetrics.updateRollbackMetrics(this.hoodieMetrics.getDurationInMs(timer.stop()), numFilesDeleted);
        metricName = this.hoodieMetrics.getMetricsName("rollback", "duration");
        msec = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.hoodieMetrics.getMetricsName("rollback", "numFilesDeleted");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesDeleted);
        timer = this.hoodieMetrics.getRollbackCtx();
        Thread.sleep(5L);
        numFilesDeleted = 1 + rand.nextInt();
        this.hoodieMetrics.updateCleanMetrics(this.hoodieMetrics.getDurationInMs(timer.stop()), (int)numFilesDeleted);
        metricName = this.hoodieMetrics.getMetricsName("clean", "duration");
        msec = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.hoodieMetrics.getMetricsName("clean", "numFilesDeleted");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesDeleted);
        timer = this.hoodieMetrics.getFinalizeCtx();
        Thread.sleep(5L);
        long numFilesFinalized = 1 + rand.nextInt();
        this.hoodieMetrics.updateFinalizeWriteMetrics(this.hoodieMetrics.getDurationInMs(timer.stop()), (long)((int)numFilesFinalized));
        metricName = this.hoodieMetrics.getMetricsName("finalize", "duration");
        msec = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue();
        Assertions.assertTrue((msec > 0L ? 1 : 0) != 0);
        metricName = this.hoodieMetrics.getMetricsName("finalize", "numFilesFinalized");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (long)numFilesFinalized);
        Stream.of("commit", "deltacommit", "compaction").forEach(action -> {
            Timer.Context commitTimer = action.equals("commit") ? this.hoodieMetrics.getCommitCtx() : (action.equals("deltacommit") ? this.hoodieMetrics.getDeltaCommitCtx() : this.hoodieMetrics.getCompactionCtx());
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long randomValue = 1 + rand.nextInt();
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)Mockito.mock(HoodieCommitMetadata.class);
            Mockito.when((Object)metadata.fetchTotalPartitionsWritten()).thenReturn((Object)(randomValue + 1L));
            Mockito.when((Object)metadata.fetchTotalFilesInsert()).thenReturn((Object)(randomValue + 2L));
            Mockito.when((Object)metadata.fetchTotalFilesUpdated()).thenReturn((Object)(randomValue + 3L));
            Mockito.when((Object)metadata.fetchTotalRecordsWritten()).thenReturn((Object)(randomValue + 4L));
            Mockito.when((Object)metadata.fetchTotalUpdateRecordsWritten()).thenReturn((Object)(randomValue + 5L));
            Mockito.when((Object)metadata.fetchTotalInsertRecordsWritten()).thenReturn((Object)(randomValue + 6L));
            Mockito.when((Object)metadata.fetchTotalBytesWritten()).thenReturn((Object)(randomValue + 7L));
            Mockito.when((Object)metadata.getTotalScanTime()).thenReturn((Object)(randomValue + 8L));
            Mockito.when((Object)metadata.getTotalCreateTime()).thenReturn((Object)(randomValue + 9L));
            Mockito.when((Object)metadata.getTotalUpsertTime()).thenReturn((Object)(randomValue + 10L));
            Mockito.when((Object)metadata.getTotalCompactedRecordsUpdated()).thenReturn((Object)(randomValue + 11L));
            Mockito.when((Object)metadata.getTotalLogFilesCompacted()).thenReturn((Object)(randomValue + 12L));
            Mockito.when((Object)metadata.getTotalLogFilesSize()).thenReturn((Object)(randomValue + 13L));
            Mockito.when((Object)metadata.getTotalRecordsDeleted()).thenReturn((Object)(randomValue + 14L));
            Mockito.when((Object)metadata.getTotalCorruptLogBlocks()).thenReturn((Object)(randomValue + 15L));
            Mockito.when((Object)metadata.getTotalRollbackLogBlocks()).thenReturn((Object)(randomValue + 16L));
            Mockito.when((Object)metadata.getMinAndMaxEventTime()).thenReturn((Object)Pair.of((Object)Option.empty(), (Object)Option.empty()));
            Mockito.when((Object)this.writeConfig.isCompactionLogBlockMetricsOn()).thenReturn((Object)true);
            this.hoodieMetrics.updateCommitMetrics(randomValue + 17L, commitTimer.stop(), metadata, action);
            String metricname = this.hoodieMetrics.getMetricsName(action, "duration");
            long duration = (Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue();
            Assertions.assertTrue((duration > 0L ? 1 : 0) != 0);
            metricname = this.hoodieMetrics.getMetricsName(action, "totalPartitionsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalPartitionsWritten());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalFilesInsert");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalFilesInsert());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalFilesUpdate");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalFilesUpdated());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalRecordsWritten());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalUpdateRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalUpdateRecordsWritten());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalInsertRecordsWritten");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalInsertRecordsWritten());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalBytesWritten");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)metadata.fetchTotalBytesWritten());
            metricname = this.hoodieMetrics.getMetricsName(action, "commitTime");
            Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue()), (long)(randomValue + 17L));
            metricname = this.hoodieMetrics.getMetricsName(action, "totalScanTime");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalScanTime());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalCreateTime");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalCreateTime());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalUpsertTime");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalUpsertTime());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalCompactedRecordsUpdated");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalCompactedRecordsUpdated());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalLogFilesCompacted");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalLogFilesCompacted());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalLogFilesSize");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalLogFilesSize());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalRecordsDeleted");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalRecordsDeleted());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalCorruptedLogBlocks");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalCorruptLogBlocks());
            metricname = this.hoodieMetrics.getMetricsName(action, "totalRollbackLogBlocks");
            Assertions.assertEquals((Object)((Gauge)this.metrics.getRegistry().getGauges().get(metricname)).getValue(), (Object)metadata.getTotalRollbackLogBlocks());
        });
        HoodieInstant instant001 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clustering", "1001");
        HoodieInstant instant0011 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", "11001");
        HoodieInstant instant002 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", "1002");
        HoodieInstant instant003 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", "1003");
        HoodieInstant instant004 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", "1004");
        HoodieInstant instant005 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clustering", "1005");
        HoodieInstant instant006 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", "1006");
        MockHoodieActiveTimeline activeTimeline = new MockHoodieActiveTimeline(instant001, instant0011, instant002, instant003, instant004, instant005, instant006);
        this.hoodieMetrics.updateClusteringTimeLineInstantMetrics((HoodieActiveTimeline)activeTimeline);
        metricName = this.hoodieMetrics.getMetricsName("clustering", "earliestInflightClusteringInstant");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (Long)Long.valueOf("1002"));
        metricName = this.hoodieMetrics.getMetricsName("clustering", "latestCompletedClusteringInstant");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (Long)Long.valueOf("1005"));
        metricName = this.hoodieMetrics.getMetricsName("clustering", "pendingClusteringInstantCount");
        Assertions.assertEquals((long)((Long)((Gauge)this.metrics.getRegistry().getGauges().get(metricName)).getValue()), (long)4L);
    }

    private static class MockHoodieActiveTimeline
    extends ActiveTimelineV2 {
        public MockHoodieActiveTimeline(HoodieInstant ... instants) {
            this.setInstants(Arrays.asList(instants));
        }
    }
}

