/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.cloudwatch;

import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.aws.cloudwatch.CloudWatchReporter;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.cloudwatch.CloudWatchMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class TestCloudWatchMetricsReporter {
    @Mock
    private HoodieMetricsConfig metricsConfig;
    @Mock
    private MetricRegistry registry;
    @Mock
    private CloudWatchReporter reporter;

    @Test
    public void testReporter() {
        Mockito.when((Object)this.metricsConfig.getCloudWatchReportPeriodSeconds()).thenReturn((Object)30);
        CloudWatchMetricsReporter metricsReporter = new CloudWatchMetricsReporter(this.metricsConfig, this.registry, this.reporter);
        metricsReporter.start();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).start(30L, TimeUnit.SECONDS);
        metricsReporter.report();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).report();
        metricsReporter.stop();
        ((CloudWatchReporter)Mockito.verify((Object)this.reporter, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void testReporterViaReporterFactory() {
        try {
            Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.CLOUDWATCH);
            MetricsReporterFactory.createReporter((HoodieMetricsConfig)this.metricsConfig, (MetricRegistry)this.registry).get();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assertions.assertTrue((boolean)Arrays.stream(((InvocationTargetException)e.getCause()).getTargetException().getStackTrace()).anyMatch(ste -> ste.toString().contains("org.apache.hudi.aws.cloudwatch.CloudWatchReporter.getAmazonCloudWatchClient")));
        }
    }
}

