/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.datadog;

import com.codahale.metrics.MetricRegistry;
import java.util.Arrays;
import java.util.UUID;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.datadog.DatadogHttpClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestDatadogMetricsReporter {
    @Mock
    HoodieWriteConfig writeConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;
    @Mock
    MetricRegistry registry;

    @AfterEach
    void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Test
    public void instantiationShouldFailWhenNoApiKey() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.metricsConfig.getDatadogApiKey()).thenReturn((Object)"");
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> {
            this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
            this.metrics = this.hoodieMetrics.getMetrics();
        });
        Assertions.assertEquals((Object)"Datadog cannot be initialized: API key is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldFailWhenNoMetricPrefix() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.metricsConfig.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.metricsConfig.getDatadogMetricPrefix()).thenReturn((Object)"");
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Throwable t = Assertions.assertThrows(IllegalStateException.class, () -> {
            this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
            this.metrics = this.hoodieMetrics.getMetrics();
        });
        Assertions.assertEquals((Object)"Datadog cannot be initialized: Metric prefix is null or empty.", (Object)t.getMessage());
    }

    @Test
    public void instantiationShouldSucceed() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.DATADOG);
        Mockito.when((Object)this.metricsConfig.getDatadogApiSite()).thenReturn((Object)DatadogHttpClient.ApiSite.EU);
        Mockito.when((Object)this.metricsConfig.getDatadogApiKey()).thenReturn((Object)"foo");
        Mockito.when((Object)this.metricsConfig.getDatadogApiKeySkipValidation()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getDatadogMetricPrefix()).thenReturn((Object)"bar");
        Mockito.when((Object)this.metricsConfig.getDatadogMetricHost()).thenReturn((Object)"foo");
        Mockito.when((Object)this.metricsConfig.getDatadogMetricTags()).thenReturn(Arrays.asList("baz", "foo"));
        Mockito.when((Object)this.metricsConfig.getDatadogReportPeriodSeconds()).thenReturn((Object)10);
        Mockito.when((Object)this.metricsConfig.getMetricReporterMetricsNamePrefix()).thenReturn((Object)"");
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Assertions.assertDoesNotThrow(() -> {
            this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
            this.metrics = this.hoodieMetrics.getMetrics();
        });
    }
}

