/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.CleanFileInfo;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.BaseTimelineV2;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCleanPlanner {
    private static final StorageConfiguration<?> CONF = HoodieTestUtils.getDefaultStorageConf();
    private final HoodieEngineContext context = new HoodieLocalEngineContext(CONF);
    private final HoodieTable<?, ?, ?, ?> mockHoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
    private static final String PARTITION1 = "partition1";
    private static final String PARTITION2 = "partition2";
    private static final String PARTITION3 = "partition3";

    @BeforeEach
    void setUp() {
        SyncableFileSystemView sliceView = (SyncableFileSystemView)Mockito.mock(SyncableFileSystemView.class);
        Mockito.when((Object)this.mockHoodieTable.getSliceView()).thenReturn((Object)sliceView);
        Mockito.when((Object)sliceView.getPendingCompactionOperations()).thenReturn(Stream.empty());
        Mockito.when((Object)sliceView.getPendingLogCompactionOperations()).thenReturn(Stream.empty());
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)metaClient);
        TimelineLayout layout = (TimelineLayout)Mockito.mock(TimelineLayout.class);
        Mockito.when((Object)metaClient.getTimelineLayout()).thenReturn((Object)layout);
        Mockito.when((Object)layout.getCommitMetadataSerDe()).thenReturn((Object)HoodieTestUtils.COMMIT_METADATA_SER_DE);
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        Mockito.when((Object)metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        HoodieTimeline mockCompletedCommitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)mockCompletedCommitsTimeline.countInstants()).thenReturn((Object)10);
        Mockito.when((Object)this.mockHoodieTable.getCompletedCommitsTimeline()).thenReturn((Object)mockCompletedCommitsTimeline);
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    void testGetDeletePaths(HoodieWriteConfig config, String earliestInstant, List<HoodieFileGroup> allFileGroups, List<Pair<String, Option<byte[]>>> savepoints, List<HoodieFileGroup> replacedFileGroups, Pair<Boolean, List<CleanFileInfo>> expected) throws IOException {
        SyncableFileSystemView mockFsView = (SyncableFileSystemView)Mockito.mock(SyncableFileSystemView.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)mockMetaClient);
        Mockito.when((Object)this.mockHoodieTable.getHoodieView()).thenReturn((Object)mockFsView);
        Mockito.when((Object)this.mockHoodieTable.getInstantGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameParser()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER);
        Set savepointTimestamps = savepoints.stream().map(Pair::getLeft).collect(Collectors.toSet());
        Mockito.when((Object)this.mockHoodieTable.getSavepointTimestamps()).thenReturn(savepointTimestamps);
        if (!savepoints.isEmpty()) {
            HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
            Mockito.when((Object)this.mockHoodieTable.getActiveTimeline()).thenReturn((Object)activeTimeline);
            for (Pair<String, Option<byte[]>> savepoint : savepoints) {
                HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", (String)savepoint.getLeft());
                Mockito.when((Object)activeTimeline.getInstantDetails(instant)).thenReturn(savepoint.getRight());
                Mockito.when((Object)mockMetaClient.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", (String)savepoint.getLeft())).thenReturn((Object)instant);
            }
        }
        String partitionPath = PARTITION1;
        if (config.getCleanerPolicy() == HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS) {
            Mockito.when((Object)this.mockHoodieTable.getHoodieView()).thenReturn((Object)mockFsView);
            Mockito.when((Object)mockFsView.getAllReplacedFileGroups(partitionPath)).thenReturn(replacedFileGroups.stream());
        } else {
            Mockito.when((Object)mockFsView.getReplacedFileGroupsBefore(earliestInstant, partitionPath)).thenReturn(replacedFileGroups.stream());
        }
        Mockito.when((Object)mockFsView.getAllFileGroupsStateless(partitionPath)).thenReturn(allFileGroups.stream());
        CleanPlanner cleanPlanner = new CleanPlanner(this.context, this.mockHoodieTable, config);
        HoodieInstant earliestCommitToRetain = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "COMMIT", earliestInstant);
        Pair actual = cleanPlanner.getDeletePaths(partitionPath, Option.of((Object)earliestCommitToRetain));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"incrCleaningPartitionsTestCases"})
    void testPartitionsForIncrCleaning(boolean isPartitioned, HoodieWriteConfig config, String earliestInstant, String lastCompletedTimeInLastClean, String lastCleanInstant, String earliestInstantsInLastClean, List<String> partitionsInLastClean, Map<String, List<String>> savepointsTrackedInLastClean, Option<String> expectedEarliestSavepointInLastClean, Map<String, List<String>> activeInstantsPartitions, List<String> replaceCommits, List<String> expectedPartitions, boolean areCommitsForSavepointsRemoved, Map<String, List<String>> savepoints) throws IOException, IllegalAccessException {
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.mockHoodieTable.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Set savepointTimestamps = savepoints.keySet().stream().collect(Collectors.toSet());
        Mockito.when((Object)this.mockHoodieTable.getSavepointTimestamps()).thenReturn(savepointTimestamps);
        Mockito.when((Object)this.mockHoodieTable.getInstantGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameParser()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER);
        if (!savepoints.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : savepoints.entrySet()) {
                Pair<HoodieSavepointMetadata, Option<byte[]>> savepointMetadataOptionPair = TestCleanPlanner.getSavepointMetadata(entry.getValue());
                HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", entry.getKey());
                Mockito.when((Object)activeTimeline.getInstantDetails(instant)).thenReturn(savepointMetadataOptionPair.getRight());
            }
        }
        Pair<HoodieCleanMetadata, Option<byte[]>> cleanMetadataOptionPair = TestCleanPlanner.getCleanCommitMetadata(partitionsInLastClean, lastCleanInstant, earliestInstantsInLastClean, lastCompletedTimeInLastClean, savepointsTrackedInLastClean.keySet(), expectedEarliestSavepointInLastClean);
        HoodieCleanerPlan cleanerPlan = TestCleanPlanner.mockLastCleanCommit(this.mockHoodieTable, lastCleanInstant, earliestInstantsInLastClean, activeTimeline, cleanMetadataOptionPair, savepointsTrackedInLastClean.keySet());
        TestCleanPlanner.mockFewActiveInstants(this.mockHoodieTable, activeTimeline, activeInstantsPartitions, savepointsTrackedInLastClean, areCommitsForSavepointsRemoved, replaceCommits);
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        Mockito.when((Object)this.mockHoodieTable.getStorage()).thenReturn((Object)storage);
        HoodieTableMetadata hoodieTableMetadata = (HoodieTableMetadata)Mockito.mock(HoodieTableMetadata.class);
        Mockito.when((Object)this.mockHoodieTable.getMetadataTable()).thenReturn((Object)hoodieTableMetadata);
        Mockito.when((Object)this.mockHoodieTable.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clean", lastCleanInstant)));
        Mockito.when((Object)hoodieTableMetadata.getAllPartitionPaths()).thenReturn(isPartitioned ? Arrays.asList(PARTITION1, PARTITION2, PARTITION3) : Collections.singletonList(""));
        CleanPlanner cleanPlanner = new CleanPlanner(this.context, this.mockHoodieTable, config);
        HoodieInstant earliestCommitToRetain = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "COMMIT", earliestInstant);
        List partitionsToClean = cleanPlanner.getPartitionPathsToClean(Option.of((Object)earliestCommitToRetain));
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)metaClient.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Assertions.assertEquals(expectedEarliestSavepointInLastClean, (Object)ClusteringUtils.getEarliestReplacedSavepointInClean((HoodieActiveTimeline)activeTimeline, (HoodieCleaningPolicy)config.getCleanerPolicy(), (HoodieCleanerPlan)cleanerPlan));
        Collections.sort(expectedPartitions);
        Collections.sort(partitionsToClean);
        Assertions.assertEquals(expectedPartitions, (Object)partitionsToClean);
    }

    static Stream<Arguments> testCases() {
        return Stream.concat(TestCleanPlanner.keepLatestByHoursOrCommitsArgs(), TestCleanPlanner.keepLatestVersionsArgs());
    }

    static Stream<Arguments> incrCleaningPartitionsTestCases() {
        return TestCleanPlanner.keepLatestByHoursOrCommitsArgsIncrCleanPartitions();
    }

    static Stream<Arguments> keepLatestVersionsArgs() {
        HoodieWriteConfig keepLatestVersionsConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainFileVersions(2).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS).build()).build();
        String instant1 = "20231205194919610";
        String instant2 = "20231204194919610";
        String instant3 = "20231201194919610";
        String instant4 = "20231127194919610";
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), Collections.emptyList(), Collections.emptyList(), Pair.of((Object)false, Collections.emptyList())}));
        HoodieFileGroup fileGroup = TestCleanPlanner.buildFileGroup(Arrays.asList(instant4, instant3, instant2, instant1));
        String instant3Path = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(instant3)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfoForInstant3 = new CleanFileInfo(instant3Path, false);
        String instant4Path = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(instant4)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfoForInstant4 = new CleanFileInfo(instant4Path, false);
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(fileGroup), Collections.emptyList(), Collections.emptyList(), Pair.of((Object)false, Arrays.asList(expectedCleanFileInfoForInstant3, expectedCleanFileInfoForInstant4))}));
        List<Pair> savepoints = Collections.singletonList(Pair.of((Object)instant4, TestCleanPlanner.getSavepointBytes(PARTITION1, Collections.singletonList(instant4Path))));
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(fileGroup), savepoints, Collections.emptyList(), Pair.of((Object)false, Arrays.asList(expectedCleanFileInfoForInstant3))}));
        HoodieFileGroup replacedFileGroup = TestCleanPlanner.buildFileGroup(Collections.singletonList(instant4));
        String replacedFilePath = ((HoodieBaseFile)replacedFileGroup.getAllBaseFiles().findFirst().get()).getPath();
        CleanFileInfo expectedReplaceCleanFileInfo = new CleanFileInfo(replacedFilePath, false);
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.singletonList(expectedReplaceCleanFileInfo))}));
        List<Pair> replacedFileGroupSavepoint = Collections.singletonList(Pair.of((Object)instant4, TestCleanPlanner.getSavepointBytes(PARTITION1, Collections.singletonList(replacedFilePath))));
        arguments.add(Arguments.of((Object[])new Object[]{keepLatestVersionsConfig, instant1, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(instant2, instant1))), replacedFileGroupSavepoint, Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.emptyList())}));
        return arguments.stream();
    }

    static Stream<Arguments> keepLatestByHoursOrCommitsArgs() {
        String earliestInstant = "20231204194919610";
        String earliestInstantPlusTwoDays = "20231205194919610";
        String earliestInstantMinusThreeDays = "20231201194919610";
        String earliestInstantMinusOneWeek = "20231127194919610";
        String earliestInstantMinusOneMonth = "20231104194919610";
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieFileGroup fileGroupsBeforeInstant = TestCleanPlanner.buildFileGroup(Arrays.asList(earliestInstantMinusOneMonth, earliestInstantMinusOneWeek));
        CleanFileInfo expectedCleanFileInfoForFirstFile = new CleanFileInfo(fileGroupsBeforeInstant.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(earliestInstantMinusOneMonth)).findFirst().get().getPath(), false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroupsBeforeInstant), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedCleanFileInfoForFirstFile))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Arrays.asList(earliestInstantMinusOneMonth, earliestInstantPlusTwoDays))), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        String oldestFileInstant = earliestInstantMinusOneMonth;
        HoodieFileGroup fileGroup = TestCleanPlanner.buildFileGroup(Arrays.asList(oldestFileInstant, earliestInstantMinusThreeDays, earliestInstantPlusTwoDays));
        String oldestFilePath = fileGroup.getAllBaseFiles().filter(baseFile -> baseFile.getCommitTime().equals(oldestFileInstant)).findFirst().get().getPath();
        CleanFileInfo expectedCleanFileInfo = new CleanFileInfo(oldestFilePath, false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroup), Collections.emptyList(), Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedCleanFileInfo))));
        List<Pair<String, Option<byte[]>>> savepoints = Collections.singletonList(Pair.of((Object)oldestFileInstant, TestCleanPlanner.getSavepointBytes(PARTITION1, Collections.singletonList(oldestFilePath))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(fileGroup), savepoints, Collections.emptyList(), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieFileGroup replacedFileGroup = TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth));
        String replacedFilePath = ((HoodieBaseFile)replacedFileGroup.getAllBaseFiles().findFirst().get()).getPath();
        CleanFileInfo expectedReplaceCleanFileInfo = new CleanFileInfo(replacedFilePath, false);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.singletonList(expectedReplaceCleanFileInfo))));
        List<Pair<String, Option<byte[]>>> savepointsForReplacedGroup = Collections.singletonList(Pair.of((Object)oldestFileInstant, TestCleanPlanner.getSavepointBytes(PARTITION1, Collections.singletonList(replacedFilePath))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsCases(earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), savepointsForReplacedGroup, Collections.singletonList(replacedFileGroup), (Pair<Boolean, List<CleanFileInfo>>)Pair.of((Object)false, Collections.emptyList())));
        HoodieWriteConfig writeConfigWithLargerRetention = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(50).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).build()).build();
        arguments.add(Arguments.of((Object[])new Object[]{writeConfigWithLargerRetention, earliestInstant, Collections.singletonList(TestCleanPlanner.buildFileGroup(Collections.singletonList(earliestInstantMinusOneMonth))), Collections.emptyList(), Collections.singletonList(replacedFileGroup), Pair.of((Object)false, Collections.emptyList())}));
        return arguments.stream();
    }

    static Stream<Arguments> keepLatestByHoursOrCommitsArgsIncrCleanPartitions() {
        String earliestInstantMinusOneMonth;
        String earliestInstantMinusOneWeek;
        String earliestInstantMinusSixDays;
        String earliestInstantPlusTwoDays;
        String earliestInstant = "20231204194919610";
        String lastCleanInstant = earliestInstantPlusTwoDays = "20231206194919610";
        String earliestInstantMinusThreeDays = "20231201194919610";
        String earliestInstantMinusFourDays = "20231130194919610";
        String earliestInstantMinusFiveDays = "20231129194919610";
        String earliestInstantInLastClean = earliestInstantMinusSixDays = "20231128194919610";
        String lastCompletedInLastClean = earliestInstantMinusSixDays;
        String savepoint2 = earliestInstantMinusOneWeek = "20231127194919610";
        String savepoint3 = earliestInstantMinusOneMonth = "20231104194919610";
        List<String> threePartitionsInActiveTimeline = Arrays.asList(PARTITION1, PARTITION2, PARTITION3);
        HashMap<String, List<String>> activeInstantsPartitionsMap3 = new HashMap<String, List<String>>();
        activeInstantsPartitionsMap3.put(earliestInstantMinusThreeDays, threePartitionsInActiveTimeline);
        activeInstantsPartitionsMap3.put(earliestInstantMinusFourDays, threePartitionsInActiveTimeline);
        activeInstantsPartitionsMap3.put(earliestInstantMinusFiveDays, threePartitionsInActiveTimeline);
        List<String> twoPartitionsInActiveTimeline = Arrays.asList(PARTITION2, PARTITION3);
        HashMap<String, List<String>> activeInstantsPartitionsMap2 = new HashMap<String, List<String>>();
        activeInstantsPartitionsMap2.put(earliestInstantMinusThreeDays, twoPartitionsInActiveTimeline);
        activeInstantsPartitionsMap2.put(earliestInstantMinusFourDays, twoPartitionsInActiveTimeline);
        activeInstantsPartitionsMap2.put(earliestInstantMinusFiveDays, twoPartitionsInActiveTimeline);
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.emptyMap(), (Option<String>)Option.empty(), activeInstantsPartitionsMap3, Collections.emptyList(), threePartitionsInActiveTimeline, false, Collections.emptyMap()));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), (Option<String>)Option.empty(), activeInstantsPartitionsMap3, Collections.emptyList(), threePartitionsInActiveTimeline, false, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.emptyMap(), (Option<String>)Option.empty(), activeInstantsPartitionsMap3, Collections.emptyList(), threePartitionsInActiveTimeline, false, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), (Option<String>)Option.empty(), activeInstantsPartitionsMap2, Collections.emptyList(), twoPartitionsInActiveTimeline, false, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), (Option<String>)Option.empty(), activeInstantsPartitionsMap2, Collections.emptyList(), threePartitionsInActiveTimeline, false, Collections.emptyMap()));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), (Option<String>)Option.empty(), activeInstantsPartitionsMap2, Collections.singletonList(earliestInstantMinusThreeDays), twoPartitionsInActiveTimeline, false, Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1))));
        HashMap<String, List<String>> latestSavepoints = new HashMap<String, List<String>>();
        latestSavepoints.put(savepoint3, Collections.singletonList(PARTITION1));
        latestSavepoints.put(savepoint2, Collections.singletonList(PARTITION1));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint3, Collections.singletonList(PARTITION1)), (Option<String>)Option.of((Object)savepoint3), activeInstantsPartitionsMap2, Collections.singletonList(earliestInstantMinusOneWeek), twoPartitionsInActiveTimeline, false, latestSavepoints));
        HashMap<String, List<String>> previousSavepoints = new HashMap<String, List<String>>();
        previousSavepoints.put(savepoint2, Collections.singletonList(PARTITION1));
        previousSavepoints.put(savepoint3, Collections.singletonList(PARTITION2));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), previousSavepoints, (Option<String>)Option.of((Object)savepoint3), activeInstantsPartitionsMap2, Collections.singletonList(earliestInstantMinusOneWeek), threePartitionsInActiveTimeline, false, Collections.singletonMap(savepoint3, Collections.singletonList(PARTITION2))));
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), previousSavepoints, (Option<String>)Option.empty(), activeInstantsPartitionsMap3, Collections.singletonList(earliestInstantMinusThreeDays), threePartitionsInActiveTimeline, false, Collections.singletonMap(savepoint3, Collections.singletonList(PARTITION2))));
        List<String> unPartitionsInActiveTimeline = Arrays.asList("");
        HashMap<String, List<String>> activeInstantsUnPartitionsMap = new HashMap<String, List<String>>();
        activeInstantsUnPartitionsMap.put(earliestInstantMinusThreeDays, unPartitionsInActiveTimeline);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(false, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(""), Collections.singletonMap(savepoint2, Collections.singletonList("")), (Option<String>)Option.empty(), activeInstantsUnPartitionsMap, Collections.emptyList(), unPartitionsInActiveTimeline, false, Collections.emptyMap()));
        activeInstantsPartitionsMap2.remove(earliestInstantMinusOneWeek);
        arguments.addAll(TestCleanPlanner.buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(true, earliestInstant, lastCompletedInLastClean, lastCleanInstant, earliestInstantInLastClean, Collections.singletonList(PARTITION1), Collections.singletonMap(savepoint2, Collections.singletonList(PARTITION1)), (Option<String>)Option.empty(), activeInstantsPartitionsMap2, Collections.emptyList(), threePartitionsInActiveTimeline, true, Collections.emptyMap()));
        return arguments.stream();
    }

    private static HoodieWriteConfig getCleanByHoursConfig() {
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().cleanerNumHoursRetained(24).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS).build()).build();
    }

    private static HoodieWriteConfig getCleanByCommitsConfig() {
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().retainCommits(5).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).build()).build();
    }

    private static List<Arguments> buildArgumentsForCleanByHoursAndCommitsCases(String earliestInstant, List<HoodieFileGroup> allFileGroups, List<Pair<String, Option<byte[]>>> savepoints, List<HoodieFileGroup> replacedFileGroups, Pair<Boolean, List<CleanFileInfo>> expected) {
        return Arrays.asList(Arguments.of((Object[])new Object[]{TestCleanPlanner.getCleanByHoursConfig(), earliestInstant, allFileGroups, savepoints, replacedFileGroups, expected}), Arguments.of((Object[])new Object[]{TestCleanPlanner.getCleanByCommitsConfig(), earliestInstant, allFileGroups, savepoints, replacedFileGroups, expected}));
    }

    private static List<Arguments> buildArgumentsForCleanByHoursAndCommitsIncrCleanPartitionsCases(boolean isPartitioned, String earliestInstant, String latestCompletedInLastClean, String lastKnownCleanInstantTime, String earliestInstantInLastClean, List<String> partitionsInLastClean, Map<String, List<String>> savepointsTrackedInLastClean, Option<String> expectedEarliestSavepointInLastClean, Map<String, List<String>> activeInstantsToPartitionsMap, List<String> replaceCommits, List<String> expectedPartitions, boolean areCommitsForSavepointsRemoved, Map<String, List<String>> savepoints) {
        return Arrays.asList(Arguments.of((Object[])new Object[]{isPartitioned, TestCleanPlanner.getCleanByHoursConfig(), earliestInstant, latestCompletedInLastClean, lastKnownCleanInstantTime, earliestInstantInLastClean, partitionsInLastClean, savepointsTrackedInLastClean, expectedEarliestSavepointInLastClean, activeInstantsToPartitionsMap, replaceCommits, expectedPartitions, areCommitsForSavepointsRemoved, savepoints}), Arguments.of((Object[])new Object[]{isPartitioned, TestCleanPlanner.getCleanByCommitsConfig(), earliestInstant, latestCompletedInLastClean, lastKnownCleanInstantTime, earliestInstantInLastClean, partitionsInLastClean, savepointsTrackedInLastClean, expectedEarliestSavepointInLastClean, activeInstantsToPartitionsMap, replaceCommits, expectedPartitions, areCommitsForSavepointsRemoved, savepoints}));
    }

    private static HoodieFileGroup buildFileGroup(List<String> baseFileCommitTimes) {
        return TestCleanPlanner.buildFileGroup(baseFileCommitTimes, PARTITION1);
    }

    private static HoodieFileGroup buildFileGroup(List<String> baseFileCommitTimes, String partition) {
        String fileGroup = UUID.randomUUID() + "-0";
        HoodieFileGroupId fileGroupId = new HoodieFileGroupId(partition, UUID.randomUUID().toString());
        HoodieTimeline timeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)timeline.lastInstant()).thenReturn((Object)Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "COMMIT", baseFileCommitTimes.get(baseFileCommitTimes.size() - 1))));
        HoodieFileGroup group = new HoodieFileGroup(fileGroupId, timeline);
        for (String baseFileCommitTime : baseFileCommitTimes) {
            Mockito.when((Object)timeline.containsOrBeforeTimelineStarts(baseFileCommitTime)).thenReturn((Object)true);
            HoodieBaseFile baseFile = new HoodieBaseFile(String.format("file:///tmp/base/%s_1-0-1_%s.parquet", fileGroup, baseFileCommitTime));
            group.addBaseFile(baseFile);
        }
        return group;
    }

    private static Option<byte[]> getSavepointBytes(String partition, List<String> paths) {
        try {
            HashMap<String, HoodieSavepointPartitionMetadata> partitionMetadata = new HashMap<String, HoodieSavepointPartitionMetadata>();
            List fileNames = paths.stream().map(path -> path.substring(path.lastIndexOf("/") + 1)).collect(Collectors.toList());
            partitionMetadata.put(partition, new HoodieSavepointPartitionMetadata(partition, fileNames));
            HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata("user", Long.valueOf(1L), "comments", partitionMetadata, Integer.valueOf(1));
            return TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)savepointMetadata);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Pair<HoodieCleanMetadata, Option<byte[]>> getCleanCommitMetadata(List<String> partitions, String instantTime, String earliestCommitToRetain, String lastCompletedTime, Set<String> savepointsToTrack, Option<String> earliestCommitToNotArchive) {
        try {
            HashMap partitionMetadata = new HashMap();
            partitions.forEach(partition -> partitionMetadata.put(partition, new HoodieCleanPartitionMetadata(partition, HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Boolean.valueOf(false))));
            HashMap<String, String> extraMetadata = new HashMap<String, String>();
            extraMetadata.put("savepointed_timestamps", savepointsToTrack.stream().collect(Collectors.joining(",")));
            HoodieCleanMetadata cleanMetadata = new HoodieCleanMetadata(instantTime, Long.valueOf(100L), Integer.valueOf(10), earliestCommitToRetain, lastCompletedTime, partitionMetadata, CleanerUtils.CLEAN_METADATA_VERSION_2, Collections.EMPTY_MAP, extraMetadata.isEmpty() ? null : extraMetadata);
            return Pair.of((Object)cleanMetadata, (Object)TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)cleanMetadata));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static Pair<HoodieSavepointMetadata, Option<byte[]>> getSavepointMetadata(List<String> partitions) {
        try {
            HashMap partitionMetadata = new HashMap();
            partitions.forEach(partition -> partitionMetadata.put(partition, new HoodieSavepointPartitionMetadata(partition, Collections.emptyList())));
            HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata("user", Long.valueOf(1L), "comments", partitionMetadata, Integer.valueOf(1));
            return Pair.of((Object)savepointMetadata, (Object)TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)savepointMetadata));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static HoodieCleanerPlan mockLastCleanCommit(HoodieTable hoodieTable, String timestamp, String earliestCommitToRetain, HoodieActiveTimeline activeTimeline, Pair<HoodieCleanMetadata, Option<byte[]>> cleanMetadata, Set<String> savepointsTrackedInLastClean) throws IOException {
        BaseTimelineV2 cleanTimeline = (BaseTimelineV2)Mockito.mock(BaseTimelineV2.class);
        Mockito.when((Object)activeTimeline.getCleanerTimeline()).thenReturn((Object)cleanTimeline);
        Mockito.when((Object)hoodieTable.getCleanTimeline()).thenReturn((Object)cleanTimeline);
        BaseTimelineV2 completedCleanTimeline = (BaseTimelineV2)Mockito.mock(BaseTimelineV2.class);
        Mockito.when((Object)cleanTimeline.filterCompletedInstants()).thenReturn((Object)completedCleanTimeline);
        HoodieInstant latestCleanInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clean", timestamp);
        Mockito.when((Object)completedCleanTimeline.lastInstant()).thenReturn((Object)Option.of((Object)latestCleanInstant));
        Mockito.when((Object)activeTimeline.isEmpty(latestCleanInstant)).thenReturn((Object)false);
        Mockito.when((Object)activeTimeline.getInstantDetails(latestCleanInstant)).thenReturn(cleanMetadata.getRight());
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant(earliestCommitToRetain, "commit", HoodieInstant.State.COMPLETED.name()), ((HoodieCleanMetadata)cleanMetadata.getLeft()).getLastCompletedCommitTimestamp(), HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name(), Collections.emptyMap(), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, null, null, ((HoodieCleanMetadata)cleanMetadata.getLeft()).getExtraMetadata());
        Mockito.when((Object)activeTimeline.readCleanerInfoAsBytes((HoodieInstant)ArgumentMatchers.any())).thenReturn((Object)Option.of((Object)TimelineMetadataUtils.serializeAvroMetadata((SpecificRecordBase)cleanerPlan, HoodieCleanerPlan.class).get()));
        BaseTimelineV2 commitsTimeline = (BaseTimelineV2)Mockito.mock(BaseTimelineV2.class);
        Mockito.when((Object)activeTimeline.getCommitsTimeline()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.isBeforeTimelineStarts(earliestCommitToRetain)).thenReturn((Object)false);
        Mockito.when((Object)hoodieTable.isPartitioned()).thenReturn((Object)true);
        Mockito.when((Object)hoodieTable.isMetadataTable()).thenReturn((Object)false);
        return cleanerPlan;
    }

    private static void mockFewActiveInstants(HoodieTable hoodieTable, HoodieActiveTimeline activeTimeline, Map<String, List<String>> activeInstantsToPartitions, Map<String, List<String>> savepointedCommitsToAdd, boolean areCommitsForSavepointsRemoved, List<String> replaceCommits) throws IOException {
        BaseTimelineV2 commitsTimeline = new BaseTimelineV2();
        ArrayList instants = new ArrayList();
        HashMap<String, List> instantstoProcess = new HashMap<String, List>();
        instantstoProcess.putAll(activeInstantsToPartitions);
        if (!areCommitsForSavepointsRemoved) {
            instantstoProcess.putAll(savepointedCommitsToAdd);
        }
        instantstoProcess.forEach((k, v) -> {
            HoodieInstant hoodieInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", k);
            instants.add(hoodieInstant);
            HashMap partitionToWriteStats = new HashMap();
            v.forEach(partition -> partitionToWriteStats.put(partition, Collections.emptyList()));
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            v.forEach(partition -> commitMetadata.getPartitionToWriteStats().put(partition, Collections.emptyList()));
            try {
                Mockito.when((Object)hoodieTable.getActiveTimeline().getInstantDetails(hoodieInstant)).thenReturn((Object)TimelineMetadataUtils.serializeCommitMetadata((CommitMetadataSerDe)HoodieTestUtils.COMMIT_METADATA_SER_DE, (HoodieCommitMetadata)commitMetadata));
            }
            catch (IOException e) {
                throw new RuntimeException("Should not have failed", e);
            }
        });
        commitsTimeline.setInstants(instants);
        Collections.sort(instants);
        Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)hoodieTable.getMetaClient().getCommitMetadataSerDe()).thenReturn((Object)HoodieTestUtils.COMMIT_METADATA_SER_DE);
        Mockito.when((Object)hoodieTable.getActiveTimeline().getInstantsAsStream()).thenReturn(instants.stream());
        Mockito.when((Object)hoodieTable.getCompletedCommitsTimeline()).thenReturn((Object)commitsTimeline);
        BaseTimelineV2 savepointTimeline = new BaseTimelineV2();
        List savepointInstants = savepointedCommitsToAdd.keySet().stream().map(sp -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "savepoint", sp)).collect(Collectors.toList());
        savepointTimeline.setInstants(savepointInstants);
        BaseTimelineV2 completedReplaceTimeline = new BaseTimelineV2();
        List completedReplaceInstants = replaceCommits.stream().map(rc -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", rc)).collect(Collectors.toList());
        completedReplaceTimeline.setInstants(completedReplaceInstants);
        Mockito.when((Object)activeTimeline.getCompletedReplaceTimeline()).thenReturn((Object)completedReplaceTimeline);
        Mockito.when((Object)activeTimeline.getSavePointTimeline()).thenReturn((Object)savepointTimeline);
        Mockito.when((Object)hoodieTable.isPartitioned()).thenReturn((Object)true);
        Mockito.when((Object)hoodieTable.isMetadataTable()).thenReturn((Object)false);
    }
}

