/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.action.rollback.MarkerBasedRollbackStrategy;
import org.apache.hudi.table.action.rollback.TestBaseRollbackHelper;
import org.apache.hudi.table.action.rollback.TestRollbackUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TestMarkerBasedRollbackStrategy
extends TestBaseRollbackHelper {
    private static final int ROLLBACK_LOG_VERSION = 10;

    TestMarkerBasedRollbackStrategy() {
    }

    @Override
    @BeforeEach
    void setup() throws IOException {
        super.setup();
    }

    @ParameterizedTest
    @ValueSource(strings={"SIX", "EIGHT"})
    void testGetRollbackRequestsWithMultipleLogFilesInOneFileGroup(HoodieTableVersion tableVersion) throws IOException {
        this.prepareMetaClient(tableVersion);
        HoodieLocalEngineContext context = new HoodieLocalEngineContext(this.storage.getConf());
        String rollbackInstantTime = "003";
        String instantToRollbackTs = "002";
        String baseInstantTimeOfLogFiles = "001";
        String partition1 = "partition1";
        String partition2 = "partition2";
        String baseFileId1 = UUID.randomUUID().toString();
        String baseFileId2 = UUID.randomUUID().toString();
        String baseFileId3 = UUID.randomUUID().toString();
        String logFileId1 = UUID.randomUUID().toString();
        String logFileId2 = UUID.randomUUID().toString();
        StoragePath baseFilePath1 = this.createBaseFileAndMarkerToRollback(partition1, baseFileId1, instantToRollbackTs);
        StoragePath baseFilePath2 = this.createBaseFileAndMarkerToRollback(partition2, baseFileId2, instantToRollbackTs);
        StoragePath baseFilePath3 = this.createBaseFileAndMarkerToRollback(partition2, baseFileId3, instantToRollbackTs);
        Map<String, Long> logFilesToRollback1 = this.createLogFilesAndMarkersToRollback(partition2, logFileId1, baseInstantTimeOfLogFiles, instantToRollbackTs, IntStream.of(1));
        Map<String, Long> logFilesToRollback2 = IntStream.range(1, 10).boxed().flatMap(version -> this.createLogFilesAndMarkersToRollback(partition2, logFileId2, baseInstantTimeOfLogFiles, instantToRollbackTs, IntStream.of((int)version)).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HoodieInstant instantToRollback = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantToRollbackTs);
        List actual = new MarkerBasedRollbackStrategy(this.table, (HoodieEngineContext)context, this.config, rollbackInstantTime).getRollbackRequests(instantToRollback);
        ArrayList<HoodieRollbackRequest> expected = new ArrayList<HoodieRollbackRequest>();
        expected.add(new HoodieRollbackRequest(partition1, baseFileId1, instantToRollbackTs, Collections.singletonList(baseFilePath1.toString()), Collections.emptyMap()));
        expected.add(new HoodieRollbackRequest(partition2, baseFileId2, instantToRollbackTs, Collections.singletonList(baseFilePath2.toString()), Collections.emptyMap()));
        expected.add(new HoodieRollbackRequest(partition2, baseFileId3, instantToRollbackTs, Collections.singletonList(baseFilePath3.toString()), Collections.emptyMap()));
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            logFilesToRollback1.keySet().forEach(logFilePath -> expected.add(new HoodieRollbackRequest(partition2, logFileId1, instantToRollbackTs, Collections.singletonList(logFilePath), Collections.emptyMap())));
            logFilesToRollback2.keySet().forEach(logFilePath -> expected.add(new HoodieRollbackRequest(partition2, logFileId2, instantToRollbackTs, Collections.singletonList(logFilePath), Collections.emptyMap())));
        } else {
            expected.add(new HoodieRollbackRequest(partition2, logFileId1, baseInstantTimeOfLogFiles, Collections.emptyList(), logFilesToRollback1));
            expected.add(new HoodieRollbackRequest(partition2, logFileId2, baseInstantTimeOfLogFiles, Collections.emptyList(), logFilesToRollback2));
        }
        TestRollbackUtils.assertRollbackRequestListEquals(expected, actual);
    }

    private StoragePath createBaseFileAndMarkerToRollback(String partition, String fileId, String instantTime) throws IOException {
        StoragePath baseFilePath = this.createBaseFileToRollback(partition, fileId, instantTime);
        FileCreateUtils.createMarkerFile((HoodieTableMetaClient)this.metaClient, (String)partition, (String)instantTime, (String)fileId, (IOType)IOType.CREATE);
        return baseFilePath;
    }

    private Map<String, Long> createLogFilesAndMarkersToRollback(String partition, String fileId, String baseInstantTime, String currentInstantTime, IntStream logVersions) {
        Map<String, Long> logFilesToRollback = this.createLogFilesToRollback(partition, fileId, baseInstantTime, logVersions, 0L);
        return logFilesToRollback.keySet().stream().map(logFileName -> {
            try {
                FileCreateUtils.createLogFileMarker((HoodieTableMetaClient)this.metaClient, (String)partition, (String)currentInstantTime, (String)logFileName);
                if (this.metaClient.getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
                    return new StoragePath(new StoragePath(this.basePath, partition), logFileName).toString();
                }
                return logFileName;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toMap(Function.identity(), e -> 1L));
    }
}

