/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.HashMap;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SevenToEightUpgradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestSevenToEightUpgradeHandler {
    @Mock
    private HoodieTable table;
    @Mock
    private HoodieTableMetaClient metaClient;
    @Mock
    private HoodieEngineContext context;
    @Mock
    private HoodieWriteConfig config;
    @Mock
    private HoodieTableConfig tableConfig;
    @Mock
    private SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private SevenToEightUpgradeHandler upgradeHandler;

    @BeforeEach
    void setUp() {
        this.upgradeHandler = new SevenToEightUpgradeHandler();
    }

    @Test
    void testPropertyUpgrade() {
        HashMap tablePropsToAdd = new HashMap();
        Mockito.when((Object)this.config.getString(ArgumentMatchers.anyString())).thenAnswer(i -> {
            Object arg0 = i.getArguments()[0];
            if (arg0.equals(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key())) {
                return "partition_field";
            }
            if (arg0.equals(HoodieWriteConfig.RECORD_MERGE_MODE.key())) {
                return RecordMergeMode.EVENT_TIME_ORDERING.name();
            }
            return null;
        });
        Mockito.when((Object)this.tableConfig.getKeyGeneratorClassName()).thenReturn((Object)"org.apache.hudi.keygen.CustomKeyGenerator");
        SevenToEightUpgradeHandler.upgradePartitionFields((HoodieWriteConfig)this.config, (HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertEquals((Object)"partition_field", tablePropsToAdd.get(HoodieTableConfig.PARTITION_FIELDS));
        SevenToEightUpgradeHandler.setInitialVersion((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertEquals((Object)"6", tablePropsToAdd.get(HoodieTableConfig.INITIAL_VERSION));
        Mockito.when((Object)this.tableConfig.contains((ConfigProperty)Mockito.isA(ConfigProperty.class))).thenAnswer(i -> i.getArguments()[0].equals(HoodieTableConfig.PAYLOAD_CLASS_NAME));
        Mockito.when((Object)this.tableConfig.getPayloadClass()).thenReturn((Object)OverwriteWithLatestAvroPayload.class.getName());
        SevenToEightUpgradeHandler.upgradeMergeMode((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.RECORD_MERGE_MODE));
        Assertions.assertNotNull(tablePropsToAdd.get(HoodieTableConfig.RECORD_MERGE_MODE));
        Mockito.when((Object)this.tableConfig.getBooleanOrDefault(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tableConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)).thenReturn((Object)HFileBootstrapIndex.class.getName());
        SevenToEightUpgradeHandler.upgradeBootstrapIndexType((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE));
        SevenToEightUpgradeHandler.upgradeKeyGeneratorType((HoodieTableConfig)this.tableConfig, tablePropsToAdd);
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
        Assertions.assertTrue((boolean)tablePropsToAdd.containsKey(HoodieTableConfig.KEY_GENERATOR_TYPE));
    }
}

