/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.Transformations;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.HoodieWriteHelper;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.jetbrains.annotations.NotNull;
import org.mockito.Mockito;

public abstract class HoodieWriterClientTestHarness
extends HoodieCommonTestHarness {
    protected static int timelineServicePort = (Integer)FileSystemViewStorageConfig.REMOTE_PORT_NUM.defaultValue();
    protected static final String CLUSTERING_FAILURE = "CLUSTERING FAILURE";
    protected static final String CLEANING_FAILURE = "CLEANING FAILURE";
    protected HoodieTestTable testTable;

    protected abstract BaseHoodieWriteClient getHoodieWriteClient(HoodieWriteConfig var1);

    protected void addConfigsForPopulateMetaFields(HoodieWriteConfig.Builder configBuilder, boolean populateMetaFields, boolean isMetadataTable) {
        if (!populateMetaFields) {
            configBuilder.withProperties(isMetadataTable ? this.getPropertiesForMetadataTable() : HoodieWriterClientTestHarness.getPropertiesForKeyGen()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.SIMPLE).build());
        }
    }

    protected void addConfigsForPopulateMetaFields(HoodieWriteConfig.Builder configBuilder, boolean populateMetaFields) {
        this.addConfigsForPopulateMetaFields(configBuilder, populateMetaFields, false);
    }

    public static Properties getPropertiesForKeyGen() {
        return HoodieWriterClientTestHarness.getPropertiesForKeyGen(false);
    }

    public static Properties getPropertiesForKeyGen(boolean populateMetaFields) {
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.POPULATE_META_FIELDS.key(), String.valueOf(populateMetaFields));
        properties.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "_row_key");
        properties.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
        properties.put(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
        return properties;
    }

    protected Properties getPropertiesForMetadataTable() {
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.POPULATE_META_FIELDS.key(), "false");
        properties.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "key");
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "key");
        return properties;
    }

    public HoodieWriteConfig getConfig() {
        return this.getConfigBuilder().build();
    }

    public HoodieWriteConfig getConfig(HoodieIndex.IndexType indexType) {
        return this.getConfigBuilder(indexType).build();
    }

    protected HoodieWriteConfig.Builder getConfigBuilder() {
        return this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    }

    public HoodieWriteConfig.Builder getConfigBuilder(HoodieFailedWritesCleaningPolicy cleaningPolicy) {
        return this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", HoodieIndex.IndexType.BLOOM, cleaningPolicy);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(HoodieIndex.IndexType indexType) {
        return this.getConfigBuilder("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", indexType, HoodieFailedWritesCleaningPolicy.EAGER);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(String schemaStr) {
        return this.getConfigBuilder(schemaStr, HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(String schemaStr, HoodieIndex.IndexType indexType) {
        return this.getConfigBuilder(schemaStr, indexType, HoodieFailedWritesCleaningPolicy.EAGER);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(String schemaStr, HoodieIndex.IndexType indexType, HoodieFailedWritesCleaningPolicy cleaningPolicy) {
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(this.basePath).withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION.intValue()).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(cleaningPolicy).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).orcMaxFileSize(0x100000L).build()).forTable("raw_trips").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(indexType).build()).withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withEnableBackupForRemoteFileSystemView(false).withRemoteServerPort(Integer.valueOf(timelineServicePort)).build());
        if (StringUtils.nonEmpty((String)schemaStr)) {
            builder.withSchema(schemaStr);
        }
        return builder;
    }

    protected abstract List<WriteStatus> writeAndVerifyBatch(BaseHoodieWriteClient var1, List<HoodieRecord> var2, String var3, boolean var4, boolean var5) throws IOException;

    protected Object castInsertFirstBatch(HoodieWriteConfig writeConfig, BaseHoodieWriteClient client, String newCommitTime, String initCommitTime, int numRecordsInThisCommit, Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, InstantGenerator instantGenerator) throws Exception {
        return this.castInsertFirstBatch(writeConfig, client, newCommitTime, initCommitTime, numRecordsInThisCommit, writeFn, isPreppedAPI, assertForCommit, expRecordsInThisCommit, true, instantGenerator);
    }

    protected Object castInsertFirstBatch(HoodieWriteConfig writeConfig, BaseHoodieWriteClient client, String newCommitTime, String initCommitTime, int numRecordsInThisCommit, Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        return null;
    }

    protected Object castWriteBatch(BaseHoodieWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, Function2<List<HoodieRecord>, String, Integer> recordGenFunction, Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, InstantGenerator instantGenerator) throws Exception {
        return this.castWriteBatch(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, doCommit, true, instantGenerator);
    }

    protected Object castWriteBatch(BaseHoodieWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, Function2<List<HoodieRecord>, String, Integer> recordGenFunction, Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        return null;
    }

    protected Object castUpdateBatch(HoodieWriteConfig writeConfig, BaseHoodieWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        return null;
    }

    protected Object castDeleteBatch(HoodieWriteConfig writeConfig, BaseHoodieWriteClient client, String newCommitTime, String prevCommitTime, String initCommitTime, int numRecordsInThisCommit, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, TimelineFactory timelineFactory, InstantGenerator instantGenerator) throws Exception {
        return this.castDeleteBatch(writeConfig, client, newCommitTime, prevCommitTime, initCommitTime, numRecordsInThisCommit, isPreppedAPI, assertForCommit, expRecordsInThisCommit, expTotalRecords, true, timelineFactory, instantGenerator);
    }

    protected Object castDeleteBatch(HoodieWriteConfig writeConfig, BaseHoodieWriteClient client, String newCommitTime, String prevCommitTime, String initCommitTime, int numRecordsInThisCommit, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, boolean filterForCommitTimeWithAssert, TimelineFactory timelineFactory, InstantGenerator instantGenerator) throws Exception {
        return null;
    }

    protected Function2<List<HoodieRecord>, String, Integer> generateWrapRecordsFn(boolean isPreppedAPI, HoodieWriteConfig writeConfig, Function2<List<HoodieRecord>, String, Integer> wrapped) {
        return null;
    }

    protected String[] assertTheEntireDatasetHasAllRecordsStill(int expectedRecords) {
        return new String[0];
    }

    protected void testMergeHandle(HoodieWriteConfig config) throws IOException {
    }

    protected HoodieWriteConfig getRollbackMarkersAndConsistencyGuardWriteConfig(boolean rollbackUsingMarkers, boolean enableOptimisticConsistencyGuard, boolean populateMetaFields) {
        Properties properties = new Properties();
        if (!populateMetaFields) {
            properties = HoodieWriterClientTestHarness.getPropertiesForKeyGen();
        }
        return !enableOptimisticConsistencyGuard ? this.getConfigBuilder().withRollbackUsingMarkers(rollbackUsingMarkers).withAutoCommit(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).withMaxConsistencyCheckIntervalMs(1).withInitialConsistencyCheckIntervalMs(1).withEnableOptimisticConsistencyGuard(enableOptimisticConsistencyGuard).build()).build() : this.getConfigBuilder().withRollbackUsingMarkers(rollbackUsingMarkers).withAutoCommit(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).withEnableOptimisticConsistencyGuard(enableOptimisticConsistencyGuard).withOptimisticConsistencyGuardSleepTimeMs(1L).build()).withProperties(properties).build();
    }

    protected HoodieWriteConfig getConsistencyCheckWriteConfig(boolean enableOptimisticConsistencyGuard) {
        return !enableOptimisticConsistencyGuard ? this.getConfigBuilder().withAutoCommit(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).withMaxConsistencyCheckIntervalMs(1).withInitialConsistencyCheckIntervalMs(1).withEnableOptimisticConsistencyGuard(enableOptimisticConsistencyGuard).build()).build() : this.getConfigBuilder().withAutoCommit(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).withEnableOptimisticConsistencyGuard(enableOptimisticConsistencyGuard).withOptimisticConsistencyGuardSleepTimeMs(1L).build()).build();
    }

    protected HoodieWriteConfig getParallelWritingWriteConfig(HoodieFailedWritesCleaningPolicy cleaningPolicy, boolean populateMetaFields) {
        Properties properties = new Properties();
        properties.setProperty("hoodie.write.lock.wait_time_ms", "3000");
        properties.setProperty("hoodie.write.lock.client.wait_time_ms_between_retry", "3000");
        properties.setProperty("hoodie.write.lock.client.num_retries", "20");
        if (!populateMetaFields) {
            properties.putAll((Map<?, ?>)HoodieWriterClientTestHarness.getPropertiesForKeyGen(populateMetaFields));
        }
        return this.getConfigBuilder().withEmbeddedTimelineServerEnabled(false).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(cleaningPolicy).withAutoClean(Boolean.valueOf(false)).build()).withHeartbeatIntervalInMs(Integer.valueOf(3000)).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).withAutoCommit(false).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withProperties(properties).build();
    }

    @NotNull
    protected Set<String> verifyRecordKeys(List<HoodieRecord> expectedRecords, List<WriteStatus> allStatus, List<GenericRecord> records) {
        for (WriteStatus status : allStatus) {
            StoragePath filePath = new StoragePath(this.basePath, status.getStat().getPath());
            records.addAll(HoodieWriterClientTestHarness.getFileUtilsInstance(this.createMetaClient()).readAvroRecords(this.storage, filePath));
        }
        Set expectedKeys = Transformations.recordsToRecordKeySet(expectedRecords);
        org.junit.jupiter.api.Assertions.assertEquals((int)records.size(), (int)expectedKeys.size());
        return expectedKeys;
    }

    protected void verifyRecordsWrittenWithPreservedMetadata(Set<String> commitTimes, List<HoodieRecord> expectedRecords, List<WriteStatus> allStatus) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        Set<String> expectedKeys = this.verifyRecordKeys(expectedRecords, allStatus, records);
        Map<String, List<GenericRecord>> recordsByCommitTime = records.stream().collect(Collectors.groupingBy(r -> r.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)commitTimes.containsAll(recordsByCommitTime.keySet()));
        Set expectedFileIds = allStatus.stream().map(WriteStatus::getFileId).collect(Collectors.toSet());
        for (GenericRecord record : records) {
            String recordKey = record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedKeys.contains(recordKey));
            String fileName = record.get(HoodieRecord.FILENAME_METADATA_FIELD).toString();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedFileIds.contains(FSUtils.getFileId((String)fileName)));
        }
    }

    protected Pair<String, String> getPartitionAndBaseFilePathsFromLatestCommitMetadata(HoodieTableMetaClient metaClient) throws IOException {
        String extension = metaClient.getTableConfig().getBaseFileFormat().getFileExtension();
        HoodieInstant instant = (HoodieInstant)metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant().get();
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
        String filePath = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).filter(s -> s.getPath().endsWith(extension)).findAny().map(HoodieWriteStat::getPath).orElse(null);
        String partitionPath = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).filter(s -> s.getPath().endsWith(extension)).findAny().map(HoodieWriteStat::getPartitionPath).orElse(null);
        return Pair.of((Object)partitionPath, (Object)(metaClient.getBasePath() + "/" + filePath));
    }

    public static FileFormatUtils getFileUtilsInstance(HoodieTableMetaClient metaClient) {
        return HoodieIOFactory.getIOFactory((HoodieStorage)metaClient.getStorage()).getFileFormatUtils(metaClient.getTableConfig().getBaseFileFormat());
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, boolean useNullSchema, boolean mergeAllowDuplicateInserts) {
        return this.getSmallInsertWriteConfig(insertSplitSize, useNullSchema, (long)this.dataGen.getEstimatedFileSizeInBytes(150), mergeAllowDuplicateInserts);
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, boolean useNullSchema, long smallFileSize, boolean mergeAllowDuplicateInserts) {
        String schemaStr = useNullSchema ? HoodieTestDataGenerator.NULL_SCHEMA : "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
        return this.getSmallInsertWriteConfig(insertSplitSize, schemaStr, smallFileSize, mergeAllowDuplicateInserts);
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, String schemaStr, long smallFileSize) {
        return this.getSmallInsertWriteConfig(insertSplitSize, schemaStr, smallFileSize, false);
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, String schemaStr, long smallFileSize, boolean mergeAllowDuplicateInserts) {
        return this.getSmallInsertWriteConfig(insertSplitSize, schemaStr, smallFileSize, mergeAllowDuplicateInserts, true, new Properties());
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, String schemaStr, long smallFileSize, boolean populateMetaFields, Properties props) {
        return this.getSmallInsertWriteConfig(insertSplitSize, schemaStr, smallFileSize, false, populateMetaFields, props);
    }

    protected HoodieWriteConfig getSmallInsertWriteConfig(int insertSplitSize, String schemaStr, long smallFileSize, boolean mergeAllowDuplicateInserts, boolean populateMetaFields, Properties props) {
        HoodieWriteConfig.Builder builder = this.getConfigBuilder(schemaStr);
        if (!populateMetaFields) {
            builder.withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.SIMPLE).build());
        }
        return builder.withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(smallFileSize).insertSplitSize(insertSplitSize).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize((long)this.dataGen.getEstimatedFileSizeInBytes(200)).parquetMaxFileSize((long)this.dataGen.getEstimatedFileSizeInBytes(200)).build()).withMergeAllowDuplicateOnInserts(mergeAllowDuplicateInserts).withProps((Map)props).build();
    }

    protected HoodieWriteConfig getSmallInsertWriteConfigForMDT(int insertSplitSize, String schemaStr, long smallFileSize, boolean mergeAllowDuplicateInserts) {
        HoodieWriteConfig.Builder builder = this.getConfigBuilder(schemaStr, HoodieIndex.IndexType.BLOOM, HoodieFailedWritesCleaningPolicy.EAGER);
        return builder.withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(smallFileSize).insertSplitSize(insertSplitSize).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withFailedWritesCleaningPolicy(HoodieFailedWritesCleaningPolicy.LAZY).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize((long)this.dataGen.getEstimatedFileSizeInBytes(200)).parquetMaxFileSize((long)this.dataGen.getEstimatedFileSizeInBytes(200)).build()).withMergeAllowDuplicateOnInserts(mergeAllowDuplicateInserts).build();
    }

    protected HoodieWriteConfig getWriteConfigWithPopulateMetaFieldsAndAllowOperationMetaField(boolean populateMetaFields, boolean allowOperationMetadataField) {
        HoodieWriteConfig.Builder configBuilder = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAllowOperationMetadataField(allowOperationMetadataField).combineInput(true, true);
        this.addConfigsForPopulateMetaFields(configBuilder, populateMetaFields);
        return configBuilder.build();
    }

    protected List<HoodieRecord<RawTripTestPayload>> dedupForCopyOnWriteStorage(HoodieWriteConfig writeConfig, HoodieData<HoodieRecord> records, boolean isGlobal, int additionalParallelism, int expectedNumPartitions) {
        HoodieIndex index = (HoodieIndex)Mockito.mock(HoodieIndex.class);
        Mockito.when((Object)index.isGlobal()).thenReturn((Object)isGlobal);
        int dedupParallelism = records.getNumPartitions() + additionalParallelism;
        HoodieData dedupedRecsRdd = HoodieWriteHelper.newInstance().deduplicateRecords(records, index, dedupParallelism, writeConfig.getSchema(), writeConfig.getProps(), (HoodieRecordMerger)HoodiePreCombineAvroRecordMerger.INSTANCE);
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedNumPartitions, (int)dedupedRecsRdd.getNumPartitions());
        List dedupedRecs = dedupedRecsRdd.collectAsList();
        org.junit.jupiter.api.Assertions.assertEquals((int)(isGlobal ? 1 : 2), (int)dedupedRecs.size());
        Assertions.assertNoDupesWithinPartition(dedupedRecs);
        return dedupedRecs;
    }

    protected HoodieTableMetaClient createMetaClient() {
        return HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (String)this.basePath);
    }

    protected HoodieTableMetaClient createMetaClient(String basePath) {
        return HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (String)basePath);
    }

    protected Set<HoodieFileGroupId> getFileGroupIdsFromWriteStatus(List<WriteStatus> statuses) {
        return statuses.stream().map(s -> new HoodieFileGroupId(s.getPartitionPath(), s.getFileId())).collect(Collectors.toSet());
    }

    protected void verifyClusteredFilesWithReplaceCommitMetadata(String partitionPath) throws IOException {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.createMetaClient());
        HoodieInstant replaceCommitInstant = (HoodieInstant)this.metaClient.getActiveTimeline().getCompletedReplaceTimeline().firstInstant().get();
        HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])this.metaClient.getActiveTimeline().getInstantDetails(replaceCommitInstant).get()), HoodieReplaceCommitMetadata.class);
        ArrayList filesFromReplaceCommit = new ArrayList();
        replaceCommitMetadata.getPartitionToWriteStats().forEach((k, v) -> v.forEach(entry -> filesFromReplaceCommit.add(entry.getPath())));
        List pathInfoList = this.storage.listDirectEntries(new StoragePath(this.basePath, partitionPath));
        List clusteredFiles = pathInfoList.stream().filter(entry -> entry.getPath().getName().contains(replaceCommitInstant.requestedTime())).map(pathInfo -> partitionPath + "/" + pathInfo.getPath().getName()).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals(clusteredFiles, filesFromReplaceCommit);
    }

    protected static List<Pair<HoodieInstant, HoodieClusteringPlan>> getAndAssertPendingClusteringPlans(boolean scheduleInlineClustering, HoodieTableMetaClient metaClient) {
        List<Pair<HoodieInstant, HoodieClusteringPlan>> pendingClusteringPlans = ClusteringUtils.getAllPendingClusteringPlans((HoodieTableMetaClient)metaClient).collect(Collectors.toList());
        if (scheduleInlineClustering) {
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pendingClusteringPlans.size());
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)pendingClusteringPlans.size());
        }
        return pendingClusteringPlans;
    }

    protected void checkTimelineForUpsertsInternal(HoodieTableMetaClient metaClient) {
        HoodieActiveTimeline activeTimeline = HoodieTestUtils.TIMELINE_FACTORY.createActiveTimeline(metaClient, false);
        List instants = activeTimeline.getCommitAndReplaceTimeline().getInstants();
        org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)instants.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "001"), instants.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "001"), instants.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "001"), instants.get(2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((HoodieInstant)instants.get(2)).isLegacy());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "004"), instants.get(3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "004"), instants.get(4));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "004"), instants.get(5));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((HoodieInstant)instants.get(5)).isLegacy());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)((HoodieInstant)instants.get(8)).isLegacy());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "commit", "006"), instants.get(6));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", "006"), instants.get(7));
        org.junit.jupiter.api.Assertions.assertEquals((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "006"), instants.get(8));
    }

    protected void verifyRecordsWritten(String commitTime, boolean populateMetadataField, List<HoodieRecord> expectedRecords, List<WriteStatus> allStatus, HoodieWriteConfig config, KeyGenerator keyGenerator) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        Set<String> expectedKeys = this.verifyRecordKeys(expectedRecords, allStatus, records);
        if (config.populateMetaFields()) {
            for (GenericRecord record : records) {
                String recordKey = record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
                org.junit.jupiter.api.Assertions.assertEquals((Object)commitTime, (Object)record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedKeys.contains(recordKey));
            }
        } else {
            for (GenericRecord record : records) {
                String recordKey = keyGenerator.getKey(record).getRecordKey();
                if (!populateMetadataField) {
                    org.junit.jupiter.api.Assertions.assertNull((Object)record.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)expectedKeys.contains(recordKey));
            }
        }
    }

    protected List<WriteStatus> writeAndVerifyBatch(BaseHoodieWriteClient client, List<HoodieRecord> inserts, String commitTime, boolean populateMetaFields) throws IOException {
        return this.writeAndVerifyBatch(client, inserts, commitTime, populateMetaFields, false);
    }

    protected Pair<Pair<List<HoodieRecord>, List<String>>, Set<HoodieFileGroupId>> insertTwoBatches(BaseHoodieWriteClient writeClient, BaseHoodieWriteClient brokenClusteringClient, boolean populateMetaFields, String partitionPath, boolean failInlineClustering) throws IOException {
        BaseHoodieWriteClient client;
        if (failInlineClustering) {
            if (null != writeClient) {
                writeClient.close();
            }
            client = brokenClusteringClient;
        } else {
            client = writeClient;
        }
        this.dataGen = new HoodieTestDataGenerator(new String[]{partitionPath});
        String commitTime1 = client.createNewInstantTime();
        List records1 = this.dataGen.generateInserts(commitTime1, Integer.valueOf(200));
        List<WriteStatus> statuses1 = this.writeAndVerifyBatch(client, records1, commitTime1, populateMetaFields, failInlineClustering);
        Set<HoodieFileGroupId> fileIds1 = this.getFileGroupIdsFromWriteStatus(statuses1);
        String commitTime2 = client.createNewInstantTime();
        List records2 = this.dataGen.generateInserts(commitTime2, Integer.valueOf(200));
        List<WriteStatus> statuses2 = this.writeAndVerifyBatch(client, records2, commitTime2, populateMetaFields, failInlineClustering);
        client.close();
        Set<HoodieFileGroupId> fileIds2 = this.getFileGroupIdsFromWriteStatus(statuses2);
        HashSet<HoodieFileGroupId> fileIdsUnion = new HashSet<HoodieFileGroupId>(fileIds1);
        fileIdsUnion.addAll(fileIds2);
        HashSet<HoodieFileGroupId> fileIdIntersection = new HashSet<HoodieFileGroupId>(fileIds1);
        fileIdIntersection.retainAll(fileIds2);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)fileIdIntersection.size());
        return Pair.of((Object)Pair.of(Stream.concat(records1.stream(), records2.stream()).collect(Collectors.toList()), Arrays.asList(commitTime1, commitTime2)), fileIdsUnion);
    }

    protected void rollbackAndAssert(boolean enableOptimisticConsistencyGuard, String instantTime, HoodieTableMetaClient metaClient, BaseHoodieWriteClient client) throws IOException {
        if (!enableOptimisticConsistencyGuard) {
            client.rollback(instantTime);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.testTable.commitExists(instantTime), (String)"After explicit rollback, commit file should not be present");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getMarkerFolderPath(instantTime))));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime), (String)"With optimistic CG, first commit should succeed. commit file should be present");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getMarkerFolderPath(instantTime))));
            client.rollback(instantTime);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.testTable.commitExists(instantTime), (String)"After explicit rollback, commit file should not be present");
        }
    }

    protected Pair<StoragePath, List<WriteStatus>> testConsistencyCheck(HoodieEngineContext context, HoodieTableMetaClient metaClient, String instantTime, boolean enableOptimisticConsistencyGuard, Function2<HoodieTable, HoodieTableMetaClient, HoodieWriteConfig> getHoodieTableFn, Function transformInputFn, Function transformOutputFn) throws Exception {
        String partitionPath;
        HoodieWriteConfig cfg = this.getConsistencyCheckWriteConfig(enableOptimisticConsistencyGuard);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfg);
        client.startCommitWithTime(instantTime);
        List writeRecords = this.dataGen.generateInserts(instantTime, Integer.valueOf(200));
        List result = (List)transformOutputFn.apply(client.bulkInsert(transformInputFn.apply(writeRecords), instantTime));
        String markerFolderPath = metaClient.getMarkerFolderPath(instantTime);
        if (cfg.getMarkersType() == MarkerType.TIMELINE_SERVER_BASED) {
            String markerName = (String)MarkerUtils.readTimelineServerBasedMarkersFromFileSystem((String)markerFolderPath, (HoodieStorage)this.storage, (HoodieEngineContext)context, (int)1).values().stream().flatMap(Collection::stream).findFirst().get();
            partitionPath = new StoragePath(markerFolderPath, markerName).getParent().toString();
        } else {
            partitionPath = (String)this.storage.globEntries(new StoragePath(String.format("%s/*/*/*/*", markerFolderPath)), (StoragePathFilter & Serializable)path -> path.toString().contains(".marker")).stream().limit(1L).map(status -> status.getPath().getParent().toString()).collect(Collectors.toList()).get(0);
        }
        Option markerFilePath = WriteMarkersFactory.get((MarkerType)cfg.getMarkersType(), (HoodieTable)getHoodieTableFn.apply(metaClient, cfg), (String)instantTime).create(partitionPath, FSUtils.makeBaseFileName((String)instantTime, (String)"1-0-1", (String)UUID.randomUUID().toString(), (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()), IOType.MERGE);
        if (!enableOptimisticConsistencyGuard) {
            Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(HoodieCommitException.class, () -> client.commit(instantTime, transformInputFn.apply(result)), (String)"Commit should fail due to consistency check");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e.getCause() instanceof HoodieIOException));
        } else {
            client.commit(instantTime, transformInputFn.apply(result));
        }
        return Pair.of((Object)markerFilePath.get(), (Object)result);
    }

    protected void testConsistencyCheckDuringFinalize(HoodieEngineContext context, boolean enableOptimisticConsistencyGuard, Function2<HoodieTable, HoodieTableMetaClient, HoodieWriteConfig> getHoodieTableFn, Function transformInputFn, Function transformOutputFn) throws Exception {
        HoodieTableMetaClient metaClient = this.createMetaClient();
        String instantTime = "000";
        HoodieWriteConfig cfg = this.getConfigBuilder().withAutoCommit(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withEnableOptimisticConsistencyGuard(enableOptimisticConsistencyGuard).build()).build();
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfg);
        client.setOperationType(WriteOperationType.UPSERT);
        Pair<StoragePath, List<WriteStatus>> result = this.testConsistencyCheck(context, metaClient, instantTime, enableOptimisticConsistencyGuard, getHoodieTableFn, transformInputFn, transformOutputFn);
        metaClient.getStorage().deleteFile((StoragePath)result.getKey());
        if (!enableOptimisticConsistencyGuard) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)client.commit(instantTime, transformInputFn.apply(result.getRight())), (String)"Commit should succeed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime), (String)"After explicit commit, commit file should be created");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getMarkerFolderPath(instantTime))));
        } else {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime), (String)"After explicit commit, commit file should be created");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)metaClient.getStorage().exists(new StoragePath(metaClient.getMarkerFolderPath(instantTime))));
        }
    }

    protected void testRollbackAfterConsistencyCheckFailureUsingFileList(HoodieEngineContext context, boolean rollbackUsingMarkers, boolean enableOptimisticConsistencyGuard, boolean populateMetaFields, Function2<HoodieTable, HoodieTableMetaClient, HoodieWriteConfig> getHoodieTableFn, Function transformInputFn, Function transformOutputFn) throws Exception {
        String instantTime = "00000000000010";
        HoodieTableMetaClient metaClient = this.createMetaClient();
        HoodieWriteConfig cfg = this.getRollbackMarkersAndConsistencyGuardWriteConfig(rollbackUsingMarkers, enableOptimisticConsistencyGuard, populateMetaFields);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfg);
        this.testConsistencyCheck(context, metaClient, instantTime, enableOptimisticConsistencyGuard, getHoodieTableFn, transformInputFn, transformOutputFn);
        this.rollbackAndAssert(enableOptimisticConsistencyGuard, instantTime, metaClient, client);
    }

    protected List<HoodieRecord> generate3AvroRecords(String commitTime) throws IOException {
        String recordKey = UUID.randomUUID().toString();
        HoodieKey keyOne = new HoodieKey(recordKey, "2018-01-01");
        HoodieAvroRecord recordOne = new HoodieAvroRecord(keyOne, (HoodieRecordPayload)this.dataGen.generateRandomValue(keyOne, commitTime), HoodieOperation.INSERT);
        HoodieKey keyTwo = new HoodieKey(recordKey, "2018-02-01");
        HoodieAvroRecord recordTwo = new HoodieAvroRecord(keyTwo, (HoodieRecordPayload)this.dataGen.generateRandomValue(keyTwo, commitTime), HoodieOperation.INSERT);
        HoodieAvroRecord recordThree = new HoodieAvroRecord(keyTwo, (HoodieRecordPayload)this.dataGen.generateRandomValue(keyTwo, commitTime), HoodieOperation.UPDATE_AFTER);
        return Arrays.asList(recordOne, recordTwo, recordThree);
    }

    private HoodieWriteMetadata<List<WriteStatus>> performClustering(HoodieClusteringConfig clusteringConfig, boolean populateMetaFields, boolean completeClustering, String validatorClasses, String sqlQueryForEqualityValidation, String sqlQueryForSingleResultValidation, Pair<List<HoodieRecord>, List<String>> allRecords, Function<HoodieWriteMetadata, HoodieWriteMetadata<List<WriteStatus>>> transformWriteMetadataFn, Function<HoodieWriteConfig, KeyGenerator> createKeyGeneratorFn) {
        HoodiePreCommitValidatorConfig validatorConfig = HoodiePreCommitValidatorConfig.newBuilder().withPreCommitValidator(StringUtils.nullToEmpty((String)validatorClasses)).withPrecommitValidatorEqualitySqlQueries(sqlQueryForEqualityValidation).withPrecommitValidatorSingleResultSqlQueries(sqlQueryForSingleResultValidation).build();
        HoodieWriteConfig config = this.getConfigBuilder().withAutoCommit(false).withPreCommitValidatorConfig(validatorConfig).withProps((Map)(populateMetaFields ? new Properties() : HoodieWriterClientTestHarness.getPropertiesForKeyGen())).withClusteringConfig(clusteringConfig).build();
        BaseHoodieWriteClient client = this.getHoodieWriteClient(config);
        String clusteringCommitTime = client.scheduleClustering(Option.empty()).get().toString();
        HoodieWriteMetadata<List<WriteStatus>> clusterMetadata = transformWriteMetadataFn.apply(client.cluster(clusteringCommitTime, completeClustering));
        if (config.populateMetaFields()) {
            this.verifyRecordsWrittenWithPreservedMetadata(new HashSet<String>((Collection)allRecords.getRight()), (List)allRecords.getLeft(), (List)clusterMetadata.getWriteStatuses());
        } else {
            this.verifyRecordsWritten(clusteringCommitTime, populateMetaFields, (List)allRecords.getLeft(), (List)clusterMetadata.getWriteStatuses(), config, createKeyGeneratorFn.apply(config));
        }
        return clusterMetadata;
    }

    protected void testClustering(HoodieClusteringConfig clusteringConfig, boolean populateMetaFields, boolean completeClustering, boolean assertSameFileIds, String validatorClasses, String sqlQueryForEqualityValidation, String sqlQueryForSingleResultValidation, Pair<Pair<List<HoodieRecord>, List<String>>, Set<HoodieFileGroupId>> allRecords, Function<HoodieWriteMetadata, HoodieWriteMetadata<List<WriteStatus>>> transformWriteMetadataFn, Function<HoodieWriteConfig, KeyGenerator> createKeyGeneratorFn) {
        HoodieWriteConfig config = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAutoCommit(false).withClusteringConfig(clusteringConfig).withProps((Map)HoodieWriterClientTestHarness.getPropertiesForKeyGen()).build();
        HoodieWriteMetadata<List<WriteStatus>> clusterMetadata = this.performClustering(clusteringConfig, populateMetaFields, completeClustering, validatorClasses, sqlQueryForEqualityValidation, sqlQueryForSingleResultValidation, (Pair<List<HoodieRecord>, List<String>>)((Pair)allRecords.getLeft()), transformWriteMetadataFn, createKeyGeneratorFn);
        if (assertSameFileIds) {
            Set replacedFileIds = ((List)clusterMetadata.getWriteStats().get()).stream().map(s -> new HoodieFileGroupId(s.getPartitionPath(), s.getFileId())).collect(Collectors.toSet());
            Set insertedFileIds = (Set)allRecords.getRight();
            org.junit.jupiter.api.Assertions.assertEquals((Object)insertedFileIds, replacedFileIds);
        }
        if (completeClustering) {
            String clusteringCommitTime = ((HoodieInstant)this.createMetaClient().reloadActiveTimeline().getCompletedReplaceTimeline().getReverseOrderedInstants().findFirst().get()).requestedTime();
            this.verifyRecordsWritten(clusteringCommitTime, populateMetaFields, (List)((Pair)allRecords.getLeft()).getLeft(), (List)clusterMetadata.getWriteStatuses(), config, createKeyGeneratorFn.apply(config));
        }
    }

    protected Pair<Pair<List<HoodieRecord>, List<String>>, Set<HoodieFileGroupId>> testInsertTwoBatches(boolean populateMetaFields, Function createBrokenClusteringClientFn) throws IOException {
        return this.testInsertTwoBatches(populateMetaFields, "2015/03/16", createBrokenClusteringClientFn);
    }

    protected Pair<Pair<List<HoodieRecord>, List<String>>, Set<HoodieFileGroupId>> testInsertTwoBatches(boolean populateMetaFields, String partitionPath, Function createBrokenClusteringClientFn) throws IOException {
        return this.testInsertTwoBatches(populateMetaFields, partitionPath, HoodieWriterClientTestHarness.getPropertiesForKeyGen(populateMetaFields), false, createBrokenClusteringClientFn);
    }

    protected Pair<Pair<List<HoodieRecord>, List<String>>, Set<HoodieFileGroupId>> testInsertTwoBatches(boolean populateMetaFields, String partitionPath, Properties props, boolean failInlineClustering, Function createBrokenClusteringClientFn) throws IOException {
        HoodieWriteConfig config = this.getSmallInsertWriteConfig(2000, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", 10L, false, populateMetaFields, populateMetaFields ? props : HoodieWriterClientTestHarness.getPropertiesForKeyGen());
        return this.insertTwoBatches(this.getHoodieWriteClient(config), (BaseHoodieWriteClient)createBrokenClusteringClientFn.apply(config), populateMetaFields, partitionPath, failInlineClustering);
    }

    protected void testCommitWritesRelativePaths(Function transformInputFn) throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder().withAutoCommit(false);
        this.addConfigsForPopulateMetaFields(cfgBuilder, true);
        try (BaseHoodieWriteClient client = this.getHoodieWriteClient(cfgBuilder.build());){
            HoodieTableMetaClient metaClient = this.createMetaClient();
            String instantTime = "000";
            client.startCommitWithTime(instantTime);
            List records = this.dataGen.generateInserts(instantTime, Integer.valueOf(200));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)client.commit(instantTime, client.bulkInsert(transformInputFn.apply(records), instantTime)), (String)"Commit should succeed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime), (String)"After explicit commit, commit file should be created");
            String actionType = metaClient.getCommitActionType();
            HoodieInstant commitInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, actionType, instantTime);
            HoodieTimeline commitTimeline = metaClient.getCommitTimeline().filterCompletedInstants();
            HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize(commitInstant, (byte[])commitTimeline.getInstantDetails(commitInstant).get(), HoodieCommitMetadata.class);
            StoragePath basePath = metaClient.getBasePath();
            Collection commitPathNames = commitMetadata.getFileIdAndFullPaths(basePath).values();
            HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime);
            HoodieCommitMetadata metadata = (HoodieCommitMetadata)metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])metaClient.reloadActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            HashMap paths = metadata.getFileIdAndFullPaths(basePath);
            for (String pathName : paths.values()) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)commitPathNames.contains(pathName));
            }
        }
    }

    protected void testMetadataStatsOnCommit(boolean populateMetaFields, Function transformInputFn) throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder().withAutoCommit(false);
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        HoodieWriteConfig cfg = cfgBuilder.build();
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfg);
        String instantTime0 = "000";
        client.startCommitWithTime(instantTime0);
        List records0 = this.dataGen.generateInserts(instantTime0, Integer.valueOf(200));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)client.commit(instantTime0, client.bulkInsert(transformInputFn.apply(records0), instantTime0)), (String)"Commit should succeed");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime0), (String)"After explicit commit, commit file should be created");
        HoodieInstant instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime0);
        HoodieCommitMetadata metadata = (HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])this.createMetaClient().reloadActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
        int inserts = 0;
        for (Map.Entry pstat : metadata.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : (List)pstat.getValue()) {
                inserts = (int)((long)inserts + stat.getNumInserts());
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)inserts);
        String instantTime1 = "001";
        client.startCommitWithTime(instantTime1);
        List records1 = this.dataGen.generateUpdates(instantTime1, records0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)client.commit(instantTime1, client.upsert(transformInputFn.apply(records1), instantTime1)), (String)"Commit should succeed");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(instantTime1), (String)"After explicit commit, commit file should be created");
        this.metaClient = this.createMetaClient();
        instant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime1);
        metadata = (HoodieCommitMetadata)this.metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])this.metaClient.reloadActiveTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
        inserts = 0;
        int upserts = 0;
        for (Map.Entry pstat : metadata.getPartitionToWriteStats().entrySet()) {
            for (HoodieWriteStat stat : (List)pstat.getValue()) {
                inserts = (int)((long)inserts + stat.getNumInserts());
                upserts = (int)((long)upserts + stat.getNumUpdateWrites());
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)inserts);
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)upserts);
    }

    protected void testFailWritesOnInlineTableServiceThrowable(boolean shouldFailOnException, boolean actuallyFailed, Function createBrokenClusteringClientFn, String error) throws IOException {
        try {
            Properties properties = new Properties();
            properties.setProperty("hoodie.fail.writes.on.inline.table.service.exception", String.valueOf(shouldFailOnException));
            properties.setProperty("hoodie.auto.commit", "false");
            properties.setProperty("hoodie.clustering.inline.max.commits", "1");
            properties.setProperty("hoodie.clustering.inline", "true");
            properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "partition_path");
            this.testInsertTwoBatches(true, "2015/03/16", properties, true, createBrokenClusteringClientFn);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)actuallyFailed);
        }
        catch (Error | HoodieException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)error, (Object)e.getMessage());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)actuallyFailed);
        }
    }

    protected void testDeletesWithoutInserts(boolean populateMetaFields, Function transformInputFn, Function transformOutputFn) {
        String testPartitionPath = "2016/09/26";
        int insertSplitLimit = 100;
        HoodieWriteConfig config = this.getSmallInsertWriteConfig(100, "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}", this.dataGen.getEstimatedFileSizeInBytes(150), populateMetaFields, populateMetaFields ? new Properties() : HoodieWriterClientTestHarness.getPropertiesForKeyGen());
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2016/09/26"});
        BaseHoodieWriteClient client = this.getHoodieWriteClient(config);
        String commitTime1 = "001";
        client.startCommitWithTime(commitTime1);
        List dummyInserts = this.dataGen.generateInserts(commitTime1, Integer.valueOf(20));
        List hoodieKeysToDelete = Transformations.randomSelectAsHoodieKeys((List)dummyInserts, (int)20);
        transformOutputFn.apply(client.delete(transformInputFn.apply(hoodieKeysToDelete), commitTime1));
    }

    protected void testInlineScheduleClustering(Function createBrokenClusteringClientFn, HoodieClusteringConfig clusteringConfig, Function transformInputFn, Function transformOutputFn) throws IOException {
        this.testInsertTwoBatches(true, createBrokenClusteringClientFn);
        HoodieWriteConfig config = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAutoCommit(false).withClusteringConfig(clusteringConfig).withProps((Map)HoodieWriterClientTestHarness.getPropertiesForKeyGen()).build();
        this.dataGen = new HoodieTestDataGenerator(new String[]{"2015/03/16"});
        this.generateInsertsAndCommit(config, transformInputFn, transformOutputFn);
        HoodieTableMetaClient metaClient = this.createMetaClient();
        HoodieWriterClientTestHarness.getAndAssertPendingClusteringPlans(clusteringConfig.getBoolean(HoodieClusteringConfig.SCHEDULE_INLINE_CLUSTERING), metaClient);
    }

    protected void testAndValidateClusteringOutputFiles(Function createBrokenClusteringClientFn, HoodieClusteringConfig clusteringConfig, Function transformInputFn, Function transformOutputFn) throws IOException {
        String partitionPath = "2015/03/16";
        this.testInsertTwoBatches(true, partitionPath, createBrokenClusteringClientFn);
        HoodieWriteConfig config = this.getConfigBuilder().withEmbeddedTimelineServerEnabled(false).withAutoCommit(false).withClusteringConfig(clusteringConfig).build();
        this.generateInsertsAndCommit(config, transformInputFn, transformOutputFn);
        this.verifyClusteredFilesWithReplaceCommitMetadata(partitionPath);
    }

    private void generateInsertsAndCommit(HoodieWriteConfig config, Function transformInputFn, Function transformOutputFn) {
        try (BaseHoodieWriteClient client = this.getHoodieWriteClient(config);){
            String commitTime = client.createNewInstantTime();
            List records = this.dataGen.generateInserts(commitTime, Integer.valueOf(200));
            client.startCommitWithTime(commitTime);
            List statusList = (List)transformOutputFn.apply(client.insert(transformInputFn.apply(records), commitTime));
            Assertions.assertNoWriteErrors(statusList);
            client.commit(commitTime, transformInputFn.apply(statusList));
        }
    }

    protected void testDeduplication(Function3<List<WriteStatus>, BaseHoodieWriteClient, List<HoodieRecord>, String> writeFn, boolean populateMetaFields, boolean allowOperationMetadataField) throws Exception {
        String newCommitTime = "001";
        List<HoodieRecord> recordList = this.generate3AvroRecords(newCommitTime);
        HoodieListData records = HoodieListData.eager(recordList);
        HoodieWriteConfig writeConfig = this.getWriteConfigWithPopulateMetaFieldsAndAllowOperationMetaField(populateMetaFields, allowOperationMetadataField);
        List<HoodieRecord<RawTripTestPayload>> dedupedRecs = this.dedupForCopyOnWriteStorage(writeConfig, (HoodieData<HoodieRecord>)records, true, allowOperationMetadataField ? 100 : 2, records.getNumPartitions());
        if (allowOperationMetadataField) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)dedupedRecs.get(0).getOperation(), (Object)recordList.get(2).getOperation());
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)dedupedRecs.get(0).getPartitionPath(), (Object)recordList.get(2).getPartitionPath());
            this.dedupForCopyOnWriteStorage(writeConfig, (HoodieData<HoodieRecord>)records, false, 2, records.getNumPartitions());
        }
        try (BaseHoodieWriteClient client = this.getHoodieWriteClient(writeConfig);){
            client.startCommitWithTime(newCommitTime);
            List<WriteStatus> statuses = writeFn.apply(client, recordList, newCommitTime);
            Assertions.assertNoWriteErrors(statuses);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)statuses.size());
            Assertions.assertNoDuplicatesInPartition(statuses.stream().map(WriteStatus::getWrittenRecordDelegates).flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    protected void testAutoCommit(Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean isPrepped, boolean populateMetaFields, InstantGenerator instantGenerator) throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder().withAutoCommit(false);
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        try (BaseHoodieWriteClient client = this.getHoodieWriteClient(cfgBuilder.build());){
            String prevCommitTime = "000";
            String newCommitTime = "001";
            int numRecords = 200;
            Object result = this.castInsertFirstBatch(cfgBuilder.build(), client, newCommitTime, prevCommitTime, numRecords, writeFn, isPrepped, false, numRecords, instantGenerator);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.testTable.commitExists(newCommitTime), (String)"If Autocommit is false, then commit should not be made automatically");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)client.commit(newCommitTime, result), (String)"Commit should succeed");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.testTable.commitExists(newCommitTime), (String)"After explicit commit, commit file should be created");
        }
    }

    protected void testDeletesForInsertsInSameBatch(InstantGenerator instantGenerator) throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY);
        this.addConfigsForPopulateMetaFields(cfgBuilder, true);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfgBuilder.build());
        String initCommitTime = "000";
        String newCommitTime = "001";
        ArrayList recordsInFirstBatch = new ArrayList();
        Function2<List<HoodieRecord>, String, Integer> recordGenFunction = (instantTime, numRecordsInThisCommit) -> {
            List fewRecordsForInsert = this.dataGen.generateInserts(instantTime, Integer.valueOf(200));
            List fewRecordsForDelete = fewRecordsForInsert.subList(40, 90);
            recordsInFirstBatch.addAll(fewRecordsForInsert);
            recordsInFirstBatch.addAll(this.dataGen.generateDeletesFromExistingRecords(fewRecordsForDelete));
            return recordsInFirstBatch;
        };
        this.castWriteBatch(client, newCommitTime, initCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, -1, recordGenFunction, BaseHoodieWriteClient::upsert, true, 150, 150, 1, false, true, instantGenerator);
    }

    protected void testHoodieConcatHandle(boolean populateMetaFields, boolean isPrepped, InstantGenerator instantGenerator) throws Exception {
        this.metaClient = this.createMetaClient(this.basePath);
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder();
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        HoodieWriteConfig hoodieWriteConfig = cfgBuilder.withMergeAllowDuplicateOnInserts(true).withTimelineLayoutVersion(TimelineLayoutVersion.VERSION_0.intValue()).build();
        HoodieTableMetaClient.newTableBuilder().fromMetaClient(this.metaClient).setTimelineLayoutVersion(TimelineLayoutVersion.VERSION_0).initTable(this.metaClient.getStorageConf().newInstance(), this.metaClient.getBasePath());
        BaseHoodieWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);
        String newCommitTime = "001";
        String initCommitTime = "000";
        int numRecords = 200;
        this.castInsertFirstBatch(hoodieWriteConfig, client, newCommitTime, initCommitTime, numRecords, BaseHoodieWriteClient::insert, isPrepped, true, numRecords, populateMetaFields, instantGenerator);
        String prevCommitTime = newCommitTime;
        newCommitTime = "004";
        numRecords = 100;
        String commitTimeBetweenPrevAndNew = "002";
        Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPrepped, hoodieWriteConfig, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateUniqueUpdates(arg_0, arg_1));
        this.castWriteBatch(client, newCommitTime, prevCommitTime, (Option<List<String>>)Option.of(Arrays.asList(commitTimeBetweenPrevAndNew)), initCommitTime, numRecords, recordGenFunction, BaseHoodieWriteClient::insert, true, numRecords, 300, 2, false, populateMetaFields, instantGenerator);
    }

    protected void testHoodieConcatHandleOnDupInserts(boolean isPrepped, InstantGenerator instantGenerator) throws Exception {
        HoodieWriteConfig config = this.getConfigBuilder().withMergeAllowDuplicateOnInserts(true).build();
        BaseHoodieWriteClient client = this.getHoodieWriteClient(config);
        String initCommitTime = "000";
        String newCommitTime = "001";
        int firstInsertRecords = 50;
        this.castInsertFirstBatch(config, client, newCommitTime, initCommitTime, firstInsertRecords, BaseHoodieWriteClient::insert, isPrepped, true, firstInsertRecords, config.populateMetaFields(), instantGenerator);
        String prevCommitTime = newCommitTime;
        newCommitTime = "004";
        int secondInsertRecords = 100;
        List<String> commitTimesBetweenPrevAndNew = Arrays.asList("002", "003");
        Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPrepped, config, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateUpdates(arg_0, arg_1));
        this.castWriteBatch(client, newCommitTime, prevCommitTime, (Option<List<String>>)Option.of(commitTimesBetweenPrevAndNew), initCommitTime, secondInsertRecords, recordGenFunction, BaseHoodieWriteClient::insert, true, secondInsertRecords, firstInsertRecords + secondInsertRecords, 2, false, config.populateMetaFields(), instantGenerator);
    }

    protected void testUpsertsInternal(Function3<Object, BaseHoodieWriteClient, Object, String> writeFn, boolean populateMetaFields, boolean isPrepped, SupportsUpgradeDowngrade upgradeDowngrade) throws Exception {
        this.metaClient = this.createMetaClient();
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withRollbackUsingMarkers(true).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build());
        this.addConfigsForPopulateMetaFields(cfgBuilder, populateMetaFields);
        HoodieTableMetaClient.newTableBuilder().fromMetaClient(this.metaClient).setTableVersion(6).setPopulateMetaFields(populateMetaFields).initTable(this.metaClient.getStorageConf().newInstance(), this.metaClient.getBasePath());
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (StoragePath)new StoragePath(this.basePath), (HoodieTableVersion)HoodieTableVersion.SIX);
        HoodieWriteConfig config = cfgBuilder.withWriteTableVersion(6).build();
        BaseHoodieWriteClient client = this.getHoodieWriteClient(config);
        String newCommitTime = "001";
        String initCommitTime = "000";
        int numRecords = 200;
        this.castInsertFirstBatch(config, client, newCommitTime, initCommitTime, numRecords, BaseHoodieWriteClient::insert, isPrepped, true, numRecords, populateMetaFields, this.metaClient.getInstantGenerator());
        String prevCommitTime = newCommitTime;
        newCommitTime = "004";
        numRecords = 100;
        String commitTimeBetweenPrevAndNew = "002";
        this.castUpdateBatch(config, client, newCommitTime, prevCommitTime, (Option<List<String>>)Option.of(Arrays.asList(commitTimeBetweenPrevAndNew)), initCommitTime, numRecords, writeFn, isPrepped, true, numRecords, 200, 2, populateMetaFields, this.metaClient.getInstantGenerator());
        prevCommitTime = newCommitTime;
        newCommitTime = "005";
        numRecords = 50;
        this.castDeleteBatch(config, client, newCommitTime, prevCommitTime, initCommitTime, numRecords, isPrepped, true, 0, 150, config.populateMetaFields(), this.metaClient.getTimelineLayout().getTimelineFactory(), this.metaClient.getInstantGenerator());
        HoodieWriteConfig newConfig = this.getConfigBuilder().withProps((Map)config.getProps()).withWriteTableVersion(HoodieTableVersion.EIGHT.versionCode()).build();
        client = this.getHoodieWriteClient(newConfig);
        new UpgradeDowngrade(this.metaClient, newConfig, client.getEngineContext(), upgradeDowngrade).run(HoodieTableVersion.EIGHT, null);
        client = this.getHoodieWriteClient(newConfig);
        client.savepoint("004", "user1", "comment1");
        client.restoreToInstant("004", config.isMetadataTableEnabled());
        this.metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (StoragePath)new StoragePath(this.basePath), (HoodieTableVersion)HoodieTableVersion.EIGHT);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.reloadActiveTimeline().getRollbackTimeline().lastInstant().isPresent());
        client.deleteSavepoint("004");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.metaClient.reloadActiveTimeline().getSavePointTimeline().containsInstant("004"));
        this.assertTheEntireDatasetHasAllRecordsStill(200);
        prevCommitTime = newCommitTime;
        newCommitTime = "006";
        numRecords = 50;
        this.castDeleteBatch(newConfig, client, newCommitTime, prevCommitTime, initCommitTime, numRecords, isPrepped, true, 0, 150, this.metaClient.getTimelineLayout().getTimelineFactory(), this.metaClient.getInstantGenerator());
        this.checkTimelineForUpsertsInternal(this.metaClient);
        this.testMergeHandle(config);
    }

    protected void testDeletes(Function3<Function2<List<HoodieRecord>, String, Integer>, String, Integer, List<HoodieRecord>> secondBatchGenFn, int numRecordsInSecondBatch, int expRecordsInSecondBatch, int expTotalRecords) throws Exception {
        HoodieWriteConfig.Builder cfgBuilder = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY);
        this.addConfigsForPopulateMetaFields(cfgBuilder, true);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(cfgBuilder.build());
        String initCommitTime = "000";
        String newCommitTime = "001";
        ArrayList recordsInFirstBatch = new ArrayList();
        Function2<List<HoodieRecord>, String, Integer> recordGenFunction = (instantTime, numRecordsInThisCommit) -> {
            List fewRecordsForInsert = this.dataGen.generateInserts(instantTime, Integer.valueOf(200));
            List fewRecordsForDelete = this.dataGen.generateDeletes(instantTime, Integer.valueOf(100));
            recordsInFirstBatch.addAll(fewRecordsForInsert);
            recordsInFirstBatch.addAll(fewRecordsForDelete);
            return recordsInFirstBatch;
        };
        this.castWriteBatch(client, newCommitTime, initCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, -1, recordGenFunction, BaseHoodieWriteClient::upsert, true, 200, 200, 1, false, true, HoodieTestUtils.INSTANT_GENERATOR);
        String prevCommitTime = newCommitTime;
        newCommitTime = "004";
        recordGenFunction = secondBatchGenFn.apply(newCommitTime, numRecordsInSecondBatch, recordsInFirstBatch);
        this.castWriteBatch(client, newCommitTime, prevCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, numRecordsInSecondBatch, recordGenFunction, BaseHoodieWriteClient::upsert, true, expRecordsInSecondBatch, expTotalRecords, 2, false, true, HoodieTestUtils.INSTANT_GENERATOR);
    }

    protected void testRollbackFailedCommits(boolean populateMetaFields) throws Exception {
        HoodieFailedWritesCleaningPolicy cleaningPolicy = HoodieFailedWritesCleaningPolicy.NEVER;
        HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "100", "100", (Option<List<String>>)Option.of(Arrays.asList("100")), "100", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, true, HoodieTestUtils.INSTANT_GENERATOR);
        this.castWriteBatch(client, "200", "100", (Option<List<String>>)Option.of(Arrays.asList("200")), "100", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "300", "200", (Option<List<String>>)Option.of(Arrays.asList("300")), "300", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        this.dataGen = new HoodieTestDataGenerator();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "400", "300", (Option<List<String>>)Option.of(Arrays.asList("400")), "400", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, true, HoodieTestUtils.INSTANT_GENERATOR);
        HoodieTableMetaClient metaClient = this.createMetaClient();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)metaClient.getActiveTimeline().filterInflights().countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().countInstants());
        boolean conditionMet = false;
        while (!conditionMet) {
            conditionMet = client.getHeartbeatClient().isHeartbeatExpired("300");
            Thread.sleep(2000L);
        }
        client.close();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "500", "400", (Option<List<String>>)Option.of(Arrays.asList("500")), "500", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, true, HoodieTestUtils.INSTANT_GENERATOR);
        client.clean();
        client.close();
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline().reload();
        if (cleaningPolicy.isLazy()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.getCommitsTimeline().filterCompletedInstants().countInstants());
        } else if (cleaningPolicy.isNever()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).countInstants());
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.getCommitsTimeline().filterCompletedInstants().countInstants());
        }
    }

    protected void testRollbackFailedCommitsToggleCleaningPolicy(boolean populateMetaFields) throws Exception {
        HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath);
        this.metaClient = this.createMetaClient();
        HoodieFailedWritesCleaningPolicy cleaningPolicy = HoodieFailedWritesCleaningPolicy.EAGER;
        BaseHoodieWriteClient client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "100", "100", (Option<List<String>>)Option.of(Arrays.asList("100")), "100", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, true, HoodieTestUtils.INSTANT_GENERATOR);
        this.castWriteBatch(client, "200", "100", (Option<List<String>>)Option.of(Arrays.asList("200")), "200", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        cleaningPolicy = HoodieFailedWritesCleaningPolicy.LAZY;
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "300", "200", (Option<List<String>>)Option.of(Arrays.asList("300")), "300", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "400", "300", (Option<List<String>>)Option.of(Arrays.asList("400")), "400", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        boolean conditionMet = false;
        while (!conditionMet) {
            conditionMet = client.getHeartbeatClient().isHeartbeatExpired("400");
            Thread.sleep(2000L);
        }
        client.clean();
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline().reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "500", "400", (Option<List<String>>)Option.of(Arrays.asList("300")), "300", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "600", "500", (Option<List<String>>)Option.of(Arrays.asList("400")), "400", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 300, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        cleaningPolicy = HoodieFailedWritesCleaningPolicy.EAGER;
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        client.startCommit();
        client.close();
        timeline = this.metaClient.getActiveTimeline().reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeline.getCommitsTimeline().filterCompletedInstants().countInstants());
    }

    protected void testParallelInsertAndCleanPreviousFailedCommits(boolean populateMetaFields) throws Exception {
        HoodieFailedWritesCleaningPolicy cleaningPolicy = HoodieFailedWritesCleaningPolicy.LAZY;
        ExecutorService service = Executors.newFixedThreadPool(2);
        HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath);
        BaseHoodieWriteClient client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "100", "100", (Option<List<String>>)Option.of(Arrays.asList("100")), "100", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 100, 0, true, HoodieTestUtils.INSTANT_GENERATOR);
        this.castWriteBatch(client, "200", "100", (Option<List<String>>)Option.of(Arrays.asList("200")), "200", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 100, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        this.castWriteBatch(client, "300", "200", (Option<List<String>>)Option.of(Arrays.asList("300")), "300", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 100, 0, false, HoodieTestUtils.INSTANT_GENERATOR);
        client.close();
        this.dataGen = new HoodieTestDataGenerator();
        Future<Object> commit3 = service.submit(() -> this.castWriteBatch(this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields)), "400", "300", (Option<List<String>>)Option.of(Arrays.asList("400")), "300", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 100, 0, true, HoodieTestUtils.INSTANT_GENERATOR));
        commit3.get();
        HoodieTableMetaClient metaClient = this.createMetaClient();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)metaClient.getActiveTimeline().filterInflights().countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().countInstants());
        client = this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields));
        boolean conditionMet = false;
        while (!conditionMet) {
            conditionMet = client.getHeartbeatClient().isHeartbeatExpired("300");
            Thread.sleep(2000L);
        }
        Future<Object> commit4 = service.submit(() -> this.castWriteBatch(this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields)), "500", "400", (Option<List<String>>)Option.of(Arrays.asList("500")), "500", 100, (arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1), BaseHoodieWriteClient::bulkInsert, false, 100, 100, 0, true, HoodieTestUtils.INSTANT_GENERATOR));
        Future<HoodieCleanMetadata> clean1 = service.submit(() -> this.getHoodieWriteClient(this.getParallelWritingWriteConfig(cleaningPolicy, populateMetaFields)).clean());
        commit4.get();
        clean1.get();
        client.close();
        HoodieActiveTimeline timeline = metaClient.getActiveTimeline().reload();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"rollback"})).countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)timeline.getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"clean"})).countInstants());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.getCommitsTimeline().filterCompletedInstants().countInstants());
        service.shutdown();
    }

    @FunctionalInterface
    public static interface Function3<R, T1, T2, T3> {
        public R apply(T1 var1, T2 var2, T3 var3) throws IOException;
    }

    @FunctionalInterface
    public static interface Function2<R, T1, T2> {
        public R apply(T1 var1, T2 var2) throws IOException;
    }
}

