/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utils;

import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.util.CommonClientUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCommonClientUtils {
    @Test
    public void testDisallowPartialUpdatesPreVersion8() {
        HoodieWriteConfig wConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        HoodieTableConfig tConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)wConfig.getWriteVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)tConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)wConfig.shouldWritePartialUpdates()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieNotSupportedException.class, () -> CommonClientUtils.validateTableVersion((HoodieTableConfig)tConfig, (HoodieWriteConfig)wConfig));
    }

    @Test
    public void testDisallowNBCCPreVersion8() {
        HoodieWriteConfig wConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        HoodieTableConfig tConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
        Mockito.when((Object)wConfig.getWriteVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)tConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        Mockito.when((Object)wConfig.isNonBlockingConcurrencyControl()).thenReturn((Object)true);
        Assertions.assertThrows(HoodieNotSupportedException.class, () -> CommonClientUtils.validateTableVersion((HoodieTableConfig)tConfig, (HoodieWriteConfig)wConfig));
    }

    @Test
    public void testGenerateTokenOnError() {
        TaskContextSupplier taskContextSupplier = (TaskContextSupplier)Mockito.mock(TaskContextSupplier.class);
        Mockito.when((Object)taskContextSupplier.getPartitionIdSupplier()).thenThrow(new Throwable[]{new RuntimeException("generated under testing")});
        Assertions.assertEquals((Object)"0-0-0", (Object)CommonClientUtils.generateWriteToken((TaskContextSupplier)taskContextSupplier));
    }
}

