/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hudi.async.HoodieAsyncTableService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncArchiveService
extends HoodieAsyncTableService {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncArchiveService.class);
    private final BaseHoodieWriteClient writeClient;
    private final transient ExecutorService executor = Executors.newSingleThreadExecutor();

    protected AsyncArchiveService(BaseHoodieWriteClient writeClient) {
        super(writeClient.getConfig());
        this.writeClient = writeClient;
    }

    @Override
    protected Pair<CompletableFuture, ExecutorService> startService() {
        LOG.info("Starting async archive service...");
        return Pair.of(CompletableFuture.supplyAsync(() -> {
            this.writeClient.archive();
            return true;
        }, this.executor), (Object)this.executor);
    }

    public static AsyncArchiveService startAsyncArchiveIfEnabled(BaseHoodieWriteClient writeClient) {
        HoodieWriteConfig config = writeClient.getConfig();
        if (!config.isAutoArchive() || !config.isAsyncArchive()) {
            LOG.info("The HoodieWriteClient is not configured to auto & async archive. Async archive service will not start.");
            return null;
        }
        AsyncArchiveService asyncArchiveService = new AsyncArchiveService(writeClient);
        asyncArchiveService.start(null);
        return asyncArchiveService;
    }

    public static void waitForCompletion(AsyncArchiveService asyncArchiveService) {
        if (asyncArchiveService != null) {
            LOG.info("Waiting for async archive service to finish");
            try {
                asyncArchiveService.waitForShutdown();
            }
            catch (Exception e) {
                throw new HoodieException("Error waiting for async archive service to finish", (Throwable)e);
            }
        }
    }

    public static void forceShutdown(AsyncArchiveService asyncArchiveService) {
        if (asyncArchiveService != null) {
            LOG.info("Shutting down async archive service...");
            asyncArchiveService.shutdown(true);
        }
    }
}

