/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.async;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieAsyncService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieAsyncService.class);
    private static final long POLLING_SECONDS = 10L;
    protected boolean hasError;
    private boolean started;
    private boolean shutdownRequested = false;
    private volatile boolean shutdown;
    private transient ExecutorService executor;
    private transient CompletableFuture future;
    private final boolean runInDaemonMode;
    private transient BlockingQueue<String> pendingInstants = new LinkedBlockingQueue<String>();
    private transient ReentrantLock queueLock = new ReentrantLock();
    private transient Condition consumed = this.queueLock.newCondition();

    protected HoodieAsyncService() {
        this(false);
    }

    protected HoodieAsyncService(boolean runInDaemonMode) {
        this.runInDaemonMode = runInDaemonMode;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void waitForShutdown() throws ExecutionException, InterruptedException {
        if (this.future == null) {
            return;
        }
        try {
            this.future.get();
        }
        catch (ExecutionException ex) {
            LOG.error("Service shutdown with error", (Throwable)ex);
            throw ex;
        }
    }

    public void shutdown(boolean force) {
        if (!this.shutdownRequested || force) {
            this.shutdownRequested = true;
            this.shutdown = true;
            if (this.executor != null) {
                if (force) {
                    this.executor.shutdownNow();
                } else {
                    this.executor.shutdown();
                    try {
                        this.executor.awaitTermination(24L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ie) {
                        LOG.error("Interrupted while waiting for shutdown", (Throwable)ie);
                    }
                }
            }
        }
    }

    public void start(Function<Boolean, Boolean> onShutdownCallback) {
        if (this.started) {
            LOG.warn("The async service already started.");
            return;
        }
        Pair<CompletableFuture, ExecutorService> res = this.startService();
        this.future = (CompletableFuture)res.getKey();
        this.executor = (ExecutorService)res.getValue();
        this.started = true;
        this.shutdownCallback(onShutdownCallback);
    }

    protected abstract Pair<CompletableFuture, ExecutorService> startService();

    private void shutdownCallback(Function<Boolean, Boolean> callback) {
        if (this.future == null) {
            return;
        }
        this.future.whenComplete((resp, error) -> {
            if (null != callback) {
                callback.apply(null != error);
            }
            this.started = false;
        });
    }

    public boolean isRunInDaemonMode() {
        return this.runInDaemonMode;
    }

    public void waitTillPendingAsyncServiceInstantsReducesTo(int numPending) throws InterruptedException {
        try {
            this.queueLock.lock();
            while (!this.isShutdown() && !this.hasError() && this.pendingInstants.size() > numPending) {
                this.consumed.await(10L, TimeUnit.SECONDS);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public void enqueuePendingAsyncServiceInstant(String instantTime) {
        LOG.info("Enqueuing new pending table service instant: " + instantTime);
        this.pendingInstants.add(instantTime);
    }

    String fetchNextAsyncServiceInstant() throws InterruptedException {
        LOG.info(String.format("Waiting for next instant up to %d seconds", 10L));
        String instantTime = this.pendingInstants.poll(10L, TimeUnit.SECONDS);
        if (instantTime != null) {
            try {
                this.queueLock.lock();
                this.consumed.signal();
            }
            finally {
                this.queueLock.unlock();
            }
        }
        return instantTime;
    }
}

